<?php

require_once "../../_class/Conexao_class.php";
require_once "../../_class/Crud_class.php";

error_reporting(E_ALL);
ini_set('display_errors', 'On');

$id = base64_decode($_GET['id']);
$id = substr($id, 8);
$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'caixa');
$sql = "SELECT * from boleto WHERE id = " . $id . "";
$arrayParam = '';
$dados = $crud->getSQLGeneric($sql, $arrayParam, false);

require 'autoload.php';
$beneficiario = new \Newerton\Yii2Boleto\Pessoa(
        [
    'nome' => 'DIVISHOP CENTRO COMERCIAL DO VESTUARIO',
    'endereco' => 'AV JK, 1200 - SANTA CLARA',
    'cep' => '35500-155',
    'uf' => 'MG',
    'cidade' => 'DIVIÓPOLIS',
    'documento' => '01.542.531./0001-79',
        ]
);

$pagador = new \Newerton\Yii2Boleto\Pessoa(
        [
    'nome' => $dados->nome,
    'endereco' => $dados->endereco,
    'bairro' => $dados->bairro,
    'cep' => $dados->cep,
    'uf' => $dados->uf,
    'cidade' => $dados->cidade,
    'documento' => $dados->documento,
        ]
);

$boleto = new Newerton\Yii2Boleto\Boleto\Banco\Bancoob(
        [
    'logo' => realpath(__DIR__ . '/../logos/') . DIRECTORY_SEPARATOR . 'divishop.png',
    'dataVencimento' => new \Carbon\Carbon($dados->vencimento),
    'valor' => $dados->valor,
    'multa' => false,
    'juros' => false,
    'numero' => $dados->numero,
    'numeroDocumento' => $dados->numerodocumento,
    'pagador' => $pagador,
    'beneficiario' => $beneficiario,
    'carteira' => 1,
    'modalidade' => '01',
    'parcela' => '001',
    'agencia' => $dados->agencia,
    'convenio' => '1350',
    'codigoCliente' => '1350',
    'conta' => $dados->conta,
    'descricaoDemonstrativo' => [nl2br($dados->demonstrativo1), $dados->demonstrativo2, nl2br($dados->demonstrativo3)],
    'instrucoes' => [nl2br($dados->instrucao1), nl2br($dados->instrucao2), nl2br($dados->instrucao3)],
    'aceite' => 'S',
    'especieDoc' => 'RC',
        ]
);

$pdf = new Newerton\Yii2Boleto\Boleto\Render\Pdf();
$pdf->addBoleto($boleto);
$pdf->hideInstrucoes();
//$pdf->showComprovante();
$pdf->gerarBoleto($pdf::OUTPUT_SAVE, __DIR__ . DIRECTORY_SEPARATOR . 'arquivos' . DIRECTORY_SEPARATOR . 'bancoob.pdf');
header('Content-type: application/pdf');
//$boleto->renderPDF(true, false);
@readfile(__DIR__ . DIRECTORY_SEPARATOR . 'arquivos' . DIRECTORY_SEPARATOR . 'bancoob.pdf');
