<?php

namespace NFePHP\EFD\Elements\Contribuicoes;

use NFePHP\EFD\Common\Element;
use NFePHP\EFD\Common\ElementInterface;
use \stdClass;

class Z0005 extends Element implements ElementInterface {

    const REG = '0005';
    const LEVEL = 2;
    const PARENT = '0000';

    protected $parameters = [
        'FANTASIA' => [
            'type' => 'string',
            'regex' => '^.{0,60}$',
            'required' => false,
            'info' => 'Nome de fantasia associado ao nome empresarial',
            'format' => ''
        ],
        'CEP' => [
            'type' => 'numeric',
            'regex' => '^(\d{8})$',
            'required' => false,
            'info' => 'Código de Endereçamento Postal.',
            'format' => ''
        ],
        'END' => [
            'type' => 'string',
            'regex' => '^.{0,60}$',
            'required' => false,
            'info' => 'Logradouro e endereço do imóvel.',
            'format' => ''
        ],
        'NUM' => [
            'type' => 'string',
            'regex' => '^(.*)$',
            'required' => false,
            'info' => 'Número do imóvel.',
            'format' => ''
        ],
        'COMPL' => [
            'type' => 'string',
            'regex' => '^.{0,60}$',
            'required' => false,
            'info' => 'Dados complementares do endereço.',
            'format' => ''
        ],
        'BAIRRO' => [
            'type' => 'string',
            'regex' => '^.{0,60}$',
            'required' => false,
            'info' => 'Bairro em que o imóvel está situado.',
            'format' => ''
        ],
        'FONE' => [
            'type' => 'string',
            'regex' => '^.{0,11}$',
            'required' => false,
            'info' => 'Número do telefone.',
            'format' => ''
        ],
        'FAX' => [
            'type' => 'string',
            'regex' => '^.{0,11}$',
            'required' => false,
            'info' => 'Número do fax.',
            'format' => ''
        ],
        'EMAIL' => [
            'type' => 'string',
            'regex' => '^(.*)$',
            'required' => false,
            'info' => 'Endereço do correio eletrônico.',
            'format' => ''
        ],
    ];

    /**
     * Constructor
     * @param \stdClass $std
     */
    public function __construct(\stdClass $std) {
        parent::__construct(self::REG);
        $this->std = $this->standarize($std);
    }

}
