<?php

require_once "../../_backend/_class/Conexao_class.php";
require_once "../../_backend/_class/Crud_class.php";

function soNumero($str) {
    return preg_replace("/[^0-9]/", "", $str);
}

function removeAcentos($texto) {
    $aFind = array('&', 'á', 'à', 'ã', 'â', 'é', 'ê',
        'í', 'ó', 'ô', 'õ', 'ú', 'ü', 'ç', 'Á', 'À', 'Ã', 'Â',
        'É', 'Ê', 'Í', 'Ó', 'Ô', 'Õ', 'Ú', 'Ü', 'Ç');
    $aSubs = array('e', 'a', 'a', 'a', 'a', 'e', 'e',
        'i', 'o', 'o', 'o', 'u', 'u', 'c', 'A', 'A', 'A', 'A',
        'E', 'E', 'I', 'O', 'O', 'O', 'U', 'U', 'C');
    $novoTexto = str_replace($aFind, $aSubs, $texto);
    $novoTexto = preg_replace("/[^a-zA-Z0-9 @,-.;:\/_]/", "", $novoTexto);
    return $novoTexto;
}

//echo '<br/>';
//echo strtoupper($registro11);

error_reporting(E_ALL);
ini_set('display_errors', 'On');

$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'usuario');
$sql = 'Select estoqueprodutos.produto, estoqueprodutos.var1, estoqueprodutos.var2, estoqueprodutos.var3, 
        estoqueprodutos.codproduto, Sum(estoqueprodutos.qtd2) as estoque, 
produtos.codigo, produtos.descricao, produtos.categoria, produtos.ref, produtos.unidade, produtos.custo, produtos.fornecedor
FROM estoqueprodutos INNER JOIN produtos
ON estoqueprodutos.produto = produtos.codigo';
$sql .= " WHERE 1=1";
$sql .= ' AND estoqueprodutos.qtd2 > 0';
$sql .= " GROUP BY estoqueprodutos.produto";
$sql .= ' ORDER BY estoqueprodutos.codproduto ASC';
$arrayParam = '';
$estoqueprodutos = $crud->getSQLGeneric($sql, $arrayParam, true);

//echo $sql;
//
//echo '<pre>';
//print_r($dadosnfe);
//echo '</pre>';
$texto = '';
$registro74 = '';
$registro75 = '';
$valor = 0;
foreach ($estoqueprodutos as $estoque) :
    $total = $estoque->custo * $estoque->estoque;
    $total = number_format($total, 2, '.', '');
//    echo $total;
    $valor = $valor + $total;
    $registro74 .= '74';
    $registro74 .= '20201231';
    $registro74 .= str_pad($estoque->produto, 14, ' ');
    $registro74 .= str_pad(soNumero($estoque->estoque), 13, '0', STR_PAD_LEFT);
    $registro74 .= str_pad(soNumero($total), 13, '0', STR_PAD_LEFT);
    $registro74 .= '1';
    $registro74 .= str_pad('0', 14, '0', STR_PAD_LEFT);
    $registro74 .= str_pad(' ', 14, ' ');
    $registro74 .= 'MG';
    $registro74 .= str_pad(' ', 45, ' ');
    $registro74 .= "\r\n";

    $registro75 .= '75';
    $registro75 .= '20210201';
    $registro75 .= '20210228';
    $registro75 .= str_pad(substr($estoque->produto, 0, 14), 14, ' ');
    $registro75 .= str_pad(substr('00000000', 0, 8), 8, ' ');
    $registro75 .= str_pad(substr(removeAcentos(trim($estoque->descricao)), 0, 53), 53, ' ');
    $registro75 .= str_pad(substr($estoque->unidade, 0, 6), 6, ' ');
    $registro75 .= str_pad('0', 5, '0', STR_PAD_LEFT);
    $registro75 .= str_pad('0', 4, '0', STR_PAD_LEFT);
    $registro75 .= str_pad('0', 5, '0', STR_PAD_LEFT);
    $registro75 .= str_pad('0', 13, '0', STR_PAD_LEFT);
    $registro75 .= "\r\n";

endforeach;
$texto .= strtoupper($registro74);
$texto .= strtoupper($registro75);

//echo $valor;
//
$arquivo = fopen("registro74.txt", "w");
fwrite($arquivo, $texto);
fclose($arquivo);
