<?php

require_once "../../_backend/_class/Conexao_class.php";
require_once "../../_backend/_class/Crud_class.php";

//error_reporting(E_ALL);
//ini_set('display_errors', 'On');

// Garante sessão ativa (PHP 8.1+)
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

function padronizarIE($estado, $ie) {
    // Array com a quantidade de dígitos da IE para cada estado
    $digitosPorEstado = [
        'AC' => 13,
        'AL' => 9,
        'AP' => 9,
        'AM' => 9,
        'BA' => 8, // Pode ter 8 ou 9 dígitos, mas vamos usar o mais comum (8)
        'CE' => 9,
        'DF' => 13,
        'ES' => 9,
        'GO' => 9,
        'MA' => 9,
        'MT' => 11,
        'MS' => 9,
        'MG' => 13,
        'PA' => 9,
        'PB' => 9,
        'PR' => 10,
        'PE' => 9,
        'PI' => 9,
        'RJ' => 8,
        'RN' => 9, // Pode ter 9 ou 10 dígitos
        'RS' => 10,
        'RO' => 14,
        'RR' => 9,
        'SC' => 9,
        'SP' => 12,
        'SE' => 9,
        'TO' => 9
    ];

    // Verifica se o estado está no array e aplica padding
    if (isset($digitosPorEstado[$estado])) {
        $tamanhoIE = $digitosPorEstado[$estado];
        return str_pad($ie, $tamanhoIE, '0', STR_PAD_LEFT);
    } else {
        // Se o estado não é encontrado, retorna a IE original
        return $ie;
    }
}

function soNumero($str) {
    return preg_replace("/[^0-9]/", "", $str);
}

function BuscaDesc($valor) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'emitente');
    $sql = "SELECT * from produtos where codigo = '$valor'";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

    return $dados->descricao;
}

function BuscaCFOP($valor) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'emitente');
    $sql = "SELECT * from produtonfe where NFe = '$valor'";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

    return $dados->CFOP;
}

function BuscaALIQ($valor, $pICMS, $CFOP) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'emitente');
    $sql = "SELECT sum(vBC) as vBC from produtonfe where NFe = '$valor' and pICMS = '$pICMS' and CFOP = '$CFOP'";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

    return $dados->vBC;
}

function removeAcentos($texto) {
    $aFind = array('&', 'á', 'à', 'ã', 'â', 'é', 'ê',
        'í', 'ó', 'ô', 'õ', 'ú', 'ü', 'ç', 'Á', 'À', 'Ã', 'Â',
        'É', 'Ê', 'Í', 'Ó', 'Ô', 'Õ', 'Ú', 'Ü', 'Ç');
    $aSubs = array('e', 'a', 'a', 'a', 'a', 'e', 'e',
        'i', 'o', 'o', 'o', 'u', 'u', 'c', 'A', 'A', 'A', 'A',
        'E', 'E', 'I', 'O', 'O', 'O', 'U', 'U', 'C');
    $novoTexto = str_replace($aFind, $aSubs, $texto);
    $novoTexto = preg_replace("/[^a-zA-Z0-9 @,-.;:\/_]/", "", $novoTexto);
    return $novoTexto;
}

//Gera Registro 10

$data1 = parseDate($_POST['datai'], "Y-m-d");
$data2 = parseDate($_POST['dataf'], "Y-m-d");

$mes = parseDate($_POST['datai'], "m-d");
$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'emitente');
$sql = "SELECT * from emitente where emitenteid = '" . $_SESSION['Empresa'] . "'";
$arrayParam = '';
$emitente = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

//print_r($emitente);
//echo ;

$registro10 = '10';
$registro10 .= str_pad(soNumero($emitente->CNPJ), 14, '0', STR_PAD_LEFT);
$registro10 .= str_pad($emitente->IE, 14, ' ');
$registro10 .= str_pad(substr(removeAcentos($emitente->xNome), 0, 35), 35, ' ');
$registro10 .= str_pad(removeAcentos($emitente->xMun), 30, ' ');
$registro10 .= str_pad($emitente->UF, 2, ' ');
$registro10 .= str_pad(substr(soNumero($emitente->fone), 0, 10), 10, ' ');
$registro10 .= parseDate($data1, "Ymd");
$registro10 .= parseDate($data2, "Ymd");
$registro10 .= '3';
$registro10 .= '3';
$registro10 .= $_POST['finalidade'];
$registro10 .= "\r\n";

$texto = strtoupper($registro10);
//echo strtoupper($registro10);

$contato = ' ';
$registro11 = '11';
$registro11 .= str_pad(substr(removeAcentos($emitente->xLgr), 0, 34), 34, ' ');
$registro11 .= str_pad(soNumero($emitente->nro), 5, '0', STR_PAD_LEFT);
$registro11 .= str_pad(substr(removeAcentos($emitente->xCpl), 0, 22), 22, ' ');
$registro11 .= str_pad(substr(removeAcentos($emitente->xBairro), 0, 15), 15, ' ');
$registro11 .= str_pad(soNumero($emitente->CEP), 8, '0', STR_PAD_LEFT);
$registro11 .= str_pad(substr(removeAcentos($emitente->xNome), 0, 28), 28, ' ');
$registro11 .= str_pad(substr(soNumero($emitente->fone), 0, 12), 12, '0', STR_PAD_LEFT);
$registro11 .= "\r\n";

$texto .= strtoupper($registro11);

//echo '<br/>';
//echo strtoupper($registro11);

$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'emitente');
$sql = "SELECT * from nfe ";

if ($_POST['tipodata'] == 'E') :
    $sql .= " WHERE STR_TO_DATE(dhEmi, '%d/%m/%Y') BETWEEN  '{$data1}' AND '{$data2}' AND status != '' AND status !='101'";
elseif ($_POST['tipodata'] == 'SA') :
    $sql .= " WHERE STR_TO_DATE(dhSaiEnt, '%d/%m/%Y') BETWEEN  '{$data1}' AND '{$data2}' AND status != '' AND status !='101'";
else :
    $sql .= " WHERE ((STR_TO_DATE(dhEmi, '%d/%m/%Y') BETWEEN  '{$data1}' AND '{$data2}') OR (STR_TO_DATE(dhSaiEnt, '%d/%m/%Y') BETWEEN  
    '{$data1}' AND '{$data2}')) AND status != '' AND status !='101'";
endif;

if ($_POST['registro'] <> 'T') :
    $sql .= " and tipo = '" . $_POST['registro'] . "'";
endif;

if ($_POST['nfce'] == 'S') :
    $sql .= " and modelo <> '65'";
endif;

$sql .= " and empresa = '$emitente->emitenteid'";
//echo $sql;

$arrayParam = '';
$dadosnfe = $crud->getSQLGeneric($sql, $arrayParam, true);

//echo '<pre>';
//print_r($dadosnfe);
//echo '</pre>';

$totalregistro50 = 0;
$totalregistro61 = 0;
$totalregistro54 = 0;
$totalregistro75 = 0;
$registro50 = '';
$produtos50 = array();
$totalregistro51 = 0;
$registro54 = '';
$registro75 = '';
$produtos = array();
$registro61R = '';       // inicializa para evitar notice
$totalinventaro = 0;     // usado no inventário
$tvFretenf = 0;          // acumulador de frete

foreach ($dadosnfe as $nfe) :

    if ($nfe->modelo < 55 && $nfe->modelo >= 1) :
        $totalregistro50 = $totalregistro50 + 1;
        $registro50 .= '50';
        $registro50 .= str_pad(soNumero($nfe->destCNPJ), 14, '0', STR_PAD_LEFT);
        $registro50 .= str_pad(soNumero(padronizarIE($nfe->destUF, $nfe->destIE)), 14, ' ');
        $registro50 .= parseDate($nfe->dhEmi, "Ymd");
        $registro50 .= str_pad($nfe->destUF, 2, ' ');
        $registro50 .= str_pad(soNumero($nfe->modelo), 2, '0');
        $registro50 .= str_pad(soNumero($nfe->serie), 3, ' ');
        $registro50 .= str_pad(substr(soNumero($nfe->nNF), -6), 6, '0', STR_PAD_LEFT);
        $registro50 .= str_pad(substr(soNumero($nfe->CFOP), 0, 4), 4, '0', STR_PAD_LEFT);
        $registro50 .= 'T';
        $registro50 .= str_pad(soNumero(number_format($nfe->vNF + $nfe->vOutronf, 2, '.', '')), 13, '0', STR_PAD_LEFT);
        $registro50 .= str_pad('0', 13, '0', STR_PAD_LEFT);
        $registro50 .= str_pad('0', 13, '0', STR_PAD_LEFT);
        $registro50 .= str_pad('0', 13, '0', STR_PAD_LEFT);
        $registro50 .= str_pad(substr(soNumero($nfe->vOutronf)), 13, '0', STR_PAD_LEFT);
        $registro50 .= str_pad('0', 4, '0', STR_PAD_LEFT);
        $registro50 .= 'N';
        $registro50 .= "\r\n";
    endif;

    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'produtonfe');
    $sql = "SELECT CFOP, pICMS, sum(valortotal) as valortotal, sum(vBC) as vBC, 
        sum(vBCIPI) as vBCIPI, 
        sum(vICMS) as vICMS, sum(vICMSST) as vICMSST, sum(vIPI) as vIPI from produtonfe";
    $sql .= " WHERE NFe = '$nfe->id'";
    $sql .= " GROUP BY CFOP, pICMS";
    $arrayParam = '';
    $dadosprodnfec = $crud->getSQLGeneric($sql, $arrayParam, true);

    $vDescnf = 0;
    $totalitem = count($dadosprodnfec);

    if ($nfe->vDescnf > 0 && $totalitem > 0) :
        $vDescnf = number_format($nfe->vDescnf / $totalitem, 2, '.', '');
        $vDescnfitem = number_format($nfe->vDescnf / $totalitem, 2, '.', '');
    endif;

    $vOutronf = 0;
    $tvOutronf = 0;
    if ($nfe->vOutronf > 0 && $totalitem > 0) :
        $vOutronf = number_format($nfe->vOutronf / $totalitem, 2, '.', '');
    else :
        $vOutronf = 0;
        $tvOutronf = 0;
    endif;

    $vFCPST = 0;
    if ($nfe->vFCPST > 0 && $totalitem > 0) :
        $vFCPST = number_format($nfe->vFCPST / $totalitem, 2, '.', '');
    else :
        $vFCPST = 0;
    endif;

    $tvDescnf = 0;
    $itemnf = 1;

    foreach ($dadosprodnfec as $dadosprodnfe) :
        // registro 50
        if ($nfe->modelo <> '65' && $nfe->modelo <> '57') :
            if (!in_array(soNumero($nfe->id . $dadosprodnfe->pICMS . $dadosprodnfe->CFOP), $produtos50)) :

                if ($itemnf == $totalitem && $totalitem > 0) :
                    $vDescnf = $nfe->vDescnf - $tvDescnf;
                    $vDescnf = number_format($vDescnf, 2, '.', '');
                endif;
                $tvDescnf = $tvDescnf + $vDescnf;

                $vFretenf = 0;
                if ($itemnf == $totalitem && $totalitem > 0) :
                    $vFretenf = $nfe->vFretenf - $tvFretenf;
                    $vFretenf = number_format($vFretenf, 2, '.', '');
                endif;
                $tvFretenf = $tvFretenf + $vFretenf;

                $vOutronf = 0;
                if ($itemnf == $totalitem && $totalitem > 0) :
                    $vOutronf = $nfe->vOutronf - $tvOutronf;
                    $vOutronf = number_format($vOutronf, 2, '.', '');
                endif;
                $tvOutronf = $tvOutronf + $vOutronf;

                $produtos50[] = soNumero($nfe->id . $dadosprodnfe->pICMS . $dadosprodnfe->CFOP);
                $totalregistro50 = $totalregistro50 + 1;
                $registro50 .= '50';
                $registro50 .= str_pad(soNumero($nfe->destCNPJ), 14, '0', STR_PAD_LEFT);
                if ($nfe->destIE == '') :
                    $registro50 .= 'ISENTO        ';
                else :
                    if (strlen($nfe->destCNPJ) < 14) :
                        $registro50 .= 'ISENTO        ';
                    else :
                        $registro50 .= str_pad(soNumero(padronizarIE($nfe->destUF, $nfe->destIE)), 14, ' ');
                    endif;
                endif;

                if ($nfe->dhSaiEnt != '') :
                    $datasaida = parseDate($nfe->dhSaiEnt, "Y-m-d");

                    if (strtotime($datasaida) > strtotime($data2)) :
                        $registro50 .= parseDate($nfe->dhEmi, "Ymd");
                    else :
                        $registro50 .= parseDate($nfe->dhSaiEnt, "Ymd");
                    endif;
                else :
                    $registro50 .= parseDate($nfe->dhEmi, "Ymd");

                endif;
                $registro50 .= str_pad($nfe->destUF, 2, ' ');
                $registro50 .= str_pad(soNumero($nfe->modelo), 2, '0');
                $registro50 .= str_pad(soNumero($nfe->serie), 3, ' ');
                $registro50 .= str_pad(substr(soNumero($nfe->nNF), -6), 6, '0', STR_PAD_LEFT);
                $registro50 .= str_pad(substr(soNumero($dadosprodnfe->CFOP), 0, 4), 4, '0', STR_PAD_LEFT);
                if ($nfe->tipo == 'Entrada') :
                    $registro50 .= 'T';
                else :
                    $registro50 .= 'P';
                endif;
                $registro50 .= str_pad(soNumero(number_format($dadosprodnfe->valortotal + $dadosprodnfe->vIPI + $dadosprodnfe->vICMSST + $vFCPST + $tvFretenf + $vOutronf - $vDescnf, 2, '.', '')), 13, '0', STR_PAD_LEFT);
                if (soNumero($dadosprodnfe->vICMS) > 0) :
                    $registro50 .= str_pad(soNumero($dadosprodnfe->vBC), 13, '0', STR_PAD_LEFT);
                    $registro50 .= str_pad(soNumero(number_format($dadosprodnfe->vICMS, 2, '.', '')), 13, '0', STR_PAD_LEFT);
                    $registro50 .= str_pad('0', 13, '0', STR_PAD_LEFT);
                else :
                    $registro50 .= str_pad('0', 13, '0', STR_PAD_LEFT);
                    $registro50 .= str_pad('0', 13, '0', STR_PAD_LEFT);
                    $registro50 .= str_pad(soNumero($dadosprodnfe->valortotal), 13, '0', STR_PAD_LEFT);
                endif;
                $registro50 .= str_pad(substr(soNumero($nfe->vOutronf), 0, 4), 13, '0', STR_PAD_LEFT);
                $registro50 .= str_pad(substr(soNumero($dadosprodnfe->pICMS), 0, 4), 4, '0', STR_PAD_LEFT);
                if ($nfe->status == '101') :
                    $registro50 .= 'S';
                else :
                    $registro50 .= 'N';
                endif;
                $registro50 .= "\r\n";
                $itemnf++;

            endif;

        endif;
    endforeach;

    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'produtonfe');
    $sql = "SELECT * from produtonfe";
    $sql .= " WHERE NFe = '$nfe->id'";
    $arrayParam = '';
    $dadosprodnfec = $crud->getSQLGeneric($sql, $arrayParam, true);

    $item = 1;

    foreach ($dadosprodnfec as $dadosprodnfe) :
        if ($nfe->modelo <> '65' && $nfe->modelo <> '57') :
            $totalregistro54 = $totalregistro54 + 1;
            $registro54 .= '54';
            $registro54 .= str_pad(soNumero($nfe->destCNPJ), 14, '0', STR_PAD_LEFT);
            $registro54 .= str_pad(soNumero($nfe->modelo), 2, '0');
            $registro54 .= str_pad(soNumero($nfe->serie), 3, ' ');
            $registro54 .= str_pad(substr(soNumero($nfe->nNF), -6), 6, '0', STR_PAD_LEFT);
            $registro54 .= str_pad(substr(soNumero($dadosprodnfe->CFOP), 0, 4), 4, '0', STR_PAD_LEFT);
            $registro54 .= str_pad(substr(soNumero($dadosprodnfe->CST), 0, 3), 3, '0', STR_PAD_LEFT);
            $registro54 .= str_pad(substr(soNumero($item), 0, 3), 3, '0', STR_PAD_LEFT);
            $registro54 .= str_pad(substr($dadosprodnfe->cProd, 0, 14), 14, ' ');
            $registro54 .= str_pad(soNumero($dadosprodnfe->qtd), 11, '0', STR_PAD_LEFT);
            $registro54 .= str_pad(soNumero(number_format($dadosprodnfe->qtd * $dadosprodnfe->vProd - $dadosprodnfe->vDesc, 2, '.', '')), 12, '0', STR_PAD_LEFT);
            $registro54 .= str_pad(soNumero($dadosprodnfe->vDesc), 12, '0', STR_PAD_LEFT);
            $registro54 .= str_pad(soNumero($dadosprodnfe->vBC), 12, '0', STR_PAD_LEFT);
            $registro54 .= str_pad(soNumero($dadosprodnfe->vBCST), 12, '0', STR_PAD_LEFT);
            $registro54 .= str_pad(soNumero($dadosprodnfe->vIPI), 12, '0', STR_PAD_LEFT);
            $registro54 .= str_pad(soNumero($dadosprodnfe->pICMS), 4, '0', STR_PAD_LEFT);
            $registro54 .= "\r\n";
            $item++;
        else :
            $totalregistro61 = $totalregistro61 + 1;
            $registro61R .= '61R';
            $registro61R .= str_pad(soNumero(parseDate($nfe->dhEmi, "mY")), 2, '0');
            $registro61R .= str_pad(substr($dadosprodnfe->cProd, 0, 14), 14, ' ');
            $registro61R .= str_pad(soNumero($dadosprodnfe->qtd), 13, '0', STR_PAD_LEFT);
            $registro61R .= str_pad(soNumero($dadosprodnfe->vProd), 16, '0', STR_PAD_LEFT);
            $registro61R .= str_pad(soNumero($dadosprodnfe->vBC), 16, '0', STR_PAD_LEFT);
            $registro61R .= str_pad(soNumero($dadosprodnfe->pICMS), 4, '0', STR_PAD_LEFT);
            $registro61R .= str_pad(' ', 54, ' ');
            $registro61R .= "\r\n";
            $item++;
        endif;

        if (!in_array(substr($dadosprodnfe->cProd, 0, 14), $produtos, true)) :
            $produtos[] = substr($dadosprodnfe->cProd, 0, 14);
            $totalregistro75 = $totalregistro75 + 1;

            $registro75 .= '75';
            $registro75 .= parseDate($data1, "Ymd");
            $registro75 .= parseDate($data2, "Ymd");
            $registro75 .= str_pad(substr($dadosprodnfe->cProd, 0, 14), 14, ' ');
            $registro75 .= str_pad(substr($dadosprodnfe->NCM, 0, 8), 8, ' ');
            if ($dadosprodnfe->xProd == '') :
                $registro75 .= str_pad(substr(removeAcentos(trim(BuscaDesc($dadosprodnfe->cProd))), 0, 53), 53, ' ');
            else :
                $registro75 .= str_pad(substr(removeAcentos(trim($dadosprodnfe->xProd)), 0, 53), 53, ' ');
            endif;
            if ($dadosprodnfe->uCom != '') :
                $registro75 .= str_pad(substr($dadosprodnfe->uCom, 0, 6), 6, ' ');

            else :
                $registro75 .= str_pad('KG', 6, ' ');

            endif;
            $registro75 .= str_pad(soNumero($dadosprodnfe->pIPI), 5, '0', STR_PAD_LEFT);
            $registro75 .= str_pad(soNumero($dadosprodnfe->pICMS), 4, '0', STR_PAD_LEFT);
            $registro75 .= str_pad(soNumero($dadosprodnfe->pMVAST), 5, '0', STR_PAD_LEFT);
            $registro75 .= str_pad('0', 13, '0', STR_PAD_LEFT);
            $registro75 .= "\r\n";
        endif;
    endforeach;

    if ($nfe->modelo <> '65' && $nfe->modelo <> '57') :
        if ($nfe->vFretenf > 0) :
            $totalregistro54 = $totalregistro54 + 1;
            $registro54 .= '54';
            $registro54 .= str_pad(soNumero($nfe->destCNPJ), 14, '0', STR_PAD_LEFT);
            $registro54 .= str_pad(soNumero($nfe->modelo), 2, '0');
            $registro54 .= str_pad(soNumero($nfe->serie), 3, ' ');
            $registro54 .= str_pad(substr(soNumero($nfe->nNF), -6), 6, '0', STR_PAD_LEFT);
            $registro54 .= str_pad(substr(BuscaCFOP($nfe->id), 0, 4), 4, '0', STR_PAD_LEFT);
            $registro54 .= str_pad(substr('0', 0, 3), 3, '0', STR_PAD_LEFT);
            $registro54 .= str_pad(substr('991', 0, 3), 3, '0', STR_PAD_LEFT);
            $registro54 .= str_pad('', 14, ' ');
            $registro54 .= str_pad('', 11, '0', STR_PAD_LEFT);
            $registro54 .= str_pad(soNumero($nfe->vFretenf), 12, '0', STR_PAD_LEFT);
            $registro54 .= str_pad(soNumero($nfe->vFretenf), 12, '0', STR_PAD_LEFT);
            $registro54 .= str_pad('', 12, '0', STR_PAD_LEFT);
            $registro54 .= str_pad('', 12, '0', STR_PAD_LEFT);
            $registro54 .= str_pad('', 12, '0', STR_PAD_LEFT);
            $registro54 .= str_pad('', 4, '0', STR_PAD_LEFT);
            $registro54 .= "\r\n";
        endif;

        if ($nfe->vOutronf > 0) :
            $totalregistro54 = $totalregistro54 + 1;
            $registro54 .= '54';
            $registro54 .= str_pad(soNumero($nfe->destCNPJ), 14, '0', STR_PAD_LEFT);
            $registro54 .= str_pad(soNumero($nfe->modelo), 2, '0');
            $registro54 .= str_pad(soNumero($nfe->serie), 3, ' ');
            $registro54 .= str_pad(substr(soNumero($nfe->nNF), -6), 6, '0', STR_PAD_LEFT);
            $registro54 .= str_pad(substr(BuscaCFOP($nfe->id), 0, 4), 4, '0', STR_PAD_LEFT);
            $registro54 .= str_pad(substr('0', 0, 3), 3, '0', STR_PAD_LEFT);
            $registro54 .= str_pad(substr('999', 0, 3), 3, '0', STR_PAD_LEFT);
            $registro54 .= str_pad('', 14, ' ');
            $registro54 .= str_pad('', 11, '0', STR_PAD_LEFT);
            $registro54 .= str_pad('', 12, '0', STR_PAD_LEFT);
            $registro54 .= str_pad(soNumero($nfe->vOutronf), 12, '0', STR_PAD_LEFT);
            $registro54 .= str_pad('', 12, '0', STR_PAD_LEFT);
            $registro54 .= str_pad('', 12, '0', STR_PAD_LEFT);
            $registro54 .= str_pad('', 12, '0', STR_PAD_LEFT);
            $registro54 .= str_pad('', 4, '0', STR_PAD_LEFT);
            $registro54 .= "\r\n";
        endif;
    endif;
endforeach;

$texto .= strtoupper($registro50);
$texto .= strtoupper($registro54);

foreach ($dadosnfe as $nfe) :
    if ($nfe->modelo == '65'):
        $totalregistro61 = $totalregistro61 + 1;
        $registro61 = '61';
        $registro61 .= str_pad(' ', 14, ' ');
        $registro61 .= str_pad(' ', 14, ' ');
        $registro61 .= parseDate($nfe->dhEmi, "Ymd");
        $registro61 .= str_pad(soNumero($nfe->modelo), 2, '0');
        $registro61 .= str_pad(soNumero($nfe->serie), 3, ' ');
        $registro61 .= str_pad('', 2, ' ');
        $registro61 .= str_pad(substr(soNumero($nfe->nNF), -6), 6, '0', STR_PAD_LEFT);
        $registro61 .= str_pad(substr(soNumero($nfe->nNF), -6), 6, '0', STR_PAD_LEFT);
        $registro61 .= str_pad(soNumero($nfe->vNF), 13, '0', STR_PAD_LEFT);
        $registro61 .= str_pad(soNumero($nfe->vBCnf), 13, '0', STR_PAD_LEFT);
        $registro61 .= str_pad(soNumero($nfe->vICMSnf), 12, '0', STR_PAD_LEFT);
        $registro61 .= str_pad('0', 13, '0', STR_PAD_LEFT);
        $registro61 .= str_pad(soNumero($nfe->vOutronf), 13, '0', STR_PAD_LEFT);
        $registro61 .= str_pad('0', 4, '0', STR_PAD_LEFT);
        $registro61 .= ' ';
        $registro61 .= "\r\n";
        $texto .= strtoupper($registro61);
    endif;
endforeach;
$texto .= strtoupper($registro61R);

$totalregistro70 = 0;
foreach ($dadosnfe as $nfe) :
    if ($nfe->modelo == '57'):
        $totalregistro70 = $totalregistro70 + 1;
        $registro70 = '70';
        $registro70 .= str_pad(soNumero($nfe->destCNPJ), 14, '0', STR_PAD_LEFT);
        $registro70 .= str_pad(soNumero(padronizarIE($nfe->destUF, $nfe->destIE)), 14, ' ');
        $registro70 .= parseDate($nfe->dhEmi, "Ymd");
        $registro70 .= str_pad($nfe->destUF, 2, ' ');
        $registro70 .= str_pad(soNumero($nfe->modelo), 2, '0');
        $registro70 .= str_pad(soNumero($nfe->serie), 3, ' ');
        $registro70 .= str_pad(substr(soNumero($nfe->nNF), -6), 6, '0', STR_PAD_LEFT);
        $registro70 .= str_pad(substr(soNumero($nfe->CFOP), 0, 4), 4, '0', STR_PAD_LEFT);
        $registro70 .= str_pad(soNumero($nfe->vNF), 13, '0', STR_PAD_LEFT);
        $registro70 .= str_pad(soNumero($nfe->vBCnf), 14, '0', STR_PAD_LEFT);
        $registro70 .= str_pad(soNumero($nfe->vICMSnf), 14, '0', STR_PAD_LEFT);
        $registro70 .= str_pad('0', 14, '0', STR_PAD_LEFT);
        $registro70 .= str_pad(substr(soNumero($nfe->vOutronf)), 14, '0', STR_PAD_LEFT);
        $registro70 .= '1';
        if ($nfe->status == '101') :
            $registro70 .= 'S';
        else :
            $registro70 .= 'N';
        endif;
        $registro70 .= "\r\n";
        $texto .= strtoupper($registro70);
    endif;

endforeach;

$registro74 = '';
$totalregistro74 = 0;

if ($_POST['inventario'] == 'S') :
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'nfe');
    $sql = "SELECT produto, descricao, unidade, ref, sum(qtdsaida) as qtdsaida, 
                sum(qtdentrada) as qtdentrada, data, ncm, sum(totalsaida) as totalsaida,
                sum(totalentrada) as totalentrada,
                empresa from temp_inventario";
    $sql .= " WHERE empresa = '" . $_SESSION['Empresa'] . "'";
    
    $sql .= " Group by produto order by descricao";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);
    foreach ($dados as $dados) :
        $qtd = $dados->qtdentrada - $dados->qtdsaida;
        $qtd = number_format($qtd, 3, '.', '');
        $precomedio = $dados->qtdentrada > 0 ? ($dados->totalentrada / $dados->qtdentrada) : 0;
        $total = $qtd * $precomedio;
        $precomediov = number_format($precomedio, 6, ',', '.');
        
        $precocorrigio = substr($precomediov, -4);

        $total = number_format($total, 2, '.', '');
        if ($qtd > 0) :
            $totalregistro74 = $totalregistro74 + 1;
            $totalinventaro = $totalinventaro + $total;
            $datainventario = parseDate($_POST['datainventario'], 'Ymd');
            $registro74 .= '74';
            $registro74 .= $datainventario;
            $registro74 .= str_pad($dados->produto, 14, ' ');
            $registro74 .= str_pad(soNumero($qtd), 13, '0', STR_PAD_LEFT);
            $registro74 .= str_pad(soNumero($total), 13, '0', STR_PAD_LEFT);
            $registro74 .= '1';
            $registro74 .= str_pad('0', 14, '0', STR_PAD_LEFT);
            $registro74 .= str_pad(' ', 14, ' ');
            $registro74 .= 'MG';
            $registro74 .= str_pad(' ', 45, ' ');
            $registro74 .= "\r\n";

            $search = '';
            $search .= parseDate($data1, "Ymd");
            $search .= parseDate($data2, "Ymd");
            $search .= str_pad(substr($dados->produto, 0, 14), 14, ' ');
            if (preg_match("/{$search}/i", $registro75)) :
                $search = '';
            else :
                $totalregistro75 = $totalregistro75 + 1;
                $registro75 .= '75';
                $registro75 .= parseDate($data1, "Ymd");
                $registro75 .= parseDate($data2, "Ymd");
                $registro75 .= str_pad(substr($dados->produto, 0, 14), 14, ' ');
                $registro75 .= str_pad(substr($dados->ncm, 0, 8), 8, ' ');
                $registro75 .= str_pad(substr(removeAcentos(trim($dados->descricao)), 0, 53), 53, ' ');
                $registro75 .= str_pad(substr($dados->unidade, 0, 6), 6, ' ');
                $registro75 .= str_pad('0', 5, '0', STR_PAD_LEFT);
                $registro75 .= str_pad('0', 4, '0', STR_PAD_LEFT);
                $registro75 .= str_pad('0', 5, '0', STR_PAD_LEFT);
                $registro75 .= str_pad('0', 13, '0', STR_PAD_LEFT);
                $registro75 .= "\r\n";
                $search = '';
            endif;

        endif;
    endforeach;
    $texto .= strtoupper($registro74);
endif;

$totalgeral = $totalregistro50 + $totalregistro51 + $totalregistro54 + $totalregistro61 + $totalregistro70 + $totalregistro74 + $totalregistro75 + 3;

$texto .= strtoupper($registro75);

$registro90 = '90';
$registro90 .= str_pad(soNumero($emitente->CNPJ), 14, '0', STR_PAD_LEFT);
$registro90 .= str_pad($emitente->IE, 14, ' ');
$registro90 .= '50';
$registro90 .= str_pad($totalregistro50, 8, '0', STR_PAD_LEFT);
if ($_POST['inventario'] == 'N') :
    $registro90 .= '51';
    $registro90 .= str_pad($totalregistro51, 8, '0', STR_PAD_LEFT);
endif;
$registro90 .= '54';
$registro90 .= str_pad($totalregistro54, 8, '0', STR_PAD_LEFT);
$registro90 .= '61';
$registro90 .= str_pad($totalregistro61, 8, '0', STR_PAD_LEFT);
$registro90 .= '70';
$registro90 .= str_pad($totalregistro70, 8, '0', STR_PAD_LEFT);
if ($_POST['inventario'] == 'S') :
    $registro90 .= '74';
    $registro90 .= str_pad($totalregistro74, 8, '0', STR_PAD_LEFT);
endif;
$registro90 .= '75';
$registro90 .= str_pad($totalregistro75, 8, '0', STR_PAD_LEFT);
$registro90 .= '99';
$registro90 .= str_pad($totalgeral, 8, '0', STR_PAD_LEFT);

$total90 = strlen($registro90);
$total90 = 125 - $total90;
$registro90 .= str_pad(' ', $total90, ' ');
$registro90 .= '1';

$texto .= strtoupper($registro90);

$arquivo = fopen("sintegra-" . $emitente->CNPJ . "-" . $mes . ".txt", "w");
fwrite($arquivo, $texto);
fclose($arquivo);

$nomearquivo = "sintegra-" . $emitente->CNPJ . "-" . $mes . ".txt";

function download($arquivo) {
    header("Content-Type: application/force-download");
    header("Content-Type: application/octet-stream;");
    header("Content-Length:" . filesize($arquivo));
    header("Content-disposition: attachment; filename=" . $arquivo);
    header("Pragma: no-cache");
    header("Cache-Control: no-store, no-cache, must-revalidate, post-check=0, pre-check=0");
    header("Expires: 0");
    readfile($arquivo);
    flush();
}

//print_R($_POST);

download($nomearquivo);
