<?php
namespace PhpPimacoTest;

use PHPUnit\Framework\TestCase;
use Proner\PhpPimaco\Tags\QrCode;

class QrCodeTest extends TestCase
{
    function test_render()
    {
        $qrcode = new QrCode('123456789');

        $render = "<img style='float: left' src='data:image/png;base64,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'>";
        $this->assertEquals($render,$qrcode->render());
    }

    function test_render_with_br()
    {
        $qrcode = new QrCode('123456789');
        $qrcode->br();
        
        $render = "<img  src='data:image/png;base64,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'><br>";
        $this->assertEquals($render,$qrcode->render());
    }
}
