<?php

require_once "../_class/Conexao_class.php";
require_once "../_class/Crud_class.php";
require_once "vendor/autoload.php";

//echo $codigo->getHtmlDiv();

use Proner\PhpPimaco\Tag;
use Proner\PhpPimaco\Pimaco;

$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'geraetq');
$sql = "SELECT geraetiq.id, geraetiq.produto, geraetiq.qtd, estoqueprodutos.estoqueprodutosid, estoqueprodutos.var1, estoqueprodutos.produto, estoqueprodutos.codproduto, 
produtos.codigo, produtos.ref, produtos.descricao, 
precoprodutos.produto, precoprodutos.tabela, precoprodutos.valor
from geraetiq
LEFT JOIN estoqueprodutos on geraetiq.produto = estoqueprodutos.codproduto
LEFT JOIN produtos on produtos.codigo = estoqueprodutos.produto
LEFT JOIN precoprodutos on precoprodutos.produto = produtos.codigo";
$sql .= " Where tabela = '1'";

$arrayParam = '';
$dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);


$var = '';
$pimaco = new Pimaco('6089');

foreach ($dados as $etq) :
    for ($index = 0; $index < $etq->qtd; $index++) :
        $tag = new Tag();
        $tag->setBorder(0.1);
        $tag->p('&nbsp;' . substr($etq->descricao, 0, 30) . '')->setSize(2)->br();
        $tag->p('&nbsp;R$: ' . number_format($etq->valor, 2, ',', '.') . '')->setSize(2)->br();
        $tag->barcode('T2'.$etq->estoqueprodutosid.'', 'TYPE_CODE_128')->setWidth(1.8)->setMargin(array(0, 0, 0, 1))->br();
        $tag->p('&nbsp;'. $etq->codproduto . '')->setSize(2)->b();
        $pimaco->addTag($tag);
    endfor;

endforeach;



$pimaco->output();
