<?php
date_default_timezone_set("Brazil/East");
require_once("../../../functions.php");
require_once("../_modal/_modal.php");
require_once("../../_class/Conexao_class.php");
require_once("../../_class/Crud_class.php");
require_once("../../_class/Emitente_class.php");
//error_reporting(E_ALL);
//ini_set('display_errors', 'On');
?>
<!DOCTYPE html>
<html lang="en" >
    <head>
        <meta charset="UTF-8">
        <title>Timeline</title>
        <link rel="stylesheet" href="css/main.css">
    </head>
    <body>
        <!-- partial:index.partial.html -->
        <div class="body-wrap">
            <!-- # component starts -->
            <div class="pres-timeline" id="this-timeline">
                <!-- ###   -->
                <!--   <div class="periods-section"> -->
                <div class="periods-container">
                    <?php
                    $sql = "SELECT * FROM " . $SETTINGS["data_table_periods"];
                    if ($result = $mysqli->query($sql)) {
                        while ($row = $result->fetch_assoc()) {
                            ?>
                            <section class="period-single" period="period<?php echo $row['id']; ?>">
                                <h4 class="year"><?php echo $row['years']; ?></h4>
                                <h2 class="title"><?php echo $row['title']; ?></h2>
                                <p><?php echo $row['description']; ?></p>
                            </section>
                        <?php
                        }
                    }
                    ?>

                    <div class="btn-back"></div>
                    <div class="btn-next"></div>
                </div>
                <!--   </div> -->
                <!-- ### -->
                <!--   <div class="timeline-section"> -->
                <div class="timeline-container">
                    <!--     # timeline graphic place holder - fill with js -->
                    <div class="timeline"></div>

                    <div class="btn-back"><svg width="30" height="30" viewBox="0 0 30 30" xmlns="http://www.w3.org/2000/svg"><path fill="none" d="M0 0h30v30H0z"/><path fill="#D8D8D8" fill-rule="evenodd" d="M11.828 15l7.89-7.89-2.83-2.828L6.283 14.89l.11.11-.11.11L16.89 25.72l2.828-2.83"/></svg></div>
                    <div class="btn-next"><svg width="30" height="30" viewBox="0 0 30 30" xmlns="http://www.w3.org/2000/svg"><path fill="none" d="M0 0h30v30H0z"/><path fill="#D8D8D8" fill-rule="evenodd" d="M18.172 14.718l-7.89-7.89L13.112 4l10.606 10.607-.11.11.11.11-10.608 10.61-2.828-2.83 7.89-7.89"/></svg></div>
                </div>
                <!--   </div> -->
                <!-- ### -->
                <!--   <div class="cards-section"> -->
                <div class="cards-container">
                    <?php
                    $flag = true;
                    $sql = "SELECT *, DATE_FORMAT(datetime, '%Y') AS 'date' FROM " . $SETTINGS["data_table_timeline"] . " ORDER BY datetime ASC";
                    if ($result = $mysqli->query($sql)) {
                        while ($row = $result->fetch_assoc()) {
                            ?>
                            <section class="card-single<?php if ($flag) echo ' active'; ?>"
                                     period="period<?php echo $row['period_id']; ?>">
                                <h4 class="year"><?php echo $row['date']; ?></h4>
                                <h2 class="title"><?php echo $row['title']; ?></h2>
                                <div class="content">
                                    <img src="<?php echo $row['image']; ?>" alt=""/>
                                    <p><?php echo $row['description']; ?></p>
                                </div>
                            </section>
                            <?php
                            $flag = false;
                        }
                    }
                    ?>

                </div>
                <!--   </div> -->
                <!-- ###   -->
            </div>
            <!-- # component ends -->
        </div>
        <!-- partial -->
        <script src='https://cdnjs.cloudflare.com/ajax/libs/jquery/3.2.1/jquery.min.js'></script>
        <script  src="js/main.js"></script>
        <script>
            // ## document load ##
            $(document).ready(function () {
                var colorcode = {
                    'period1': '#fec541',
                    'period2': '#36d484'
                };
                var timeline = new PRESTimeline($('#this-timeline'), colorcode);
            });
        </script>
    </body>
</html>
