<?php
$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'cliente');

$data = date("d/m");

$sql = "SELECT produtos.codigo, produtos.descricao, produtos.custo, precoprodutos.produto,
    precoprodutos.valor,
    produtos.custo + 0.20 as minvenda from produtos inner JOIN precoprodutos 
    on precoprodutos.produto = produtos.codigo where precoprodutos.valor < produtos.custo + 0.20";
$arrayParam = '';
//echo $sql;
$dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

if (count($dados) > 0) :
    ?>
    <div class="row">

        <div class="col-md-12">


            <section class="panel panel-featured panel-featured-default" style="border: 1px solid #dddddd;">
                <header class="panel-heading">              
                    <h2 class="panel-title">Produtos com preço de venda menor que 20%</h2>
                </header>
                <div class="panel-body">
                    <table class="table table-hover table-condensed table-striped width-full">
                        <tr>
                            <td><b>Produto</b></td>
                            <td><b>Descrição</b></td>
                            <td><b>Custo</b></td>
                            <td><b>Valor de Venda</b></td>
                            <td><b>Valor Min.</b></td>

                        </tr>
                        <?php
                        foreach ($dados as $produto) :
                            ?>
                            <tr>
                                <td><?= $produto->produto ?></td>
                                <td><?= $produto->descricao ?></td>                              
                                <td>R$ <?= number_format($produto->custo, 2, ',', '') ?></td>
                                <td>R$ <?= number_format($produto->valor, 2, ',', '') ?></td>
                                <td>R$ <?= number_format($produto->minvenda, 2, ',', '') ?></td>
                            </tr>
                            <?php
                        endforeach;
                        ?>
                    </table>

                </div>
            </section>
        </div>
    </div>

    <?php
endif;
?>