<?php
require_once("../../../functions.php");
require_once "../../../_backend/_class/Conexao_class.php";
require_once "../../../_backend/_class/Crud_class.php";
require_once "../../../_backend/_class/parametros.php";
require_once "../../../_backend/_class/Emitente_class.php";
require_once "../../../_backend/_class/cobranca_class.php";

function Situacao($valor) {
    switch ($valor) :
        case "A" :
            return '<label class="label label-info" style="font-size: 95%;"> Aberta </label>';
            break;
        case "BC" :
            return '<label class="label label-success" style="font-size: 95%;"> Baixada </label>';
            break;
        case "BP" :
            return '<label class="label label-warning" style="font-size: 95%;">Parcialmente </label>';
            break;
    endswitch;
}

function BuscaEmpresa($empresa) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'estoqueprodutos');
    $sql = "SELECT * from emitente where emitenteid = '$empresa'
        ";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, false);

    return $dados->xFant;
}

?>
<div class="scroller" style="height:200px; overflow-y: scroll" data-rail-visible="1" data-rail-color="yellow" data-handle-color="#a1b2bd">

    <table class="table table-striped table-hover table-condensed">
        <tr>
            <td><b>TÍTULO</b></td>
            <td><b>CLIENTE</b></td>
            <td><b>EMISSÃO</b></td>
            <td><b>VENCIMENTO</b></td>
            <td><b>TIPO</b></td>
            <td><b>HISTORICO</b></td>
            <td><b>VALOR</b></td>
            <td><b>SITUAÇÃO</b></td>
            <td style="width: 10%"><b>EMPRESA</b></td>
            <td><b>LEMBRETE</b></td>
        </tr>
        <?php
//        error_reporting(E_ALL);
//        ini_set('display_errors', 'On');
        if (!isset($_GET['datai'])) :
            $_GET['datai'] = date('Y-m-d', strtotime(date("Y-m-d") . ' - 10 days'));
        endif;
        if (!isset($_GET['dataf'])) :
            $_GET['dataf'] = date('Y-m-d');
        endif;
//        $_GET['datai'] = parseDate($_GET['datai'], 'Y-m-d');
//        $_GET['dataf'] = parseDate($_GET['dataf'], 'Y-m-d');

        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'lancamento');
        $total = 0;
        $sql = "SELECT 
  lancamento.`lancamentoid`,
  lancamento.`titulo`,
  lancamento.`parcela`,
  lancamento.`historico`,
  lancamento.`tipoconta`,
  lancamento.`tipocobranca`,
  lancamento.`dataemissao`,
  lancamento.`datavencimento`,
  lancamento.`valor`,
  lancamento.`fornecedor`,
  lancamento.`cliente`,
  lancamento.`representante`,
  lancamento.`funcionario`,
  lancamento.`transportador`,
  lancamento.`planodecontas`,
  lancamento.`situacao`,
  lancamento.`datapagamento`,
  lancamento.`obs`,
  lancamento.`aprovadopag`,
  lancamento.empresa,
  cliente.xNome as clientenome,
  cliente.whatsapp,
  cliente.clienteid as clienteid,
  funcionario.xNome as funcionarionome,
  funcionario.funcionarioid as funcionarioid,
  transportador.xNome as transportadornome,
  transportador.transportadorid as transportadorid
FROM 
lancamento
 LEFT JOIN cliente as cliente ON lancamento.cliente = cliente.clienteid
 LEFT JOIN transportador as transportador ON lancamento.transportador = transportador.transportadorid
 LEFT JOIN funcionario as funcionario ON lancamento.funcionario = funcionario.funcionarioid";
        $sql .= ' WHERE str_to_date(datavencimento, "%d/%m/%Y") BETWEEN "' . $_GET['datai'] . '" AND "' . $_GET['dataf'] . '"';
        $sql .= " AND lancamento.tipoconta = 'R'
                            and situacao <> 'BC'";
        $arrayParam = '';
        $dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

//                    echo $sql;
        foreach ($dados as $row) :
            if ($row->aprovadopag == 'S') :
                $bg = "bg_confirmada";
            elseif ($row->aprovadopag == 'N') :
                $bg = "bg_cancelada";
            else :
                $bg = "bg-default";
            endif;
            ?>
            <tr class="<?= $bg ?>">
                <td><?= $row->titulo ?>/<?= $row->parcela ?></td>
                <td><?php
                    if ($row->cliente != "") :
                        if ($row->transportador > 0) :
                            echo $row->fornecedor . ' - ' . $row->fornecedornome . ' <br/> ' . $row->transportador . ' - ' . $row->transportadornome;
                        else :
                            echo $row->cliente . ' - ' . $row->clientenome;
                        endif;
                    elseif ($row->funcionario != "") :
                        echo $row->funcionario . ' - ' . $row->funcionarionome;
                    elseif ($row->transportador != "") :
                        echo $row->transportador . ' - ' . $row->transportadornome;

                    else :
                        echo '';
                    endif;
                    ?></td>

                <td><?= $row->dataemissao ?></td>
                <td><?= $row->datavencimento ?></td>
                <td><?= $cobranca[$row->tipocobranca] ?></td>
                <td><?= substr($row->historico, 0, 25) ?>.</td>
                <td>R$ <?= number_format($row->valor, 2, ',', '.') ?></td>
                <td><?= Situacao($row->situacao); ?></td>
                <td><?= BuscaEmpresa($row->empresa) ?></td>
                <td><button class="btn btn-success" type="button" onclick="AbreZapLembrete('<?= $row->clientenome ?>', '<?= $row->datavencimento ?>', '<?= number_format($row->valor, 2, ',', '.') ?>', '<?= $row->whatsapp ?>')"><i class="fa fa-whatsapp"></i></button></td>
               
            </tr>
            <?php
            $total = $total + $row->valor;
        endforeach;
        ?>
    </table>
</div>
<script>
    $("#totallembrete").html('<?= number_format($total, 2, ',', '.') ?>');


    function AbreZapLembrete(cliente, vencimento, valor, whatsapp) {
        var msg = 'Olá ' + cliente + '! Passando para lembrar que seu boleto no valor de R$ ' + valor + ' vence no dia ' + vencimento + '! Se você já tiver efetuado o pagamento, favor desconsiderar essa mensagem, ou se precisar da segunda via do seu boleto, so me falar. Desde de já agradeço!';
        $("#msgzaptlem").val(msg);
        $("#zaplem").val(whatsapp);
        $("#msgzaplembrete").modal('show');
    }

    function EnviaZapLembrete() {
        var msg = $("#msgzaptlem").val();
        var zap = $("#zaplem").val();
        window.open('https://api.whatsapp.com/send?phone=55' + zap + '&text=' + msg);
//        $("#msgzap").modal("hide");
        FechaZapLembrete();
    }


    function FechaZapLembrete() {
         $("#msgzaplembrete").modal("hide");
    }

</script>


<div class="modal fade bs-modal-lg bd-example-modal-xl" id="msgzaplembrete" style="z-index: 99999" tabindex="-1" role="dialog" aria-hidden="true" backdrop="static" data-backdrop="static">
    <div class="modal-dialog modal-lg modal-xl" style="width: 50%;">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title"> Enviar para cliente</h4>
            </div>

            <div class="modal-body"> 
                <div class="row">
                    <div class="col-md-12">
                        <label>Mensagem</label>
                        <textarea id="msgzaptlem" rows="5" class="form-control"></textarea>
                    </div>

                </div>
                <div class="row">
                    <div class="col-md-4">
                        <label>Whatsapp</label>
                        <div class="input-group input-group-icon">
                            <input name="whatsapp" maxlength="15" id="zaplem" onkeypress='mascaraTelefone(this, cpfCnpj)' value="<?= $dadoscliente->whatsapp ?>" type="text" class="form-control" placeholder=""> 
                            <span class="input-group-addon">
                                <span class="icon icon-lg">
                                    <i class="fa fa-whatsapp"></i>
                                </span>
                            </span>
                        </div>
                    </div>

                </div>
            </div>

            <div class="modal-footer"> 
                <a href="javascript::" onclick="FechaZapLembrete()"  class="btn btn-warning"> <i class="fa fa-close"></i> Sair </a>
                <a href="javascript::" onclick="EnviaZapLembrete()"  class="btn btn-success"> <i class="fa fa-whatsapp"></i> Enviar </a>
            </div>
        </div>
    </div>
</div>