<?php

function BuscaVariacaoDesc($prod, $variacao, $sigla, $nivel) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'estoqueprodutos');
    $sql = "SELECT produtos.variacao, produtos.codigo, 
                    variacao.variacaoid, variacao.var1, variacao.var2, 
                    variacao.var3 ,
                    itensvariacao.variacao, itensvariacao.sigla,
                    itensvariacao.descricao, itensvariacao.nivel
                    FROM produtos 
                    INNER JOIN variacao ON produtos.variacao = variacao.variacaoid 
                    INNER JOIN itensvariacao ON itensvariacao.variacao = variacao.variacaoid                   
                    WHERE codigo = '$prod' 
                    AND itensvariacao.nivel = '$nivel'
                    AND itensvariacao.sigla = '$sigla'";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, false);

    return $dados->descricao;
}

$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'cliente');

$data = date("d/m");

$sql = "SELECT produtos.codigo , produtos.descricao, estoqueprodutos.produto, estoqueprodutos.var1, estoqueprodutos.var2, estoqueprodutos.var3,
estoqueprodutos.codproduto, estoqueprodutos.estoquemin, estoqueprodutos." . $_SESSION['Estoque'] . " as estoque from produtos
INNER join estoqueprodutos on estoqueprodutos.produto = produtos.codigo where estoqueprodutos.estoquemin >  estoqueprodutos." . $_SESSION['Estoque'] . "
   LIMIT 20 
    ";
$arrayParam = '';
//echo $sql;
$dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

if (count($dados) > 0) :
    ?>
    <div class="row">

        <div class="col-md-12">


            <section class="panel panel-featured panel-featured-default" style="border: 1px solid #dddddd;">
                <header class="panel-heading">              
                    <h2 class="panel-title">Produtos com pouco estoque</h2>
                </header>
                <div class="panel-body">
                    <table class="table table-hover table-condensed table-striped width-full">
                        <tr>
                            <td><b>Produto</b></td>
                            <?php
                            if ($parametros->grade === 'S') :
                                ?>
                                <td><b>Código</b></td>
                                <?php
                            endif;
                            ?>
                            <td><b>Descrição</b></td>
                            <?php
                            if ($parametros->grade === 'S') :
                                ?>
                                <td><b>Var 1</b></td>
                                <td><b>Var 2</b></td>
                                <td><b>Var 3</b></td>
                                <?php
                            endif;
                            ?>
                            <td><b>Qtd</b></td>

                        </tr>
                        <?php
                        foreach ($dados as $produto) :
                            ?>
                            <tr>
                                <td><?= $produto->produto ?></td>
                                <?php
                                if ($parametros->grade === 'S') :
                                    ?>
                                    <td><?= $produto->codproduto ?></td>
                                    <?php
                                endif;
                                ?>
                                <td><?= $produto->descricao ?></td>
                                <?php
                                if ($parametros->grade === 'S') :
                                    ?>
                                    <td><?= $produto->var1 . ' - ' . BuscaVariacaoDesc($produto->produto, '1', $produto->var1, '1') ?></td>
                                    <td><?= $produto->var2 . ' - ' . BuscaVariacaoDesc($produto->produto, '2', $produto->var2, '2') ?></td>
                                    <td><?= $produto->var3 . ' - ' . BuscaVariacaoDesc($produto->produto, '3', $produto->var3, '3') ?></td>
                                    <?php
                                endif;
                                ?>
                                <td><?= $produto->estoque ?></td>
                            </tr>
                            <?php
                        endforeach;
                        ?>
                    </table>

                </div>
            </section>
        </div>
    </div>

    <?php
endif;
?>