<script src="https://cdn.jsdelivr.net/npm/chart.js@2.8.0"></script>
<style>
    canvas {
        -moz-user-select: none;
        -webkit-user-select: none;
        -ms-user-select: none;
    }
</style>
<?php

function CalculaP($valor, $total) {
    $valor1 = $valor / $total;
    $porcentagem = $valor1 * 100;

//    return number_format($porcentagem, 2, ',', '');
    return $porcentagem;
}

function Classificao($porc) {
    if ($porc < 80) :
        return 'A';
    elseif ($porc < 95) :
        return 'B';
    else :
        return 'C';
    endif;
}

function RetornaCor($classificacao) {
    if ($classificacao == 'A') :
        return 'style="background: #c5f3b2;
    color: #737373;"';
    elseif ($classificacao == 'B') :
        return 'style="background: #ffe5bf;
    color: #737373;"';
    else :
        return 'style="background: #f3f3f3;
    color: #737373;"';
    endif;
}

function BuscaVariacaoDesccuva($prod, $variacao, $sigla, $nivel) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'estoqueprodutos');
    $sql = "SELECT produtos.variacao, produtos.codigo, 
                    variacao.variacaoid, variacao.var1, variacao.var2, 
                    variacao.var3 ,
                    itensvariacao.variacao, itensvariacao.sigla,
                    itensvariacao.descricao, itensvariacao.nivel
                    FROM produtos 
                    INNER JOIN variacao ON produtos.variacao = variacao.variacaoid 
                    INNER JOIN itensvariacao ON itensvariacao.variacao = variacao.variacaoid                   
                    WHERE codigo = '$prod' 
                    AND itensvariacao.nivel = '$nivel'
                    AND itensvariacao.sigla = '$sigla'";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, false);

    return $dados->descricao;
}

$data_incio1 = mktime(0, 0, 0, date('m'), 1, date('Y'));
$data_fim1 = mktime(23, 59, 59, date('m'), date("t"), date('Y'));
$inicio1 = date('Y-m-d', $data_incio1);
$fim1 = date('Y-m-d', $data_fim1);

$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'cliente');
$data = date("d/m");
$sql = 'select movimentacao.documento, movimentacao.data, movimentacao.finalizado, 
    movimentacao.empresa, itmovimentacao.documento, itmovimentacao.preco, itmovimentacao.cancelado, 
    sum(itmovimentacao.quantidade) as qtd, 
    sum(itmovimentacao.quantidade) * itmovimentacao.preco as total,
    itmovimentacao.produto, 
    estoqueprodutos.produto as prod, estoqueprodutos.codproduto, 
    estoqueprodutos.var1, estoqueprodutos.var2, estoqueprodutos.var3,
    produtos.codigo,  produtos.descricao from movimentacao 
    INNER JOIN itmovimentacao ON itmovimentacao.documento = movimentacao.documento 
    INNER JOIN estoqueprodutos ON estoqueprodutos.codproduto = itmovimentacao.produto 
    INNER JOIN produtos ON produtos.codigo = estoqueprodutos.produto 
    where str_to_date(data, "%d/%m/%Y") BETWEEN "' . $inicio1 . '" AND "' . $fim1 . '" 
        AND itmovimentacao.cancelado = "N"
    GROUP by itmovimentacao.produto 
    ORDER BY total DESC 
    LIMIT 15 ';
//echo $sql;
$arrayParam = '';
$dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

$total = 0;
foreach ($dados as $dadost) :
    $total = $total + $dadost->total;
endforeach;
//print_r($dados);
?>
<div class="row">

    <canvas id="myChart"></canvas>
    <script>
        var ctx = document.getElementById('myChart').getContext('2d');
        var chart = new Chart(ctx, {
            // The type of chart we want to create
            type: 'line',

            // The data for our dataset
            data: {
                labels: ['January', 'February', 'March', 'April', 'May', 'June', 'July'],
                datasets: [{
                        label: 'My First dataset',
                        backgroundColor: 'rgb(255, 99, 132)',
                        borderColor: 'rgb(255, 99, 132)',
                        data: [0, 10, 5, 2, 20, 30, 45]
                    }]
            },

            // Configuration options go here
            options: {}
        });
    </script>

    <div class="col-md-12">


        <section class="panel panel-featured panel-featured-default" style="border: 1px solid #dddddd;">
            <header class="panel-heading">              
                <h2 class="panel-title">Curva ABC produtos vendidos (Mensal)</h2>
            </header>
            <div class="panel-body">
                <table class="table table-condensed width-full">
                    <tr>
                        <td><b>Produto</b></td>
                        <?php
                        if ($parametros->grade === 'S') :
                            ?>
                            <td><b>Var 1</b></td>
                            <td><b>Var 2</b></td>
                            <td><b>Var 3</b></td>
                            <?php
                        endif;
                        ?>
                        <td><b>Quantidade</b></td>
                        <td><b>Preço Médio</b></td>
                        <td><b>Valor Total</b></td>
                        <td><b>% Individual</b></td>
                        <td><b>% Acumulada</b></td>
                        <td><b>Classificação</b></td>
                    </tr>
                    <?php
                    $panterior = 0;
                    foreach ($dados as $dados) :
                        $acumulada = CalculaP($dados->total, $total) + $panterior;
                        $classificao = Classificao($acumulada);
                        ?>
                        <tr <?= RetornaCor($classificao) ?>>
                            <td><?= $dados->codproduto ?> - <?= $dados->descricao ?></td>
                            <?php
                            if ($parametros->grade === 'S') :
                                ?>
                                <td><?= $dados->var1 . ' - ' . BuscaVariacaoDesccuva($dados->prod, '1', $dados->var1, '1') ?></td>
                                <td><?= $dados->var2 . ' - ' . BuscaVariacaoDesccuva($dados->prod, '2', $dados->var2, '2') ?></td>
                                <td><?= $dados->var3 . ' - ' . BuscaVariacaoDesccuva($dados->prod, '3', $dados->var3, '3') ?></td>
                                <?php
                            endif;
                            ?>

                            <td><?php
                                if (floor($dados->qtd) != $dados->qtd) :
                                    echo $dados->qtd;
                                else :
                                    echo intval($dados->qtd);
                                endif;
                                ?></td>
                            <td>R$ <?= number_format($dados->total / $dados->qtd, 2, ',', '') ?></td>
                            <td>R$ <?= number_format($dados->total, 2, ',', '.') ?></td>

                            <td><?= number_format(CalculaP($dados->total, $total), 2, ',', '') ?> %</td>
                            <td><?php
                                echo number_format($acumulada, 2, ',', '') . ' %';
                                ?></td>
                            <td><?= Classificao($acumulada) ?></td>
                        </tr>
                        <?php
                        $panterior = CalculaP($dados->total, $total) + $panterior;
                    endforeach;
                    ?>
                </table>
            </div>

        </section>

    </div>
</div>