<?php
ob_start();
?>
<style>
    body {
        font-size: 12px;
    }

    h1, h2, h3, h4, h5, h6,
    .h1, .h2, .h3, .h4, .h5, .h6 {
        font-family: inherit;
        font-weight: 500;
        line-height: 1.1;
        color: inherit;
    }
    h1 small,
    h1 .small, h2 small,
    h2 .small, h3 small,
    h3 .small, h4 small,
    h4 .small, h5 small,
    h5 .small, h6 small,
    h6 .small,
    .h1 small,
    .h1 .small, .h2 small,
    .h2 .small, .h3 small,
    .h3 .small, .h4 small,
    .h4 .small, .h5 small,
    .h5 .small, .h6 small,
    .h6 .small {
        font-weight: normal;
        line-height: 1;
        color: #777777;
    }

    h1, .h1,
    h2, .h2,
    h3, .h3 {
        margin-top: 20px;
        margin-bottom: 10px;
    }
    h1 small,
    h1 .small, .h1 small,
    .h1 .small,
    h2 small,
    h2 .small, .h2 small,
    .h2 .small,
    h3 small,
    h3 .small, .h3 small,
    .h3 .small {
        font-size: 65%;
    }

    h4, .h4,
    h5, .h5,
    h6, .h6 {
        margin-top: 10px;
        margin-bottom: 10px;
    }
    h4 small,
    h4 .small, .h4 small,
    .h4 .small,
    h5 small,
    h5 .small, .h5 small,
    .h5 .small,
    h6 small,
    h6 .small, .h6 small,
    .h6 .small {
        font-size: 75%;
    }

    h1, .h1 {
        font-size: 36px;
    }

    h2, .h2 {
        font-size: 30px;
    }

    h3, .h3 {
        font-size: 24px;
    }

    h4, .h4 {
        font-size: 18px;
    }

    h5, .h5 {
        font-size: 14px;
    }

    h6, .h6 {
        font-size: 12px;
    }
    .text-center {
        text-align: center;
    }

    table {
        width: 100%;
        padding: 10px;
    }

    td {
        padding: 3px;
    }
    th {
        text-align: left;
    }
    /*.titulotr { border:  none};*/
    /*.titulotr { background: #000; border:1px black solid;};*/
    .table-bordered th,
    .table-bordered td {
        border: 1px solid #ddd !important;
    }

    .full_table_list_titulo{
        border-collapse: collapse;
    }
    .full_table_list_titulo tr{
        border:1px black solid;
    }

    .full_table_list{
        border-collapse: collapse;
    }
    .full_table_list tr{
        border:1px black solid;
    }
    .full_table_list tr:nth-child(even) {
        background: #fff
    }
    .full_table_list tr:nth-child(odd) {
        background: #fff
    }

    .tablecor {
        border:1px black solid;
        background: #eee
    }
    .titulotr {
        border:1px black solid;
        background: #F5F5F5
    }
</style>
<?php
require_once("../../../functions.php");
//
require_once "../../../_backend/_class/Conexao_class.php";
require_once "../../../_backend/_class/Crud_class.php";
require_once "../../../_backend/_class/cobranca_class.php";
require_once "../../../_backend/_class/parametros.php";
require_once "../../../_backend/_class/Emitente_class.php";

$logo = '' . FRONTEND . '/img/logomarca/' . $emitente->CNPJ . '/' . $emitente->logo . '';

function BuscaVendedor($valor) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'vendedor');
    $sql = "SELECT * from vendedor where vendedorid = '$valor' ";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

    return $dados->xNome;
}

$documento = $_GET['documento'];
$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'itmovimentacao_troca');
$sql = "SELECT * from movimentacao_troca where documento = '$documento' ";
$arrayParam = '';
$dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

if ($dados->para == 'R') :
    $dest = BuscaPara('R', $dados->representante);
elseif ($dados->para == 'F') :
    $dest = BuscaPara('F', $dados->funcionario);
else :
    $dest = BuscaPara('C', $dados->cliente);
endif;

function BuscaPara($valor, $id) {

    if ($valor == 'R') :
        $sql = "SELECT * from representante where representanteid = '$id' ";
    elseif ($valor == 'F') :
        $sql = "SELECT * from funcionario where funcionarioid = '$id' ";
    else :
        $sql = "SELECT * from cliente where clienteid = '$id' ";
    endif;

    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'tabela');
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

    return $dados;
}

if ($dados->tipo == 'C') :
    $titulo = 'SAÍDA CONSIGNADA ';
elseif ($dados->tipo == 'S') :
    $titulo = 'DOCUMENTO AUXILIAR DE TROCA ';
endif;

if ($dados->para == 'R') :
    $idrel = $dest->representanteid;
elseif ($dados->para == 'F') :
    $idrel = $dest->funcionarioid;
else :
    $idrel = $dest->clienteid;
endif;
?>
<table class="table full_table_list_titulo">
    <tr> 
        <td align="center"> <?= $titulo ?> <br/> ESTE DOCUMENTO NÃO É VÁLIDO COMO DOCUMENTO FISCAL </td>
    </tr>

</table>

<table class="table ">
    <tr>
        <td width="20%"><img src="<?= $logo ?>" height="80px" alt=""/></td>
        <td width="40%"><b> <?= $emitente->xNome ?> </b> 
            <br/>
            <?= $emitente->xLgr ?>, <?= $emitente->nro ?> - <?= $emitente->xBairro ?> <br/>
            <?= $emitente->xMun ?>  <?= $emitente->UF ?> <br/>
            <b>CNPJ: </b><?= $emitente->CNPJ ?> <br/>
            <b>INSC. ESTADUAL: </b><?= $emitente->IE ?> <br/>
            <b>TELEFONE: </b><?= $emitente->fone ?> <br/>
            <b>E-MAIL: </b><?= $emitente->email ?> <br/>
        </td>

        <td width="40%" align="center" style="border: 1px solid #A8A8A8; font-size: 10px;">

            DOCUMENTO Nº:   <b><?= $dados->doc_empresa ?></b>
            <hr/>
            EMISSÃO:   <b><?= $dados->data ?> <?= $dados->hora ?></b>
            <hr/>
            VENDEDOR:   <b><?= BuscaVendedor($dados->vendedor) ?></b>

        </td>
    </tr>

</table>


<table class="table table-borded full_table_list_titulo" style="border: 1px solid #A8A8A8; font-size: 12px;">
    <tr>
        <td colspan="5" style="text-align: center; background-color: #E8E8E8;">DADOS DO CLIENTE</td>
    </tr>
    <tr style="border: 1px solid #A8A8A8; font-size: 12px;">
        <td colspan="3" style="border: 1px solid #A8A8A8; font-size: 12px;">
            <span style="font-size: 10px;"> Nome / Razão Social</span> <br/>
            <?= $idrel ?>- <?= $dest->xNome ?>
        </td>

        <td style="border: 1px solid #A8A8A8; font-size: 12px;">
            <span style="font-size: 10px;"> CPF/CNPJ</span> <br/>
            <?= $dest->CNPJ ?>
        </td>
        <td  style="border: 1px solid #A8A8A8; font-size: 12px;">
            <span style="font-size: 10px;"> I.E</span> <br/>
            <?= $dest->IE ?></td>

    </tr>
    <tr style="border: 1px solid #A8A8A8; font-size: 12px;">
        <td colspan="5" style="border: 1px solid #A8A8A8; font-size: 12px;">
            <span style="font-size: 10px;"> Endereço</span> <br/>
            <?= $dest->xLgr ?>, <?= $dest->nro ?> <?= $dest->xComp ?> - <?= $dest->xBairro ?></td>



    </tr>
    <tr style="border: 1px solid #A8A8A8; font-size: 12px;">

        <td colspan="2" style="border: 1px solid #A8A8A8; font-size: 12px;">
            <span style="font-size: 10px;"> CIDADE</span> <br/>
            <?= $dest->xMun ?> - <?= $dest->UF ?>
        </td>

        <td style="border: 1px solid #A8A8A8; font-size: 12px;">
            <span style="font-size: 10px;">CEP</span> <br/>
            <?= $dest->CEP ?></td>


        <td  style="border: 1px solid #A8A8A8; font-size: 12px;">
            <span style="font-size: 10px;"> Telefone</span> <br/>
            <?= $dest->fone ?></td>
        <td  style="border: 1px solid #A8A8A8; font-size: 12px;">
            <span style="font-size: 10px;"> Whatsapp</span> <br/>
            <?= $dest->whatsapp ?></td>

    </tr>

</table>
<Br/>


<table class="table table-striped table-condensed full_table_list">
    <tr class="titulotr">
        <td colspan="6" style="text-align: center; background-color: #E8E8E8;">DEVOLUÇÕES</td>
    </tr>

    <tr class="titulotr">
        <td><b>Produto</b></td>
        <td><b>Ref.</b></td>
        <td width="40%"><b>Descrição</b></td>
        <td><b>Qtd</b></td>
        <td><b>Valor Unit.</b></td>
        <td><b>Valor Total</b></td>
    </tr>
    <tr>
    </tr>
    <?php
    $pecasD = 0;
    $totalD = 0;
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'itmovimentacao_troca');

    $parametros->romaneioagrupado = 'N';

    if ($parametros->romaneioagrupado == 'S') :

        $sql = "SELECT sum(itmovimentacao_troca.quantidade) as qtd, sum(itmovimentacao_troca.valorliquido) as total, itmovimentacao_troca.id, itmovimentacao_troca.preco,
        itmovimentacao_troca.documento, itmovimentacao_troca.produto, itmovimentacao_troca.operacao, itmovimentacao_troca.cancelado,
        estoqueprodutos.produto, estoqueprodutos.codproduto, 
produtos.codigo, produtos.descricao, produtos.ref from itmovimentacao_troca
LEFT JOIN estoqueprodutos on itmovimentacao_troca.produto = estoqueprodutos.codproduto
LEFT JOIN produtos on produtos.codigo = estoqueprodutos.produto
WHERE itmovimentacao_troca.documento = '$documento' AND itmovimentacao_troca.operacao = 'E' and itmovimentacao_troca.cancelado <> 'S'
GROUP BY estoqueprodutos.produto, itmovimentacao_troca.preco ";

    else :
        $sql = "SELECT itmovimentacao_troca.quantidade as qtd, itmovimentacao_troca.valorliquido as total, itmovimentacao_troca.id, itmovimentacao_troca.preco,
        itmovimentacao_troca.documento, itmovimentacao_troca.produto, itmovimentacao_troca.operacao, itmovimentacao_troca.cancelado,
        estoqueprodutos.produto, estoqueprodutos.codproduto, 
produtos.codigo, produtos.descricao, produtos.ref from itmovimentacao_troca
LEFT JOIN estoqueprodutos on itmovimentacao_troca.produto = estoqueprodutos.codproduto
LEFT JOIN produtos on produtos.codigo = estoqueprodutos.produto
WHERE itmovimentacao_troca.documento = '$documento' AND itmovimentacao_troca.operacao = 'E' and itmovimentacao_troca.cancelado <> 'S'";

    endif;

//    echo $sql;
    $arrayParam = '';
    $dadositD = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

    foreach ($dadositD as $value) :

        $pecasD = $pecasD + $value->qtd;
        $totalD = $totalD + $value->total;
        ?>
        <tr class=''>
            <td><?php
                if ($parametros->romaneioagrupado == 'S') :
                    echo $value->codigo;
                else :
                    echo $value->codproduto;
                endif;
                ?></td>
            <td><?= $value->ref ?></td>
            <td><?= $value->descricao ?></td>
            <td><?= number_format($value->qtd, $parametros->casadecimal, ',', '.') ?></td>
            <td>R$ <?= number_format($value->preco, $parametros->casadecimal, ',', '.') ?></td>
            <td>R$ <?= number_format($value->total, $parametros->casadecimal, ',', '.') ?></td>
        </tr>
        <?php
    endforeach;
    ?>
    <tr>
        <td colspan="5">
        </td>
    </tr>
</table>

<table class="table table-striped table-condensed full_table_list">
 <tr class="titulotr">
        <td colspan="6" style="text-align: center; background-color: #E8E8E8;">SAÍDAS</td>
    </tr>

    <tr class="">
        <td><b>Produto</b></td>
        <td><b>Ref.</b></td>
        <td width="40%"><b>Descrição</b></td>
        <td><b>Qtd</b></td>
        <td><b>Valor Unit.</b></td>
        <td><b>Valor Total</b></td>
    </tr>
    <tr>
    </tr>
    <?php
    $pecasS = 0;
    $totalS = 0;
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'itmovimentacao_troca');

    if ($parametros->romaneioagrupado == 'S') :

        $sql = "SELECT sum(itmovimentacao_troca.quantidade) as qtd, sum(itmovimentacao_troca.valorliquido) as total, itmovimentacao_troca.id, itmovimentacao_troca.preco,
        itmovimentacao_troca.documento, itmovimentacao_troca.produto, itmovimentacao_troca.operacao,itmovimentacao_troca.cancelado,
        estoqueprodutos.produto, estoqueprodutos.codproduto, 
produtos.codigo, produtos.descricao, produtos.ref from itmovimentacao_troca
LEFT JOIN estoqueprodutos on itmovimentacao_troca.produto = estoqueprodutos.codproduto
LEFT JOIN produtos on produtos.codigo = estoqueprodutos.produto
WHERE itmovimentacao_troca.documento = '$documento' AND itmovimentacao_troca.operacao = 'S' AND itmovimentacao_troca.cancelado <> 'S'
GROUP BY estoqueprodutos.produto, itmovimentacao_troca.preco";
    else :

        $sql = "SELECT itmovimentacao_troca.quantidade as qtd, itmovimentacao_troca.valorliquido as total, itmovimentacao_troca.id, itmovimentacao_troca.preco,
        itmovimentacao_troca.documento, itmovimentacao_troca.produto, itmovimentacao_troca.operacao,itmovimentacao_troca.cancelado,
        estoqueprodutos.produto, estoqueprodutos.codproduto, 
produtos.codigo, produtos.descricao, produtos.ref from itmovimentacao_troca
LEFT JOIN estoqueprodutos on itmovimentacao_troca.produto = estoqueprodutos.codproduto
LEFT JOIN produtos on produtos.codigo = estoqueprodutos.produto
WHERE itmovimentacao_troca.documento = '$documento' AND itmovimentacao_troca.operacao = 'S' AND itmovimentacao_troca.cancelado <> 'S'";
    endif;

//    echo $sql;
    $arrayParam = '';
    $dadositS = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

    foreach ($dadositS as $value) :

        $pecasS = $pecasS + $value->qtd;
        $totalS = $totalS + $value->total;
        ?>
        <tr class=''>
            <td><?php
                if ($parametros->romaneioagrupado == 'S') :
                    echo $value->codigo;
                else :
                    echo $value->codproduto;
                endif;
                ?></td>
            <td><?= $value->ref ?></td>
            <td><?= $value->descricao ?></td>
            <td><?= number_format($value->qtd, $parametros->casadecimal, ',', '.') ?></td>
            <td>R$ <?= number_format($value->preco, $parametros->casadecimal, ',', '.') ?></td>
            <td>R$ <?= number_format($value->total, $parametros->casadecimal, ',', '.') ?></td>
        </tr>
        <?php
    endforeach;
    ?>
    <tr>
        <td colspan="5">
        </td>
    </tr>
</table>

<hr/>

<table class="table table-striped table-condensed full_table_list">
    <tr>
        <td><b>Total Peças (Saída)</b></td>
        <td><?= intval($pecasS) ?></td>
    </tr>
    <tr>
        <td><b>Total Peças (Devolução)</b></td>
        <td><?= intval($pecasD) ?></td>
    </tr>
    <tr>
        <td><b> Valor (Saída)</b></td>
        <td>R$ <?= number_format($totalS, $parametros->casadecimal, ',', '.') ?></td>
    </tr>
    <tr>
        <td><b>Valor (Devolução)</b></td>
        <td>R$ <?= number_format($totalD, $parametros->casadecimal, ',', '.') ?></td>
    </tr>
    <tr>
        <td><b>Total Bruto (Saída - Devolução)</b></td>
        <td>R$ <?= number_format($totalS - $totalD, $parametros->casadecimal, ',', '.') ?></td>
    </tr>
    <tr>
        <td><b>Desconto</b></td>
        <td>R$ <?= number_format($dados->desconto, $parametros->casadecimal, ',', '.') ?></td>
    </tr>
    <tr>
        <?php
        $totalliq = $totalS - $totalD;
        $totalliq = $totalliq - $dados->desconto;
        ?>
        <td><b>Valor a Acertar: </b></td>
        <td>R$ <?= number_format($totalliq, $parametros->casadecimal, ',', '.') ?></td>
    </tr>
</table>
<?php
if ($dados->creditocliente == 'S') :
    ?>
    <h5> VALOR DE R$ <?= number_format($dados->credito, $parametros->casadecimal, ',', '.') ?> ADICIONADO AO CRÉDITO DO CLIENTE.</h5>
    <?php
endif;
?>

<?php
if ($dados->devcliente == 'S') :
    ?>
    <h5> VALOR DE R$ <?= number_format($dados->devolucao, $parametros->casadecimal, ',', '.') ?> DEVOLVIDO AO CLIENTE.</h5>
    <?php
endif;
?>

<?php
if ($dados->utilizadocredito == 'S') :
    ?>
    <h5> UTILIZADO O CRÉDITO DE R$ <?= number_format($dados->credito, $parametros->casadecimal, ',', '.') ?> COMO PARTE DO PAGAMENTO.</h5>
    <?php
endif;
?>
<hr/>

<?php
$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'itmovimentacao_troca');
$sql = "SELECT * FROM recebimentomov_troca where documento = '$documento'";
//    echo $sql;
$arrayParam = '';
$dadosrec = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

$totalf = count($dadosrec);
if ($totalf > 0) :
    ?>
    <h5> FATURAMENTO </h5>

    <table class="table table-striped table-bordered table-condensed full_table_list">
        <tr class="titulotr">
            <td>Data Vencimento</td>
            <td>Tipo Recebimento</td>
            <td>Valor</td>
        </tr>
        <?php
        foreach ($dadosrec as $value) :
            ?>
            <tr>
                <td><?= $value->dataven ?></td>
                <td><?= $cobranca[$value->tiporeceb] ?></td>
                <td>R$ <?= number_format($value->valor, $parametros->casadecimal, ',', '.') ?></td>
            </tr>
            <?php
        endforeach;
        ?>
    </table>
    <?php
endif;

$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'vendedor');
$sql = "SELECT * from msg_eventos where empresa = '$emitente->emitenteid' ";
$arrayParam = '';
$msg = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

echo nl2br($msg->troca);
?>
<?php
require_once("../../_inc/mpdf/vendor/autoload.php");

// converte o conteudo para uft-8
$mpdf = new \Mpdf\Mpdf([
    'margin_top' => 5,
    'margin_left' => 5,
    'margin_right' => 5,
    'mirrorMargins' => true,
    'default_font_size' => 12,
        ]);
//$mpdf = new mPDF('','', 0, '', 15, 15, 16, 16, 9, 9, '');
//$mpdf = new mPDF('','', 0, '', 15, 15, 16, 16, 9, 9, '');
$mpdf->keep_table_proportions = true;
$mpdf->allow_charset_conversion = true;
$footer = "<table width = \"1000\">
                   <tr>
                     <td style='font-size: 10px; bottom:-15px;' align=\"right\">Pag: {PAGENO} de {nb}</td>
                   </tr>
                 </table>";
$mpdf->SetHTMLFooter($footer);
$html = ob_get_clean();
$mpdf->WriteHTML($html);
// escreve definitivamente o conteudo no PDF
$mpdf->Output("romaneio.pdf", 'I');
// imprime

exit();
?>