<?php
ob_start();
?>
<style>
    body {
        font-size: 12px;
    }

    h1, h2, h3, h4, h5, h6,
    .h1, .h2, .h3, .h4, .h5, .h6 {
        font-family: inherit;
        font-weight: 500;
        line-height: 1.1;
        color: inherit;
    }
    h1 small,
    h1 .small, h2 small,
    h2 .small, h3 small,
    h3 .small, h4 small,
    h4 .small, h5 small,
    h5 .small, h6 small,
    h6 .small,
    .h1 small,
    .h1 .small, .h2 small,
    .h2 .small, .h3 small,
    .h3 .small, .h4 small,
    .h4 .small, .h5 small,
    .h5 .small, .h6 small,
    .h6 .small {
        font-weight: normal;
        line-height: 1;
        color: #777777;
    }

    h1, .h1,
    h2, .h2,
    h3, .h3 {
        margin-top: 20px;
        margin-bottom: 10px;
    }
    h1 small,
    h1 .small, .h1 small,
    .h1 .small,
    h2 small,
    h2 .small, .h2 small,
    .h2 .small,
    h3 small,
    h3 .small, .h3 small,
    .h3 .small {
        font-size: 65%;
    }

    h4, .h4,
    h5, .h5,
    h6, .h6 {
        margin-top: 10px;
        margin-bottom: 10px;
    }
    h4 small,
    h4 .small, .h4 small,
    .h4 .small,
    h5 small,
    h5 .small, .h5 small,
    .h5 .small,
    h6 small,
    h6 .small, .h6 small,
    .h6 .small {
        font-size: 75%;
    }

    h1, .h1 {
        font-size: 36px;
    }

    h2, .h2 {
        font-size: 30px;
    }

    h3, .h3 {
        font-size: 24px;
    }

    h4, .h4 {
        font-size: 18px;
    }

    h5, .h5 {
        font-size: 14px;
    }

    h6, .h6 {
        font-size: 12px;
    }
    .text-center {
        text-align: center;
    }

    table {
        width: 100%;
        padding: 10px;
    }

    td {
        padding: 3px;
    }
    th {
        text-align: left;
    }
    /*.titulotr { border:  none};*/
    /*.titulotr { background: #000; border:1px black solid;};*/
    .table-bordered th,
    .table-bordered td {
        border: 1px solid #ddd !important;
    }

    .full_table_list_titulo{
        border-collapse: collapse;
    }
    .full_table_list_titulo tr{
        border:1px black solid;
    }

    .full_table_list{
        border-collapse: collapse;
    }
    .full_table_list tr{
        border:1px black solid;
    }
    .full_table_list tr:nth-child(even) {
        background: #fff
    }
    .full_table_list tr:nth-child(odd) {
        background: #fff
    }

    .tablecor {
        border:1px black solid;
        background: #eee
    }
    .titulotr {
        border:1px black solid;
        background: #F5F5F5
    }
</style>
<?php

function RetornaTipo($valor) {
    switch ($valor) {
        case 'D':
            return 'DINHEIRO';
            break;
        case 'C':
            return 'CHEQUE';
            break;
        case 'CC':
            return 'CARTÃO DE CRÉDITO';
            break;
        case 'CD':
            return 'CARTÃO DE DÉBITO';
            break;
        case 'NP':
            return 'NOTA PROMISSÓRIA';
            break;
        case 'DP':
            return 'DÉPOSITO BANCÁRIO';
            break;
        case 'B':
            return 'BOLETO';
            break;
        case 'O':
            return 'OUTROS';
            break;
    }
}

function BuscaRef($valor) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'vendedor');
    $sql = "SELECT ref from produtos where codigo = '$valor' ";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

    return $dados->ref;
}

function BuscaDesc($valor) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'vendedor');
    $sql = "SELECT ref from produtos where codigo = '$valor' ";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

    return $dados->descricao;
}

require_once("../../../functions.php");
//
require_once "../../../_backend/_class/Conexao_class.php";
require_once "../../../_backend/_class/Crud_class.php";
require_once "../../../_backend/_class/parametros.php";
require_once "../../../_backend/_class/Emitente_class.php";

$logo = '' . FRONTEND . '/img/logomarca/' . $emitente->CNPJ . '/' . $emitente->logo . '';

function BuscaVendedor($valor) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'vendedor');
    $sql = "SELECT * from vendedor where vendedorid = '$valor' ";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

    return $dados->xNome;
}

function RetornaEmpresa($valor) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'emitente');
    $sql = "SELECT * from emitente where emitenteid = '" . $valor . "'";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, false);

    return $dados;
}

function RetornaUsuario($valor) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'usuario');
    $sql = "SELECT * from usuario where usuarioid = '" . $valor . "'";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, false);

    return $dados->usuarionome;
}

$documento = $_GET['documento'];
$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'movimentacao_transferencia');
$sql = "SELECT * from movimentacao_transferencia where documento = '" . $_GET['documento'] . "'";
$arrayParam = '';
$dados = $crud->getSQLGeneric($sql, $arrayParam, false);
$titulo = 'DOCUMENTO AUXILIAR DE TRANSFERÊNCIA ';

$empresa = RetornaEmpresa($dados->empresa);
$filial = RetornaEmpresa($dados->filial);
?>

<table class="table full_table_list_titulo">
    <tr> 
        <td align="center"> <?= $titulo ?> <br/> ESTE DOCUMENTO NÃO É VÁLIDO COMO DOCUMENTO FISCAL </td>
    </tr>

</table>

<table class="table ">
    <tr>
        <td width="20%"><img src="<?= $logo ?>" height="80px" alt=""/></td>
        <td width="40%"><b> <?= $emitente->xNome ?> </b> 
            <br/>
            <?= $emitente->xLgr ?>, <?= $emitente->nro ?> - <?= $emitente->xBairro ?> <br/>
            <?= $emitente->xMun ?>  <?= $emitente->UF ?> <br/>
            <b>CNPJ: </b><?= $emitente->CNPJ ?> <br/>
            <b>INSC. ESTADUAL: </b><?= $emitente->IE ?> <br/>
            <b>TELEFONE: </b><?= $emitente->fone ?> <br/>
            <b>E-MAIL: </b><?= $emitente->email ?> <br/>
        </td>

        <td width="40%" align="center" style="border: 1px solid #A8A8A8; font-size: 10px;">

            DOCUMENTO Nº:   <b><?= $dados->doc_empresa ?></b>
            <hr/>
            EMISSÃO:   <b><?= $dados->data ?> <?= $dados->hora ?></b>
            <hr/>
            USUÁRIO:   <b><?= $dados->usuario ?> - <?= RetornaUsuario($dados->usuario) ?></b>

        </td>
    </tr>

</table>


<table class="table table-borded full_table_list_titulo" style="border: 1px solid #A8A8A8; font-size: 12px;">
    <tr>
        <td colspan="5" style="text-align: center; background-color: #E8E8E8;">DADOS DA FILIAL</td>
    </tr>
    <tr style="border: 1px solid #A8A8A8; font-size: 12px;">
        <td colspan="3" style="border: 1px solid #A8A8A8; font-size: 12px;">
            <span style="font-size: 10px;"> Nome / Razão Social</span> <br/>
            <?= $filial->emitenteid ?> - <?= $filial->xNome ?>
        </td>

        <td style="border: 1px solid #A8A8A8; font-size: 12px;">
            <span style="font-size: 10px;"> CPF/CNPJ</span> <br/>
            <?= $filial->CNPJ ?>
        </td>
        <td  style="border: 1px solid #A8A8A8; font-size: 12px;">
            <span style="font-size: 10px;"> I.E</span> <br/>
            <?= $filial->IE ?></td>

    </tr>
    <tr style="border: 1px solid #A8A8A8; font-size: 12px;">
        <td colspan="5" style="border: 1px solid #A8A8A8; font-size: 12px;">
            <span style="font-size: 10px;"> Endereço</span> <br/>
            <?= $filial->xLgr ?>, <?= $filial->nro ?> <?= $filial->xComp ?> - <?= $filial->xBairro ?></td>



    </tr>
    <tr style="border: 1px solid #A8A8A8; font-size: 12px;">

        <td colspan="3" style="border: 1px solid #A8A8A8; font-size: 12px;">
            <span style="font-size: 10px;"> CIDADE</span> <br/>
            <?= $filial->xMun ?> - <?= $filial->UF ?>
        </td>

        <td style="border: 1px solid #A8A8A8; font-size: 12px;">
            <span style="font-size: 10px;">CEP</span> <br/>
            <?= $filial->CEP ?></td>


        <td  style="border: 1px solid #A8A8A8; font-size: 12px;">
            <span style="font-size: 10px;"> Telefone</span> <br/>
            <?= $filial->fone ?></td>


    </tr>

</table>
<Br/>

<table class="table table-striped table-condensed full_table_list">
    <tr class="titulotr">
        <td colspan="6" style="text-align: center; background-color: #E8E8E8;">PRODUTOS</td>
    </tr>
    <tr class="">
        <td><b>Produto</b></td>
        <td><b>Ref</b></td>
        <td width="40%"><b>Descrição</b></td>
        <td><b>Qtd</b></td>
        <td><b>Valor Unit.</b></td>
        <td><b>Valor Total</b></td>
    </tr>

    <?php
    $pecas = 0;
    $total = 0;
    $descontop = 0;
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'itmovimentacao_transferencia');

    $sql = "SELECT sum(itmovimentacao_transferencia.quantidade) as qtd, sum(itmovimentacao_transferencia.valortotal) as total, 
        itmovimentacao_transferencia.id, itmovimentacao_transferencia.preco, itmovimentacao_transferencia.documento, itmovimentacao_transferencia.produto, 
        itmovimentacao_transferencia.cancelado, estoqueprodutos.estoqueprodutosid, 
estoqueprodutos.produto, estoqueprodutos.codproduto, estoqueprodutos.var1, estoqueprodutos.var2,
produtos.codigo, produtos.descricao, produtos.ref from itmovimentacao_transferencia
LEFT JOIN estoqueprodutos on itmovimentacao_transferencia.produto = estoqueprodutos.codproduto
LEFT JOIN produtos on produtos.codigo = estoqueprodutos.produto
WHERE itmovimentacao_transferencia.documento = '$documento' and itmovimentacao_transferencia.cancelado = 'N'";
    $sql .= "GROUP BY estoqueprodutos.estoqueprodutosid";

//    echo $sql;
    $arrayParam = '';
    $dadosit = $crud->getSQLGeneric($sql, $arrayParam, TRUE);
    $produtos = array();
    $total = 0;

    foreach ($dadosit as $value) :
        if ($value->cancelado != 'S') :
            $pecas = $pecas + $value->qtd;
            if ($parametros->tamvar === '2') :
                $produtos[$value->codigo . $value->var1][$value->var2] = array(
                    "var1" => $value->var1,
                    "descricao" => $value->descricao,
                    "var2" => $value->var2,
                    "qtd" => $value->qtd,
                    "preco" => $value->preco
                );
            else :
                $produtos[$value->codigo][$value->var1] = array(
                    "var1" => $value->var1,
                    "descricao" => $value->descricao,
                    "var2" => $value->var2,
                    "qtd" => $value->qtd,
                    "preco" => $value->preco
                );
            endif;
            ?>

            <?php
        endif;

//        echo '<pre>';
//        print_r($produtos);
//        echo '</pre>';


        if ($value->tdesconto > 0) :
            $descontop = $descontop + $value->tdesconto;
            $total = $total + $value->total + $value->tdesconto;

        else :
            $total = $total + $value->total;

        endif;
    endforeach;

    $i = 0;
    foreach ($produtos as $key => $row) {
        $topc = 0;
        foreach ($row as $i => $a):
            $topc = $topc + $a['qtd'];
            $preco = $a['preco'];
        endforeach;
        ?>
        <tr class=''>
            <td><b>
                    <?=
                    $key
                    ?>
                </b>
            </td>
            <td><b><?= BuscaRef($key) ?></b></td>
            <td colspan=""><b><?= $a['descricao'] ?></td>
            <td colspan=""><b><?= number_format($topc, $parametros->casadecimal, ',', '.') ?></b></td>
            <td colspan=""><b>R$ <?= number_format($preco, $parametros->casadecimal, ',', '.') ?></b></td>
            <td colspan=""><b>R$ <?= number_format($topc * $preco, $parametros->casadecimal, ',', '.') ?></b></td>

        </tr>
        <tr>
            <td colspan="2"> </td>
            <td  colspan="2">
                <table class="table table-striped table-condensed full_table_list">
                    <tr>
                        <?php
                        $topc = 0;
                        foreach ($row as $i => $a) {
                            $topc = $topc + $a['qtd'];
                            $preco = $a['preco'];
                            ?>
                            <td style="font-size: 10px; ">

                                <?= $i ?>
                            </td>

                            <?php
//                    echo '<td>' . $i . " " . $a['qtd'] . " " . $a['preco'] . '</td>';
                        }
                        ?>

                    </tr>
                    <tr> 

                        <?php
                        foreach ($row as $i => $a) {
                            ?>
                            <td style="">

                                <?= number_format($a['qtd'], $parametros->casadecimal, ',', '.') ?>
                            </td>

                            <?php
//                    echo '<td>' . $i . " " . $a['qtd'] . " " . $a['preco'] . '</td>';
                        }
                        ?>

                    </tr>
                </table>
            </td>
        </tr>

        <?php
    }


//    echo '<pre>';
//    print_r($produtos);
//    echo '</pre>';
    ?>
    <tr>
        <td colspan="5">
        </td>
    </tr>
</table>
<hr/>


<table class="table table-striped  table-condensed full_table_list">
    <tr>
        <td><b>Total Itens</b></td>
        <td><b><?= number_format($pecas, $parametros->casadecimal, ',', '.') ?></b></td>
    </tr>
    <tr>
        <td><b>Sub-Total</b></td>
        <td>R$ <?= number_format($total, $parametros->casadecimal, ',', '.') ?></td>
        <td width="50%" style="border: none;"> </td>

    </tr>

    <tr>
        <td><b>Total</b></td>
        <td>R$ <?= number_format($total, $parametros->casadecimal, ',', '.') ?></td>
        <td width="50%" style="border: none;"> </td>

    </tr>


</table>


<table class="table table-striped  table-condensed full_table_list text-center">
    <tr>
        <td>
            <br/><br/><br/><br/><br/>
        </td>
        <td><br/><br/><br/><br/><br/></td>
    </tr>
    <tr>
        <td>
            <hr/>
            Assinatura Emitente
        </td>
        <td><hr/>
            Assinatura Destinatário</td>
    </tr>

    <tr>
        <td><br/></td>
        <td><br/></td>
    </tr>

</table>


<?php
require_once("../../_inc/mpdf/vendor/autoload.php");

// converte o conteudo para uft-8
$mpdf = new \Mpdf\Mpdf([
    'margin_top' => 5,
    'margin_left' => 5,
    'margin_right' => 5,
    'mirrorMargins' => true,
    'default_font_size' => 12,
        ]);
//$mpdf = new mPDF('','', 0, '', 15, 15, 16, 16, 9, 9, '');
$mpdf->keep_table_proportions = true;
$mpdf->allow_charset_conversion = true;
$footer = "<table width = \"1000\">
                   <tr>
                     <td style='font-size: 10px; bottom:-15px;' align=\"right\">Pag: {PAGENO} de {nb}</td>
                   </tr>
                 </table>";
$mpdf->SetHTMLFooter($footer);
$html = ob_get_clean();
$mpdf->WriteHTML($html);
// escreve definitivamente o conteudo no PDF
$mpdf->Output("romaneio.pdf", 'I');
// imprime

exit();
?>