<?php
ob_start();
?>
<style>
    body {
        font-size: 12px;
    }

    h1, h2, h3, h4, h5, h6,
    .h1, .h2, .h3, .h4, .h5, .h6 {
        font-family: inherit;
        font-weight: 500;
        line-height: 1.1;
        color: inherit;
    }
    h1 small,
    h1 .small, h2 small,
    h2 .small, h3 small,
    h3 .small, h4 small,
    h4 .small, h5 small,
    h5 .small, h6 small,
    h6 .small,
    .h1 small,
    .h1 .small, .h2 small,
    .h2 .small, .h3 small,
    .h3 .small, .h4 small,
    .h4 .small, .h5 small,
    .h5 .small, .h6 small,
    .h6 .small {
        font-weight: normal;
        line-height: 1;
        color: #777777;
    }

    h1, .h1,
    h2, .h2,
    h3, .h3 {
        margin-top: 20px;
        margin-bottom: 10px;
    }
    h1 small,
    h1 .small, .h1 small,
    .h1 .small,
    h2 small,
    h2 .small, .h2 small,
    .h2 .small,
    h3 small,
    h3 .small, .h3 small,
    .h3 .small {
        font-size: 65%;
    }

    h4, .h4,
    h5, .h5,
    h6, .h6 {
        margin-top: 10px;
        margin-bottom: 10px;
    }
    h4 small,
    h4 .small, .h4 small,
    .h4 .small,
    h5 small,
    h5 .small, .h5 small,
    .h5 .small,
    h6 small,
    h6 .small, .h6 small,
    .h6 .small {
        font-size: 75%;
    }

    h1, .h1 {
        font-size: 36px;
    }

    h2, .h2 {
        font-size: 30px;
    }

    h3, .h3 {
        font-size: 24px;
    }

    h4, .h4 {
        font-size: 18px;
    }

    h5, .h5 {
        font-size: 14px;
    }

    h6, .h6 {
        font-size: 12px;
    }
    .text-center {
        text-align: center;
    }

    table {
        width: 100%;
        padding: 10px;
    }

    td {
        padding: 3px;
    }
    th {
        text-align: left;
    }
    /*.titulotr { border:  none};*/
    /*.titulotr { background: #000; border:1px black solid;};*/
    .table-bordered th,
    .table-bordered td {
        border: 1px solid #ddd !important;
    }

    .full_table_list_titulo{
        border-collapse: collapse;
    }
    .full_table_list_titulo tr{
        border:1px black solid;
    }

    .full_table_list{
        border-collapse: collapse;
    }
    .full_table_list tr{
        border:1px black solid;
    }
    .full_table_list tr:nth-child(even) {
        background: #fff
    }
    .full_table_list tr:nth-child(odd) {
        background: #fff
    }

    .tablecor {
        border:1px black solid;
        background: #eee
    }
    .titulotr {
        border:1px black solid;
        background: #F5F5F5
    }
</style>
<?php
require_once("../../../functions.php");
//
require_once "../../../_backend/_class/Conexao_class.php";
require_once "../../../_backend/_class/Crud_class.php";
require_once "../../../_backend/_class/parametros.php";
require_once "../../../_backend/_class/Emitente_class.php";

$logo = '' . FRONTEND . '/img/logomarca/' . $emitente->CNPJ . '/' . $emitente->logo . '';

function BuscaVendedor($valor) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'vendedor');
    $sql = "SELECT * from vendedor where vendedorid = '$valor' ";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

    return $dados->xNome;
}

function RetornaEmpresa($valor) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'emitente');
    $sql = "SELECT * from emitente where emitenteid = '" . $valor . "'";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, false);

    return $dados;
}

function RetornaUsuario($valor) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'usuario');
    $sql = "SELECT * from usuario where usuarioid = '" . $valor . "'";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, false);

    return $dados->usuarionome;
}

$documento = $_GET['documento'];
$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'movimentacao_transferencia');
$sql = "SELECT * from movimentacao_transferencia where documento = '" . $_GET['documento'] . "'";
$arrayParam = '';
$dados = $crud->getSQLGeneric($sql, $arrayParam, false);
$titulo = 'DOCUMENTO AUXILIAR DE TRANSFERÊNCIA ';

$empresa = RetornaEmpresa($dados->empresa);
$filial = RetornaEmpresa($dados->filial);
?>
<table class="table full_table_list_titulo">
    <tr> 
        <td colspan="6" align="center"> <?= $titulo ?> <br/> ESTE DOCUMENTO NÃO É VÁLIDO COMO DOCUMENTO FISCAL </td>
    </tr>

</table>

<table class="table">
    <tr>
        <td rowspan="4" width="17%"><img src="<?= $logo ?>" height="80px" style="max-width: 15%" alt=""/></td>
        <td><b> De : </b>
            <?= $empresa->emitenteid ?> - <?= $empresa->xNome ?> <br/>
            <b>CNPJ : </b> <?= $empresa->CNPJ ?> <br/>
            <?= $empresa->xLgr ?>, <?= $empresa->nro ?> - <?= $empresa->xBairro ?> <br/>
            <?= $empresa->xMun ?> - <?= $empresa->UF ?> / <?= $empresa->fone ?>
        </td>
        <td></td>
        <td><b> Para : </b>
            <?= $filial->emitenteid ?> - <?= $filial->xNome ?> <br/>
            <b>CNPJ : </b> <?= $filial->CNPJ ?> <br/>
            <?= $filial->xLgr ?>, <?= $filial->nro ?> - <?= $filial->xBairro ?> <br/>
            <?= $filial->xMun ?> - <?= $filial->UF ?> /  <?= $filial->fone ?>
        </td>
    </tr>
    <tr>
        <td> <b> Documento : </b> <?= $dados->doc_empresa ?></td>
        <td><b> Data : </b><?= $dados->data ?></td>
        <td colspan="2" align="right"> <b>Usuário : </b> <?= $dados->usuario ?> - <?= RetornaUsuario($dados->usuario) ?></td>        
    </tr>   
</table>
<hr/>

<table class="table table-striped table-condensed full_table_list">
    <tr class="titulotr">
        <td colspan="5"></td>
    </tr>
    <tr class="">
        <td><b>Produto</b></td>
        <td width="40%"><b>Descrição</b></td>
        <td><b>Qtd</b></td>
        <?php
        if ($parametros->simplificaromtransf == 'N') :
            ?>
            <td><b>Valor Unit.</b></td>
            <td><b>Valor Total</b></td>
            <?php
        endif;
        ?>
    </tr>

    <?php
    $pecas = 0;
    $total = 0;
    $descontop = 0;
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'itmovimentacao');

    $sql = "SELECT sum(itmovimentacao_transferencia.quantidade) as qtd,   itmovimentacao_transferencia.id, itmovimentacao_transferencia.preco,
        itmovimentacao_transferencia.documento, itmovimentacao_transferencia.produto, itmovimentacao_transferencia.cancelado, estoqueprodutos.produto, estoqueprodutos.codproduto, 
produtos.codigo, produtos.descricao from itmovimentacao_transferencia
LEFT JOIN estoqueprodutos on itmovimentacao_transferencia.produto = estoqueprodutos.codproduto
LEFT JOIN produtos on produtos.codigo = estoqueprodutos.produto
WHERE itmovimentacao_transferencia.documento = '" . $documento . "' and itmovimentacao_transferencia.cancelado != 'S'";
    $sql .= " GROUP BY estoqueprodutos.codproduto";
//    echo $sql;
    $arrayParam = '';
    $dadosit = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

    foreach ($dadosit as $value) :
        if ($value->cancelado == 'S') :
            if ($parametros->exibeitemcanc == 'S') :
                ?>

                <tr class=''>
                    <td><s>
                            <?php
                            if ($parametros->agrupaitens == 'S') :
                                echo $value->codigo;
                            else :
                                echo $value->codproduto;
                            endif;
                            ?>
                        </s>
                    </td>
                    <td><s><?= $value->descricao ?></s></td>
                    <td><s><?= number_format($value->qtd, $parametros->casadecimal, ',', '.') ?></s></td>
                    <?php
                    if ($parametros->simplificaromtransf == 'N') :
                        ?>
                        <td><s>R$ <?= number_format($value->preco, $parametros->casadecimal, ',', '.') ?></s></td>
                        <td>
                            <s>
                                <?= number_format($value->qtd * $value->preco, $parametros->casadecimal, ',', '.') ?>
                            </s>
                            Canc.

                        </td>
                        <?php
                    endif;
                    ?>
                </tr>

                <?php
            endif;
        else :

            $pecas = $pecas + $value->qtd;
            ?>
            <tr class=''>
                <td>
                    <?php
                    if ($parametros->agrupaitens == 'S') :
                        echo $value->codigo;
                    else :
                        echo $value->codproduto;
                    endif;
                    ?>
                </td>
                <td><?= $value->descricao ?></td>
                <td><?= number_format($value->qtd, $parametros->casadecimal, ',', '.') ?></td>
                <?php
                if ($parametros->simplificaromtransf == 'N') :
                    ?>
                    <td>R$ <?= number_format($value->preco, $parametros->casadecimal, ',', '.') ?></td>
                    <td>
                        <?php
                        $total = $total + ($value->qtd * $value->preco);
                        ?>
                        R$ <?= number_format($value->qtd * $value->preco, $parametros->casadecimal, ',', '.') ?>
                    </td>
                    <?php
                endif;
                ?>
            </tr>
        <?php
        endif;
    endforeach;
    ?>
    <tr>
        <td colspan="5">
        </td>
    </tr>
</table>
<hr/>


<table class="table table-striped  table-condensed full_table_list">
    <tr>
        <td><b>Total Itens</b></td>
        <td><b><?= number_format($pecas, $parametros->casadecimal, ',', '.') ?></b></td>
    </tr>
    <tr>
        <td><b>Sub-Total</b></td>
        <td>R$ <?= number_format($total, $parametros->casadecimal, ',', '.') ?></td>
        <td width="50%" style="border: none;"> </td>

    </tr>

    <tr>
        <td><b>Total</b></td>
        <td>R$ <?= number_format($total, $parametros->casadecimal, ',', '.') ?></td>
        <td width="50%" style="border: none;"> </td>

    </tr>


</table>

<?php
if ($dados->obs != '') :
    ?>
    <h5> <b> Observações: </b> <br/> <?= $dados->obs ?></h5>
    <hr/>
    <?php
endif;
?>


<table class="table table-striped  table-condensed full_table_list text-center">
    <tr>
        <td>
            <br/><br/><br/><br/><br/>
        </td>
        <td><br/><br/><br/><br/><br/></td>
    </tr>
    <tr>
        <td>
            <hr/>
            Assinatura Emitente
        </td>
        <td><hr/>
            Assinatura Destinatário</td>
    </tr>

    <tr>
        <td><br/></td>
        <td><br/></td>
    </tr>

</table>

<?php
require_once("../../_inc/mpdf/vendor/autoload.php");

// converte o conteudo para uft-8
$mpdf = new \Mpdf\Mpdf([
    'margin_top' => 5,
    'margin_left' => 5,
    'margin_right' => 5,
    'mirrorMargins' => true,
    'default_font_size' => 12,
        ]);
//$mpdf = new mPDF('','', 0, '', 15, 15, 16, 16, 9, 9, '');
$mpdf->keep_table_proportions = true;
$mpdf->allow_charset_conversion = true;
$footer = "<table width = \"1000\">
                   <tr>
                     <td style='font-size: 10px; bottom:-15px;' align=\"right\">Pag: {PAGENO} de {nb}</td>
                   </tr>
                 </table>";
$mpdf->SetHTMLFooter($footer);
$html = ob_get_clean();
$mpdf->WriteHTML($html);
// escreve definitivamente o conteudo no PDF
$mpdf->Output("romaneio.pdf", 'I');
// imprime

exit();
?>