<?php
ob_start();
?>
<style>
    body {
        font-size: 12px;
    }

    h1, h2, h3, h4, h5, h6,
    .h1, .h2, .h3, .h4, .h5, .h6 {
        font-family: inherit;
        font-weight: 500;
        line-height: 1.1;
        color: inherit; }
    h1 small,
    h1 .small, h2 small,
    h2 .small, h3 small,
    h3 .small, h4 small,
    h4 .small, h5 small,
    h5 .small, h6 small,
    h6 .small,
    .h1 small,
    .h1 .small, .h2 small,
    .h2 .small, .h3 small,
    .h3 .small, .h4 small,
    .h4 .small, .h5 small,
    .h5 .small, .h6 small,
    .h6 .small {
        font-weight: normal;
        line-height: 1;
        color: #777777; }

    h1, .h1,
    h2, .h2,
    h3, .h3 {
        margin-top: 20px;
        margin-bottom: 10px; }
    h1 small,
    h1 .small, .h1 small,
    .h1 .small,
    h2 small,
    h2 .small, .h2 small,
    .h2 .small,
    h3 small,
    h3 .small, .h3 small,
    .h3 .small {
        font-size: 65%; }

    h4, .h4,
    h5, .h5,
    h6, .h6 {
        margin-top: 10px;
        margin-bottom: 10px; }
    h4 small,
    h4 .small, .h4 small,
    .h4 .small,
    h5 small,
    h5 .small, .h5 small,
    .h5 .small,
    h6 small,
    h6 .small, .h6 small,
    .h6 .small {
        font-size: 75%; }

    h1, .h1 {
        font-size: 36px; }

    h2, .h2 {
        font-size: 30px; }

    h3, .h3 {
        font-size: 24px; }

    h4, .h4 {
        font-size: 18px; }

    h5, .h5 {
        font-size: 14px; }

    h6, .h6 {
        font-size: 12px; }
    .text-center {
        text-align: center; }

    table {
        width: 100%;
        padding: 10px;
    }

    td {
        padding: 3px;
    }
    th {
        text-align: left;
    }
    /*.titulotr { border:  none};*/
    /*.titulotr { background: #000; border:1px black solid;};*/
    .table-bordered th,
    .table-bordered td {
        border: 1px solid #ddd !important; } 

    .full_table_list_titulo{border-collapse: collapse;}
    .full_table_list_titulo tr{border:1px black solid;}

    .full_table_list{border-collapse: collapse;}
    .full_table_list tr{border:1px black solid;}
    .full_table_list tr:nth-child(even) {background: #fff}
    .full_table_list tr:nth-child(odd) {background: #fff}  

    .tablecor {border:1px black solid; background: #eee}
    .titulotr {border:1px black solid; background: #F5F5F5}
</style>
<?php
require_once("../../../functions.php");
//
require_once "../../../_backend/_class/Conexao_class.php";
require_once "../../../_backend/_class/Crud_class.php";
require_once "../../../_backend/_class/cobranca_class.php";
require_once "../../../_backend/_class/parametros.php";
require_once "../../../_backend/_class/Emitente_class.php";


$logo = '' . FRONTEND . '/img/logomarca/' . $emitente->CNPJ . '/' . $emitente->logo . '';

function BuscaVendedor($valor) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'vendedor');
    $sql = "SELECT * from vendedor where vendedorid = '$valor' ";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

    return $dados->xNome;
}

$documento = $_GET['documento'];
$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'itseparacao');
$sql = "SELECT * from separacao where documento = '$documento' ";
$arrayParam = '';
$dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);


if ($dados->para == 'R') :
    $dest = BuscaPara('R', $dados->representante);
elseif ($dados->para == 'F') :
    $dest = BuscaPara('F', $dados->funcionario);
else :
    $dest = BuscaPara('C', $dados->cliente);
endif;

function BuscaPara($valor, $id) {

    if ($valor == 'R') :
        $sql = "SELECT * from representante where representanteid = '$id' ";
    elseif ($valor == 'F') :
        $sql = "SELECT * from funcionario where funcionarioid = '$id' ";
    else :
        $sql = "SELECT * from cliente where clienteid = '$id' ";
    endif;

    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'tabela');
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

    return $dados;
}

 $titulo = 'SEPARAÇÃO DE PEDIDO ';

if ($dados->para == 'R') :
    $idrel = $dest->representanteid;
    $titulorel = 'Representante';
elseif ($dados->para == 'F') :
    $idrel = $dest->funcionarioid;
    $titulorel = 'Funcionário';
else :
    $idrel = $dest->clienteid;
    $titulorel = 'Cliente';
endif;
?>
<?php
//require_once "cabecalho.php";
?>
<table class="table full_table_list_titulo">
    <tr> 
        <td colspan="7" align="center"> <?= $titulo ?> <br/> ESTE DOCUMENTO NÃO É VÁLIDO COMO DOCUMENTO FISCAL </td>
    </tr>
    <tr>
        <td rowspan="5" width="15%"><img src="<?= $logo ?>" height="80px" style="max-width: 15%" alt=""/></td>
        <td width="10%"> <b> Documento </b></td>
        <td colspan="2"><?= $dados->doc_empresa ?></td>
        <td width="10%"><b> Data</b></td>
        <td colspan="2"><?= $dados->data ?></td>
    </tr>
    <tr>
        <td width="10%"> <b>Vendedor</td>
        <td colspan="4"><?= $dados->vendedor ?> - <?= BuscaVendedor($dados->vendedor) ?></td>

    </tr>
    <tr>
        <td width="10%"><b> <?= $titulorel ?></b></td>
        <td colspan="2"><?= $idrel ?> - <?= $dest->xNome ?></td>
        <td width="10%"><b> CPF/CNPJ</b></td>
        <td colspan="2"><?= $dest->CNPJ ?></td>
    </tr>
    <tr>

        <td width="10%"><b> Telefone</b></td>
        <td colspan="2"><?= $dest->fone ?></td>
        <td width="10%"><b> CEP</b></td>
        <td colspan="2"><?= $dest->CEP ?></td>
    </tr>
    <tr>
        <td width="10%"> <b>Endereço</b></td>
        <td colspan="2"><?= $dest->xLgr ?>, <?= $dest->nro ?> - <?= $dest->xBairro ?></td>
        <td width="10%"><b> Cidade</b></td>
        <td colspan="1"><?= $dest->xMun ?> - <?= $dest->UF ?></td>

    </tr>
    <tr>


    </tr>
</table>
<hr/>

<table class="table table-striped table-condensed full_table_list">
    <tr class="titulotr">
        <td colspan="5"></td>
    </tr>
    <tr class="">
        <td><b>Produto</b></td>
        <td><b>Ref.</b></td>
        <td width="40%"><b>Descrição</b></td>
        <td><b>Qtd</b></td>
        <td><b>Valor Unit.</b></td>
        <td><b>Valor Total</b></td>
    </tr>

    <?php
    $pecas = 0;
    $total = 0;
    $descontop = 0;
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'itseparacao');


    if ($parametros->agrupaitens == 'S') :
        $sql = "SELECT sum(itseparacao.quantidade) as qtd, sum(itseparacao.valorliquido) as total, sum(itseparacao.desconto) as tdesconto, itseparacao.id, itseparacao.preco,
        itseparacao.documento, itseparacao.produto, itseparacao.cancelado,  estoqueprodutos.produto, estoqueprodutos.codproduto, 
produtos.codigo, produtos.descricao, produtos.ref from itseparacao
LEFT JOIN estoqueprodutos on itseparacao.produto = estoqueprodutos.codproduto
LEFT JOIN produtos on produtos.codigo = estoqueprodutos.produto
WHERE itseparacao.documento = '$documento' AND itseparacao.cancelado = 'N' ";
        $sql .= "GROUP BY estoqueprodutos.produto, itseparacao.preco";

    else :
        $sql = "SELECT itseparacao.quantidade as qtd, itseparacao.valorliquido as total, itseparacao.desconto as tdesconto, itseparacao.id, itseparacao.preco,
        itseparacao.documento, itseparacao.produto, itseparacao.cancelado, estoqueprodutos.produto, estoqueprodutos.codproduto, 
produtos.codigo, produtos.descricao, produtos.ref from itseparacao
LEFT JOIN estoqueprodutos on itseparacao.produto = estoqueprodutos.codproduto
LEFT JOIN produtos on produtos.codigo = estoqueprodutos.produto
WHERE itseparacao.documento = '$documento' ";
//        $sql .= "GROUP BY estoqueprodutos.produto, itseparacao.preco";
    endif;

//    echo $sql;
    
    $sql .= " ORDER BY produtos.codigo, produtos.ref ASC";
    $arrayParam = '';
    $dadosit = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

    foreach ($dadosit as $value) :



        if ($value->cancelado == 'S') :
            if ($parametros->exibeitemcanc == 'S') :
                ?>

                <tr class=''>
                    <td><s>
                            <?php
                            if ($parametros->agrupaitens == 'S') :
                                echo $value->codigo;
                            else :
                                echo $value->codproduto;
                            endif;
                            ?>
                        </s>
                    </td>
                    <td><s><?= $value->ref ?></s></td>
                    <td><s><?= $value->descricao ?></s></td>
                    <td><s><?= number_format($value->qtd, $parametros->casadecimal, ',', '.') ?></s></td>
                    <td><s>R$ <?= number_format($value->preco, $parametros->casadecimal, ',', '.') ?></s></td>
                    <td>
                        <s>
                            <?php
                            if ($value->tdesconto > 0) :
                                ?>
                                R$ (<?= number_format($value->total + $value->tdesconto, $parametros->casadecimal, ',', '.') ?>)
                                <?= number_format($value->total, $parametros->casadecimal, ',', '.') ?>
                                <?php
                            else :
                                ?>
                                R$ <?= number_format($value->total, $parametros->casadecimal, ',', '.') ?>
                            <?php
                            endif;
                            ?>
                        </s>
                        Canc.

                    </td>
                </tr>

                <?php
            endif;
        else :

            $pecas = $pecas + $value->qtd;
            ?>
            <tr class=''>
                <td>
                    <?php
                    if ($parametros->agrupaitens == 'S') :
                        echo $value->codigo;
                    else :
                        echo $value->codproduto;
                    endif;
                    ?>
                </td>
                <td><?= $value->ref ?></td>
                <td><?= $value->descricao ?></td>
                <td><?= number_format($value->qtd, $parametros->casadecimal, ',', '.') ?></td>
                <td>R$ <?= number_format($value->preco, $parametros->casadecimal, ',', '.') ?></td>
                <td>

                    <?php
                    if ($value->tdesconto > 0) :

                        $descontop = $descontop + $value->tdesconto;
                        $total = $total + $value->total + $value->tdesconto;
                        ?>
                        R$ <s>(<?= number_format($value->total + $value->tdesconto, $parametros->casadecimal, ',', '.') ?>)</s>
                        <?= number_format($value->total, $parametros->casadecimal, ',', '.') ?>
                        <?php
                    else :
                        $total = $total + $value->total;
                        ?>
                        R$ <?= number_format($value->total, $parametros->casadecimal, ',', '.') ?>
                    <?php
                    endif;
                    ?>
                </td>
            </tr>
        <?php
        endif;
    endforeach;
    ?>
    <tr>
        <td colspan="5">
        </td>
    </tr>
</table>
<hr/>


<table class="table table-striped  table-condensed full_table_list">
    <tr>
        <td><b>Total Itens</b></td>
        <td><b><?= number_format($pecas, $parametros->casadecimal, ',', '.') ?></b></td>
    </tr>
    <tr>
        <td><b>Sub-Total</b></td>
        <td>R$ <?= number_format($total, $parametros->casadecimal, ',', '.') ?></td>
        <td width="50%" style="border: none;"> </td>

    </tr>
    <?php
    if ($dados->frete > 0) :
        ?>
        <tr>
            <td><b>Frete</b></td>
            <td>R$ <?= number_format($dados->frete, $parametros->casadecimal, ',', '.') ?></td>
            <td width="50%" style="border: none;"> </td>

        </tr>
        <?php
    endif;
    ?>

    <?php

    function porcentagem_nx($parcial, $total) {
        return ( $parcial * 100 ) / $total;
    }
    ?>
    <tr>
        <td><b>Desconto (-)</b></td>
        <td>R$ <?= number_format($dados->desconto + $descontop, $parametros->casadecimal, ',', '.') ?> (<?= number_format(porcentagem_nx($dados->desconto, $total), $parametros->casadecimal, ',', '.') ?>%)</td>
        <td width="50%" style="border: none;"> </td>

    </tr>
    <?php
    if ($dados->credito > 0) :
        ?>
        <tr>
            <td><b>Crédito (-)</b></td>
            <td>R$ <?= number_format($dados->credito, $parametros->casadecimal, ',', '.') ?></td>
            <td width="50%" style="border: none;"> </td>

        </tr>
        <?php
    endif;
    ?>

    <tr>
        <td><b>Total</b></td>
        <td>R$ <?= number_format($total + $dados->frete - ($dados->desconto + $descontop), $parametros->casadecimal, ',', '.') ?></td>
        <td width="50%" style="border: none;"> </td>

    </tr>
    <tr>
        <td><b>Total Pago</b></td>
        <td>R$ <?= number_format($dados->valorpago, $parametros->casadecimal, ',', '.') ?></td>
        <td width="50%" style="border: none;"> </td>

    </tr>

    <tr>
        <td><b>Troco</b></td>
        <td>R$ <?= number_format($dados->troco, $parametros->casadecimal, ',', '.') ?></td>
        <td width="50%" style="border: none;"> </td>

    </tr>
</table>



<hr/>


<?php
if ($dados->obs != '') :
    ?>
    <h5> <b> Observações: </b> <br/> <?= $dados->obs ?></h5>
    <hr/>
    <?php
endif;
?>

<?php
if ($dados->utilizadocredito == 'S') :
    ?>
    <h5> UTILIZADO O CRÉDITO DE R$ <?= number_format($dados->credito, $parametros->casadecimal, ',', '.') ?> COMO PARTE DO PAGAMENTO.</h5>
    <?php
endif;
?>


<?php
require_once("../../_inc/mpdf/vendor/autoload.php");

// converte o conteudo para uft-8
$mpdf = new \Mpdf\Mpdf([
    'margin_top' => 5,
    'margin_left' => 5,
    'margin_right' => 5,
    'mirrorMargins' => true,
    'default_font_size' => 12,
        ]);
//$mpdf = new mPDF('','', 0, '', 15, 15, 16, 16, 9, 9, '');
$mpdf->keep_table_proportions = true;
$mpdf->allow_charset_conversion = true;
$footer = "<table width = \"1000\">
                   <tr>
                     <td style='font-size: 10px; bottom:-15px;' align=\"right\">Pag: {PAGENO} de {nb} / data impressão: ".date('d/m/Y H:i')."</td>
                   </tr>
                 </table>";
$mpdf->SetHTMLFooter($footer);
$html = ob_get_clean();
$mpdf->WriteHTML($html);
// escreve definitivamente o conteudo no PDF
$mpdf->Output("romaneio.pdf", 'I');
// imprime

exit();
?>