<?php
ob_start();
?>
<style>
    body {
        font-size: 12px;
    }

    h1, h2, h3, h4, h5, h6,
    .h1, .h2, .h3, .h4, .h5, .h6 {
        font-family: inherit;
        font-weight: 500;
        line-height: 1.1;
        color: inherit;
    }
    h1 small,
    h1 .small, h2 small,
    h2 .small, h3 small,
    h3 .small, h4 small,
    h4 .small, h5 small,
    h5 .small, h6 small,
    h6 .small,
    .h1 small,
    .h1 .small, .h2 small,
    .h2 .small, .h3 small,
    .h3 .small, .h4 small,
    .h4 .small, .h5 small,
    .h5 .small, .h6 small,
    .h6 .small {
        font-weight: normal;
        line-height: 1;
        color: #777777;
    }

    h1, .h1,
    h2, .h2,
    h3, .h3 {
        margin-top: 20px;
        margin-bottom: 10px;
    }
    h1 small,
    h1 .small, .h1 small,
    .h1 .small,
    h2 small,
    h2 .small, .h2 small,
    .h2 .small,
    h3 small,
    h3 .small, .h3 small,
    .h3 .small {
        font-size: 65%;
    }

    h4, .h4,
    h5, .h5,
    h6, .h6 {
        margin-top: 10px;
        margin-bottom: 10px;
    }
    h4 small,
    h4 .small, .h4 small,
    .h4 .small,
    h5 small,
    h5 .small, .h5 small,
    .h5 .small,
    h6 small,
    h6 .small, .h6 small,
    .h6 .small {
        font-size: 75%;
    }

    h1, .h1 {
        font-size: 36px;
    }

    h2, .h2 {
        font-size: 30px;
    }

    h3, .h3 {
        font-size: 24px;
    }

    h4, .h4 {
        font-size: 18px;
    }

    h5, .h5 {
        font-size: 14px;
    }

    h6, .h6 {
        font-size: 12px;
    }
    .text-center {
        text-align: center;
    }

    table {
        width: 100%;
        padding: 10px;
    }

    td {
        padding: 3px;
    }
    th {
        text-align: left;
    }
    /*.titulotr { border:  none};*/
    /*.titulotr { background: #000; border:1px black solid;};*/
    .table-bordered th,
    .table-bordered td {
        border: 1px solid #ddd !important;
    }

    .full_table_list_titulo{
        border-collapse: collapse;
    }
    .full_table_list_titulo tr{
        border:1px black solid;
    }

    .full_table_list{
        border-collapse: collapse;
    }
    .full_table_list tr{
        border:1px black solid;
    }
    .full_table_list tr:nth-child(even) {
        background: #fff
    }
    .full_table_list tr:nth-child(odd) {
        background: #fff
    }

    .tablecor {
        border:1px black solid;
        background: #eee
    }
    .titulotr {
        border:1px black solid;
        background: #F5F5F5
    }
</style>
<?php
require_once("../../../functions.php");
//
require_once "../../../_backend/_class/Conexao_class.php";
require_once "../../../_backend/_class/Crud_class.php";
require_once "../../../_backend/_class/cobranca_class.php";
require_once "../../../_backend/_class/parametros.php";
require_once "../../../_backend/_class/Emitente_class.php";

$logo = '' . FRONTEND . '/img/logomarca/' . $emitente->CNPJ . '/' . $emitente->logo . '';

function BuscaVendedor($valor) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'vendedor');
    $sql = "SELECT * from vendedor where vendedorid = '$valor' ";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

    return $dados->xNome;
}

function BuscaCorretor($valor) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'vendedor');
    $sql = "SELECT * from corretor where corretorid = '$valor' ";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

    return $dados->xNome;
}

$documento = $_GET['documento'];
$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'itmovimentacao');
$sql = "SELECT * from movimentacao where documento = '$documento' ";
$arrayParam = '';
$dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

if ($dados->para == 'R') :
    $dest = BuscaPara('R', $dados->representante);
elseif ($dados->para == 'F') :
    $dest = BuscaPara('F', $dados->funcionario);
else :
    $dest = BuscaPara('C', $dados->cliente);
endif;

function BuscaPara($valor, $id) {

    if ($valor == 'R') :
        $sql = "SELECT * from representante where representanteid = '$id' ";
    elseif ($valor == 'F') :
        $sql = "SELECT * from funcionario where funcionarioid = '$id' ";
    else :
        $sql = "SELECT * from cliente where clienteid = '$id' ";
    endif;

    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'tabela');
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

    return $dados;
}

if ($dados->tipo == 'C') :
    $titulo = 'DOCUMENTO AUXILIAR DE VENDA CONSIGNADA ';
elseif ($dados->tipo == 'S') :
    $titulo = 'DOCUMENTO AUXILIAR DE VENDA ';
endif;

if ($dados->para == 'R') :
    $idrel = $dest->representanteid;
    $titulorel = 'Representante';
elseif ($dados->para == 'F') :
    $idrel = $dest->funcionarioid;
    $titulorel = 'Funcionário';
else :
    $idrel = $dest->clienteid;
    $titulorel = 'Cliente';
endif;
?>
<?php
//require_once "cabecalho.php";
?>
<table class="table full_table_list_titulo">
    <tr> 
        <td align="center"> <?= $titulo ?> <br/> ESTE DOCUMENTO NÃO É VÁLIDO COMO DOCUMENTO FISCAL </td>
    </tr>

</table>


<?php
if ($parametros->cabecalhoromaneio == 'S') :
    ?>
    <table class="table ">
        <tr>
            <td width="20%"><img src="<?= $logo ?>" height="80px" alt=""/></td>
            <td width="40%"><b> <?= $emitente->xNome ?> </b> 
                <br/>
                <?= $emitente->xLgr ?>, <?= $emitente->nro ?> - <?= $emitente->xBairro ?> <br/>
                <?= $emitente->xMun ?>  <?= $emitente->UF ?> <br/>
                <b>CNPJ: </b><?= $emitente->CNPJ ?> <br/>
                <b>INSC. ESTADUAL: </b><?= $emitente->IE ?> <br/>
                <b>TELEFONE: </b><?= $emitente->fone ?> <br/>
                <b>E-MAIL: </b><?= $emitente->email ?> <br/>
            </td>

            <td width="20%" align="center" style="border: 1px solid #A8A8A8; font-size: 10px;">

                <h5>DOCUMENTO Nº:   <b><?= $dados->doc_empresa ?></b> </h5>

                <hr/>
                EMISSÃO:   <b><?= $dados->data ?> <?= $dados->hora ?></b>
                <hr/>
                VENDEDOR:   <b><?= BuscaVendedor($dados->vendedor) ?></b>

                <?php
                if ($dados->corretor > 0) :
                    ?>
                    <hr/>
                    CORRETOR:   <b><?= BuscaCorretor($dados->corretor) ?></b>
                    <?php
                endif;
                ?>

            </td>
        </tr>

    </table>

    <table class="table table-borded full_table_list_titulo" style="border: 1px solid #A8A8A8; font-size: 12px;">
        <tr>
            <td colspan="5" style="text-align: center; background-color: #E8E8E8;">DADOS DO CLIENTE</td>
        </tr>
        <tr style="border: 1px solid #A8A8A8; font-size: 12px;">
            <td colspan="3" style="border: 1px solid #A8A8A8; font-size: 12px;">
                <span style="font-size: 10px;"> Nome / Razão Social</span> <br/>
                <?= $idrel ?>- <?= $dest->xNome ?>
            </td>

            <td style="border: 1px solid #A8A8A8; font-size: 12px;">
                <span style="font-size: 10px;"> CPF/CNPJ</span> <br/>
                <?= $dest->CNPJ ?>
            </td>
            <td  style="border: 1px solid #A8A8A8; font-size: 12px;">
                <span style="font-size: 10px;"> I.E</span> <br/>
                <?= $dest->IE ?></td>

        </tr>
        <tr style="border: 1px solid #A8A8A8; font-size: 12px;">
            <td colspan="5" style="border: 1px solid #A8A8A8; font-size: 12px;">
                <span style="font-size: 10px;"> Endereço</span> <br/>
                <?= $dest->xLgr ?>, <?= $dest->nro ?> <?= $dest->xCpl ?> - <?= $dest->xBairro ?></td>



        </tr>
        <tr style="border: 1px solid #A8A8A8; font-size: 12px;">

            <td colspan="2" style="border: 1px solid #A8A8A8; font-size: 12px;">
                <span style="font-size: 10px;"> CIDADE</span> <br/>
                <?= $dest->xMun ?> - <?= $dest->UF ?>
            </td>

            <td style="border: 1px solid #A8A8A8; font-size: 12px;">
                <span style="font-size: 10px;">CEP</span> <br/>
                <?= $dest->CEP ?></td>


            <td  style="border: 1px solid #A8A8A8; font-size: 12px;">
                <span style="font-size: 10px;"> Telefone</span> <br/>
                <?= $dest->fone ?></td>
            <td  style="border: 1px solid #A8A8A8; font-size: 12px;">
                <span style="font-size: 10px;"> Whatsapp</span> <br/>
                <?= $dest->whatsapp ?></td>

        </tr>

    </table>
    <?php
else :
    ?>
    <table class="table ">
        <tr>
            <td width="80%"> 
                <table class="table table-borded full_table_list_titulo" style="border: 1px solid #A8A8A8; font-size: 12px;">
                    <tr>
                        <td colspan="5" style="text-align: center; background-color: #E8E8E8;">DADOS DO CLIENTE</td>
                    </tr>
                    <tr style="border: 1px solid #A8A8A8; font-size: 12px;">
                        <td colspan="3" style="border: 1px solid #A8A8A8; font-size: 12px;">
                            <span style="font-size: 10px;"> Nome / Razão Social</span> <br/>
                            <?= $idrel ?>- <?= $dest->xNome ?>
                        </td>

                        <td style="border: 1px solid #A8A8A8; font-size: 12px;">
                            <span style="font-size: 10px;"> CPF/CNPJ</span> <br/>
                            <?= $dest->CNPJ ?>
                        </td>
                        <td  style="border: 1px solid #A8A8A8; font-size: 12px;">
                            <span style="font-size: 10px;"> I.E</span> <br/>
                            <?= $dest->IE ?></td>

                    </tr>
                    <tr style="border: 1px solid #A8A8A8; font-size: 12px;">
                        <td colspan="5" style="border: 1px solid #A8A8A8; font-size: 12px;">
                            <span style="font-size: 10px;"> Endereço</span> <br/>
                            <?= $dest->xLgr ?>, <?= $dest->nro ?> <?= $dest->xComp ?> - <?= $dest->xBairro ?></td>



                    </tr>
                    <tr style="border: 1px solid #A8A8A8; font-size: 12px;">

                        <td colspan="2" style="border: 1px solid #A8A8A8; font-size: 12px;">
                            <span style="font-size: 10px;"> CIDADE</span> <br/>
                            <?= $dest->xMun ?> - <?= $dest->UF ?>
                        </td>

                        <td style="border: 1px solid #A8A8A8; font-size: 12px;">
                            <span style="font-size: 10px;">CEP</span> <br/>
                            <?= $dest->CEP ?></td>


                        <td  style="border: 1px solid #A8A8A8; font-size: 12px;">
                            <span style="font-size: 10px;"> Telefone</span> <br/>
                            <?= $dest->fone ?></td>
                        <td  style="border: 1px solid #A8A8A8; font-size: 12px;">
                            <span style="font-size: 10px;"> Whatsapp</span> <br/>
                            <?= $dest->whatsapp ?></td>

                    </tr>

                </table>

            </td>     
            <td width="20%" align="center" style="border: 1px solid #A8A8A8; font-size: 10px;">

                <h5>DOCUMENTO Nº:   <b><?= $dados->doc_empresa ?></b> </h5>

                <hr/>
                EMISSÃO:   <b><?= $dados->data ?> <?= $dados->hora ?></b>
                <hr/>
                VENDEDOR:   <b><?= BuscaVendedor($dados->vendedor) ?></b>

                <?php
                if ($dados->corretor > 0) :
                    ?>
                    <hr/>
                    CORRETOR:   <b><?= BuscaCorretor($dados->corretor) ?></b>
                    <?php
                endif;
                ?>

            </td>
        </tr>

    </table>
<?php
endif;
?>

<Br/>

<table class="table table-striped table-condensed full_table_list">
    <tr class="titulotr">
        <td colspan="16" style="text-align: center; background-color: #E8E8E8;">PRODUTOS</td>
    </tr>
    <tr class="">
        <td><b>Produto</b></td>
        <td><b>Cor</b></td>
        <td><b>Ref.</b></td>
        <td width="30%"><b>Descrição</b></td>
        <td colspan="10"><b>Quantidade</b></td>
        <td><b>Valor Unit.</b></td>
        <td><b>Valor Total</b></td>
    </tr>

    <?php
    $pecas = 0;
    $total = 0;
    $descontop = 0;
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'itmovimentacao');

    $sql = "SELECT sum(itmovimentacao.quantidade) as qtd, sum(itmovimentacao.valorliquido) as total, 
        sum(itmovimentacao.desconto) as tdesconto, itmovimentacao.id, itmovimentacao.preco,
        itmovimentacao.documento, itmovimentacao.produto, itmovimentacao.cancelado, 
        estoqueprodutos.produto as prodestoque, estoqueprodutos.codproduto, estoqueprodutos.var1,
        estoqueprodutos.var2,estoqueprodutos.ordem1, estoqueprodutos.ordem2,
produtos.codigo, produtos.descricao, produtos.ref from itmovimentacao
LEFT JOIN estoqueprodutos on itmovimentacao.produto = estoqueprodutos.codproduto
LEFT JOIN produtos on produtos.codigo = estoqueprodutos.produto
WHERE itmovimentacao.documento = '$documento' ";
    $sql .= " AND cancelado = 'N'";
    $sql .= "GROUP BY estoqueprodutos.codproduto, itmovimentacao.preco
        ORDER BY produtos.codigo, produtos.ref, estoqueprodutos.ordem1, estoqueprodutos.ordem2 ASC";
    $arrayParam = '';
    $dadosit = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'temp_romaneio');
    $sql = "DELETE FROM temp_romaneio WHERE documento = '$documento'";
    $retornodelete = $crud->Sql($sql);

    foreach ($dadosit as $value) :
        $descontop = $descontop + $value->tdesconto;
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'temp_romaneio');
        if ($value->var2 == '') :
            $sql = "SELECT * FROM temp_romaneio WHERE produto = '$value->codigo' and vunit = '$value->preco' and documento = '$documento'";
        else :
            $sql = "SELECT * FROM temp_romaneio WHERE produto = '$value->codigo' and var1 = '$value->var1' and vunit = '$value->preco' and documento = '$documento'";
        endif;
        $arrayParam = '';
        $dadosit = $crud->getSQLGeneric($sql, $arrayParam, true);

        $totalregistro = count($dadosit);
        if ($totalregistro > 0) :
            if ($value->var2 == '') :
                $variacoes = $dadosit[0]->variacoes . '|' . $value->var1 . ':' . $value->qtd;
            else :
                $variacoes = $dadosit[0]->variacoes . '|' . $value->var2 . ':' . $value->qtd;
            endif;
            $sql = "UPDATE temp_romaneio SET variacoes = '$variacoes', total = total + '$value->total' where id = '" . $dadosit[0]->id . "'";
            $insert = $crud->Sql($sql);
        else :
            if ($value->var2 == '') :
                $var = '';
                $variacoes = $value->var1 . ':' . $value->qtd;
            else :
                $var = $value->var1;
                $variacoes = $value->var2 . ':' . $value->qtd;
            endif;

            $sql = "INSERT INTO temp_romaneio(produto, ref, descricao, var1, variacoes, vunit, total, documento)
                VALUES ('$value->codigo', '$value->ref', '$value->descricao', '$var', '$variacoes',
                  '$value->preco', '$value->total',  '$documento')
                ";
            $insert = $crud->Sql($sql);
        endif;

    endforeach;

    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'temp_romaneio');
    $sql = "SELECT * FROM temp_romaneio WHERE documento = '$documento'";
    $arrayParam = '';
    $dadositens = $crud->getSQLGeneric($sql, $arrayParam, true);

    foreach ($dadositens as $value) :
        $total = $total + $value->total;
        ?>
        <tr>
            <td>
                <?= $value->produto ?>
            </td>
            <td>
                <?= $value->var1 ?>
            </td>
            <td>
                <?= $value->ref ?>
            </td>

            <td>
                <?= $value->descricao ?>
            </td>


            <?php
            $separa = explode("|", $value->variacoes);
            $grade = '';
            $i = 0;
            $totalqtdgeral = 0;
            for ($index = 0; $index < count($separa); $index++) :
                echo '<td>';
                $grade = explode(":", $separa[$index]);
                echo $grade[0];
                echo '</td>';
                $i++;
                $totalqtdgeral += $grade[1];
            endfor;

            for ($iz = $i; $iz < 10; $iz++) :
                echo '<td>';
                echo '</td>';
            endfor;
            
            $totalgeralitem = $totalqtdgeral * $value->vunit;
                  
                
            ?>


            <td>
                R$ <?= number_format($value->vunit, $parametros->casadecimal, ',', '.') ?>
            </td>

            <td>
                
        <?php
         if($value->total <> $totalgeralitem) :
        ?>
        <span style="font-size: 10px">(R$ <s><?= $totalgeralitem ?></s>)</span> <br/>
         R$ <?= number_format($value->total, $parametros->casadecimal, ',', '.') ?>
        <?php
        
        else :
            ?>
            
             R$ <?= number_format($value->total, $parametros->casadecimal, ',', '.') ?>
            <?php
            
            endif; 
        ?>
               
            </td>
        </tr>

        <tr style="border-bottom: 1px solid #DCDCDC">
            <td colspan="4"></td>
            <?php
            $separa = explode("|", $value->variacoes);
            $grade = '';
            $i = 0;

            for ($index = 0; $index < count($separa); $index++) :
                echo '<td>';
                $grade = explode(":", $separa[$index]);
                $pecas = $pecas + $grade[1];
                echo number_format($grade[1], $parametros->casadecimal, ',', '.');
                echo '</td>';
                $i++;
            endfor;

            for ($iz = $i; $iz < 10; $iz++) :
                echo '<td>';
                echo '</td>';
            endfor;
            ?>

            <td colspan="2"></td>
        </tr>
        <?php
    endforeach;
    ?>
    <tr>
        <td colspan="5">
        </td>
    </tr>
</table>


<table class="table table-striped  table-condensed full_table_list">
    <tr>
        <td><b>Total Itens</b></td>
        <td><b><?= number_format($pecas, $parametros->casadecimal, ',', '.') ?></b></td>
    </tr>
    <tr>
        <td><b>Sub-Total</b></td>
        <td>R$ <?= number_format($total + $descontop, $parametros->casadecimal, ',', '.') ?></td>
        <td width="50%" style="border: none;"> </td>

    </tr>
    <?php
    if ($parametros->somafrete == 'S') :
        if ($dados->frete > 0) :
            ?>
            <tr>
                <td><b>Frete</b></td>
                <td>R$ <?= number_format($dados->frete, $parametros->casadecimal, ',', '.') ?></td>
                <td width="50%" style="border: none;"> </td>

            </tr>
            <?php
        endif;
    else :
        $dados->frete = 0;
    endif;
    ?>

    <?php

    function porcentagem_nx($parcial, $total) {
        return ( $parcial * 100 ) / $total;
    }
    ?>
    <tr>
        <td><b>Desconto (-)</b></td>
        <td>R$ <?= number_format($dados->desconto + $descontop, $parametros->casadecimal, ',', '.') ?> (<?= number_format(porcentagem_nx($dados->desconto + $descontop, $dados->valorpago + $dados->desconto), $parametros->casadecimal, ',', '.') ?>%)</td>
        <td width="50%" style="border: none;"> </td>

    </tr>
    <?php
    if ($dados->credito > 0) :
        ?>
        <tr>
            <td><b>Crédito (-)</b></td>
            <td>R$ <?= number_format($dados->credito, $parametros->casadecimal, ',', '.') ?></td>
            <td width="50%" style="border: none;"> </td>

        </tr>
        <?php
    endif;
    ?>

    <tr>
        <td><b>Total</b></td>
        <td>R$ <?= number_format($total + $dados->frete - ($dados->desconto), $parametros->casadecimal, ',', '.') ?></td>
        <td width="50%" style="border: none;"> </td>

    </tr>
    <tr>
        <td><b>Total Pago</b></td>
        <td>R$ <?= number_format($dados->valorpago, $parametros->casadecimal, ',', '.') ?></td>
        <td width="50%" style="border: none;"> </td>

    </tr>

    <tr>
        <td><b>Troco</b></td>
        <td>R$ <?= number_format($dados->troco, $parametros->casadecimal, ',', '.') ?></td>
        <td width="50%" style="border: none;"> </td>

    </tr>
</table>



<hr/>


<?php
if ($dados->obs != '') :
    ?>
    <h5> <b> Observações: </b> <br/> <?= $dados->obs ?></h5>
    <hr/>
    <?php
endif;
?>

<?php
if ($dados->linkmaps != '') :
    ?>
    <h5> <b> <a href="<?= $dados->linkmaps ?>" target="_blank"> Rota </a> </b> <br/> </h5>
    <hr/>
    <?php
endif;
?>

<?php
if ($dados->utilizadocredito == 'S') :
    ?>
    <h5> UTILIZADO O CRÉDITO DE R$ <?= number_format($dados->credito, $parametros->casadecimal, ',', '.') ?> COMO PARTE DO PAGAMENTO.</h5>
    <?php
endif;
?>
<?php
$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'itmovimentacao');
$sql = "SELECT * FROM recebimentomov where documento = '$documento'";
//    echo $sql;
$arrayParam = '';
$dadosrec = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

$totalf = count($dadosrec);
if ($totalf > 0) :
    ?>
    <h5> FATURAMENTO </h5>

    <table class="table table-striped table-bordered table-condensed full_table_list">
        <tr class="titulotr">
            <td>Data Vencimento</td>
            <td>Tipo Recebimento</td>
            <td>Valor</td>
        </tr>
        <?php
        foreach ($dadosrec as $value) :
            ?>
            <tr>
                <td><?= $value->dataven ?></td>
                <td><?= $cobranca[$value->tiporeceb] ?></td>
                <td>R$ <?= number_format($value->valor, $parametros->casadecimal, ',', '.') ?></td>
            </tr>
            <?php
        endforeach;
        ?>
    </table>
    <?php
endif;

$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'vendedor');
$sql = "SELECT * from msg_eventos where empresa = '$emitente->emitenteid' ";
$arrayParam = '';
$msg = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

echo nl2br($msg->saida);
?>




<?php
require_once("../../_inc/mpdf/vendor/autoload.php");

// converte o conteudo para uft-8
$mpdf = new \Mpdf\Mpdf([
    'margin_top' => 5,
    'margin_left' => 5,
    'margin_right' => 5,
    'mirrorMargins' => true,
    'default_font_size' => 12,
        ]);
//$mpdf = new mPDF('','', 0, '', 15, 15, 16, 16, 9, 9, '');
$mpdf->keep_table_proportions = true;
$mpdf->allow_charset_conversion = true;
$footer = "<table width = \"1000\">
                   <tr>
                     <td style='font-size: 10px; bottom:-15px;' align=\"right\">Pag: {PAGENO} de {nb} / data impressão: " . date('d/m/Y H:i') . "</td>
                   </tr>
                 </table>";
$mpdf->SetHTMLFooter($footer);
$html = ob_get_clean();
$mpdf->WriteHTML($html);
// escreve definitivamente o conteudo no PDF
$mpdf->Output("romaneio.pdf", 'I');
// imprime

exit();
?>