<?php
ob_start();
?>
<style>
    body {
        font-size: 9px;
    }

    h1, h2, h3, h4, h5, h6,
    .h1, .h2, .h3, .h4, .h5, .h6 {
        font-family: inherit;
        font-weight: 500;
        line-height: 1.1;
        color: inherit; }
    h1 small,
    h1 .small, h2 small,
    h2 .small, h3 small,
    h3 .small, h4 small,
    h4 .small, h5 small,
    h5 .small, h6 small,
    h6 .small,
    .h1 small,
    .h1 .small, .h2 small,
    .h2 .small, .h3 small,
    .h3 .small, .h4 small,
    .h4 .small, .h5 small,
    .h5 .small, .h6 small,
    .h6 .small {
        font-weight: normal;
        line-height: 1;
        color: #777777; }

    h1, .h1,
    h2, .h2,
    h3, .h3 {
        margin-top: 20px;
        margin-bottom: 10px; }
    h1 small,
    h1 .small, .h1 small,
    .h1 .small,
    h2 small,
    h2 .small, .h2 small,
    .h2 .small,
    h3 small,
    h3 .small, .h3 small,
    .h3 .small {
        font-size: 65%; }

    h4, .h4,
    h5, .h5,
    h6, .h6 {
        margin-top: 10px;
        margin-bottom: 10px; }
    h4 small,
    h4 .small, .h4 small,
    .h4 .small,
    h5 small,
    h5 .small, .h5 small,
    .h5 .small,
    h6 small,
    h6 .small, .h6 small,
    .h6 .small {
        font-size: 75%; }

    h1, .h1 {
        font-size: 36px; }

    h2, .h2 {
        font-size: 30px; }

    h3, .h3 {
        font-size: 24px; }

    h4, .h4 {
        font-size: 18px; }

    h5, .h5 {
        font-size: 14px; }

    h6, .h6 {
        font-size: 12px; }
    .text-center {
        text-align: center; }

    table {
        width: 100%;
        padding: 10px;
    }

    td {
        padding: 7px;
    }
    th {
        text-align: left;
    }
    /*.titulotr { border:  none};*/
    /*.titulotr { background: #000; border:1px black solid;};*/
    .table-bordered th,
    .table-bordered td {
        border: 1px solid #ddd !important; } 

    .full_table_list_titulo{border-collapse: collapse;}
    .full_table_list_titulo tr{border:1px black solid;}

    .full_table_list{border-collapse: collapse;}
    .full_table_list tr{border:1px black solid;}
    .full_table_list tr:nth-child(even) {background: #eee}
    .full_table_list tr:nth-child(odd) {background: #fff}  

    .tablecor {border:1px black solid; background: #eee}
    .titulotr {border:1px black solid; background: #F5F5F5}
</style>
<?php
require_once("../../../functions.php");
//
require_once "../../../_backend/_class/Conexao_class.php";
require_once "../../../_backend/_class/Crud_class.php";
require_once "../../../_backend/_class/parametros.php";


$documento = $_GET['documento'];
$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'itmovimentacao');
$sql = "SELECT * from movimentacao where documento = '$documento' ";
$arrayParam = '';
$dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);


if ($dados->para == 'R') :
    $dest = BuscaPara('R', $dados->representante);
elseif ($dados->para == 'F') :
    $dest = BuscaPara('F', $dados->funcionario);
else :
    $dest = BuscaPara('C', $dados->cliente);
endif;

function BuscaPara($valor, $id) {

    if ($valor == 'R') :
        $sql = "SELECT * from representante where representanteid = '$id' ";
    elseif ($valor == 'F') :
        $sql = "SELECT * from funcionario where funcionarioid = '$id' ";
    else :
        $sql = "SELECT * from cliente where clienteid = '$id' ";
    endif;

    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'tabela');
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

    return $dados;
}

if ($dados->para == 'R') :
    $titulo = 'SAÍDA CONSIGNADA ';
elseif ($dados->para == 'C') :
    $titulo = 'DOCUMENTO DE SAÍDA ';
endif;
?>
<table class="table table-bordered full_table_list_titulo">
    <tr> 
        <td colspan="6" align="center"> <?= $titulo ?> - ESTE DOCUMENTO NÃO É VÁLIDO COMO DOCUMENTO FISCAL </td>
    </tr>
    <tr>
        <td width="10%"> Documento</td>
        <td colspan="2"><?= $dados->documento ?></td>
        <td width="10%"> Data</td>
        <td colspan="2"><?= $dados->data ?></td>
    </tr>
    <tr>
        <td width="10%"> Nome</td>
        <td colspan="2"><?= $dest->xNome ?></td>
        <td width="10%"> CPF/CNPJ</td>
        <td colspan="2"><?= $dest->CNPJ ?></td>
    </tr>
    <tr>
        <td width="10%"> Endereço</td>
        <td colspan="2"><?= $dest->xLgr ?>, <?= $dest->nro ?> - <?= $dest->xBairro ?></td>
        <td width="10%"> Cidade</td>
        <td colspan="2"><?= $dest->xMun ?> - <?= $dest->UF ?></td>
    </tr>
    <tr>


    </tr>
</table>
<!--<hr/>-->

<table class="table table-striped table-bordered table-condensed full_table_list">
    <tr class="titulotr">
        <td colspan="5"></td>
    </tr>
    <tr class="titulotr">
        <td>Produto</td>
        <td>Qtd</td>
        <td>Descrição</td>
        <td>Valor Unit.</td>
        <td>Valor Total</td>
    </tr>

    <?php
    $pecas = 0;
    $total = 0;
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'itmovimentacao');
    $sql = "SELECT sum(itmovimentacao.quantidade) as qtd, sum(itmovimentacao.valorliquido) as total, itmovimentacao.id, itmovimentacao.preco,
        itmovimentacao.documento, itmovimentacao.produto, estoqueprodutos.produto, estoqueprodutos.codproduto, 
produtos.codigo, produtos.descricao from itmovimentacao
LEFT JOIN estoqueprodutos on itmovimentacao.produto = estoqueprodutos.codproduto
LEFT JOIN produtos on produtos.codigo = estoqueprodutos.produto
WHERE itmovimentacao.documento = '$documento'
GROUP BY estoqueprodutos.produto";

//    echo $sql;
    $arrayParam = '';
    $dadosit = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

    foreach ($dadosit as $value) :

        $pecas = $pecas + $value->qtd;
        $total = $total + $value->total;
        ?>
        <tr class='tablecor'>
            <td><?= $value->codigo ?></td>
            <td><?= intval($value->qtd) ?></td>
            <td><?= $value->descricao ?></td>
            <td>R$ <?= number_format($value->preco, $parametros->casadecimal, ',', '.') ?></td>
            <td>R$ <?= number_format($value->total, $parametros->casadecimal, ',', '.') ?></td>
        </tr>
        <?php
    endforeach;
    ?>
    <tr class="titulotr">
        <td colspan="5"></td>
    </tr>
    <tr class="titulotr">
        <td>Total Peças</td>
        <td><?= intval($pecas) ?></td>
        <td></td>
        <td>Total</td>
        <td>R$ <?= number_format($total, $parametros->casadecimal, ',', '.') ?></td>

    </tr>
</table>

<?php
if ($dados->para == 'C') :
    ?>

    <table class="table table-striped table-bordered table-condensed full_table_list">
        <tr class="titulotr">
            <td>Data Vencimento</td>
            <td>Tipo Recebimento</td>
            <td>Valor</td>
        </tr>
        <?php
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'itmovimentacao');
        $sql = "SELECT * FROM recebimentomov where documento = '$documento'";
//    echo $sql;
        $arrayParam = '';
        $dadosrec = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

        foreach ($dadosrec as $value) :
            ?>
            <tr>
                <td><?= $value->dataven ?></td>
                <td><?= $value->tiporeceb ?></td>
                <td><?= $value->valor ?></td>
            </tr>
            <?php
        endforeach;
        ?>
    </table>
    <?php
endif;
require_once("../../_inc/mpdf/mpdf.php");


// converte o conteudo para uft-8
$mpdf = new mPDF('utf-8', array(190, 236));
// Define a default page using all default values except "L" for Landscape orientation
$mpdf = new mPDF('', '', 0, '', 5, 5, 5, 16, 9, 9, 'L');
//$mpdf = new mPDF('','', 0, '', 15, 15, 16, 16, 9, 9, '');
$mpdf->keep_table_proportions = true;
$mpdf->allow_charset_conversion = true;
$footer = "<table width = \"1000\">
                   <tr>
                     <td style='font-size: 10px; bottom:-15px;' align=\"right\">Pag: {PAGENO} de {nb}</td>
                   </tr>
                 </table>";
$mpdf->SetHTMLFooter($footer);
$html = ob_get_clean();
$mpdf->WriteHTML($html);
// escreve definitivamente o conteudo no PDF
$mpdf->Output("romaneio.pdf", 'I');
// imprime

exit();
?>