<?php
date_default_timezone_set('America/Sao_Paulo');
require_once "../../_class/Conexao_class.php";
require_once "../../_class/Crud_class.php";
require_once "../../_class/parametros.php";
require_once "../../../functions.php";
require_once("../_modal/_modal.php");

function RetornaCliente($valor) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'emitente');
    $sql = "SELECT * from cliente where clienteid = '" . $valor . "'";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, false);

    return $dados;
}

function RetornaEstoque($emitente, $produto) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'emitente');
    $sql = "SELECT estoqueprodutos.qtd" . $emitente . " as estoque, codproduto from estoqueprodutos where codproduto = '" . $produto . "'";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, false);

    return $dados->estoque;
}

function RetornaUsuario($valor) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'usuario');
    $sql = "SELECT * from usuario where usuarioid = '" . $valor . "'";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, false);

    return $dados->usuarionome;
}

$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'movimentacao_transferencia');
$sql = "SELECT * from pedidos_integracoes where id = '" . $_GET['numero'] . "'";
$arrayParam = '';
$dados = $crud->getSQLGeneric($sql, $arrayParam, false);

$empresa = RetornaCliente($dados->cliente);

if ($dados->status !== 'pendente') :
    ?>

    <div class="row container-fluid">
        <div class="col-md-12 alert alert-info">
            Pedido já confirmado. <b><?= $dados->status ?> </b>
        </div>
    </div>
    <?php
    exit;
endif;
?>

<style>
    .ng {
        font-weight: bold;
        color: #000;
    }
</style>

<script>

    function Produto(valor) {
//        alert(valor);
        $("#produto").val(valor);
        if (valor == '') {
            return false;
        }
        $.ajax({
            type: "GET",
            url: "<?= BACKEND ?>/_controller/_select/_ajax/produtos_select_ajax.php",
            data: {
                produtos: valor
            },
            dataType: "json",
// função para de sucesso
            success: function (data) {
//  alert();
//alert(data);
                if (data != '') {
//                    alert(data[0].xNome);
                    $("#produtos").val(data[0].codproduto);
                    $("#produtodescricao").val(data[0].descricao);
                } else {
                    toastr.warning('Produto Não Encontrado!');
                    $("#produto").val('');
                    $("#produtodescricao").val('');
                }
            }
        }); //termina o jquery


        $("#busca").modal('hide');
    }

    function Busca(valor) {
//        alert(valor);
        $("#busca").modal('show');
        $("#buscatitle").html('BUSCA ' + valor.toUpperCase());
        $("#carregandobusca").css("display", "block");
        $("#recebegrid").load('_backend/_view/_grid/grade_produtos_grid.php?busca=S', function () {
            $("#carregandobusca").css("display", "none");
        });
        $("#carregandobusca").css("display", "none");
    }


    function Busca(valor) {
        $("#busca").modal('show');
        $("#buscatitle").html('BUSCA ' + valor.toUpperCase());
        $("#carregandobusca").css("display", "block");
        $("#recebegrid").load('_backend/_view/_grid/' + valor + '_grid.php?busca=S', function () {
            $("#carregandobusca").css("display", "none");
        });
        $("#carregandobusca").css("display", "none");
    }


    function SubstituirProduto() {
        var sku = $("#produtosku").val();
        var produto = $("#produtos").val();
        var qtd = $("#qtdsubstituicao").val();
        $.ajax({
            type: "GET",
            url: "<?= BACKEND ?>/_controller/_update/substituir_item_pedidosintegracoes_update.php",
            data: {
                id: sku,
                produto: produto,
                qtd: qtd
            },
            dataType: "json",
// função para de sucesso
            success: function (data) {
//  alert();
                if (data.retorno) {
                    toastr.warning('Substituição Realizada');
                    Carrega('_view', 'pedidos_integracoes.php?numero=<?= $_GET['numero'] ?>', 'Detalhes');
                } else {
                    toastr.warning('Tente novamente');
                }
            }
        }); //termina o jquery
    }

    function Vendedor(valor) {
        if (valor == '') {
            return false;
        }
//        alert(valor);
        $.ajax({
            type: "GET",
            url: "<?= BACKEND ?>/_controller/_select/_ajax/vendedor_select_ajax.php",
            data: {
                vendedor: valor
            },
            dataType: "json",
// função para de sucesso
            success: function (data) {
//  alert();
                if (data != '') {
//                    alert(data[0].xNome);
                    $("#nomevendedor").val(data[0].xNome);
                    $("#vendedor").val(data[0].vendedorid);
                } else {
                    $("#vendedor").val('');
                    $("#nomevendedor").val('');
                    toastr.warning('Vendedor Não Encontrado');
                }
            }
        }); //termina o jquery


        $("#busca").modal('hide');
    }


    function substituir(valor, qtd) {
        $("#Substituicao").modal('show');
        $("#produtosku").val(valor);
        $("#qtdsubstituicao").val(qtd);
    }

</script>



<div class="row">
    <div class="col-md-4">
        <b>Data do Pedido: </b> <?= $dados->data_pedido ?>
    </div>
    <div class="col-md-4">
        <b>Numero: </b> <?= $dados->numero ?> 
    </div>
    <div class="col-md-4">
        <b>Situação: </b> <?= $dados->status ?> 
    </div>
</div>
<br/>
<div class="row">
    <div class="col-md-4">
        <b> CLIENTE:  </b>   <?= $empresa->clienteid ?> - <?= $empresa->xNome ?> <br/>       
    </div>
    <div class="col-md-4">
        <b>ENDEREÇO: </b>  <?= $empresa->xLgr ?>, <?= $empresa->nro ?> - <?= $empresa->xBairro ?>
    </div>
    <div class="col-md-4">
        <?= $empresa->xMun ?> - <?= $empresa->UF ?> / <?= $empresa->fone ?>
    </div>
</div>
<Br/>

<div class="row">
    <div class="col-md-4">
        <b> VALOR:  </b>  R$ <?= number_format($dados->valor, 2, ',', '.') ?> <br/>       
    </div>
</div>
<Br/>
<table class="table table-condesed table-striped">
    <thead>
        <tr class="alert alert-default">
            <td></td>
            <td><b>CÓDIGO</b></td>
            <td><b>DESCRIÇÃO</b></td>
            <td><b>QUANTIDADE</b></td>            
            <?php
            if ($parametros->exibeestoqueintegracao == 'S') :

                $sql = "SELECT * from emitente";
//    echo $sql;
                $arrayParam = '';
                $emit = $crud->getSQLGeneric($sql, $arrayParam, true);

                foreach ($emit as $emit) :
                    ?>
                    <td><b><?= $emit->xFant ?></b></td>
                    <?php
                endforeach;
            else :
                ?>
                <td><b>ESTOQUE</b></td>            
            <?php
            endif;
            ?>

        </tr>
    </thead>
    <?php
    $sql = "SELECT pedidos_integracoes_itens.id, pedidos_integracoes_itens.quantidade, pedidos_integracoes_itens.nome, pedidos_integracoes_itens.preco, pedidos_integracoes_itens.sku, 
        pedidos_integracoes_itens.pedido, pedidos_integracoes_itens.total, estoqueprodutos.produto, estoqueprodutos.codproduto, 
produtos.codigo, produtos.descricao from pedidos_integracoes_itens
LEFT JOIN estoqueprodutos on pedidos_integracoes_itens.sku = estoqueprodutos.codproduto
LEFT JOIN produtos on produtos.codigo = estoqueprodutos.produto
WHERE  pedidos_integracoes_itens.pedido = '" . $_GET['numero'] . "'";
//    echo $sql;
    $arrayParam = '';
    $itens = $crud->getSQLGeneric($sql, $arrayParam, true);

    foreach ($itens as $itens) :
        $totalqtd = $totalqtd + $itens->quantidade;
        ?>
        <tr class="ng">
            <td><button class="btn btn-warning btn-sm" type="button" onclick="substituir('<?= $itens->id ?>', '<?= $itens->quantidade ?>')"><i class="fa fa-edit"></i> </button></td>
            <td class="text-uppercase"><b><?= $itens->sku ?></b></td>
            <td class="text-uppercase"><b><?= $itens->nome ?></td>
            <td class="text-uppercase"><?= number_format($itens->quantidade, $parametros->casadecimalqtd, ',', '.') ?>            </td>
            <?php
            if ($parametros->exibeestoqueintegracao == 'S') :
                $sql = "SELECT * from emitente";
//    echo $sql;
                $arrayParam = '';
                $emit = $crud->getSQLGeneric($sql, $arrayParam, true);

                foreach ($emit as $emit) :
                    ?>
                    <?php
                endforeach;
            else :
                ?>
                <td><?= number_format(RetornaEstoque($_SESSION['Empresa'], $itens->sku), $parametros->casadecimalqtd, ',', '.') ?></td>
            <?php
            endif;
            ?>
        </tr>
        <?php
    endforeach;
    ?>

    <tr class="alert alert-default">
        <td colspan="3"> <b> TOTAL PEÇAS</b></td>
        <td> <b> <?= number_format($totalqtd, $parametros->casadecimalqtd, ',', '.') ?> </b></td>
        <td colspan="3"></td>
    </tr>
    <tfoot>
        <tr>
            <td colspan="7" class="text-right"> 
                <button class="btn btn-success" data-toggle="modal" data-target="#ConfirmaSaida"> CONFIRMAR </button>
            </td>
        </tr>
    </tfoot>
</table>

<div class="row">
    <div class="col-md-12">
        FORMA DE PAGAMENTO
    </div>
</div>
<div class="row">
    <div class="col-md-12">

        <table class="table table-condesed table-striped">
            <thead>
                <tr class="alert alert-default">
                    <td>TOTAL DE PARCELA</td>
                    <td>VALOR</td>
                    <td>FORMA</td>
                </tr>
            </thead>
            <?php
            $pdo = Conexao::getInstance();
            $crud = Crud::getInstance($pdo, 'emitente');
            $sql = "SELECT * from recebimento_pedidos_integracoes where pedido = '" . $_GET['numero'] . "'";
            $arrayParam = '';
            $pagamento = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

            foreach ($pagamento as $pagamento) :
                ?>
                <tr>
                    <td><?= $pagamento->parcela ?> </td>
                    <td><?= $pagamento->valor ?> </td>
                    <td><?= $pagamento->forma ?> </td>
                </tr>
                <?php
            endforeach;
            ?>
        </table>
    </div>
</div>

<!-- Modal -->
<div class="modal fade" id="ConfirmaSaida" tabindex="-1" role="dialog" aria-labelledby="ConfirmaSaida">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title" id="myModalLabel">Confirmação</h4>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-12">

                        <label>Empresa</label>
                        <?php
                        $pdo = Conexao::getInstance();
                        $crud = Crud::getInstance($pdo, 'emitente');
                        $sql = "SELECT * from emitente";
                        $arrayParam = '';
                        $dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);
//        echo $sql
                        ?>
                        <select id="empresa" name="empresa" class="form-control">

                            <option></option>
                            <?php
                            foreach ($dados as $dados) :
                                ?>
                                <option <?php
                                if ($_SESSION['Empresa'] === $dados->emitenteid) {
                                    echo 'selected';
                                }
                                ?> value="<?= $dados->emitenteid ?>"><?= $dados->xNome ?> - <?= $dados->CNPJ ?></option>
                                    <?php
                                endforeach;
                                ?>
                        </select>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-12">
                        <label> Vendedor </label>
                    </div>
                    <div class="col-md-3">
                        <input id="vendedor" name="vendedor" type="text" onblur="Vendedor(this.value)" class="form-control" placeholder="Cod"> 
                    </div>

                    <div class="col-md-9">
                        <input id="nomevendedor" type="text" readonly="" class="form-control" placeholder="Nome Vendedor"> 
                    </div>
                </div>
                <div class="row">
                    <br/>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancelar</button>
                    <button type="button" id="btnconfirma" class="btn btn-primary" onclick="Confirma()">Confirmar</button>
                </div>
            </div>
        </div>
    </div>
</div>


<!-- Modal -->
<div class="modal fade" id="Substituicao" tabindex="-1" role="dialog" aria-labelledby="Substituicao">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title" id="myModalLabel">Substituição de Item</h4>
            </div>
            <div class="modal-body">
                <div class="row">
                    <input type="hidden" id="produtosku">
                    <div class="col-md-3">
                        <label>Produto </label>
                        <input name="produto" id="produtos" onblur="Produto(this.value)" type="text" class="form-control" placeholder=""> 
                        <i onclick="Busca('grade_produtos')" style="position: absolute; right: 22px; top: 37px; z-index: 9999" class="fa fa-search"> </i>
                    </div>

                    <div class="col-md-7">
                        <label>Produto Descrição </label>                         
                        <input id="produtodescricao" disabled="" type="text" required="" class="form-control" placeholder="">                   
                    </div>

                    <div class="col-md-2">
                        <label>Quantidade </label>                         
                        <input id="qtdsubstituicao" name="qtd" type="text" required="" class="form-control" placeholder="">                   
                    </div>

                </div>

                <div class="row">
                    <br/>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancelar</button>
                    <button type="button" id="btnconfirma" class="btn btn-primary" onclick="SubstituirProduto()">Confirmar</button>
                </div>
            </div>
        </div>
    </div>
</div>


<script>

    function AtualizaNuvemShop(documento) {
        $.ajax({
            type: "POST",
            url: "_backend/NuvemShop/AtualizaEstoque_saida.php",
            data: {
                documento: documento
            },
            cache: false,
            dataType: "json",
            success: function (data)
            {
                //                    alert(data[0].situacao)

            }
        });
    }

    function RateioDesc(documento) {
        $.ajax({
            type: "POST",
            url: "_backend/_controller/_update/rateio_desconto_update.php",
            data: {
                documento: documento
            },
            dataType: "json",
// função para de sucesso
            success: function (data) {
            }
        }); //termina o jquery
    }

    function Confirma() {
        bootbox.confirm({
            message: "Deseja confirmar a a movimentação e dar baixa em seu estoque?",
            buttons: {
                confirm: {
                    label: 'Sim',
                    className: 'btn-success'
                },
                cancel: {
                    label: 'Não',
                    className: 'btn-danger'
                }
            },
            callback: function (result) {
                $("#btnconfirma").attr("disabled", true);
                $("#btnconfirma").html("Aguarde...");
                if (result) {
                    $.ajax({
                        type: "POST",
                        url: "_backend/_controller/_insert/pedidos_integracoes.php",
                        data: {
                            numero: <?= $_GET['numero'] ?>,
                            empresa: $("#empresa").val(),
                            vendedor: $("#vendedor").val()
                        },
                        dataType: "json",
                        // função para de sucesso
                        success: function (data) {
                            //                alert(data);
                            if (data.retorno === true) {
                                bootbox.alert("Documento confirmado, documento de saída número: " + data.doc + "", function () {
                                    AtualizaNuvemShop(data.docinterno);
                                    RateioDesc(data.docinterno);
                                    Carrega('_grid', 'pedidos_integracoes_grid.php', 'Pedidos E-commerce');
                                });
                            } else {
                                bootbox.alert(data.mensagem);
                                $("#btnconfirma").attr("disabled", false);
                                $("#btnconfirma").html("CONFIRMAR");
                            }
                        }
                    }); //termina o jquery 
                }
            }
        });
    }
</script>