<?php
ob_start();
?>
<style>
    body {
        font-size: 10px;
    }

    h1, h2, h3, h4, h5, h6,
    .h1, .h2, .h3, .h4, .h5, .h6 {
        font-family: inherit;
        font-weight: 500;
        line-height: 1.1;
        color: inherit;
    }
    h1 small,
    h1 .small, h2 small,
    h2 .small, h3 small,
    h3 .small, h4 small,
    h4 .small, h5 small,
    h5 .small, h6 small,
    h6 .small,
    .h1 small,
    .h1 .small, .h2 small,
    .h2 .small, .h3 small,
    .h3 .small, .h4 small,
    .h4 .small, .h5 small,
    .h5 .small, .h6 small,
    .h6 .small {
        font-weight: normal;
        line-height: 1;
        color: #777777;
    }

    h1, .h1,
    h2, .h2,
    h3, .h3 {
        margin-top: 20px;
        margin-bottom: 10px;
    }
    h1 small,
    h1 .small, .h1 small,
    .h1 .small,
    h2 small,
    h2 .small, .h2 small,
    .h2 .small,
    h3 small,
    h3 .small, .h3 small,
    .h3 .small {
        font-size: 65%;
    }

    h4, .h4,
    h5, .h5,
    h6, .h6 {
        margin-top: 10px;
        margin-bottom: 10px;
    }
    h4 small,
    h4 .small, .h4 small,
    .h4 .small,
    h5 small,
    h5 .small, .h5 small,
    .h5 .small,
    h6 small,
    h6 .small, .h6 small,
    .h6 .small {
        font-size: 75%;
    }

    h1, .h1 {
        font-size: 36px;
    }

    h2, .h2 {
        font-size: 30px;
    }

    h3, .h3 {
        font-size: 24px;
    }

    h4, .h4 {
        font-size: 18px;
    }

    h5, .h5 {
        font-size: 14px;
    }

    h6, .h6 {
        font-size: 12px;
    }
    .text-center {
        text-align: center;
    }

    table {
        width: 100%;
        padding: 10px;
    }

    td {
        padding: 3px;
    }
    th {
        text-align: left;
    }
    /*.titulotr { border:  none};*/
    /*.titulotr { background: #000; border:1px black solid;};*/
    .table-bordered th,
    .table-bordered td {
        border: 1px solid #ddd !important;
    }

    .full_table_list_titulo{
        border-collapse: collapse;
    }
    .full_table_list_titulo tr{
        border:1px black solid;
    }

    .full_table_list{
        border-collapse: collapse;
    }
    .full_table_list tr{
        border:1px black solid;
    }
    .full_table_list tr:nth-child(even) {
        background: #fff
    }
    .full_table_list tr:nth-child(odd) {
        background: #fff
    }

    .tablecor {
        border:1px black solid;
        background: #eee
    }
    .titulotr {
        border:1px black solid;
        background: #F5F5F5
    }
</style>
<?php
require_once("../../../functions.php");
//
require_once "../../../_backend/_class/Conexao_class.php";
require_once "../../../_backend/_class/Crud_class.php";
require_once "../../../_backend/_class/cobranca_class.php";
require_once "../../../_backend/_class/parametros.php";
require_once "../../../_backend/_class/Emitente_class.php";

$logo = '' . FRONTEND . '/img/logomarca/' . $emitente->CNPJ . '/' . $emitente->logo . '';

function BuscaVendedor($valor) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'vendedor');
    $sql = "SELECT * from vendedor where vendedorid = '$valor' ";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

    return $dados->xNome;
}

function BuscaRepresentante($valor) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'vendedor');
    $sql = "SELECT * from representante where representanteid = '$valor' ";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

    return $dados->xNome;
}

$documento = $_GET['documento'];
$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'itmovimentacao');
$sql = "SELECT * from pedidos where documento = '$documento' ";
$arrayParam = '';
$dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

if ($dados->para == 'R') :
    $dest = BuscaPara('R', $dados->representante);
elseif ($dados->para == 'F') :
    $dest = BuscaPara('F', $dados->funcionario);
else :
    $dest = BuscaPara('C', $dados->cliente);
endif;

function BuscaPara($valor, $id) {

    if ($valor == 'R') :
        $sql = "SELECT * from representante where representanteid = '$id' ";
    elseif ($valor == 'F') :
        $sql = "SELECT * from funcionario where funcionarioid = '$id' ";
    else :
        $sql = "SELECT * from cliente where clienteid = '$id' ";
    endif;

    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'tabela');
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

    return $dados;
}

$titulo = 'ITENS SEPARADO DO PEDIDO ';

if ($dados->para == 'R') :
    $idrel = $dest->representanteid;
    $titulorel = 'Representante';
elseif ($dados->para == 'F') :
    $idrel = $dest->funcionarioid;
    $titulorel = 'Funcionário';
else :
    $idrel = $dest->clienteid;
    $titulorel = 'Cliente';
endif;
?>
<?php
//require_once "cabecalho.php";
?>
<table class="table full_table_list_titulo">
    <tr> 
        <td colspan="7" align="center"> <?= $titulo ?> <br/> ESTE DOCUMENTO NÃO É VÁLIDO COMO DOCUMENTO FISCAL </td>
    </tr>
    <tr>
        <td rowspan="6" width="12%"><img src="<?= $logo ?>" height="40px" style="max-width: 14%" alt=""/></td>
        <td width="10%"> <b> Documento </b></td>
        <td colspan="3"><?= $dados->doc_empresa ?>
            &nbsp;&nbsp;&nbsp;&nbsp;  &nbsp;&nbsp;&nbsp;&nbsp;  &nbsp;&nbsp;&nbsp;&nbsp;  &nbsp;&nbsp;&nbsp;&nbsp;


            <b> Controle </b>
            <?= $dados->controle ?>
            &nbsp;&nbsp;&nbsp;&nbsp;  &nbsp;&nbsp;&nbsp;&nbsp;  &nbsp;&nbsp;&nbsp;&nbsp;  &nbsp;&nbsp;&nbsp;&nbsp;

            <b> Emissão</b>
            <?= $dados->data ?>
        </td>

        <td>
            <b> Entrega</b>
            <?= $dados->previsao ?>
        </td>
    </tr>
    <tr>
        <td width="10%"><b> <?= $titulorel ?></b></td>
        <td colspan="2"><?= $idrel ?> - <?= $dest->xNome ?></td>
        <td width="10%"><b> CPF/CNPJ</b></td>
        <td colspan="2"><?= $dest->CNPJ ?></td>
    </tr>
    <tr>

        <td width="10%"><b> Insc. Est.</b></td>
        <td colspan="2"><?= $dest->IE ?>
            &nbsp;&nbsp;&nbsp;&nbsp;  &nbsp;&nbsp;&nbsp;&nbsp;  &nbsp;&nbsp;&nbsp;&nbsp;  &nbsp;&nbsp;&nbsp;&nbsp;
            <b> Fone </b> &nbsp;&nbsp;&nbsp;       
            <?= $dest->fone ?>&nbsp;&nbsp; <?= $dest->whatsapp ?>
            &nbsp;&nbsp;
            <?= $dest->celular ?>
        </td>
        <td width="10%"><b> CEP</b></td>
        <td colspan="2"><?= $dest->CEP ?></td>
    </tr>
    <tr>
        <td width="10%"> <b>Endereço</b></td>
        <td colspan="2"><?= $dest->xLgr ?>, <?= $dest->nro ?> - <?= $dest->xBairro ?></td>
        <td width="10%"><b> Cidade</b></td>
        <td colspan="1"><?= $dest->xMun ?> - <?= $dest->UF ?></td>

    </tr>

    <tr>
        <td width="10%"><b> Rep.</b></td>
        <td colspan="2"><?= $dados->representante ?> - <?= BuscaRepresentante($dados->representante) ?></td>

        <td width="10%"> <b>Vendedor</b></td>
        <td colspan="2"><?= $dados->vendedor ?> - <?= BuscaVendedor($dados->vendedor) ?></td>
    </tr>
</table>

<table class="table table-striped table-condensed full_table_list">
    <tr style="background-color: #dee2e6;">
        <td><b>Ref.</b></td>
        <td><b>Produto</b></td>
        <td><b>Var. 1</b></td>
        <td colspan="12"><b>Quantidade</b></td>
        <td><b>Qtd. Total</b></td>
        <td><b>Valor</b></td>
        <td><b>Total</b></td>
    </tr>
    <?php
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'temp_romaneio');
    $sql = "SELECT * FROM temp_itenspedidos_exibe_separacao WHERE documento = '$documento' order by ref, var1";
    $arrayParam = '';
    $dadositens = $crud->getSQLGeneric($sql, $arrayParam, true);
    $totalpeca = 0;
    $vtotal = 0;
    foreach ($dadositens as $value) :
//        $total = $total + $value->total;
//        $totalpeca = 0;
        $valorliq = $valorliq + $value->total;
        ?>
        <tr style="border-bottom: 1px dashed #dee2e6;">
            <td>
                <?= $value->ref ?>
            </td>
            <td>
                <?= $value->produto . ' ' . $value->descricao ?>
            </td>

            <td>
                <?= $value->var1 ?>
            </td>

            <?php
            $separa = explode("|", $value->variacoes);
            $grade = '';
            $i = 0;
            $qtditem = 0;

            for ($index = 0; $index < count($separa); $index++) :

                $grade = explode(":", $separa[$index]);

                $vtotalitem = $value->vunit * $grade[1];
                $vtotal = $vtotal + $vtotalitem;

                $totalpeca = $totalpeca + $grade[1];
                $qtditem = $qtditem + $grade[1];
                echo '<td>';
                echo '<b>' . $grade[0] . '</b>';
                echo '<br/>';
                echo intval($grade[1]);
                echo '</td>';
                $i++;
            endfor;
            for ($iz = $i; $iz < 12; $iz++) :
                echo '<td>';
                echo '</td>';
            endfor;
            ?>

            <td><?= $qtditem ?> </td>
            <td>R$ <?= number_format($value->vunit, $parametros->casadecimal, ',', '.') ?></td>
            <td>R$ <?= number_format($value->vunit * $qtditem, $parametros->casadecimal, ',', '.') ?></td>


        </tr>
        <?php
    endforeach;
    ?>
</table>


<table class="table table-striped  table-condensed full_table_list" style="width: 100%;">
    <tr>
        <td style="width: 70%;">

            <?php
            if ($dados->obs != '') :
                ?>
                <b> Observações: </b> <br/> <?= $dados->obs ?>
                <br/>
                <?php
            endif;
            ?>
        </td>

        <td style="text-align: right; width: 30%;">
            <table class="table table-striped  table-condensed full_table_list">

                <tr>
                    <td><b>Total Itens</b></td>
                    <td><b><?= number_format($totalpeca, $parametros->casadecimal, ',', '.') ?></b></td>
                </tr>

                <tr>
                    <td><b>Total</b></td>
                    <td>
                        R$ <?= number_format($vtotal, $parametros->casadecimal, ',', '.') ?>
                    </td>
                </tr>

            </table>

        </td>
    </tr>
</table>

<hr/>  




<?php
require_once("../../_inc/mpdf/vendor/autoload.php");

// converte o conteudo para uft-8
$mpdf = new \Mpdf\Mpdf([
    'margin_top' => 5,
    'margin_left' => 5,
    'margin_right' => 5,
    'mirrorMargins' => true,
    'default_font_size' => 12,
        ]);
//$mpdf = new mPDF('','', 0, '', 15, 15, 16, 16, 9, 9, '');
$mpdf->keep_table_proportions = true;
$mpdf->allow_charset_conversion = true;
$footer = "<table width = \"1000\">
                   <tr>
                     <td style='font-size: 10px; bottom:-15px;' align=\"right\">Pag: {PAGENO} de {nb} / data impressão: " . date('d/m/Y H:i') . "</td>
                   </tr>
                 </table>";
$mpdf->SetHTMLFooter($footer);
$html = ob_get_clean();
$mpdf->WriteHTML($html);
// escreve definitivamente o conteudo no PDF
$mpdf->Output("romaneio.pdf", 'I');
// imprime

exit();
?>