<?php
ob_start();
?>
<style>

    @font-face {
        font-family: 'MyWebFont';
        src: url('draft.otf'); /* IE9 Compat Modes */

    }

    table {
        font-size: 12px;
        font-family: 'MyWebFont', Fallback, sans-serif;
    }

</style>

<?php
require_once("../../../functions.php");
//
require_once "../../../_backend/_class/Conexao_class.php";
require_once "../../../_backend/_class/Crud_class.php";
require_once "../../../_backend/_class/cobranca_class.php";
require_once "../../../_backend/_class/parametros.php";
require_once "../../../_backend/_class/Emitente_class.php";

$logo = '' . FRONTEND . '/img/logomarca/' . $emitente->CNPJ . '/' . $emitente->logo . '';

function BuscaVendedor($valor) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'vendedor');
    $sql = "SELECT * from vendedor where vendedorid = '$valor' ";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

    return $dados->xNome;
}

function BuscaVeiculo($valor) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'vendedor');
    $sql = "SELECT * from veiculo where veiculoid = '$valor' ";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

    return $dados->placa . ' : MODELO: '.$dados->modelo .' MARCA: '.$dados->marca;
}

function BuscaFuncionario($valor) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'vendedor');
    $sql = "SELECT * from funcionario where funcionarioid = '$valor' ";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

    return $dados->xNome;
}

function BuscaPreco($valor, $tabela) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'vendedor');
    $sql = "SELECT * from precoprodutos where tabela = '$tabela' and produto = '$valor'";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

    return $dados->valor;
}

$documento = $_GET['documento'];
$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'itos');
$sql = "SELECT * from os where documento = '$documento' ";
$arrayParam = '';
$dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

if ($dados->para == 'R') :
    $dest = BuscaPara('R', $dados->representante);
elseif ($dados->para == 'F') :
    $dest = BuscaPara('F', $dados->funcionario);
else :
    $dest = BuscaPara('C', $dados->cliente);
endif;

function BuscaPara($valor, $id) {

    if ($valor == 'R') :
        $sql = "SELECT * from representante where representanteid = '$id' ";
    elseif ($valor == 'F') :
        $sql = "SELECT * from funcionario where funcionarioid = '$id' ";
    else :
        $sql = "SELECT * from cliente where clienteid = '$id' ";
    endif;

    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'tabela');
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

    return $dados;
}

if ($dados->para == 'R') :
    $idrel = $dest->representanteid;
    $titulorel = 'Representante';
elseif ($dados->para == 'F') :
    $idrel = $dest->funcionarioid;
    $titulorel = 'Funcionário';
else :
    $idrel = $dest->clienteid;
    $titulorel = 'Cliente';
endif;
?>
<?php
//require_once "cabecalho.php";
?>
<table class="table full_table_list_titulo" style="width: 100%">
    <tr> 
        <td colspan="8" align="center"> ORDEM DE SERVIÇO <br/> ESTE DOCUMENTO NÃO É VÁLIDO COMO DOCUMENTO FISCAL </td>
    </tr>
    <tr> 
        <td colspan="8" align="center">  O.S NÚMERO <b> <?= $dados->doc_empresa ?> </b> </td>
    </tr>
    <tr>
        <td rowspan="6" width="15%" align="center"><img src="<?= $logo ?>" height="80px" style="max-width: 15%" alt=""/></td>
        <td width="15%"><b> Data</b></td>
        <td colspan="2"><?= $dados->emissao ?> <?= $dados->horaemissao ?></td>
        <td width="15%"> <b>Técn.</b></td>
        <td colspan="2"><?= $dados->responsavel ?> - <?= BuscaFuncionario($dados->responsavel) ?></td>

    </tr>
<!--    <tr>
        <td width="15%"> <b>Vend.</b></td>
        <td colspan="5"><?= $dados->vendedor ?> - <?= BuscaVendedor($dados->vendedor) ?></td>
       
    </tr>-->
     <tr>
          <td width="15%"> <b>Veic.</b></td>
        <td colspan="5"> <?= BuscaVeiculo($dados->veiculo) ?></td>

    </tr>
    <tr>
        <td width="10%"><b> <?= $titulorel ?></b></td>
        <td colspan="2"><?= $idrel ?> - <?= $dest->xNome ?></td>
        <td width="10%"><b> CPF/CNPJ</b></td>
        <td colspan="2"><?= $dest->CNPJ ?></td>
    </tr>
    <tr>

        <td width="10%"><b> Telefone</b></td>
        <td colspan="2"><?= $dest->fone ?></td>
        <td width="10%"><b> CEP</b></td>
        <td colspan="2"><?= $dest->CEP ?></td>
    </tr>
    <tr>
        <td width="10%"> <b>Endereço</b></td>
        <td colspan="2"><?= $dest->xLgr ?>, <?= $dest->nro ?> - <?= $dest->xBairro ?></td>
        <td width="10%"><b> Cidade</b></td>
        <td colspan="1"><?= $dest->xMun ?> - <?= $dest->UF ?></td>

    </tr>
    <tr>


    </tr>
</table>
<hr/>

<table class="table table-striped table-condensed full_table_list" style="width: 100%" >
    <tr class="titulotr">
        <td colspan="5">PRODUTOS</td>
    </tr>
    <tr class="">
        <td><b>Produto</b></td>
        <td><b>Ref.</b></td>
        <td width="40%"><b>Descrição</b></td>
        <td><b>Qtd</b></td>
        <td><b>Valor Unit.</b></td>
        <td><b>Valor Total</b></td>
    </tr>

    <?php
    $pecas = 0;
    $total = 0;
    $descontop = 0;
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'itos');

    $sql = "SELECT itos.quantidade as qtd, itos.total as total, itos.id, itos.valor as preco,
        itos.documento, itos.produto, estoqueprodutos.produto, estoqueprodutos.codproduto, 
produtos.codigo, produtos.descricao, produtos.ref from itos
LEFT JOIN estoqueprodutos on itos.produto = estoqueprodutos.codproduto
LEFT JOIN produtos on produtos.codigo = estoqueprodutos.produto
WHERE itos.documento = '$documento' ";

//    echo $sql;

    $sql .= " ORDER BY produtos.codigo, produtos.ref ASC";
    $arrayParam = '';
    $dadosit = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

    foreach ($dadosit as $value) :




        $pecas = $pecas + $value->qtd;
        ?>
        <tr class=''>
            <td>
                <?php
                if ($parametros->agrupaitens == 'S') :
                    echo $value->codigo;
                else :
                    echo $value->codproduto;
                endif;
                ?>
            </td>
            <td><?= $value->ref ?></td>
            <td><?= $value->descricao ?></td>
            <td><?= number_format($value->qtd, $parametros->casadecimal, ',', '.') ?></td>
            <td>
                R$
                <?php
                if ($parametros->exibeprecopromocao == 'S') :
                    if ($value->promocao == 'S') :
                        $precopromocao = BuscaPreco($value->codigo, $parametros->tbpadrao);
                        ?>
                        <s>(<?= number_format($precopromocao, $parametros->casadecimal, ',', '.') ?>)</s>
                        <?php
                    endif;
                endif;
                ?>


                <?= number_format($value->preco, $parametros->casadecimal, ',', '.') ?></td>
            <td>

                <?php
                if ($value->tdesconto > 0) :

                    $descontop = $descontop + $value->tdesconto;
                    $total = $total + $value->total + $value->tdesconto;
                    ?>
                    R$ <s>(<?= number_format($value->total + $value->tdesconto, $parametros->casadecimal, ',', '.') ?>)</s>
                    <?= number_format($value->total, $parametros->casadecimal, ',', '.') ?>
                    <?php
                else :
                    $total = $total + $value->total;
                    ?>
                    R$ <?= number_format($value->total, $parametros->casadecimal, ',', '.') ?>
                <?php
                endif;
                ?>
            </td>
        </tr>
        <?php
    endforeach;
    ?>
    <tr>
        <td colspan="5">
        </td>
    </tr>
</table>

<table class="table table-striped table-condensed full_table_list" style="width: 100%" >
    <tr class="titulotr">
        <td colspan="5">SERVIÇOS</td>
    </tr>
    <tr class="">
        <td><b>Serviço</b></td>
        <td><b>Ref.</b></td>
        <td width="40%"><b>Descrição</b></td>
        <td><b>Qtd</b></td>
        <td><b>Valor Unit.</b></td>
        <td><b>Valor Total</b></td>
    </tr>

    <?php
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'itos');

    $sql = "SELECT servicoos.quantidade as qtd, servicoos.total as total, servicoos.id, servicoos.valor as preco,
        servicoos.documento, servicoos.servico,
servicos.servicosid, servicos.descricao from servicoos
LEFT JOIN servicos on servicos.servicosid = servicoos.servico
WHERE servicoos.documento = '$documento' ";

//    echo $sql;

    $sql .= " ORDER BY servicos.servicosid ASC";
    $arrayParam = '';
    $dadosserv = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

    foreach ($dadosserv as $value) :
        ?>
        <tr class=''>
            <td>
                <?php
                if ($parametros->agrupaitens == 'S') :
                    echo $value->servicosid;
                else :
                    echo $value->servicosid;
                endif;
                ?>
            </td>
            <td></td>
            <td><?= $value->descricao ?></td>
            <td><?= number_format($value->qtd, $parametros->casadecimal, ',', '.') ?></td>
            <td>
                R$
                <?php
                if ($parametros->exibeprecopromocao == 'S') :
                    if ($value->promocao == 'S') :
                        $precopromocao = BuscaPreco($value->codigo, $parametros->tbpadrao);
                        ?>
                        <s>(<?= number_format($precopromocao, $parametros->casadecimal, ',', '.') ?>)</s>
                        <?php
                    endif;
                endif;
                ?>


                <?= number_format($value->preco, $parametros->casadecimal, ',', '.') ?></td>
            <td>

                <?php
                $total = $total + $value->total;
                ?>
                R$ <?= number_format($value->total, $parametros->casadecimal, ',', '.') ?>
                <?php ?>
            </td>
        </tr>
        <?php
    endforeach;
    ?>
    <tr>
        <td colspan="5">
        </td>
    </tr>
</table>
<hr/>

<?php

function porcentagem_nx($parcial, $total) {
    return ( $parcial * 100 ) / $total;
}
?>

<table class="table table-striped  table-condensed full_table_list" style="width: 100%">
    <tr>
        <td><b>Total Produtos</b></td>
        <td><b><?= number_format($pecas, $parametros->casadecimal, ',', '.') ?></b></td>
        <td><b>Sub-Total</b></td>
        <td>R$ <?= number_format($total, $parametros->casadecimal, ',', '.') ?></td>
        <td><b>Desconto (-)</b></td>
        <td>R$ <?= number_format($dados->desconto, $parametros->casadecimal, ',', '.') ?> (<?= number_format(porcentagem_nx($dados->desconto, $total), $parametros->casadecimal, ',', '.') ?>%)</td>
    </tr>

    <tr>
        <td><b>Total</b></td>
        <td>R$ <?= number_format($total + $dados->frete - ($dados->desconto), $parametros->casadecimal, ',', '.') ?></td>
        <td><b>Total Pago</b></td>
        <td>R$ <?= number_format($dados->valorpago, $parametros->casadecimal, ',', '.') ?></td>
        <td><b>Troco</b></td>
        <td>R$ <?= number_format($dados->troco, $parametros->casadecimal, ',', '.') ?></td>
    </tr>

</table>



<hr/>


<?php
if ($dados->obs != '') :
    ?>
    <h5> <b> Observações: </b> <br/> <?= $dados->obs ?></h5>
    <hr/>
    <?php
endif;
?>

<?php
if ($dados->linkmaps != '') :
    ?>
    <h5> <b> <a href="<?= $dados->linkmaps ?>" target="_blank"> Rota </a> </b> <br/> </h5>
    <hr/>
    <?php
endif;
?>

<?php
if ($dados->utilizadocredito == 'S') :
    ?>
    <h5> UTILIZADO O CRÉDITO DE R$ <?= number_format($dados->credito, $parametros->casadecimal, ',', '.') ?> COMO PARTE DO PAGAMENTO.</h5>
    <?php
endif;
?>
<?php
$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'itos');
$sql = "SELECT * FROM recebimentoos where documento = '$documento'";
//    echo $sql;
$arrayParam = '';
$dadosrec = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

$totalf = count($dadosrec);
if ($totalf > 0) :
    ?>
    FATURAMENTO
    <table class="table table-striped table-bordered table-condensed full_table_list">
        <tr>
            <?php
            foreach ($dadosrec as $value) :
                ?>
                <td><?= $value->dataven ?> - <?= $cobranca[$value->tiporeceb] ?> - R$ <?= number_format($value->valor, $parametros->casadecimal, ',', '.') ?> | </td>

                <?php
            endforeach;
            ?>
        </tr>

    </table>
    <?php
endif;

?>



<Br/>


____________________________________________ 
<br/>
<?= $dest->xNome ?>

<?php


$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'vendedor');
$sql = "SELECT * from msg_eventos where empresa = '$emitente->emitenteid' ";
$arrayParam = '';
$msg = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

echo nl2br($msg->saida);
?>




<?php
require_once("../../_inc/mpdf/vendor/autoload.php");

//// converte o conteudo para uft-8
$mpdf = new \Mpdf\Mpdf([
    'margin_top' => 5,
    'margin_left' => 5,
    'margin_right' => 5,
    'mirrorMargins' => true,
    'default_font_size' => 12,
        ]);
//$mpdf = new mPDF('','', 0, '', 15, 15, 16, 16, 9, 9, '');
$mpdf->keep_table_proportions = true;
$mpdf->allow_charset_conversion = true;
$footer = "<table width = \"1000\">
                   <tr>
                     <td style='font-size: 10px; bottom:-15px;' align=\"right\">Pag: {PAGENO} de {nb} / data impressão: " . date('d/m/Y H:i') . "</td>
                   </tr>
                 </table>";
$mpdf->SetHTMLFooter($footer);
$html = ob_get_clean();
$mpdf->WriteHTML($html);
// escreve definitivamente o conteudo no PDF
$mpdf->Output("romaneio.pdf", 'I');
// imprime

exit();
?>
<script>
    window.print();
</script>