<?php
ob_start();
?>
<style>
    body {
        font-size: 12px;
    }

    h1, h2, h3, h4, h5, h6,
    .h1, .h2, .h3, .h4, .h5, .h6 {
        font-family: inherit;
        font-weight: 500;
        line-height: 1.1;
        color: inherit;
    }
    h1 small,
    h1 .small, h2 small,
    h2 .small, h3 small,
    h3 .small, h4 small,
    h4 .small, h5 small,
    h5 .small, h6 small,
    h6 .small,
    .h1 small,
    .h1 .small, .h2 small,
    .h2 .small, .h3 small,
    .h3 .small, .h4 small,
    .h4 .small, .h5 small,
    .h5 .small, .h6 small,
    .h6 .small {
        font-weight: normal;
        line-height: 1;
        color: #777777;
    }

    h1, .h1,
    h2, .h2,
    h3, .h3 {
        margin-top: 20px;
        margin-bottom: 10px;
    }
    h1 small,
    h1 .small, .h1 small,
    .h1 .small,
    h2 small,
    h2 .small, .h2 small,
    .h2 .small,
    h3 small,
    h3 .small, .h3 small,
    .h3 .small {
        font-size: 65%;
    }

    h4, .h4,
    h5, .h5,
    h6, .h6 {
        margin-top: 10px;
        margin-bottom: 10px;
    }
    h4 small,
    h4 .small, .h4 small,
    .h4 .small,
    h5 small,
    h5 .small, .h5 small,
    .h5 .small,
    h6 small,
    h6 .small, .h6 small,
    .h6 .small {
        font-size: 75%;
    }

    h1, .h1 {
        font-size: 36px;
    }

    h2, .h2 {
        font-size: 30px;
    }

    h3, .h3 {
        font-size: 24px;
    }

    h4, .h4 {
        font-size: 18px;
    }

    h5, .h5 {
        font-size: 14px;
    }

    h6, .h6 {
        font-size: 12px;
    }
    .text-center {
        text-align: center;
    }

    table {
        width: 100%;
        padding: 10px;
    }

    td {
        padding: 3px;
    }
    th {
        text-align: left;
    }
    /*.titulotr { border:  none};*/
    /*.titulotr { background: #000; border:1px black solid;};*/
    .table-bordered th,
    .table-bordered td {
        border: 1px solid #ddd !important;
    }

    .full_table_list_titulo{
        border-collapse: collapse;
    }
    .full_table_list_titulo tr{
        border:1px black solid;
    }

    .full_table_list{
        border-collapse: collapse;
    }
    .full_table_list tr{
        border:1px black solid;
    }
    .full_table_list tr:nth-child(even) {
        background: #fff
    }
    .full_table_list tr:nth-child(odd) {
        background: #fff
    }

    .tablecor {
        border:1px black solid;
        background: #eee
    }
    .titulotr {
        border:1px black solid;
        background: #F5F5F5
    }
</style>
<?php
require_once("../../../functions.php");
//
require_once "../../../_backend/_class/Conexao_class.php";
require_once "../../../_backend/_class/Crud_class.php";
require_once "../../../_backend/_class/cobranca_class.php";
require_once "../../../_backend/_class/parametros.php";
require_once "../../../_backend/_class/Emitente_class.php";

$logo = '' . FRONTEND . '/img/logomarca/' . $emitente->CNPJ . '/' . $emitente->logo . '';

$fichatecnica = $_GET['ordemproducao'];

function BuscaTipoVar($valor) {
    if ($valor == 'P') :
        return '% ';
    else :
        return 'R$ ';
    endif;
}

function BuscaProduto($valor) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'vendedor');
    $sql = "SELECT * from produtos where codigo = '$valor'";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

    return $dados;
}

function RetornaEstoque($produto, $estoque) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'vendedor');
    $sql = "SELECT produto, codproduto, $estoque as estoque, ref from estoqueprodutos where codproduto = '$produto'";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

    return $dados->estoque;
}

function BuscaDescProd($valor) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'vendedor');
    $sql = "SELECT * from produtos where codigo = '$valor'";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

    return $dados->descricao;
}

function BuscaFichaTecnica($valor) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'vendedor');
    $sql = "SELECT * from pcp_fichatecnica where produto = '$valor'";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

    return $dados->id;
}

function BuscaUN($valor) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'vendedor');
    $sql = "SELECT * from produtos where codigo = '$valor'";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

    return $dados->unidade;
}

function BuscaFornecedor($valor) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'vendedor');
    $sql = "SELECT * from fornecedor where fornecedorid = '$valor'";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

    return $dados->xNome;
}

$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'vendedor');
$sql = "SELECT * from pcp_ordemprod where doc = '$fichatecnica'";
$arrayParam = '';
$dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

//require_once "cabecalho.php";
?>


<table class="table full_table_list_titulo">
    <tr> 
        <td align="center"> ORDEM DE COMPRA DA PRODUÇÃO Nº <?= $dados->doc ?> </td>
    </tr>
</table>

<table class="table" style="font-size: 12px;">
    <?php
    if ($parametros->cabecalho == 'S') :
        ?>
        <tr>
            <td width="15%"><img src="<?= $logo ?>" height="70px" style="max-width: 14%" alt=""/></td>
            <td width="75%"><b> <?= $emitente->xNome ?> </b> 
                <br/>
                <?= $emitente->xLgr ?>, <?= $emitente->nro ?> - <?= $emitente->xBairro ?> <br/>
                <?= $emitente->xMun ?>  <?= $emitente->UF ?> <br/>
                <?= $emitente->fone ?>
            </td>
            <td style="border: none;" width="10%">
                <small>    <?= date("d/m/Y") ?> <Br/>
                    <?= date("H:i") ?>
                </small>
            </td>
        </tr>
        <?php
    endif;
    ?>
</table>

<table class="table full_table_list_titulo table-bordered" style="border: 1px solid #6d6d6d; font-size: 11px;">
    <tr> 
        <td colspan="8" align="center"> <b>MATÉRIA PRIMA</b></td>
    </tr>
    <tr style="border-bottom: 1px solid #000;">
        <td>REF</td>
        <td>PRODUTO</td>
        <td></td>
        <td>QTD NECESSÁRIA</td>
        <td>QTD ESTOQUE</td>
        <td>COMPRAR</td>
        <td>ULTIMO CUSTO</td>
        <td>TOTAL</td>
    </tr>
    <?php
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'vendedor');
    $sql = "SELECT sum(qtd) as qtd, sum(qtdbaixa) as baixa, produto, codproduto, doc from pcp_itemprod";
    $sql .= " where doc = '" . $_GET['ordemproducao'] . "' group by produto";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

//    echo $sql;
    $totalqtd = 0;
    $totalvr = 0;
    foreach ($dados as $value1) :
        $qtd = $value1->qtd - $value1->baixa;
        if ($qtd > 0) :
            $fichatec = BuscaFichaTecnica($value1->produto);
            $pdo = Conexao::getInstance();
            $crud = Crud::getInstance($pdo, 'vendedor');
            $sql = "SELECT * from pcp_fichatecnica_composicao";
            $sql .= " where fichatecnica = '" . $fichatec . "'";
            $arrayParam = '';
            $dadoscp = $crud->getSQLGeneric($sql, $arrayParam, TRUE);
            foreach ($dadoscp as $dadoscp) :
                $estoque = RetornaEstoque($dadoscp->insumo, $_SESSION['Estoque']);
                $totalcompra = $qtd * $dadoscp->quantidade;
                if ($totalcompra > $estoque) :
                    $produto = BuscaProduto($dadoscp->insumo);
                    ?>
                    <tr>
                        <td><?= $produto->ref ?> </td>
                        <td><?= $produto->codigo ?> </td>
                        <td><?= $produto->descricao ?></td>
                        <td><?= number_format($totalcompra, '2', ',', '.') ?> <?= $produto->unidade ?></td>
                        <td><?= number_format($estoque, '2', ',', '.') ?> <?= $produto->unidade ?></td>
                        <td><?= number_format($totalcompra - $estoque, '2', ',', '.') ?> <?= $produto->unidade ?></td>
                        <td>R$ <?= number_format($produto->custo, '2', ',', '.') ?></td>
                        <td>R$ <?= number_format($produto->custo * ($totalcompra - $estoque), '2', ',', '.') ?></td>
                    </tr>       
                    <?php
                endif;
            endforeach;
            ?>

            <?php
        endif;
//    print_r($prodgrade);
        ?>


        <?php
    endforeach;
    ?>


</table>
<br/>


<?php
require_once("../../_inc/mpdf/vendor/autoload.php");

// converte o conteudo para uft-8
$mpdf = new \Mpdf\Mpdf([
    'margin_top' => 5,
    'margin_left' => 5,
    'margin_right' => 5,
    'mirrorMargins' => true,
    'default_font_size' => 12,
        ]);
//$mpdf = new mPDF('','', 0, '', 15, 15, 16, 16, 9, 9, '');
$mpdf->keep_table_proportions = true;
$mpdf->allow_charset_conversion = true;
$footer = "<table width = \"1000\">
                   <tr>
                     <td style='font-size: 10px; bottom:-15px;' align=\"right\">Pag: {PAGENO} de {nb} / data impressão: " . date('d/m/Y H:i') . "</td>
                   </tr>
                 </table>";
$mpdf->SetHTMLFooter($footer);
$html = ob_get_clean();
$mpdf->WriteHTML($html);
// escreve definitivamente o conteudo no PDF
$mpdf->Output("romaneio.pdf", 'I');
// imprime

exit();
?>