<?php
date_default_timezone_set('America/Sao_Paulo');
require_once "../../_class/Conexao_class.php";
require_once "../../_class/Crud_class.php";
require_once "../../_class/parametros.php";
require_once("../../../functions.php");

function BuscaConferencia($produto, $doc) {
    $name = 'T' . $_SESSION['Empresa'] . $doc;

    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'emitente');
    $sql = "SELECT * from $name where produto = '" . $produto . "'";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, false);

    return $dados->quantidade_conferida;
}
?>
<style>
    .bg-danger {
        background: #ffb2b9;
        color: #000000;
    }
</style>
<table class="table table-condesed">
    <thead>
        <tr class="alert alert-default">
            <?php
            if ($parametros->conftransf == 'N') :
                ?>
                <td></td>
                <?php
            endif;
            ?>
            <td><b>CÓDIGO</b></td>
            <td><b>REF.</b></td>
            <td><b>DESCRIÇÃO</b></td>
            <td><b>QUANTIDADE</b></td>

            <?php
            if ($parametros->conftransf == 'S') :
                ?>
                <td><b>CONFERÊNCIA</b></td>
                <?php
            endif;
            ?>
        </tr>
    </thead>
    <?php
    $sql = "SELECT sum(itmovimentacao_transferencia.quantidade) as qtd,  itmovimentacao_transferencia.id, itmovimentacao_transferencia.preco,
        itmovimentacao_transferencia.documento, itmovimentacao_transferencia.produto, itmovimentacao_transferencia.cancelado, estoqueprodutos.produto, estoqueprodutos.codproduto, 
produtos.codigo, produtos.descricao, produtos.ref from itmovimentacao_transferencia
LEFT JOIN estoqueprodutos on itmovimentacao_transferencia.produto = estoqueprodutos.codproduto
LEFT JOIN produtos on produtos.codigo = estoqueprodutos.produto
WHERE itmovimentacao_transferencia.documento = '" . $_GET['documento'] . "' and itmovimentacao_transferencia.cancelado != 'S'";
    $sql .= " GROUP BY estoqueprodutos.codproduto";
    $arrayParam = '';
    $itens = $crud->getSQLGeneric($sql, $arrayParam, true);

    foreach ($itens as $itens) :
        $totalqtd = $totalqtd + $itens->qtd;
        $qtdtansf = 0;
        $qtdtansf = BuscaConferencia($itens->codproduto, $_GET['documento']);
        $totaltrans = $totaltrans + $qtdtansf;
        $bg = 'bg-default';

        if ($parametros->conftransf == 'S') :
            if ($qtdtansf == $itens->qtd) :
                $bg = 'bg-default';
            else :
                $bg = 'bg-danger';
            endif;
        endif;
        ?>
        <tr class="<?= $bg ?>">
            <?php
            if ($parametros->conftransf == 'N') :
                ?>
                <td><button class="btn btn-warning btn-sm" onclick="CancelaItem('<?= $itens->id ?>', '<?= $_GET['documento'] ?>')"> <i class="fa fa-close"></i></button> </td>
                <?php
            endif;
            ?>
            <td><?= $itens->codproduto ?></td>
            <td><?= $itens->ref ?></td>
            <td><?= $itens->descricao ?></td>
            <td><?= number_format($itens->qtd, $parametros->casadecimalqtd, ',', '.') ?>            </td>
            <?php
            if ($parametros->conftransf == 'S') :
                ?>
                <td><?= number_format($qtdtansf, $parametros->casadecimalqtd, ',', '.') ?>            </td>

                <?php
            endif;
            ?>
        </tr>
        <?php
    endforeach;
    ?>

    <tr class="alert alert-default">
        <?php
        if ($parametros->conftransf == 'N') :
            ?>
            <td colspan="4"> <b> TOTAL </b></td>

            <?php
        else :
            ?>
            <td colspan="3"> <b> TOTAL </b></td>

        <?php
        endif;
        ?>


        <td> <b> <?= number_format($totalqtd, $parametros->casadecimalqtd, ',', '.') ?> </b></td>

        <?php
        if ($parametros->conftransf == 'S') :
            ?>
            <td><?= number_format($totaltrans, $parametros->casadecimalqtd, ',', '.') ?>            </td>

            <?php
        endif;
        ?>
    </tr>
    <tfoot>
        <tr>
            <td colspan="3" class="text-left">
                <a class="btn btn-primary" id="btncancela" href="<?= LINK ?>"> VOLTAR </a>
                <button class="btn btn-warning" id="btncancela" onclick="Cancela('<?= $_GET['documento'] ?>')"> CANCELAR </button>
            </td>
            <?php
            if ($parametros->conftransf == 'S') :

//                echo $totalqtd;
//                echo $totaltrans;

                if ($totalqtd == $totaltrans) :
                    ?>
                    <td colspan="2" class="text-right">
                        <button class="btn btn-success" id="btnconfirma"> CONFIRMAR </button>
                    </td>
                    <?php
                endif;
            else :
                ?>
                <td colspan="2" class="text-right">
                    <button class="btn btn-success" id="btnconfirma"> CONFIRMAR </button>
                </td>
            <?php
            endif;
            ?>

    <input type="hidden" id="doc" value="<?= $_GET['documento'] ?>">
    </tr>
    </tfoot>
</table>


<script>



    $("#btnconfirma").click(function () {
        var valor = $("#doc").val();

        // Desativa os botões e muda o texto
        $("#btnconfirma").attr("disabled", true);
        $("#btncancela").attr("disabled", true);
        $("#btnconfirma").html("Aguarde...");

        // Cria o dialog
        var dialog = bootbox.dialog({
            title: "Confirmação",
            message: "Deseja confirmar a transferência e lançar como entrada em seu estoque?",
            animate: false,
            buttons: {
                cancel: {
                    label: 'Não',
                    className: 'btn-danger',
                    callback: function () {
                        // Reativa os botões e volta ao texto original
                        $("#btnconfirma").attr("disabled", false);
                        $("#btncancela").attr("disabled", false);
                        $("#btnconfirma").html("CONFIRMAR");
                    }
                },
                confirm: {
                    label: 'Sim',
                    className: 'btn-success',
                    callback: function () {
                        // Fecha o dialog manualmente
                        dialog.modal('hide');

                        // Adiciona um timeout antes de executar o AJAX
                        setTimeout(function () {
                            // Envia os dados via AJAX
                            $.ajax({
                                type: "POST",
                                url: "_backend/_controller/_insert/transferencia_confirma.php",
                                data: {
                                    documento: valor
                                },
                                dataType: "json",
                                success: function (data) {
                                    if (data.retorno === true) {
                                        bootbox.alert("Transferência confirmada, documento de entrada número: " + data.doc, function () {
                                            $(location).attr('href', 'index.php');
                                        });
                                    } else {
                                        bootbox.alert(data.mensagem);
                                        // Reativa os botões
                                        $("#btnconfirma").attr("disabled", false);
                                        $("#btncancela").attr("disabled", false);
                                        $("#btnconfirma").html("CONFIRMAR");
                                    }
                                },
                                error: function () {
                                    bootbox.alert("Erro ao processar a solicitação. Tente novamente.");
                                    $("#btnconfirma").attr("disabled", false);
                                    $("#btncancela").attr("disabled", false);
                                    $("#btnconfirma").html("CONFIRMAR");
                                }
                            });
                        }, 1000); // Atraso de 1 segundos

                        // Impede o fechamento automático do dialog
                        return false;
                    }

                }
            }
        });
    });


    function Cancela(valor) {
        bootbox.confirm({
            message: "Deseja cancelar a transferência? Essa operação não pode ser desfeita!",
            buttons: {
                confirm: {
                    label: 'Sim',
                    className: 'btn-success'
                },
                cancel: {
                    label: 'Não',
                    className: 'btn-danger'
                }
            },
            callback: function (result) {
                $("#btnconfirma").attr("disabled", true);
                $("#btncancela").attr("disabled", true);
                $("#btncancela").html("Aguarde...");
                if (result) {
                    $.ajax({
                        type: "POST",
                        url: "_backend/_controller/_delete/movimentacao_transferencia_cancela.php",
                        data: {
                            documento: valor
                        },
                        dataType: "json",
// função para de sucesso
                        success: function (data) {
//                alert(data);
                            if (data.retorno === true) {
                                bootbox.alert("Transferência Cancelada", function () {
                                    $(location).attr('href', 'index.php');
                                });
                            } else {
                                bootbox.alert(data.mensagem);
                                $("#btnconfirma").attr("disabled", false);
                                $("#btncancela").attr("disabled", false);
                                $("#btncancela").html("CANCELAR");
                            }
                        }
                    }); //termina o jquery 
                } else {
                    $("#btnconfirma").attr("disabled", false);
                    $("#btncancela").attr("disabled", false);
                    $("#btncancela").html("CANCELAR");
                }
            }
        });
    }

    function CancelaItem(item, valor) {
        bootbox.confirm({
            message: "Deseja cancelar o item? Essa operação não pode ser desfeita!",
            buttons: {
                confirm: {
                    label: 'Sim',
                    className: 'btn-success'
                },
                cancel: {
                    label: 'Não',
                    className: 'btn-danger'
                }
            },
            callback: function (result) {
                $("#btnconfirma").attr("disabled", true);
                $("#btncancela").attr("disabled", true);
                $("#btncancela").html("Aguarde...");
                if (result) {
                    $.ajax({
                        type: "POST",
                        url: "_backend/_controller/_delete/itmovimentacao_transferencia_cancela.php",
                        data: {
                            itmovimentacao: item,
                            documento: valor
                        },
                        dataType: "json",
// função para de sucesso
                        success: function (data) {
//                alert(data);
                            if (data.retorno === true) {
                                bootbox.alert("Item Cancelado", function () {
                                    document.location.reload(true);
                                });
                            } else {
                                bootbox.alert(data.mensagem);
                                $("#btnconfirma").attr("disabled", false);
                                $("#btncancela").attr("disabled", false);
                                $("#btncancela").html("CANCELAR");
                            }
                        }
                    }); //termina o jquery 
                } else {
                    $("#btnconfirma").attr("disabled", false);
                    $("#btncancela").attr("disabled", false);
                    $("#btncancela").html("CANCELAR");
                }
            }
        });
    }
</script>
