<?php
require_once("../../../functions.php");
require_once "../../../_backend/_class/Conexao_class.php";
require_once "../../../_backend/_class/Crud_class.php";
require_once "../../../_backend/_class/parametros.php";
require_once "../../../_backend/_class/Emitente_class.php";

// error_reporting(E_ALL);
// ini_set('display_errors', 'On');

$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'nfe');
$sql = "SELECT
            prodnfeid,
            cProd,
            xProd,
            qtd
        from produtonfe WHERE NFe = '" . $_GET['nfe'] . "'";
$arrayParam = '';
$produtos = $crud->getSQLGeneric($sql, $arrayParam, true);


$sqlNFe = "SELECT
                nfe.nNF,
                fornecedor.xNome,
                fornecedor.xFant,
                fornecedor.fornecedorid
            FROM nfe
            LEFT JOIN fornecedor ON nfe.destCNPJ = fornecedor.CNPJ
            WHERE nfe.id = '" . $_GET['nfe'] . "'";
$arrayParam = '';
$dadosNFe = $crud->getSQLGeneric($sqlNFe, $arrayParam, false);


// echo '<pre>';
//     print_r($produtos);
// echo '</pre><br>';
// exit();

$codigos = [];
foreach ($produtos as $key => $produto) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'vinculacaoprodutos');
    $sqlProd = "SELECT
                    codfornecedor,
                    combinacao
                FROM vinculacaoprodutos
                WHERE vinculacaoprodutos.combinacao = '$produto->cProd'
                AND vinculacaoprodutos.fornecedor = '$dadosNFe->fornecedorid'
                ORDER BY id DESC
                ";
    $arrayParam = '';
    $dadosCodigos = $crud->getSQLGeneric($sqlProd, $arrayParam, false);

    $codigos[$key]['sistema'] = $dadosCodigos->combinacao;
    $codigos[$key]['fornecedor'] = $dadosCodigos->codfornecedor;
}

?>

<style>
    /* Estilo geral e normalizações */
    .devolucao-container {
        max-width: 95%;
        margin: 0 auto;
    }

    /* Estilos da tabela */
    .table-devolucao {
        width: 100%;
        border-collapse: collapse;
        margin-bottom: 20px;
        font-size: 14px;
    }

    .table-devolucao thead {
        background-color: #f4f4f4;
        border-bottom: 2px solid #ddd;
    }

    .table-devolucao th,
    .table-devolucao td {
        padding: 8px 10px;
        vertical-align: middle;
    }

    /* Definição de larguras das colunas */
    .col-checkbox {
        width: 80px;
        text-align: center;
    }

    .col-codigo {
        width: 120px;
    }

    .col-descricao {
        width: auto;
        /* Deixa a coluna de descrição expandir */
    }

    .col-quantidade {
        width: 250px;
        text-align: center;
    }

    /* Estilos para inputs */
    .input-quantidade {
        width: 90px;
        height: 30px;
        padding: 4px 8px;
        border: 1px solid #bbb;
        border-radius: 3px;
        text-align: center;
        font-size: 14px;
    }

    .input-quantidade:focus {
        border-color: #66afe9;
        outline: 0;
        box-shadow: inset 0 1px 1px rgba(0, 0, 0, .075), 0 0 8px rgba(102, 175, 233, .6);
    }

    /* Estilo para checkbox */
    .checkbox-devolucao {
        width: 18px;
        height: 18px;
        cursor: pointer;
    }

    .btn-selecionar-todos {
        margin-bottom: 10px;
        font-size: 13px;
        padding: 5px 10px;
    }

    /* Estilo para o botão */
    .btn-devolucao {
        margin-top: 10px;
    }

    /* Estiliza linhas alternadas */
    .table-devolucao tbody tr:nth-child(odd) {
        background-color: #f9f9f9;
    }

    .table-devolucao tbody tr:hover {
        background-color: #f0f0f0;
    }

    select.form-control-select {
        height: 34px;
        padding: 6px 12px;
        font-size: 14px;
        line-height: 1.42857143;
        color: #555;
        background-color: #fff;
        background-image: none;
        border: 1px solid #ccc;
        border-radius: 4px;
    }
</style>
<p>Selecione os produtos que deseja devolver. NF-e nº <?= $dadosNFe->nNF ?>. Fornecedor: <?= $dadosNFe->xNome ?? $dadosNFe->xFant ?></p>
<div class="devolucao-container">
    <button type="button" class="btn btn-default btn-selecionar-todos" id="selecionar-todos" title="Selecionar/Deselecionar Todos">
        <i class="fa fa-check-square-o"></i> Selecionar Todos
    </button>
    <form>
        <table class="table table-devolucao">
            <thead>
                <tr class="alert alert-default">
                    <th class="col-checkbox"></th>
                    <th class="col-codigo"><b>CÓDIGO SISTEMA</b></th>
                    <th class="col-codigo"><b>CÓDIGO FORNECEDOR</b></th>
                    <th class="col-descricao"><b>DESCRIÇÃO</b></th>
                    <th class="col-quantidade"><b>QUANTIDADE A DEVOLVER</b></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($produtos as $key => $produto) : ?>
                    <tr>
                        <td class="col-checkbox">
                            <input type="checkbox" class="checkbox-devolucao" name="produtos[]" value="<?= $produto->prodnfeid ?>">
                        </td>
                        <td class="col-codigo"><?= $codigos[$key]['sistema'] ?? 'Não Vinculado' ?></td>
                        <td class="col-codigo"><?= $codigos[$key]['fornecedor'] ?? $produto->cProd ?></td>
                        <td class="col-descricao"><?= $produto->xProd ?></td>
                        <td class="col-quantidade">
                            <input type="number" class="input-quantidade" name="qtd[<?= $produto->prodnfeid ?>]"
                                value="<?= $produto->qtd ?>" min="1" max="<?= $produto->qtd ?>">
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>

        <div class="row">
            <div class="col-md-12 text-right">
                <div style="display: inline-flex; align-items: center; margin-right: 15px;">
                    <select class="form-control-select" id="tipoCodigo" name="tipoCodigo" style="width: 220px; margin-right: 5px;">
                        <option value="sistema">Usar código do sistema</option>
                        <option value="fornecedor">Usar código do fornecedor</option>
                    </select>
                    <i class="fa fa-info-circle" style="color: #337ab7; cursor: help;" title="Se o código do fornecedor não estiver disponível, será usado o código do sistema"></i>
                </div>
                <button type="button" class="btn btn-primary btn-devolucao" id="criar" title="Criar Devolução" style="vertical-align: middle;">
                    <i class="fa fa-arrow-up"></i> Criar Devolução
                </button>
            </div>
        </div>
    </form>
</div>

<script>
    $(document).ready(function() {
        // Funcionalidade para selecionar/deselecionar todos os produtos
        var todosEstaoSelecionados = false;

        $("#selecionar-todos").click(function() {
            todosEstaoSelecionados = !todosEstaoSelecionados;

            if (todosEstaoSelecionados) {
                // Seleciona todos os checkboxes
                $(".checkbox-devolucao").prop('checked', true);
                $(this).html('<i class="fa fa-square-o"></i> Deselecionar Todos');
            } else {
                // Desmarca todos os checkboxes
                $(".checkbox-devolucao").prop('checked', false);
                $(this).html('<i class="fa fa-check-square-o"></i> Selecionar Todos');
            }
        });

        // Verificação quando os checkboxes individuais são alterados
        $(document).on('change', '.checkbox-devolucao', function() {
            // Verifica se todos estão selecionados ou não
            var totalCheckboxes = $(".checkbox-devolucao").length;
            var totalChecked = $(".checkbox-devolucao:checked").length;

            if (totalChecked === totalCheckboxes) {
                todosEstaoSelecionados = true;
                $("#selecionar-todos").html('<i class="fa fa-square-o"></i> Deselecionar Todos');
            } else {
                todosEstaoSelecionados = false;
                $("#selecionar-todos").html('<i class="fa fa-check-square-o"></i> Selecionar Todos');
            }
        });

        $("#criar").click(function() {
            // Validar se pelo menos um produto foi selecionado
            if ($("input[name='produtos[]']:checked").length === 0) {
                toastr.warning('Selecione pelo menos um produto para devolução.');
                return false;
            }

            var tipoCodigo = $("#tipoCodigo").val();

            // Coletar dados dos produtos selecionados usando um único objeto
            var produtosParaDevolver = {};

            $("input[name='produtos[]']:checked").each(function() {
                var prodId = $(this).val();
                produtosParaDevolver[prodId] = $("input[name='qtd[" + prodId + "]']").val();
            });

            // Mostrar diálogo de carregamento
            var dialog = bootbox.dialog({
                title: 'Atenção!',
                message: '<p><i class="fa fa-spin fa-spinner"></i> Aguarde, estamos criando a devolução...</p>'
            });

            // Fazer requisição AJAX
            $.ajax({
                type: "GET",
                url: "<?= BACKEND ?>/_controller/_select/_ajax/cria_devolucao_select_ajax.php",
                data: {
                    nfe: "<?= $_GET['nfe'] ?>",
                    produtosDevolver: produtosParaDevolver,
                    tipoCodigo: tipoCodigo
                },
                dataType: "json",
                success: function(data) {
                    if (data.status == 'OK') {
                        dialog.modal('hide');
                        Carrega('_grid', 'nfe_grid.php', 'NF-E');
                        document.getElementById("alerterro").style.display = "none";
                        document.getElementById("alertsucesso").style.display = "block";
                        $("#sucesso").html(data.msg);
                        setTimeout(function() {
                            $("#alertsucesso").css("display", "none");
                        }, 3000);
                    } else {
                        dialog.modal('hide');
                        toastr.warning(data.msg);
                    }
                },
                error: function() {
                    dialog.modal('hide');
                    toastr.error('Erro ao processar a requisição.');
                }
            });
        });
    });
</script>