<?php
ob_start();
?>
<style>
    body {
        font-size: 12px;
    }

    h1, h2, h3, h4, h5, h6,
    .h1, .h2, .h3, .h4, .h5, .h6 {
        font-family: inherit;
        font-weight: 500;
        line-height: 1.1;
        color: inherit; }
    h1 small,
    h1 .small, h2 small,
    h2 .small, h3 small,
    h3 .small, h4 small,
    h4 .small, h5 small,
    h5 .small, h6 small,
    h6 .small,
    .h1 small,
    .h1 .small, .h2 small,
    .h2 .small, .h3 small,
    .h3 .small, .h4 small,
    .h4 .small, .h5 small,
    .h5 .small, .h6 small,
    .h6 .small {
        font-weight: normal;
        line-height: 1;
        color: #777777; }

    h1, .h1,
    h2, .h2,
    h3, .h3 {
        margin-top: 20px;
        margin-bottom: 10px; }
    h1 small,
    h1 .small, .h1 small,
    .h1 .small,
    h2 small,
    h2 .small, .h2 small,
    .h2 .small,
    h3 small,
    h3 .small, .h3 small,
    .h3 .small {
        font-size: 65%; }

    h4, .h4,
    h5, .h5,
    h6, .h6 {
        margin-top: 10px;
        margin-bottom: 10px; }
    h4 small,
    h4 .small, .h4 small,
    .h4 .small,
    h5 small,
    h5 .small, .h5 small,
    .h5 .small,
    h6 small,
    h6 .small, .h6 small,
    .h6 .small {
        font-size: 75%; }

    h1, .h1 {
        font-size: 36px; }

    h2, .h2 {
        font-size: 30px; }

    h3, .h3 {
        font-size: 24px; }

    h4, .h4 {
        font-size: 18px; }

    h5, .h5 {
        font-size: 14px; }

    h6, .h6 {
        font-size: 12px; }
    .text-center {
        text-align: center; }

    table {
        width: 100%;
        padding: 10px;
    }

    td {
        padding: 3px;
    }
    th {
        text-align: left;
    }
    /*.titulotr { border:  none};*/
    /*.titulotr { background: #000; border:1px black solid;};*/
    .table-bordered th,
    .table-bordered td {
        border: 1px solid #ddd !important; } 

    .full_table_list_titulo{border-collapse: collapse;}
    .full_table_list_titulo tr{border:1px black solid;}

    .full_table_list{border-collapse: collapse;}
    .full_table_list tr{border:1px black solid;}
    .full_table_list tr:nth-child(even) {background: #fff}
    .full_table_list tr:nth-child(odd) {background: #fff}  

    .tablecor {border:1px black solid; background: #eee}
    .titulotr {border:1px black solid; background: #F5F5F5}
</style>
<?php
require_once("../../../functions.php");
//
require_once "../../../_backend/_class/Conexao_class.php";
require_once "../../../_backend/_class/Crud_class.php";
require_once "../../../_backend/_class/cobranca_class.php";
require_once "../../../_backend/_class/parametros.php";
require_once "../../../_backend/_class/Emitente_class.php";

$logo = '' . FRONTEND . '/img/logomarca/' . $emitente->CNPJ . '/' . $emitente->logo . '';

$fichatecnica = $_GET['fichatecnica'];

function BuscaTipoVar($valor) {
    if ($valor == 'P') :
        return '% ';
    else :
        return 'R$ ';
    endif;
}

function BuscaProduto($valor) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'vendedor');
    $sql = "SELECT * from produtos where codigo = '$valor'";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

    return $dados;
}

function BuscaDescProd($valor) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'vendedor');
    $sql = "SELECT * from produtos where codigo = '$valor'";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

    return $dados->descricao;
}

function BuscaDescCat($valor) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'vendedor');
    $sql = "SELECT * from categorias where sigla = '$valor'";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

    return $dados->descricao;
}

function BuscaDescVar($valor) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'vendedor');
    $sql = "SELECT * from pcp_variavel where id = '$valor'";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

    return $dados->variaveldesc;
}

function BuscaDescProcesso($valor) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'vendedor');
    $sql = "SELECT * from pcp_processos where id = '$valor'";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

    return $dados->descricao;
}

function BuscaUN($valor) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'vendedor');
    $sql = "SELECT * from produtos where codigo = '$valor'";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

    return $dados->unidade;
}

$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'vendedor');
$sql = "SELECT * from pcp_fichatecnica where id = '$fichatecnica'";
$arrayParam = '';
$dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

$produto = BuscaProduto($dados->produto);

//require_once "cabecalho.php";
?>

<table class="table full_table_list_titulo">
    <tr> 
        <td colspan="7" align="center"> <?= $titulo ?> <br/>SOLICITAÇÃO MAT. PRIMA FICHA TÉCNICA Nº <?= $dados->id ?></td>
    </tr>
    <tr>
        <td rowspan="5" width="15%"><img src="<?= $logo ?>" style="max-height: 80px; max-width: 13%" alt=""/></td>
        <td width="10%"> <b> Produto: </b></td>
        <td colspan="3"><?= $produto->codigo . ' - ' . $produto->descricao ?></td>
        <td colspan="2"><b>Ref: </b> <?= $produto->ref ?></td>
    </tr>
   
</table>
<Br/>

<table class="table full_table_list_titulo table-bordered" style="border: 1px solid #6d6d6d; font-size: 11px;">
    <tr> 
        <td colspan="7" align="center"> <b>COMPOSIÇÃO </b></td>
    </tr>
    <tr style="border-bottom: 1px solid #000;">
        <td >PRODUTO</td>
        <td>QUANTIDADE</td>
        <td>CUSTO</td>
        <td>TOTAL</td>
    </tr>
    <?php
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'vendedor');
    $sql = "SELECT * from pcp_fichatecnica_composicao where fichatecnica = '$fichatecnica'";
    $arrayParam = '';
    $composicao = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

    $totalqtd = 0;
    $totalvr = 0;
    foreach ($composicao as $composicao) :

        if (floor($composicao->quantidade) != $composicao->quantidade) :
            $qtd = rtrim($composicao->quantidade, "0");
        else :
            $qtd = intval($composicao->quantidade);
        endif;

        $totalqtd = $totalqtd + $qtd;
        $totalvr = $totalvr + $composicao->total;
        ?>
        <tr> 
            <td><?= BuscaDescProd($composicao->insumo) ?></td>
            <td><?= $qtd ?> <?= BuscaUN($composicao->insumo) ?></td>
            <td>R$ <?= number_format($composicao->custo, 2, ',', ' ') ?></td>
            <td>R$ <?= number_format($composicao->total, 2, ',', ' ') ?></td>

        </tr>
        <?php
    endforeach;
    ?>

    <tr style="border-top: 1px solid #000;"> 
        <td align="right">TOTAIS</td>
        <td></td>
        <td></td>
        <td>R$ <?= number_format($totalvr, 2, ',', ' ') ?></td>

    </tr>
</table>
<br/>


<?php
require_once("../../_inc/mpdf/vendor/autoload.php");

// converte o conteudo para uft-8
$mpdf = new \Mpdf\Mpdf([
    'margin_top' => 5,
    'margin_left' => 5,
    'margin_right' => 5,
    'mirrorMargins' => true,
    'default_font_size' => 12,
        ]);
//$mpdf = new mPDF('','', 0, '', 15, 15, 16, 16, 9, 9, '');
$mpdf->keep_table_proportions = true;
$mpdf->allow_charset_conversion = true;
$footer = "<table width = \"1000\">
                   <tr>
                     <td style='font-size: 10px; bottom:-15px;' align=\"right\">Pag: {PAGENO} de {nb} / data impressão: " . date('d/m/Y H:i') . "</td>
                   </tr>
                 </table>";
$mpdf->SetHTMLFooter($footer);
$html = ob_get_clean();
$mpdf->WriteHTML($html);
// escreve definitivamente o conteudo no PDF
$mpdf->Output("romaneio.pdf", 'I');
// imprime

exit();
?>