<?php
require_once("../../../functions.php");
require_once "../../../_backend/_class/Conexao_class.php";
require_once "../../../_backend/_class/Crud_class.php";
require_once "../../../_backend/_class/parametros.php";
require_once "../../../_backend/_class/Emitente_class.php";

error_reporting(E_ALL);
ini_set('display_errors', 'On');
?>

<script>
    $(document).ready(function () {
        jQuery('body').on('keydown', 'input, select, textarea', function (e) {
            var self = $(this)
                    , form = self.parents('form:eq(0)')
                    , focusable
                    , next
                    ;
            if (e.keyCode == 13) {
                focusable = form.find('input,select,button,textarea').filter(':visible');
                next = focusable.eq(focusable.index(this) + 1);
                if (next.length) {
                    next.focus();
                    next.select();
                } else {
                    form.submit();
                }
                return false;
            }
        });
    });

    function filtra(campo) {
        var busca = $("#busca").val();
        var buscat = busca.replace(/ /gi, '-');
//        alert(buscat);
        var tipo = $("#tipo").val();
        Carrega('_view', 'alteracao_tributacao_lista.php?tipo=' + tipo + '&campo=' + campo + '&busca=' + buscat + '', 'Alteração de tributação');
    }

    function Limpafiltra() {
        Carrega('_view', 'alteracao_tributacao_lista.php', 'Alteração de tributação');
    }

    function AlteraTrib(produto, valor, campo) {

//        alert(valor);
        $.ajax({
            type: "POST",
            url: "_backend/_controller/_update/tabela_tributacao_update.php",
            data: {
                produto: produto,
                valor: valor,
                campo: campo
            },
            dataType: "json",
// função para de sucesso
            success: function (data) {
//                alert(data);

            }
        }); //termina o jquery

    }

    function Altera(produto, valor, campo) {

//        alert(valor);
        $.ajax({
            type: "POST",
            url: "_backend/_controller/_update/tabela_produto_update.php",
            data: {
                produto: produto,
                valor: valor,
                campo: campo
            },
            dataType: "json",
// função para de sucesso
            success: function (data) {
//                alert(data);

            }
        }); //termina o jquery

    }


    function BuscaCest(id, ncm) {

        if (ncm === '') {
            return false;
        }
//        alert(ncm);
        $.ajax({
            type: "POST",
            url: "_backend/_controller/_select/_ajax/cest_ncm_select_ajax.php",
            data: {
                ncm: ncm
            },
            dataType: "json",
// função para de sucesso
            success: function (data) {
//                alert(data.cest);
                if (data.cest !== null) {
                    $("#" + id + "").val(data.cest);
                    AlteraTrib(id, data.cest, 'cest');
                } else {
                    toastr.warning('Cest não encontrado');
                }
            }
        }); //termina o jquery

    }


</script>

<style>
    input {
        border : 1px solid #bbb;
    }
    select {
        border : 1px solid #bbb;
        border-radius: 0px;
        height: 30px;
        padding: 0;
        outline: none;
    }
</style>

<?php

function retornaCampo($valor) {
    switch ($valor) {
        case 'produtos.cst':
            return 'CST';
            break;
        case 'produtos.descricao':
            return 'DESCRIÇÃO';
            break;
        case 'produtos.origem':
            return 'ORIGEM';
            break;
        case 'produtos.codigo':
            return 'CÓDIGO';
            break;
        case 'produtos.ref':
            return 'REFERÊNCIA';
            break;
        case 'tributacaoprodutos.cfop':
            return 'CFOP';
            break;
        case 'tributacaoprodutos.ncm':
            return 'NCM';
            break;
        case 'tributacaoprodutos.cest':
            return 'CEST';
            break;
        case 'produtos.cstipi':
            return 'IPI';
            break;
        case 'produtos.cstpis':
            return 'PIS';
            break;
        case 'produtos.cstcofins':
            return 'COFINS';
            break;
        case 'tributacaoprodutos.pICMS':
            return 'ALIQ. ICMS';
            break;
        case 'tributacaoprodutos.pICMSST':
            return 'ALIQ. ICMS ST';
            break;
    }
}
?>
<form>    
    <table class="table table-condesed table-striped">
        <thead>
            <tr>
                <td colspan="4"><input type="text" id="busca" style="height: 30px; width: 100%"></td>
                <td colspan="2">
                    <select id="tipo" style="height: 30px; width: 100%">
                        <option></option>
                        <option value="C">Contenha</option>
                        <option value="I">Igual</option>
                    </select>
                </td>
                <td colspan="2">
                    <select id="campo" onchange="filtra(this.value)" style="height: 30px; width: 100%">
                        <option></option>
                        <option value="produtos.descricao">DESCRIÇÃO</option>
                        <option value="produtos.codigo">CÓDIGO</option>
                        <option value="produtos.ref">REFERÊNCIA</option>
                        <option value="produtos.origem">ORIGEM</option>
                        <option value="tributacaoprodutos.cst">CST</option>
                        <option value="tributacaoprodutos.cfop">CFOP</option>
                        <option value="tributacaoprodutos.ncm">NCM</option>
                        <option value="tributacaoprodutos.cest">CEST</option>
                        <option value="produtos.cstipi">IPI</option>
                        <option value="produtos.cstpis">PIS</option>
                        <option value="produtos.cstcofins">COFINS</option>
                        <option value="tributacaoprodutos.pICMS">ALIQ. ICMS</option>
                        <option value="tributacaoprodutos.pICMSST">ALIQ. ICMS ST</option>
                    </select>
                </td>
            </tr>
            <?php
            if (isset($_GET['campo'])) :
                ?>
                <tr>
                    <td colspan="7">
                        <?php
                        if (isset($_GET['campo'])) :
                            $busca = str_replace('-', ' ', $_GET['busca']);
                            echo '<b>PESQUISANDO ' . retornaCampo($_GET['campo']) . ' ' . $busca . '</b>';
                        endif;
                        ?>
                    </td>
                    <td colspan="3">
                        <a href="javascript::" onclick="Limpafiltra()">Limpar Pesquisa</a> 
                    </td>
                </tr>
                <?php
            endif;
            ?>
            <tr class="alert alert-default">
                <td><b>CÓDIGO</b></td>
                <td><b>REF.</b></td>
                <td><b>DESCRIÇÃO</b></td>
                <td><b>ORIGEM</b></td>
                <td><b>CST</b></td>
                <td><b>CFOP</b></td>
                <td><b>CFOP FORA</b></td>
                <td><b>NCM</b></td>
                <td><b>CEST</b></td>
                <td><b></b></td>
                <td><b>IPI</b></td>
                <td><b>PIS</b></td>
                <td><b>COFINS</b></td>
                <td><b>ICMS</b></td>
                <td><b>ICMS ST</b></td>

            </tr>



        </thead>

        <?php
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'tabelapreco');
        $sql = "SELECT produtos.codigo, produtos.origem, produtos.descricao, produtos.ref, tributacaoprodutos.cst, produtos.fiscal, tributacaoprodutos.cfop,
            tributacaoprodutos.cstipi, tributacaoprodutos.cstcofins, tributacaoprodutos.cstpis, tributacaoprodutos.cfopuf, tributacaoprodutos.empresa,
            tributacaoprodutos.ncm, tributacaoprodutos.cest, tributacaoprodutos.pICMSST, tributacaoprodutos.pICMS from produtos 
left join tributacaoprodutos on tributacaoprodutos.produto = produtos.codigo";
        if (isset($_GET['campo'])) :
            $busca = str_replace('-', ' ', $_GET['busca']);
            if ($_GET['tipo'] == 'C') :
                $sql .= " WHERE " . $_GET['campo'] . " like '%" . $busca . "%'";
            else :
                $sql .= " WHERE " . $_GET['campo'] . " = '" . $_GET['busca'] . "'";
            endif;

            if ($parametros->separaprodutos == 'S') :
                $sql .= " AND fiscal = '$parametros->fiscal'";
            endif;
        else :
            if ($parametros->separaprodutos == 'S') :
                $sql .= " WHERE fiscal = '$parametros->fiscal'";
            endif;
        endif;

        $sql .= " AND empresa = '" . $_SESSION['Empresa'] . "'";

        $sql .= " ORDER BY produtos.codigo";
        
//        ECHO $sql;
        $arrayParam = '';
        $itens = $crud->getSQLGeneric($sql, $arrayParam, true);

        foreach ($itens as $itens) :
//            $totalqtd = $totalqtd + $itens->qtd;
            ?>
            <tr>
                <td><?= $itens->codigo ?></td>
                <td><?= $itens->ref ?></td>
                <td><?= $itens->descricao ?></td>
                <td><input type="text" size="4" class="input" onblur="AlteraTrib('<?= $itens->origem ?>', this.value, 'origem')" value="<?= $itens->origem ?>"></td>
                <td><input type="text" size="4" class="input" onblur="AlteraTrib('<?= $itens->codigo ?>', this.value, 'cst')" value="<?= $itens->cst ?>"></td>
                <td><input type="text" size="7" class="input" onblur="AlteraTrib('<?= $itens->codigo ?>', this.value, 'cfop')" value="<?= $itens->cfop ?>"></td>
                <td><input type="text" size="7" class="input" onblur="AlteraTrib('<?= $itens->codigo ?>', this.value, 'cfopuf')" value="<?= $itens->cfopuf ?>"></td>
                <td><input type="text" size="8"  class="input" id="ncm<?= $itens->codigo ?>" onblur="AlteraTrib('<?= $itens->codigo ?>', this.value, 'ncm')" value="<?= $itens->ncm ?>"></td>
                <td><input type="text" size="8" class="input" onblur="AlteraTrib('<?= $itens->codigo ?>', this.value, 'cest')" id="<?= $itens->codigo ?>" value="<?= $itens->cest ?>"></td>
                <td><a href="javascript::" onclick="BuscaCest('<?= $itens->codigo ?>', '' + $('#ncm<?= $itens->codigo ?>').val() + '')">Buscar Cest</a></td>
                <td><input type="text" size="5" class="input" onblur="AlteraTrib('<?= $itens->codigo ?>', this.value, 'cstipi')" value="<?= $itens->cstipi ?>"></td>
                <td><input type="text" size="5" class="input" onblur="AlteraTrib('<?= $itens->codigo ?>', this.value, 'cstpis')" value="<?= $itens->cstpis ?>"></td>
                <td><input type="text" size="5" class="input" onblur="AlteraTrib('<?= $itens->codigo ?>', this.value, 'cstcofins')" value="<?= $itens->cstcofins ?>"></td>
                <td><input type="text" size="5" class="input" onblur="AlteraTrib('<?= $itens->codigo ?>', this.value, 'pICMS')" value="<?= $itens->pICMS ?>"></td>
                <td><input type="text" size="5" class="input" onblur="AlteraTrib('<?= $itens->codigo ?>', this.value, 'pICMSST')" value="<?= $itens->pICMSST ?>"></td>

            </tr>
            <?php
        endforeach;
        ?>
    </table>
</form>