<?php
date_default_timezone_set("Brazil/East");
require_once "../../_class/Conexao_class.php";
require_once "../../_class/Crud_class.php";

function BuscaEmpresa($valor) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'estoqueprodutos');
    $sql = "SELECT * from emitente where emitenteid = '$valor'";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, false);

    return $dados->xNome;
}

function BuscaVendedor($valor) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'estoqueprodutos');
    $sql = "SELECT * from vendedor where vendedorid = '$valor'";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, false);

    return $dados->xNome;
}

function BuscaUsuario($valor) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'estoqueprodutos');
    $sql = "SELECT * from usuario where usuarioid = '$valor'";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, false);

    return $dados->usuarionome;
}

function descobrirPorcentagem($parte, $total) {
    if ($total == 0) {
        return 0; // Evita divisão por zero
    }
    return number_format(($parte / $total) * 100, 2, '.', ''); // Formata com 2 casas decimais
}

$inicio1 = parseDate($_POST['datai'], "Y-m-d");
$fim1 = parseDate($_POST['dataf'], "Y-m-d");

$empresabusca = '';

$empresa = $_POST['empresa'][0];
if (count($_POST['empresa']) > 1) :
    $empresa = 'T';
endif;

for ($index = 0; $index < count($_POST['empresa']); $index++) :
    $empresabusca .= $_POST['empresa'][$index];
    $empresabusca .= ',';
endfor;
$empresabusca = substr($empresabusca, 0, -1);

$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'tabela');
$sql = 'SELECT
    COUNT(*) AS total_vendas
FROM
    movimentacao
WHERE
    (
        (
            STR_TO_DATE(movimentacao.data, "%d/%m/%Y") BETWEEN "' . $inicio1 . '" AND "' . $fim1 . '"
        ) OR(
            STR_TO_DATE(
                movimentacao.datapagamento,
                "%d/%m/%Y"
            ) BETWEEN "' . $inicio1 . '" AND "' . $fim1 . '"
        )
    )';
$sql .= "AND cliente IS NOT NULL AND movimentacao.empresa IN($empresabusca)";

if (!empty($_POST['vendedor'])) :
    $sql .= ' AND vendedor = "' . $_POST['vendedor'] . '" ';
endif;

if (!empty($_POST['usuario'])) :
    $sql .= ' AND usuario = "' . $_POST['usuario'] . '" ';
endif;
$arrayParam = '  ';
$dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

$totalvendas = $dados->total_vendas;

$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'tabela');
$sql = 'SELECT
    COUNT(*) AS total_vendas
FROM
    movimentacao
WHERE
    (
        (
            STR_TO_DATE(movimentacao.data, "%d/%m/%Y") BETWEEN "' . $inicio1 . '" AND "' . $fim1 . '"
        ) OR(
            STR_TO_DATE(
                movimentacao.datapagamento,
                "%d/%m/%Y"
            ) BETWEEN "' . $inicio1 . '" AND "' . $fim1 . '"
        )
    ) AND cliente = 1';
$sql .= " AND movimentacao.empresa IN($empresabusca)";

if (!empty($_POST['vendedor'])) :
    $sql .= ' AND vendedor = "' . $_POST['vendedor'] . '" ';
endif;

if (!empty($_POST['usuario'])) :
    $sql .= ' AND usuario = "' . $_POST['usuario'] . '" ';
endif;

$arrayParam = '  ';
$dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

$totalvendasConsumidor = $dados->total_vendas;

$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'tabela');
$sql = 'SELECT
    COUNT(*) AS total_vendas
FROM
    movimentacao
WHERE
    (
        (
            STR_TO_DATE(movimentacao.data, "%d/%m/%Y") BETWEEN "' . $inicio1 . '" AND "' . $fim1 . '"
        ) OR(
            STR_TO_DATE(
                movimentacao.datapagamento,
                "%d/%m/%Y"
            ) BETWEEN "' . $inicio1 . '" AND "' . $fim1 . '"
        )
    ) AND cliente <> 1';
$sql .= " AND movimentacao.empresa IN($empresabusca)";

if (!empty($_POST['vendedor'])) :
    $sql .= ' AND vendedor = "' . $_POST['vendedor'] . '" ';
endif;

if (!empty($_POST['usuario'])) :
    $sql .= ' AND usuario = "' . $_POST['usuario'] . '" ';
endif;

$arrayParam = '  ';
$dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

$totalvendascliente = $dados->total_vendas;

$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'tabela');
$sql = 'SELECT
    COUNT(*) AS total_vendas
FROM
    movimentacao m
JOIN 
    cliente c ON m.cliente = c.clienteid
WHERE
    (
        (
            STR_TO_DATE(m.data, "%d/%m/%Y") BETWEEN "' . $inicio1 . '" AND "' . $fim1 . '"
        ) OR(
            STR_TO_DATE(
                m.datapagamento,
                "%d/%m/%Y"
            ) BETWEEN "' . $inicio1 . '" AND "' . $fim1 . '"
        )
    ) AND c.whatsapp IS NOT NULL AND c.whatsapp <> "" AND m.cliente <> 1';
$sql .= " AND m.empresa IN($empresabusca) ";

if (!empty($_POST['vendedor'])) :
    $sql .= ' AND m.vendedor = "' . $_POST['vendedor'] . '" ';
endif;

if (!empty($_POST['usuario'])) :
    $sql .= ' AND m.usuario = "' . $_POST['usuario'] . '" ';
endif;
//echo $sql;

$arrayParam = '  ';
$dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

$totalvendascomwpp = $dados->total_vendas;

$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'tabela');
$sql = 'SELECT
    COUNT(*) AS total_vendas
FROM
    movimentacao m
JOIN 
    cliente c ON m.cliente = c.clienteid
WHERE
    (
        (
            STR_TO_DATE(m.data, "%d/%m/%Y") BETWEEN "' . $inicio1 . '" AND "' . $fim1 . '"
        ) OR(
            STR_TO_DATE(
                m.datapagamento,
                "%d/%m/%Y"
            ) BETWEEN "' . $inicio1 . '" AND "' . $fim1 . '"
        )
    ) AND c.whatsapp = "" AND m.cliente <> 1';
$sql .= " AND m.empresa IN($empresabusca)";

if (!empty($_POST['vendedor'])) :
    $sql .= ' AND m.vendedor = "' . $_POST['vendedor'] . '" ';
endif;

if (!empty($_POST['usuario'])) :
    $sql .= ' AND m.usuario = "' . $_POST['usuario'] . '" ';
endif;
//echo $sql;

$arrayParam = '  ';
$dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

$totalvendassemwpp = $dados->total_vendas;

//echo $totalvendas;
//echo '<br/>';
//echo $totalvendasConsumidor;
//echo '<br/>';
//echo $totalvendascliente;
//echo '<br/>';
//echo $totalvendassemwpp;
//echo '<br/>';
//echo $totalvendascomwpp;
?>

<html>
    <head>
        <script src="https://cdn.anychart.com/releases/v8/js/anychart-base.min.js"></script>
        <script src="https://cdn.anychart.com/releases/v8/js/anychart-ui.min.js"></script>
        <script src="https://cdn.anychart.com/releases/v8/js/anychart-exports.min.js"></script>
        <link href="https://cdn.anychart.com/releases/v8/css/anychart-ui.min.css" type="text/css" rel="stylesheet">
        <link href="https://cdn.anychart.com/releases/v8/fonts/css/anychart-font.min.css" type="text/css" rel="stylesheet">
        <style type="text/css">

            html,
            body,
            #container {
                width: 100%;
                height: 100%;
                margin: 0;
                padding: 0;
            }

            table {
                border-collapse: collapse;
            }
            thead {
                vertical-align: bottom;
                text-align: center;
                font-weight: bold;
            }
            tfoot {
                text-align: center;
                font-weight: bold;
            }
            th {
                text-align: left;
                padding-left: 0.35em;
                padding-right: 0.35em;
                padding-top: 0.35em;
                padding-bottom: 0.35em;
                vertical-align: top;
            }
            td {
                padding-left: 0.35em;
                padding-right: 0.35em;
                padding-top: 0.35em;
                padding-bottom: 0.35em;
                vertical-align: top;
            }


        </style>
    </head>
    <body>

        <?php
        if ($_POST['gerar'] !== 'HTML') :
            ?>


            <div align="center">
                VENDAS POR CADASTROS
                <Br/> 
                PERÍODO: <?= $_POST['datai'] ?> À <?= $_POST['dataf'] ?>

                <?php
                if ($empresa !== 'T') :
                    ?>
                    <br/>
                    FILIAL : <?= BuscaEmpresa($_POST['empresa'][0]) ?>
                     <br/>
                    <?php
                else :
                    ?>
                    <br/>
                    FILIAL : SELECIONADAS
                    <br/>
                <?php
                endif;

                if (!empty($_POST['vendedor'])) :
                    echo 'VENDEDOR: ' . BuscaVendedor($_POST['vendedor']) . '';
                    echo ' <br/>';
                endif;

                if (!empty($_POST['usuario'])) :
                    echo 'USUÁRIO: ' . BuscaUsuario($_POST['usuario']) . '';
                    echo ' <br/>';
                endif;
                ?>

            </div>

            <table class="table table-condensed text-center" style="font-size: 12px; width: 100%; text-align: left">
                <tr>
                    <td><b>DESCRIÇÃO</b></td>
                    <td><b>TOTAL</b></td>
                    <td><b>%</b></td>
                </tr>
                <tr>
                    <td style="border-bottom: 1px dashed #dee2e6;">TOTAL DE VENDAS</td>
                    <td style="border-bottom: 1px dashed #dee2e6;"><?= $totalvendas ?></td>
                    <td style="border-bottom: 1px dashed #dee2e6;"></td>
                </tr>
                <tr>
                    <td style="border-bottom: 1px dashed #dee2e6;">TOTAL DE VENDAS COM CONSUMIDOR FINAL</td>
                    <td style="border-bottom: 1px dashed #dee2e6;"><?= $totalvendasConsumidor ?></td>
                    <td style="border-bottom: 1px dashed #dee2e6;"><?= descobrirPorcentagem($totalvendasConsumidor, $totalvendas) ?>%</td>
                </tr>
                <tr>
                    <td style="border-bottom: 1px dashed #dee2e6;">TOTAL DE VENDAS COM CLIENTE CADASTRADO</td>
                    <td style="border-bottom: 1px dashed #dee2e6;"><?= $totalvendascliente ?></td>
                    <td style="border-bottom: 1px dashed #dee2e6;"><?= descobrirPorcentagem($totalvendascliente, $totalvendas) ?>%</td>
                </tr>
                <tr>
                    <td style="border-bottom: 1px dashed #dee2e6;">TOTAL DE VENDAS COM WHATSAPP CADASTRADO</td>
                    <td style="border-bottom: 1px dashed #dee2e6;"><?= $totalvendascomwpp ?></td>
                    <td style="border-bottom: 1px dashed #dee2e6;"><?= descobrirPorcentagem($totalvendascomwpp, $totalvendas) ?>%</td>
                </tr>
                <tr>
                    <td style="border-bottom: 1px dashed #dee2e6;">TOTAL DE VENDAS SEM WHATSAPP CADASTRADO</td>
                    <td style="border-bottom: 1px dashed #dee2e6;"><?= $totalvendassemwpp ?></td>
                    <td style="border-bottom: 1px dashed #dee2e6;"><?= descobrirPorcentagem($totalvendassemwpp, $totalvendas) ?>%</td>
                </tr>

            </table>


            <?php
        else :
            ?>
            <div id="container"></div>


            <script>

                anychart.onDocumentReady(function () {
                    // create pie chart with passed data
                    var chart = anychart.pie([
                        ['Vendas sem clientes (<?= $totalvendasConsumidor ?>)', <?= $totalvendasConsumidor ?>],
                        ['Clientes com Whatsapp (<?= $totalvendascomwpp ?>)', <?= $totalvendascomwpp ?>],
                        ['Clientes Sem Whatsapp (<?= $totalvendassemwpp ?>)', <?= $totalvendassemwpp ?>]
                    ]);

                    // set chart title text settings
                    chart
                            .title('Gráfico Vendas por clientes')
                            // set chart radius
                            .radius('43%')
                            // create empty area in pie chart
                            .innerRadius('30%');

                    // set container id for the chart
                    chart.container('container');
                    // initiate chart drawing
                    chart.draw();
                });

            </script>
        <?php
        endif;
        ?>
    </body>
</html>

<?php
if ($_POST['gerar'] == 'PDF') :
    ini_set("pcre.backtrack_limit", "500000000000000");
    require_once("../../_inc/mpdf/vendor/autoload.php");
    $mpdf = new \Mpdf\Mpdf([
        'margin_top' => 5,
        'margin_left' => 5,
        'margin_right' => 5,
        'mirrorMargins' => true,
        'default_font_size' => 12
    ]);
    $mpdf->keep_table_proportions = true;
    $mpdf->allow_charset_conversion = true;
    $footer = "<table width = \"1000\">
                   <tr>
                     <td style='font-size: 10px; bottom:-15px;' align=\"right\">Pag: {PAGENO} de {nb} " . date('d/m/Y') . "</td>
                   </tr>
                 </table>";
    $mpdf->SetHTMLFooter($footer);
    $html = ob_get_clean();
    $mpdf->SetTitle('Estoque');
    $mpdf->WriteHTML($html);
    $mpdf->Output();
// imprime

    exit();
elseif ($_POST['gerar'] == 'EXCEL') :
    $file = 'TotalVendasCadastros.xls';
    header("Content-type: application/x-msexcel");
    header("Content-Disposition: attachment; filename=\"{$file}\"");
    header("Content-Description: PHP Generated Data");
else :
    echo '';
endif;
?>