<?php
ob_start();
date_default_timezone_set("Brazil/East");
require_once("../../../functions.php");
//
require_once "../../../_backend/_class/Conexao_class.php";
require_once "../../../_backend/_class/Crud_class.php";
require_once "../../../_backend/_class/parametros.php";

//error_reporting(E_ALL);
//ini_set('display_errors', 'On');

function BuscaFornecedor($valor) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'estoqueprodutos');
    $sql = "SELECT fornecedorid, xNome from fornecedor where fornecedorid = '$valor'";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, false);

    return $dados;
}

function Produto($produto) {
    static $cache = [];
    if (!isset($cache[$produto])) {
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'usuario');
        $sql = "SELECT codigo, descricao from produtos where codigo = '" . $produto . "' ";
        $arrayParam = '';
        $vendedor = $crud->getSQLGeneric($sql, $arrayParam, false);

        $cache[$produto] = $vendedor->descricao;
    }
    return $cache[$produto];
}

$inicio1 = $_POST['datai'];
$fim1 = $_POST['dataf'];
$fornecedor = $_POST['fornecedor'];
$produto = $_POST['produtos'];
$dias = $_POST['dias'];
$empresabusca = '';

$empresa = $_POST['empresa'][0];
if (count($_POST['empresa']) > 1) :
    $empresa = 'T';
endif;

for ($index = 0; $index < count($_POST['empresa']); $index++) :
    $empresabusca .= $_POST['empresa'][$index];
    $empresabusca .= ',';

    $sum .= 'ep.qtd' . $_POST['empresa'][$index] . ' + ';
endfor;

$empresabusca = substr($empresabusca, 0, -1);
$sum = substr($sum, 0, -2);
//print_r($_POST);

$inicio1 = parseDate($_POST['datai'], "Y-m-d");
$fim1 = parseDate($_POST['dataf'], "Y-m-d");

$mine = $_POST['min'] / 100;
$maxe = $_POST['max'] / 100;

$data1 = new DateTime($inicio1);
$data2 = new DateTime($fim1);

$diferenca = $data1->diff($data2);

//echo 'dif:'. $diferenca->days;

$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'itmovimentacao');
$sql = "DROP VIEW vw_produtos_compra_sugerida";
$retorno = $crud->Sql($sql);

$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'itmovimentacao');
$sql = "TRUNCATE temp_sugestaocompra";
$retorno = $crud->Sql($sql);

$sql = "CREATE VIEW vw_produtos_compra_sugerida AS
SELECT 
    p.codigo AS CodigoProduto,
    ep.codproduto AS codigoGeral,
    ep.var1, 
    ep.produto,
    ep.var2,
    ep.ordem1, 
    ep.ordem2,
    p.descricao AS DescricaoProduto,
    $sum AS EstoqueAtual,   
    COALESCE(vd.qtd_vendida_30dias, 0) AS PrevisaoVendas30Dias,
    (SELECT AVG(itm.quantidade) 
     FROM itmovimentacao itm 
     JOIN movimentacao mov ON itm.documento = mov.documento 
     WHERE itm.produto = ep.codproduto 
       AND STR_TO_DATE(mov.data, '%d/%m/%Y') >= NOW() - INTERVAL $diferenca->days DAY) AS MediaMovelVendas,
    COALESCE(vd.qtd_vendida_30dias, 0) * $mine AS EstoqueMinimo, 
    COALESCE(vd.qtd_vendida_30dias, 0) * $maxe AS EstoqueMaximo, 
    CASE 
        WHEN COALESCE(vd.qtd_vendida_30dias, 0) > ($sum) THEN 
            GREATEST(COALESCE(vd.qtd_vendida_30dias, 0) - ($sum), 
                      COALESCE(vd.qtd_vendida_30dias, 0) * 0.3 - ($sum))
        ELSE 0
    END AS QuantidadeSugeridaCompra
FROM 
    produtos p
JOIN 
    estoqueprodutos ep ON p.codigo = ep.produto
LEFT JOIN (
    SELECT 
        itm.produto AS codproduto,
        SUM(itm.quantidade) AS qtd_vendida_30dias
    FROM 
        itmovimentacao itm
    JOIN 
        movimentacao mov ON itm.documento = mov.documento
    WHERE 
        STR_TO_DATE(mov.data, '%d/%m/%Y') >= NOW() - INTERVAL $dias DAY
        AND mov.empresa IN($empresabusca)
    GROUP BY 
        itm.produto
) vd ON ep.codproduto = vd.codproduto";

if (empty($fornecedor)) :
    $sql .= "
WHERE 
    p.codigo = '$produto'  
    GROUP BY  
    ep.estoqueprodutosid
     ORDER BY
        ep.produto, ep.ordem1, ep.ordem2, ep.var1, ep.var2, `QuantidadeSugeridaCompra`  ASC;
";
else :
    $sql .= "
WHERE 
    p.fornecedor = '$fornecedor'  
    GROUP BY  
    ep.estoqueprodutosid
     ORDER BY
        ep.produto, ep.ordem1, ep.ordem2, ep.var1, ep.var2, `QuantidadeSugeridaCompra`  ASC;
";
endif;

//echo $sql;
$arrayParam = '';
$retorno1 = $crud->Sql($sql);

$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'vw_produtos_compra_sugerida');
$sql = "SELECT * FROM vw_produtos_compra_sugerida";
$arrayParam = '';
$dadosit = $crud->getSQLGeneric($sql, $arrayParam, true);

foreach ($dadosit as $value) :
    $codigoProduto = $value->CodigoProduto;
    $var1 = $value->var1;
    $var2 = $value->var2;
    $quantidadeSugerida = $value->QuantidadeSugeridaCompra;

endforeach;
//
//
foreach ($dadosit as $value) :
    if ($value->QuantidadeSugeridaCompra > 0) :
        $exibe = 'S';
    else :
        $exibe = 'N';
    endif;

    if ($_POST['exibirzero'] == 'S') :
        $exibe = 'S';
    endif;

    if ($exibe === 'S') :
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'temp_sugestaocompra');
        if ($value->var2 == '') :
            $sql = "SELECT * FROM temp_sugestaocompra WHERE produto = '$value->CodigoProduto' ";
        else :
            $sql = "SELECT * FROM temp_sugestaocompra WHERE produto = '$value->CodigoProduto' and var1 = '$value->var1'";
        endif;
        $arrayParam = '';
        $dadosit = $crud->getSQLGeneric($sql, $arrayParam, true);

        $totalregistro = count($dadosit);
        if ($totalregistro > 0) :
            if ($value->var2 == '') :
                $variacoes = $dadosit[0]->sugestao . '|' . $value->var1 . ':' . $value->QuantidadeSugeridaCompra;
                $min = $dadosit[0]->min . '|' . $value->var1 . ':' . $value->EstoqueMinimo;
                $max = $dadosit[0]->max . '|' . $value->var1 . ':' . $value->EstoqueMaximo;
                $estoque = $dadosit[0]->estoqueatual . '|' . $value->var1 . ':' . $value->EstoqueAtual;
            else :
                $variacoes = $dadosit[0]->sugestao . '|' . $value->var2 . ':' . $value->QuantidadeSugeridaCompra;
                $min = $dadosit[0]->min . '|' . $value->var2 . ':' . $value->EstoqueMinimo;
                $max = $dadosit[0]->max . '|' . $value->var2 . ':' . $value->EstoqueMaximo;
                $estoque = $dadosit[0]->estoqueatual . '|' . $value->var2 . ':' . $value->EstoqueAtual;
            endif;
            $sql = "UPDATE temp_sugestaocompra SET sugestao = '$variacoes', min = '$min', max = '$max', estoqueatual = '$estoque' where id = '" . $dadosit[0]->id . "'";
            $insert = $crud->Sql($sql);
        else :
            if ($value->var2 == '') :
                $var = '';
                $variacoes = $value->var1 . ':' . $value->QuantidadeSugeridaCompra;
                $min = $value->var1 . ':' . $value->EstoqueMinimo;
                $max = $value->var1 . ':' . $value->EstoqueMaximo;
                $estoque = $value->var1 . ':' . $value->EstoqueAtual;
            else :
                $var = $value->var1;
                $variacoes = $value->var2 . ':' . $value->QuantidadeSugeridaCompra;
                $min = $value->var2 . ':' . $value->EstoqueMinimo;
                $max = $value->var2 . ':' . $value->EstoqueMaximo;
                $estoque = $value->var2 . ':' . $value->EstoqueAtual;
            endif;

            $sql = "INSERT INTO temp_sugestaocompra(produto, ref, descricao, var1, sugestao, min, max, estoqueatual)
                VALUES ('$value->CodigoProduto', '', '$value->DescricaoProduto', '$var', '$variacoes', '$min', '$max', '$estoque')
                ";
            $insert = $crud->Sql($sql);
        endif;
    endif;

endforeach;
?>
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <title> Relatório </title>
        <style>
            body {
                font-size: 10px;
            }
            .spacer {
               border-bottom: 1px dashed #dee2e6;
            }


            h1, h2, h3, h4, h5, h6,
            .h1, .h2, .h3, .h4, .h5, .h6 {
                font-family: inherit;
                font-weight: 500;
                line-height: 1.1;
                color: inherit;
            }
            h1 small,
            h1 .small, h2 small,
            h2 .small, h3 small,
            h3 .small, h4 small,
            h4 .small, h5 small,
            h5 .small, h6 small,
            h6 .small,
            .h1 small,
            .h1 .small, .h2 small,
            .h2 .small, .h3 small,
            .h3 .small, .h4 small,
            .h4 .small, .h5 small,
            .h5 .small, .h6 small,
            .h6 .small {
                font-weight: normal;
                line-height: 1;
                color: #777777;
            }

            h1, .h1,
            h2, .h2,
            h3, .h3 {
                margin-top: 20px;
                margin-bottom: 10px;
            }
            h1 small,
            h1 .small, .h1 small,
            .h1 .small,
            h2 small,
            h2 .small, .h2 small,
            .h2 .small,
            h3 small,
            h3 .small, .h3 small,
            .h3 .small {
                font-size: 65%;
            }

            h4, .h4,
            h5, .h5,
            h6, .h6 {
                margin-top: 10px;
                margin-bottom: 10px;
            }
            h4 small,
            h4 .small, .h4 small,
            .h4 .small,
            h5 small,
            h5 .small, .h5 small,
            .h5 .small,
            h6 small,
            h6 .small, .h6 small,
            .h6 .small {
                font-size: 75%;
            }

            h1, .h1 {
                font-size: 36px;
            }

            h2, .h2 {
                font-size: 30px;
            }

            h3, .h3 {
                font-size: 24px;
            }

            h4, .h4 {
                font-size: 18px;
            }

            h5, .h5 {
                font-size: 14px;
            }

            h6, .h6 {
                font-size: 12px;
            }
            .text-center {
                text-align: center;
            }

            table {
                width: 100%;
                padding: 10px;
            }

            td {
                padding: 3px;
            }
            th {
                text-align: left;
            }
            /*.titulotr { border:  none};*/
            /*.titulotr { background: #000; border:1px black solid;};*/
            .table-bordered th,
            .table-bordered td {
                border: 1px solid #000 !important;
            }

            .full_table_list_titulo{
                border-collapse: collapse;
            }
            .full_table_list_titulo tr{
                border:1px black solid;
            }

            .full_table_list{
                border-collapse: collapse;
            }
            .full_table_list tr{
                border:1px black solid;
            }
            .full_table_list tr:nth-child(even) {
                background: #fff
            }
            .full_table_list tr:nth-child(odd) {
                background: #fff
            }

            .tablecor {
                border:1px black solid;
                background: #eee
            }
            .titulotr {
                border:1px black solid;
                background: #F5F5F5
            }

        </style>

    </head>
    <body>

        <div align="center" style="font-size: 12px;">
            <b>Sugestão de Compras</b> <br/>
            <?= $_POST['datai'] ?> a <?= $_POST['dataf'] ?>

            <br/>
            Sugestão para os próximos: <?= $dias ?> dias;
            <?php
            if (!empty($_POST['fornecedor'])) :
                $fornecedor = BuscaFornecedor($_POST['fornecedor']);
                ?>
                <br/>
                <?= $fornecedor->fornecedorid ?> - <?= $fornecedor->xNome ?>
                <?php
            endif;
            ?>

        </div>


        <table class="table table-striped table-condensed full_table_list" style='font-size: 10px; '>
            <tr style="background-color: #dee2e6;">
                <td><b>Ref.</b></td>
                <td><b>Produto</b></td>
                <td><b>Var. 1</b></td>
                <td colspan="12"><b>Quantidade</b></td>
                <td><b>Qtd. Total</b></td>
            </tr>
            <?php
            $pdo = Conexao::getInstance();
            $crud = Crud::getInstance($pdo, 'temp_romaneio');
            $sql = "SELECT * FROM temp_sugestaocompra order by produto, ref, var1";
            $arrayParam = '';
            $dadositens = $crud->getSQLGeneric($sql, $arrayParam, true);
            $totalpeca = 0;
            foreach ($dadositens as $value) :
//        $total = $total + $value->total;
//        $totalpeca = 0;
                // $valorliq = $valorliq + $value->total;
                //$dadosprod = Produto($value->produto);
                ?>
                <tr style="border-bottom: 1px dashed #dee2e6;">
                    <td>
                        <?= $value->ref ?>
                    </td>
                    <td>
                        <?= $value->produto . ' ' . $value->descricao ?>
                    </td>

                    <td>
                        <?= $value->var1 ?>
                    </td>

                    <?php
                    if ($_POST['exibemin'] == 'S' && $_POST['exibeestoque'] == 'S') :
                        ?>
                        <td>
                            <br class="spacer">
                            MIN: <br style="border-bottom: 1px dashed #dee2e6;">
                            MAX: <br class="spacer">
                            ESTOQUE: <br class="spacer">
                            SUGESTÃO:
                        </td>


                        <?php
                        $separa = explode("|", $value->sugestao);
                        $min = explode("|", $value->min);
                        $max = explode("|", $value->max);
                        $estoque = explode("|", $value->estoqueatual);
                        $grade = '';
                        $i = 0;
                        $qtditem = 0;
                        $qtditemmin = 0;
                        $qtditemmax = 0;
                        $qtdestoque = 0;
                        for ($index = 0; $index < count($separa); $index++) :
                            $grade = explode(":", $separa[$index]);
                            $grademin = explode(":", $min[$index]);
                            $grademax = explode(":", $max[$index]);
                            $gradeestoque = explode(":", $estoque[$index]);
                            $totalpeca = $totalpeca + $grade[1];
                            $qtditem = $qtditem + $grade[1];
                            $qtditemmin = $qtditemmin + intval($grademin[1]);
                            $qtditemmax = $qtditemmax + intval($grademax[1]);
                            $qtdestoque = $qtdestoque + intval($gradeestoque[1]);
                            echo '<td style="border: 1px solid #DCDCDC">';
                            echo '<b>' . $grade[0] . '</b>';
                            echo '<br/>';
                            echo intval($grademin[1]);
                            echo '<br/>';
                            echo intval($grademax[1]);
                            echo '<br/>';
                            echo intval($gradeestoque[1]);
                            echo '<br/>';
                            echo intval($grade[1]);
                            echo '</td>';
                            $i++;
                        endfor;
                        for ($iz = $i; $iz < 12; $iz++) :
                            echo '<td>';
                            echo '</td>';
                        endfor;
                        ?>

                        <td><br/><?= $qtditemmin ?> 
                            <br/><?= $qtditemmax ?> 
                            <br/><?= $qtdestoque ?> 
                            <br/><?= $qtditem ?> 
                        </td>


                        <?php
                    elseif ($_POST['exibemin'] == 'S' && $_POST['exibeestoque'] == 'N') :
                        ?>
                        <td>
                            <br/>
                            MIN: <br/>
                            MAX: <br/>
                            SUGESTÃO:
                        </td>


                        <?php
                        $separa = explode("|", $value->sugestao);
                        $min = explode("|", $value->min);
                        $max = explode("|", $value->max);
                        $grade = '';
                        $i = 0;
                        $qtditem = 0;
                        $qtditemmin = 0;
                        $qtditemmax = 0;
                        for ($index = 0; $index < count($separa); $index++) :
                            $grade = explode(":", $separa[$index]);
                            $grademin = explode(":", $min[$index]);
                            $grademax = explode(":", $max[$index]);
                            $totalpeca = $totalpeca + $grade[1];
                            $qtditem = $qtditem + $grade[1];
                            $qtditemmin = $qtditemmin + intval($grademin[1]);
                            $qtditemmax = $qtditemmax + intval($grademax[1]);
                            echo '<td style="border: 1px solid #DCDCDC">';
                            echo '<b>' . $grade[0] . '</b>';
                            echo '<br/>';
                            echo intval($grademin[1]);
                            echo '<br/>';
                            echo intval($grademax[1]);
                            echo '<br/>';
                            echo intval($grade[1]);
                            echo '</td>';
                            $i++;
                        endfor;
                        for ($iz = $i; $iz < 12; $iz++) :
                            echo '<td>';
                            echo '</td>';
                        endfor;
                        ?>

                        <td><br/><?= $qtditemmin ?> 
                            <br/><?= $qtditemmax ?> 
                            <br/><?= $qtditem ?> 
                        </td>

                        <?php
                    elseif ($_POST['exibemin'] == 'N' && $_POST['exibeestoque'] == 'S') :
                        ?>
                        <td>
                            <br/>
                            ESTOQUE: <br/>
                            SUGESTÃO:
                        </td>


                        <?php
                        $separa = explode("|", $value->sugestao);
                        $estoque = explode("|", $value->estoqueatual);
                        $grade = '';
                        $i = 0;
                        $qtditem = 0;
                        $qtdestoque = 0;
                        for ($index = 0; $index < count($separa); $index++) :
                            $grade = explode(":", $separa[$index]);
                            $gradeestoque = explode(":", $estoque[$index]);
                            $totalpeca = $totalpeca + $grade[1];
                            $qtditem = $qtditem + $grade[1];
                            $qtdestoque = $qtdestoque + intval($gradeestoque[1]);
                            echo '<td style="border: 1px solid #DCDCDC">';
                            echo '<b>' . $grade[0] . '</b>';
                            echo '<br/>';
                            echo intval($gradeestoque[1]);
                            echo '<br/>';
                            echo intval($grade[1]);
                            echo '</td>';
                            $i++;
                        endfor;
                        for ($iz = $i; $iz < 12; $iz++) :
                            echo '<td>';
                            echo '</td>';
                        endfor;
                        ?>

                        <td>
                            <br/><?= $qtdestoque ?> 
                            <br/><?= $qtditem ?> 
                        </td>
                        <?php
                    else :
                        ?>
                        <td><br/>
                            SUGESTÃO:
                        </td>

                        <?php
                        $separa = explode("|", $value->sugestao);
                        $min = explode("|", $value->min);
                        $max = explode("|", $value->max);
                        $grade = '';
                        $i = 0;
                        $qtditem = 0;
                        $qtditemmin = 0;
                        $qtditemmax = 0;
                        for ($index = 0; $index < count($separa); $index++) :
                            $grade = explode(":", $separa[$index]);
                            $grademin = explode(":", $min[$index]);
                            $grademax = explode(":", $max[$index]);
                            $totalpeca = $totalpeca + $grade[1];
                            $qtditem = $qtditem + $grade[1];
                            $qtditemmin = $qtditemmin + intval($grademin[1]);
                            $qtditemmax = $qtditemmax + intval($grademax[1]);
                            echo '<td style="border: 1px solid #DCDCDC">';
                            echo '<b>' . $grade[0] . '</b>';
                            echo '<br/>';
                            echo intval($grade[1]);
                            echo '</td>';
                            $i++;
                        endfor;
                        for ($iz = $i; $iz < 12; $iz++) :
                            echo '<td>';
                            echo '</td>';
                        endfor;
                        ?>

                        <td>
                            <?= $qtditem ?> 
                        </td>
                    <?php
                    endif;
                    ?>




                </tr>
                <?php
            endforeach;
            ?>
        </table>




    </body>
</html>



<?php
if ($_POST['gerar'] == 'EXCEL') :
//    $data = parseDate($_POST['data'], "dmY");
    $file = 'estoquegrade.xls';
    header("Content-type: application/x-msexcel");
    header("Content-Disposition: attachment; filename=\"{$file}\"");
    header("Content-Description: PHP Generated Data");
elseif ($_POST['gerar'] == 'HTML') :
    echo '';
else :
    ini_set("pcre.backtrack_limit", "500000000000000");
    require_once("../../_inc/mpdf/vendor/autoload.php");
    $mpdf = new \Mpdf\Mpdf([
        'margin_top' => 5,
        'margin_left' => 5,
        'margin_right' => 5,
        'mirrorMargins' => true,
        'default_font_size' => 12
    ]);
    $mpdf->keep_table_proportions = true;
    $mpdf->allow_charset_conversion = true;
    $footer = "<table width = \"1000\">
                   <tr>
                     <td style='font-size: 10px; bottom:-15px;' align=\"right\">Pag: {PAGENO} de {nb} " . date('d/m/Y') . "</td>
                   </tr>
                 </table>";
    $mpdf->SetHTMLFooter($footer);
    $html = ob_get_clean();
    $mpdf->SetTitle('Estoque');
    $mpdf->WriteHTML($html);
    $mpdf->Output();
// imprime

    exit();
endif;
?>