<?php
ob_start();
require_once("../../_inc/mpdf/vendor/autoload.php");
?>
<style>
    body {
        font-size: 9px;
    }

    h1, h2, h3, h4, h5, h6,
    .h1, .h2, .h3, .h4, .h5, .h6 {
        font-family: inherit;
        font-weight: 500;
        line-height: 1.1;
        color: inherit;
    }
    h1 small,
    h1 .small, h2 small,
    h2 .small, h3 small,
    h3 .small, h4 small,
    h4 .small, h5 small,
    h5 .small, h6 small,
    h6 .small,
    .h1 small,
    .h1 .small, .h2 small,
    .h2 .small, .h3 small,
    .h3 .small, .h4 small,
    .h4 .small, .h5 small,
    .h5 .small, .h6 small,
    .h6 .small {
        font-weight: normal;
        line-height: 1;
        color: #777777;
    }

    h1, .h1,
    h2, .h2,
    h3, .h3 {
        margin-top: 20px;
        margin-bottom: 10px;
    }
    h1 small,
    h1 .small, .h1 small,
    .h1 .small,
    h2 small,
    h2 .small, .h2 small,
    .h2 .small,
    h3 small,
    h3 .small, .h3 small,
    .h3 .small {
        font-size: 65%;
    }

    h4, .h4,
    h5, .h5,
    h6, .h6 {
        margin-top: 10px;
        margin-bottom: 10px;
    }
    h4 small,
    h4 .small, .h4 small,
    .h4 .small,
    h5 small,
    h5 .small, .h5 small,
    .h5 .small,
    h6 small,
    h6 .small, .h6 small,
    .h6 .small {
        font-size: 75%;
    }

    h1, .h1 {
        font-size: 36px;
    }

    h2, .h2 {
        font-size: 30px;
    }

    h3, .h3 {
        font-size: 24px;
    }

    h4, .h4 {
        font-size: 18px;
    }

    h5, .h5 {
        font-size: 14px;
    }

    h6, .h6 {
        font-size: 12px;
    }
    .text-center {
        text-align: center;
    }

    table {
        width: 100%;
        padding: 10px;
    }

    td {
        padding: 7px;
    }
    th {
        text-align: left;
    }
    /*.titulotr { border:  none};*/
    /*.titulotr { background: #000; border:1px black solid;};*/
    .table-bordered th,
    .table-bordered td {
        border: 1px solid #ddd !important;
    }

    .full_table_list_titulo{
        border-collapse: collapse;
    }
    .full_table_list_titulo tr{
        border:1px black solid;
    }

    .full_table_list{
        border-collapse: collapse;
    }
    .full_table_list tr{
        border:1px black solid;
    }
    .full_table_list tr:nth-child(even) {
        background: #eee
    }
    .full_table_list tr:nth-child(odd) {
        background: #fff
    }

    .titulotr {
        border:  none
    }
    ;
    .table-bordered th,
    .table-bordered td {
        border: 1px solid #ddd !important;
    }

    .full_table_list{
        border-collapse: collapse;
    }
    .full_table_list tr{
        border:1px black solid;
    }
    .full_table_list tr:nth-child(even) {
        background: #eee
    }
    .full_table_list tr:nth-child(odd) {
        background: #fff
    }

    .tablecor {
        border:1px solid black;
        background: #eee
    }
</style>

<?php
ini_set("pcre.backtrack_limit", "5000000");
require_once "../../_class/Conexao_class.php";
require_once "../../_class/Crud_class.php";
require_once "../../_class/Emitente_class.php";

function situacao($valor) {
    switch ($valor) :
        case '100':
            return 'Aprovada';
            break;
        case '101' :
            return 'Cancelada';
            break;
        default :
            return 'Pendente';
            break;

    endswitch;
}

$modelofisca = array(
    "55" => "NF-e",
    "65" => "NFC-e",
    "01" => "NF",
    "57" => "CT-e",
    "06" => "MODELO 06",
    "22" => "MODELO 22",
);

$data1 = parseDate($_GET['datainicio'], "Y-m-d");
$data2 = parseDate($_GET['datafim'], "Y-m-d");

$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'nfe');
$sql = "SELECT * from nfe";
$sql .= ' WHERE str_to_date(dhEmi, "%d/%m/%Y") BETWEEN "' . $data1 . '" AND "' . $data2 . '"  ';
if ($_GET['tpNF'] <> 'T') :
    if ($_GET['tpNF'] == '1') :
        $sql .= " AND tipo = 'saida' AND tpNF  = '1'";
    else :
        $sql .= " AND ((tipo = 'Entrada') or (tpNF = '0'))";
    endif;
endif;
$sql .= " AND empresa = '" . $_SESSION['Empresa'] . "'";
//$sql .= " AND ((status = '100') or (status = '999'))";

if ($_GET['situacao'] <> 'T') :
    if ($_GET['situacao'] == 'P') {
        $sql .= " AND status is null";
    } else {
        $sql .= " AND status = '" . $_GET['situacao'] . "' ";
    }
endif;

if ($_GET['modelo'] <> 'T') :
    $sql .= " AND modelo = '" . $_GET['modelo'] . "' ";
endif;

if ($_GET['indPag'] <> 'T') :
    $sql .= " AND indPag = '" . $_GET['indPag'] . "' ";
endif;

if ($_GET['cliente'] != '') :
    $sql .= " AND destCNPJ = '" . $_GET['cliente'] . "'";
endif;

if ($_GET['finNFe'] <> 'T') :
    $sql .= " AND finNFe = '" . $_GET['finNFe'] . "'";
endif;

if (!empty($_GET['tipocobranca'])) :
    $sql .= " AND nfe.id IN (
                SELECT nfe
                FROM duplicatanfe
                WHERE forma = '" . $_GET['tipocobranca'] . "'
             )";
endif;

$sql .= " AND emitente = '$emitente->emitenteid'";
//$sql .= " AND modelo = '65'";
//$sql .= " AND status is null";
//
$sql .= " order by nNF";
// echo $sql;
$arrayParam = '';
$dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);
?>

<!--<div class="text-left print">
    <i class="fa fa-print fa-2x" onclick="window.print();"></i>
</div>-->
<h3 class="text-center">RELAÇÃO NF-e  <br/> <small><?= parseDate($data1, "d/m/Y"); ?> à <?= parseDate($data2, "d/m/Y"); ?></small></h3>
<br/>
<table class="table table-bordered <?= $_GET['itens'] === 'S' ? 'full_table_list_titulo' : 'full_table_list' ?> ">
    <tr class="">
        <td>DATA EMISSÃO</td>    
        <td>MODELO</td>    
        <td>Nº</td>    
        <td>DESTINATÁRIO</td>    
        <td>VALOR PROD</td>    
        <td>DESC</td>    
        <td>FRETE</td>    
        <td>VALOR NFE</td>    
        <td>BASE CAL.</td>  
        <td>VALOR ICMS</td>    
        <td>PESO BRUTO</td>    
        <td>PESO LIQUIDO</td>    
        <td>VOL</td>
        <td>QTD ITENS</td>  
        <?php if ($_GET['exibechave'] === 'S') : ?>
            <td>CHAVE</td>    
        <?php endif; ?>
        <td>SITUAÇÃO</td>  
    </tr>


    <tbody>

        <?php
        $total = 0;
        $totalprod = 0;
        $totalbc = 0;
        $totalicms = 0;
        $totalfrete = 0;
        $prod = 0;
        $totalprod1 = 0;
        $totalPesoB = 0;
        $totalPesoL = 0;
        $totaliten = 0;
        $totalregistros = count($dados);
        foreach ($dados as $dado) :

            $pdo = Conexao::getInstance();
            $crud = Crud::getInstance($pdo, 'nfe');
            $sql = "SELECT * from produtonfe";
            $sql .= " WHERE NFe = '$dado->id'";
            $arrayParam = '';
            $produtos = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

            $itemNF = 0;

            foreach ($produtos as $produto) {
                $itemNF = $itemNF + $produto->qtd;
            }

            $total = $total + $dado->vNF;
            $totaldesc = $totaldesc + $dado->vDescnf;
            $totalfrete = $totalfrete + $dado->vFretenf;
            $totalprod = $totalprod + $dado->vProdnf;
            $totalbc = $totalbc + $dado->vBCnf;
            $totalicms = $totalicms + $dado->vICMSnf;
            $totalPesoB = $totalPesoB + $dado->pesoB;
            $totalPesoL = $totalPesoL + $dado->pesoL;
            ?>
            <tr class="tablecor">
                <td><?= $dado->dhEmi ?></td>
                <td><?= $dado->modelo ?> - <?=  $modelofisca[$dado->modelo] ?></td>
                <td><?= $dado->nNF ?></td>
                <td><?= $dado->destxNome ?></td>
                <td>R$ <?= number_format($dado->vProdnf, 2, ',', '.') ?></td>
                <td>R$ <?= number_format($dado->vDescnf, 2, ',', '.') ?></td>
                <td>R$ <?= number_format($dado->vFretenf, 2, ',', '.') ?></td>
                <td>R$ <?= number_format($dado->vNF, 2, ',', '.') ?></td>
                <td>R$ <?= number_format($dado->vBCnf, 2, ',', '.') ?></td>
                <td>R$ <?= number_format($dado->vICMSnf, 2, ',', '.') ?></td>
                <td> <?= number_format($dado->pesoB, 2, ',', '.') ?></td>
                <td><?= number_format($dado->pesoL, 2, ',', '.') ?></td>
                <td><?= $dado->nVol ?></td>
                <td><?= $itemNF ?></td>
                <?php if ($_GET['exibechave'] === 'S') : ?>
                    <td><?= $dado->chavenfe ?></td>
                <?php endif; ?>
                <td><?= Situacao($dado->status) ?></td>
            </tr>

            <?php
            

            foreach ($produtos as $produto) :
                $totaliten = $totaliten + $produto->qtd;
                if ($_GET['itens'] == 'S') :
                    ?>
                    <tr>
                        <td></td>
                        <td></td>
                        <td><?= $produto->cProd ?></td>
                        <td colspan="3"><?= $produto->xProd ?></td>
                        <td><?= $produto->uCom ?></td>
                        <td>R$ <?= number_format($produto->vProd, 2, ',', '.') ?></td>
                        <td><?= number_format($produto->qtd, 2, ',', '.') ?></td>
                        <td>R$ <?= number_format($produto->valortotal, 2, ',', '.') ?></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                    </tr>

                    <?php
                endif;
            endforeach;
            ?>

            <?php
        endforeach;
        ?>
    </tbody>

    <tr>
        <td class="bg-info" colspan="4">TOTAIS</td>    
        <td>R$ <?= number_format($totalprod, 2, ',', '.') ?> </td>    
        <td> R$ <?= number_format($totaldesc, 2, ',', '.') ?></td>  
        <td> R$ <?= number_format($totalfrete, 2, ',', '.') ?></td>  
        <td>R$ <?= number_format($total, 2, ',', '.') ?> 
        </td>     
        <td>R$ <?= number_format($totalbc, 2, ',', '.') ?> 
        </td>     
        <td>R$ <?= number_format($totalicms, 2, ',', '.') ?>
        </td>     
        <td><?= number_format($totalPesoB, 2, ',', '.') ?>
        </td>     
        <td><?= number_format($totalPesoL, 2, ',', '.') ?>
        </td>     

        <td><br/></td>  
        <td><br/></td>  
        <td><br/></td>  
    


    </tr>
    <tr>
        <td class="bg-info" colspan="13">QUANTIDADE TOTAL PRODUTOS</td>    
        <td class="bg-info" colspan="1"><?= number_format($totaliten, 2, ',', '.') ?></td>    
    </tr>
    <tr>
        <td class="bg-info" colspan="13">TOTAL DE</td>    
        <td class="bg-info" colspan="1"> <?= $totalregistros ?> registros</td>    
    </tr>

</table>

<?php
if ($_GET['formato'] == 'excel') :
    $data = 'Relacao NFe';
    $file = '' . $data . '.xls';
    header("Content-type: application/x-msexcel");
    header("Content-Disposition: attachment; filename=\"{$file}\"");
    header("Content-Description: PHP Generated Data");
elseif ($_GET['formato'] == 'pdf') :
    ini_set("pcre.backtrack_limit", "500000000000000");
    $mpdf = new \Mpdf\Mpdf([
        'margin_top' => 5,
        'margin_left' => 5,
        'margin_right' => 5,
        'mirrorMargins' => true,
        'default_font_size' => 12,
        'format' => 'A4-L'
    ]);
    $mpdf->keep_table_proportions = true;
    $mpdf->allow_charset_conversion = true;
    $footer = "<table width = \"1000\">
                   <tr>
                     <td style='font-size: 10px; bottom:-15px;' align=\"right\">Pag: {PAGENO} de {nb} " . date('d/m/Y') . "</td>
                   </tr>
                 </table>";
    $mpdf->SetHTMLFooter($footer);
    $html = ob_get_clean();
    $mpdf->SetTitle('Notas Fiscais');
    $mpdf->WriteHTML($html);
    $mpdf->Output('relacao_nfe.pdf', 'I');

else :
    echo '';
endif;
?>

