<?php
ob_start();
?>
<html>
    <head>
        <title> Relatório </title>
        <style>
            @import "../../../_frontend/_layout/assets/vendor/bootstrap/css/bootstrap.min.css";

            table {
                border-collapse: collapse;
            }
            thead {
                vertical-align: bottom;
                text-align: center;
                font-weight: bold;
            }
            tfoot {
                text-align: center;
                font-weight: bold;
            }
            th {
                text-align: left;
                padding-left: 0.35em;
                padding-right: 0.35em;
                padding-top: 0.35em;
                padding-bottom: 0.35em;
                vertical-align: top;
            }
            td {
                padding-left: 0.35em;
                padding-right: 0.35em;
                padding-top: 0.35em;
                padding-bottom: 0.35em;
                vertical-align: top;
            }

            table {
                width: 100%;
                border-collapse: collapse;
            }

            thead {
                position: sticky;
                top: 0;
                background-color: #fff; /* Cor de fundo para não ficar transparente */
                z-index: 1000; /* Garante que fique sobre outros elementos */
            }

            th {
                background-color: #f4f4f4; /* Estilização opcional */
            }


        </style>
    </head>

    <?php
    date_default_timezone_set("Brazil/East");
    require_once("../../../functions.php");
//
    require_once "../../../_backend/_class/Conexao_class.php";
    require_once "../../../_backend/_class/Crud_class.php";
    require_once "../../../_backend/_class/cobranca_class.php";
    require_once "../../../_backend/_class/parametros.php";

//error_reporting(E_ALL);
//ini_set('display_errors', 'On');


    function FormataValor($valor) {
        return number_format($valor, 2, ',', '');
    }

    function FormataValorn($valor) {
        if (empty($valor)) :
            return '';
        else :
            return number_format($valor, 2, ',', '');
        endif;
    }

    function FormataValor4($valor) {
        return number_format($valor, 4, ',', '');
    }

  function removerAcentos($string) {
    $acentos = array(
        'Á' => 'A', 'À' => 'A', 'Â' => 'A', 'Ã' => 'A', 'Ä' => 'A', 'Å' => 'A',
        'É' => 'E', 'È' => 'E', 'Ê' => 'E', 'Ë' => 'E',
        'Í' => 'I', 'Ì' => 'I', 'Î' => 'I', 'Ï' => 'I',
        'Ó' => 'O', 'Ò' => 'O', 'Ô' => 'O', 'Õ' => 'O', 'Ö' => 'O',
        'Ú' => 'U', 'Ù' => 'U', 'Û' => 'U', 'Ü' => 'U',
        'Ç' => 'C',
        'á' => 'a', 'à' => 'a', 'â' => 'a', 'ã' => 'a', 'ä' => 'a', 'å' => 'a',
        'é' => 'e', 'è' => 'e', 'ê' => 'e', 'ë' => 'e',
        'í' => 'i', 'ì' => 'i', 'î' => 'i', 'ï' => 'i',
        'ó' => 'o', 'ò' => 'o', 'ô' => 'o', 'õ' => 'o', 'ö' => 'o',
        'ú' => 'u', 'ù' => 'u', 'û' => 'u', 'ü' => 'u',
        'ç' => 'c'
    );

    return strtr($string, $acentos);
}

    function Vendedor($vendedorId) {
        static $cache = [];
        if (!isset($cache[$vendedorId])) {
            $pdo = Conexao::getInstance();
            $crud = Crud::getInstance($pdo, 'usuario');
            $sql = "SELECT * from vendedor where vendedorid = '" . $vendedorId . "' ";
            $arrayParam = '';
            $vendedor = $crud->getSQLGeneric($sql, $arrayParam, false);

            $cache[$vendedorId] = $vendedor->xNome;
        }
        return $cache[$vendedorId];
    }

    function Recebmov($documento) {
        static $cache = [];
        if (!isset($cache[$documento])) {
            $pdo = Conexao::getInstance();
            $crud = Crud::getInstance($pdo, 'usuario');
            $sql = "SELECT * FROM recebimentomov where documento = '$documento'";
            $arrayParam = '';
            $vendedor = $crud->getSQLGeneric($sql, $arrayParam, true);
            $cache[$documento] = $crud->getSQLGeneric($sql, $params, true);
        }
        return $cache[$documento];
    }

    function Recebmovtroca($documento) {
        static $cache = [];
        if (!isset($cache[$documento])) {
            $pdo = Conexao::getInstance();
            $crud = Crud::getInstance($pdo, 'usuario');
            $sql = "SELECT * FROM recebimentomov_troca where documento = '$documento'";
            $arrayParam = '';
            $vendedor = $crud->getSQLGeneric($sql, $arrayParam, true);
            $cache[$documento] = $crud->getSQLGeneric($sql, $params, true);
        }
        return $cache[$documento];
    }

    function Empresa($empresaId) {
        static $cache = [];
        if (!isset($cache[$empresaId])) {
            $pdo = Conexao::getInstance();
            $crud = Crud::getInstance($pdo, 'usuario');
            $sql = "SELECT * from emitente where emitenteid = '" . $empresaId . "' ";
            $arrayParam = '';
            $emitente = $crud->getSQLGeneric($sql, $arrayParam, false);
            $cache[$empresaId] = removerAcentos($emitente->xNome);
        }
        return $cache[$empresaId];
    }

//    print_r($empresaar);
//    $_POST['datai'] = '2024-12-01';
    $_POST['datai'] = parseDate($_POST['datai'], 'Y-m-d');
//    $_POST['dataf'] = '2024-12-31';
    $_POST['dataf'] = parseDate($_POST['dataf'], 'Y-m-d');
//    $_POST['empresa'] = '2';

    $datai = $_POST['datai'];
    $dataf = $_POST['dataf'];
    $empresa = $_POST['empresa'];

    $dataitime = strtotime($_POST['datai']);
    $dataftime = strtotime($_POST['dataf']);

    $dataconsulta = date("Y-m-d");
    $data1 = parseDate($dataconsulta, 'd/m/Y');

//    $empresa = Empresa($_POST['empresa']);
    ?>

    <body>

        <div align="center">
            RELAÇÃO DE ITENS POR PERÍODO
            <br/> <small> GERAL <br/><?= parseDate($_POST['datai'], "d/m/Y"); ?> à <?= parseDate($_POST['dataf'], "d/m/Y"); ?></small>
        </div>

        <?php
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'usuario');

        $sql = "
    CREATE OR REPLACE VIEW relacaoitem AS
    SELECT
        m.documento,
        m.DocFiscal,
        STR_TO_DATE(m.data, '%d/%m/%Y') AS data_formatada,
        m.para,

        -- Exibindo a descrição completa para o campo 'para'
        CASE 
            WHEN m.para = 'F' THEN 'Funcionario'
            WHEN m.para = 'R' THEN 'Representante'
            WHEN m.para = 'C' THEN 'Cliente'
            ELSE 'Outro'
        END AS para_completo,

        m.tbpreco,
        m.representante,
        m.vendedor,
        m.corretor,
        m.cliente,
        m.funcionario,
        m.tipo,
        m.hora,
        m.valortotal,
        m.desconto AS desconto_total,
        m.valorpago,
        m.troco,
        m.credito,
        m.situacao,
        m.frete,
        m.controle,
        m.usuario,
        m.doc_empresa,
        m.empresa,
        m.operacao,

        -- Descrição da operação a partir da tabela operacao_mov
        om.descricao AS operacao_descricao,

        STR_TO_DATE(m.datapagamento, '%d/%m/%Y') AS datapagamento_formatada,

        -- Dados do cliente
        c.clienteid,
        c.xNome AS ClienteNome,

        -- Dados do representante
        r.representanteid,
        r.xNome AS RepNome,

        -- Dados do funcionário
        f.funcionarioid,
        f.xNome AS FuncionarioNome,

        -- Nome completo baseado no campo 'para'
        CASE 
            WHEN m.para = 'F' THEN IFNULL(f.xNome, '')
            WHEN m.para = 'R' THEN IFNULL(r.xNome, '')
            WHEN m.para = 'C' THEN IFNULL(c.xNome, '')
            ELSE ''
        END AS Nome_Completo,

        -- ID correspondente ao nome completo
        CASE 
            WHEN m.para = 'F' THEN IFNULL(f.funcionarioid, '')
            WHEN m.para = 'R' THEN IFNULL(r.representanteid, '')
            WHEN m.para = 'C' THEN IFNULL(c.clienteid, '')
            ELSE ''
        END AS Nome_Completo_ID,

        -- Itens da movimentação
        itm.quantidade AS qtd,
        itm.desconto AS descitem,
        itm.valorliquido AS total,
        itm.id AS item_id,
        itm.preco,
        itm.documento AS item_documento,
        itm.produto AS item_produto,
        itm.cancelado,

        -- Rateio do desconto com arredondamento para 2 casas decimais
        ROUND(itm.desconto + (m.desconto / NULLIF(total_qtd.total_itens, 0)) * itm.quantidade, 4) AS desconto_rateado,

        -- Valor pago dividido pela quantidade do item
        ROUND(m.valorpago / NULLIF(total_qtd.total_itens, 0), 4) AS valor_pago_por_item,
        ROUND(m.troco / NULLIF(total_qtd.total_itens, 0), 4) AS troco_por_item,
        ROUND(m.credito / NULLIF(total_qtd.total_itens, 0), 4) AS credito_por_item,

        -- Dados do produto
        e.codproduto,
        p.codigo AS produto_codigo,
        p.descricao AS produto_descricao,
        p.custo,

        -- Cálculo do custo total
        ROUND(p.custo * itm.quantidade, 2) AS custo_total,

        -- Cálculo do lucro em Reais
        ROUND(itm.valorliquido - (p.custo * itm.quantidade), 2) AS lucro_reais,

        -- Cálculo do lucro em %
        ROUND(((itm.valorliquido - (p.custo * itm.quantidade)) / itm.valorliquido) * 100, 2) AS lucro_percentual,

        -- Dados do vendedor
        v.vendedorid,
        v.xNome AS VendedorNome,

        -- Dados do grupo do produto
        gp.grupo,
        g.descricao AS grupo_descricao

    FROM movimentacao m
    LEFT JOIN cliente c ON c.clienteid = m.cliente
    LEFT JOIN representante r ON r.representanteid = m.representante
    LEFT JOIN funcionario f ON f.funcionarioid = m.funcionario
    LEFT JOIN itmovimentacao itm ON itm.documento = m.documento
    LEFT JOIN estoqueprodutos e ON itm.produto = e.codproduto
    LEFT JOIN produtos p ON p.codigo = e.produto
    LEFT JOIN vendedor v ON v.vendedorid = m.vendedor
    LEFT JOIN operacao_mov om ON om.sigla = m.operacao

    -- Junção com a tabela grupoprodutos (limitando a 1 grupo por produto)
    LEFT JOIN (
        SELECT produto, MIN(grupo) AS grupo
        FROM grupoprodutos
        GROUP BY produto
    ) gp ON gp.produto = p.codigo

    -- Junção com a tabela grupos
    LEFT JOIN grupos g ON g.sequencia = gp.grupo

    -- Subquery para calcular a soma das quantidades por movimentação
    LEFT JOIN (
        SELECT documento, SUM(quantidade) AS total_itens
        FROM itmovimentacao
        WHERE cancelado <> 'S'
        GROUP BY documento
    ) total_qtd ON total_qtd.documento = m.documento

    WHERE 
        (
            (m.tipo = 'C' AND STR_TO_DATE(m.datapagamento, '%d/%m/%Y') BETWEEN '" . $datai . "' AND '" . $dataf . "') 
            OR 
            (m.tipo <> 'C' AND STR_TO_DATE(m.data, '%d/%m/%Y') BETWEEN '" . $datai . "' AND '" . $dataf . "')
        )
        AND m.situacao = 'F'
        AND m.tipo <> 'R'
        AND m.empresa = '" . $empresa . "'
        AND itm.cancelado <> 'S'
    ORDER BY m.empresa, m.doc_empresa, m.documento;
";
//
        $criaSaida = $crud->Sql($sql);

        $sql = "
            CREATE OR REPLACE VIEW relacaoitem_troca AS
SELECT
    m.documento,
    '',
    STR_TO_DATE(m.data, '%d/%m/%Y') AS data_formatada,
    m.para,
    
    -- Exibindo a descrição completa para o campo 'para'
    CASE 
        WHEN m.para = 'F' THEN 'Funcionario'
        WHEN m.para = 'R' THEN 'Representante'
        WHEN m.para = 'C' THEN 'Cliente'
        ELSE 'Outro'
    END AS para_completo,
    
    m.tbpreco,
    m.representante,
    m.vendedor,
    m.corretor,
    m.cliente,
    m.funcionario,
    m.tipo,
    m.hora,
    m.valortotal,
    m.desconto AS desconto_total,
    m.valorpago,
    m.troco,
    m.credito,
    m.situacao,
    '',
    m.controle,
    m.usuario,
    m.doc_empresa,
    m.empresa,
    '',
    
    STR_TO_DATE(m.data, '%d/%m/%Y') AS datapagamento_formatada,

    -- Dados do cliente
    c.clienteid,
    c.xNome AS ClienteNome,

    -- Dados do representante
    r.representanteid,
    r.xNome AS RepNome,

    -- Dados do funcionário
    f.funcionarioid,
    f.xNome AS FuncionarioNome,

    -- Condicional para Nome_Completo baseado no campo 'para'
    CASE 
        WHEN m.para = 'F' THEN IFNULL(f.xNome, '')
        WHEN m.para = 'R' THEN IFNULL(r.xNome, '')
        WHEN m.para = 'C' THEN IFNULL(c.xNome, '')
        ELSE ''
    END AS Nome_Completo,

    -- Juntando os IDs correspondentes ao lado do nome completo
    CASE 
        WHEN m.para = 'F' THEN IFNULL(f.funcionarioid, '')
        WHEN m.para = 'R' THEN IFNULL(r.representanteid, '')
        WHEN m.para = 'C' THEN IFNULL(c.clienteid, '')
        ELSE ''
    END AS Nome_Completo_ID,

    -- Itens da movimentação
    itm.quantidade AS qtd,
    itm.operacao,
    itm.desconto AS descitem,
    itm.valorliquido AS total,
    itm.id AS item_id,
    itm.preco,
    itm.documento AS item_documento,
    itm.produto AS item_produto,
    itm.cancelado,

    -- Rateio do desconto com arredondamento para 2 casas decimais
    ROUND(itm.desconto + (m.desconto / NULLIF(total_qtd.total_itens, 0)) * itm.quantidade, 4) AS desconto_rateado,

    -- Valor pago dividido pela quantidade do item
    ROUND(m.valorpago / NULLIF(total_qtd.total_itens, 0), 4) AS valor_pago_por_item,
    
    ROUND(m.troco / NULLIF(total_qtd.total_itens, 0), 4) AS troco_por_item,
    
    ROUND(m.credito / NULLIF(total_qtd.total_itens, 0), 4) AS credito_por_item,

    -- Dados do produto
    e.codproduto,
    p.codigo AS produto_codigo,
    p.descricao AS produto_descricao,
    p.custo,
    
    -- Cálculo do custo total
    ROUND(p.custo * itm.quantidade, 2) AS custo_total,

    -- Cálculo do lucro em Reais (pelo valor total)
    ROUND(itm.valorliquido - (p.custo * itm.quantidade), 2) AS lucro_reais,

    -- Cálculo do lucro em % (pelo valor total)
    ROUND(((itm.valorliquido - (p.custo * itm.quantidade)) / itm.valorliquido) * 100, 2) AS lucro_percentual,

    
    -- Dados do vendedor
    v.vendedorid,
    v.xNome AS VendedorNome,

    -- Dados do grupo do produto (limitando a 1 grupo por produto)
    gp.grupo,
    g.descricao AS grupo_descricao

FROM movimentacao_troca m
LEFT JOIN cliente c ON c.clienteid = m.cliente
LEFT JOIN representante r ON r.representanteid = m.representante
LEFT JOIN funcionario f ON f.funcionarioid = m.funcionario
LEFT JOIN itmovimentacao_troca itm ON itm.documento = m.documento
LEFT JOIN estoqueprodutos e ON itm.produto = e.codproduto
LEFT JOIN produtos p ON p.codigo = e.produto
LEFT JOIN vendedor v ON v.vendedorid = m.vendedor

-- Junção com a tabela grupoprodutos, garantindo que apenas um grupo seja selecionado por produto
LEFT JOIN (
    SELECT produto, MIN(grupo) AS grupo
    FROM grupoprodutos
    GROUP BY produto
) gp ON gp.produto = p.codigo

-- Junção com a tabela grupos para obter a descrição do grupo
LEFT JOIN grupos g ON g.sequencia = gp.grupo

-- Subquery para calcular a soma das quantidades por movimentação
LEFT JOIN (
    SELECT documento, SUM(quantidade) AS total_itens
    FROM itmovimentacao_troca
    WHERE cancelado <> 'S'
    GROUP BY documento
) total_qtd ON total_qtd.documento = m.documento

WHERE 
    STR_TO_DATE(m.data, '%d/%m/%Y') BETWEEN '" . $datai . "' AND '" . $dataf . "' AND m.situacao = 'F'
    AND m.empresa = '" . $empresa . "'
    AND itm.cancelado <> 'S'
ORDER BY m.empresa, m.doc_empresa, m.documento;

            ";

        $criaTroca = $crud->Sql($sql);

        $sql = "
            CREATE OR REPLACE VIEW relacaoitem_devolucao AS
SELECT
    m.documento,
    '',
    STR_TO_DATE(m.data, '%d/%m/%Y') AS data_formatada,
    m.para,
    
    -- Exibindo a descrição completa para o campo 'para'
    CASE 
        WHEN m.para = 'F' THEN 'Funcionario'
        WHEN m.para = 'R' THEN 'Representante'
        WHEN m.para = 'C' THEN 'Cliente'
        ELSE 'Outro'
    END AS para_completo,
    
    m.tbpreco,
    m.representante,
    m.vendedor,
    m.corretor,
    m.cliente,
    m.funcionario,
    m.tipo,
    m.hora,
    m.valortotal,
    m.desconto AS desconto_total,
    m.valorpago,
    m.troco,
    m.credito,
    m.situacao,
    '',
    m.controle,
    m.usuario,
    m.doc_empresa,
    m.empresa,
    '',
    
    STR_TO_DATE(m.datapagamento, '%d/%m/%Y') AS datapagamento_formatada,

    -- Dados do cliente
    c.clienteid,
    c.xNome AS ClienteNome,

    -- Dados do representante
    r.representanteid,
    r.xNome AS RepNome,

    -- Dados do funcionário
    f.funcionarioid,
    f.xNome AS FuncionarioNome,

    -- Condicional para Nome_Completo baseado no campo 'para'
    CASE 
        WHEN m.para = 'F' THEN IFNULL(f.xNome, '')
        WHEN m.para = 'R' THEN IFNULL(r.xNome, '')
        WHEN m.para = 'C' THEN IFNULL(c.xNome, '')
        ELSE ''
    END AS Nome_Completo,

    -- Juntando os IDs correspondentes ao lado do nome completo
    CASE 
        WHEN m.para = 'F' THEN IFNULL(f.funcionarioid, '')
        WHEN m.para = 'R' THEN IFNULL(r.representanteid, '')
        WHEN m.para = 'C' THEN IFNULL(c.clienteid, '')
        ELSE ''
    END AS Nome_Completo_ID,

    -- Itens da movimentação
    itm.quantidade AS qtd,
    itm.desconto AS descitem,
    itm.valorliquido AS total,
    itm.id AS item_id,
    itm.preco,
    itm.documento AS item_documento,
    itm.produto AS item_produto,
    itm.cancelado,

    -- Rateio do desconto com arredondamento para 2 casas decimais
    ROUND(itm.desconto + (m.desconto / NULLIF(total_qtd.total_itens, 0)) * itm.quantidade, 4) AS desconto_rateado,

    -- Valor pago dividido pela quantidade do item
    ROUND(itm.valorliquido, 4) AS valor_pago_por_item,
    
    ROUND(m.troco / NULLIF(total_qtd.total_itens, 0), 4) AS troco_por_item,
    
    ROUND(m.credito / NULLIF(total_qtd.total_itens, 0), 4) AS credito_por_item,

    -- Dados do produto
    e.codproduto,
    p.codigo AS produto_codigo,
    p.descricao AS produto_descricao,
    p.custo,
    
    -- Cálculo do custo total
    ROUND(p.custo * itm.quantidade, 2) AS custo_total,

    -- Cálculo do lucro em Reais (pelo valor total)
    ROUND(itm.valorliquido - (p.custo * itm.quantidade), 2) AS lucro_reais,

    -- Cálculo do lucro em % (pelo valor total)
    ROUND(((itm.valorliquido - (p.custo * itm.quantidade)) / itm.valorliquido) * 100, 2) AS lucro_percentual,

    
    -- Dados do vendedor
    v.vendedorid,
    v.xNome AS VendedorNome,

    -- Dados do grupo do produto (limitando a 1 grupo por produto)
    gp.grupo,
    g.descricao AS grupo_descricao

FROM movimentacao_dev m
LEFT JOIN cliente c ON c.clienteid = m.cliente
LEFT JOIN representante r ON r.representanteid = m.representante
LEFT JOIN funcionario f ON f.funcionarioid = m.funcionario
LEFT JOIN itmovimentacao_dev itm ON itm.documento = m.documento
LEFT JOIN estoqueprodutos e ON itm.produto = e.codproduto
LEFT JOIN produtos p ON p.codigo = e.produto
LEFT JOIN vendedor v ON v.vendedorid = m.vendedor

-- Junção com a tabela grupoprodutos, garantindo que apenas um grupo seja selecionado por produto
LEFT JOIN (
    SELECT produto, MIN(grupo) AS grupo
    FROM grupoprodutos
    GROUP BY produto
) gp ON gp.produto = p.codigo

-- Junção com a tabela grupos para obter a descrição do grupo
LEFT JOIN grupos g ON g.sequencia = gp.grupo

-- Subquery para calcular a soma das quantidades por movimentação
LEFT JOIN (
    SELECT documento, SUM(quantidade) AS total_itens
    FROM itmovimentacao_dev
    WHERE cancelado <> 'S'
    GROUP BY documento
) total_qtd ON total_qtd.documento = m.documento

WHERE 
     (
        (m.tipo = 'C' AND STR_TO_DATE(m.datapagamento, '%d/%m/%Y') BETWEEN '$datai' AND '$dataf') 
        OR 
        (m.tipo <> 'C' AND STR_TO_DATE(m.data, '%d/%m/%Y') BETWEEN '$datai' AND '$dataf')
    )
    AND m.situacao = 'F'
    AND m.tipo <> 'R'
    AND m.empresa = '$empresa'
    AND itm.cancelado <> 'S'
ORDER BY m.empresa, m.doc_empresa, m.documento;

            ";
        $criaDev = $crud->Sql($sql);

        $sql = "
          CREATE OR REPLACE VIEW relacaoitem_os AS
SELECT
    m.documento,
    STR_TO_DATE(m.emissao, '%d/%m/%Y') AS data_formatada,
    'Cliente' AS para_completo,
    m.tbpreco,
    m.vendedor,
    m.cliente,
    m.horaemissao,
    m.total as totaldoc,
    m.desconto AS desconto_total,
    m.`status`,
    m.responsavel AS usuario,
    m.doc_empresa,
    m.empresa,
    STR_TO_DATE(m.emissao, '%d/%m/%Y') AS datapagamento_formatada,
    c.clienteid,
    c.xNome,
    itm.quantidade AS qtd,
    itm.total AS total,
    itm.id AS item_id,
    itm.valor,
    itm.documento AS item_documento,
    itm.produto AS item_produto,
    srv.servico,
    srv.documento as docsrv,
    srv.quantidade AS qtdsrv,
    srv.valor AS valorsrv, 
    srv.total AS totalsrv,
    sr.servicosid, 
    sr.descricao,
    e.codproduto,
    p.codigo AS produto_codigo,
    p.descricao AS produto_descricao,
    p.custo,
    -- Rateio do desconto com arredondamento para 2 casas decimais
    ROUND(m.desconto / NULLIF(total_qtd.total_itens, 0) * itm.quantidade, 4) AS desconto_rateado,
    -- Cálculo do custo total
    ROUND(p.custo * itm.quantidade, 2) AS custo_total,
    -- Cálculo do lucro em Reais (pelo valor total)
    ROUND(itm.total - (p.custo * itm.quantidade), 2) AS lucro_reais,
    -- Cálculo do lucro em % (pelo valor total)
    ROUND(((itm.total - (p.custo * itm.quantidade)) / itm.total) * 100, 2) AS lucro_percentual,
    -- Dados do vendedor
    v.vendedorid,
    v.xNome AS VendedorNome,
    -- Dados do grupo do produto
    gp.grupo,
    g.descricao AS grupo_descricao,
    -- Campo condicional para código e descrição do serviço ou produto
    CASE 
        WHEN srv.servico IS NOT NULL THEN srv.servico
        ELSE p.codigo
    END AS codprodse,
    CASE 
        WHEN sr.descricao IS NOT NULL THEN sr.descricao
        ELSE p.descricao
    END AS descprodser,
    -- Campo condicional para o total do serviço ou produto
    CASE 
        WHEN srv.total IS NOT NULL THEN srv.total
        ELSE itm.total
    END AS totalprodser,
    CASE 
        WHEN srv.valor IS NOT NULL THEN srv.valor
        ELSE itm.valor
    END AS valorprodser
FROM os m
LEFT JOIN cliente c ON c.clienteid = m.cliente
LEFT JOIN itos itm ON itm.documento = m.documento
LEFT JOIN estoqueprodutos e ON itm.produto = e.codproduto
LEFT JOIN produtos p ON p.codigo = e.produto
LEFT JOIN vendedor v ON v.vendedorid = m.vendedor
LEFT JOIN servicoos srv ON srv.documento = m.documento
LEFT JOIN servicos sr ON sr.servicosid = srv.servico
LEFT JOIN (
    SELECT produto, MIN(grupo) AS grupo
    FROM grupoprodutos
    GROUP BY produto
) gp ON gp.produto = p.codigo
LEFT JOIN grupos g ON g.sequencia = gp.grupo
LEFT JOIN (
    SELECT documento, SUM(quantidade) AS total_itens
    FROM (
        SELECT documento, quantidade FROM itos
        UNION ALL
        SELECT documento, quantidade FROM servicoos
    ) AS combined
    GROUP BY documento
) total_qtd ON total_qtd.documento = m.documento
WHERE 
    STR_TO_DATE(m.emissao, '%d/%m/%Y') BETWEEN '$datai' AND '$dataf'
     AND m.status = 'F'
     AND m.empresa = '$empresa'
ORDER BY m.empresa, m.doc_empresa, m.documento;
            ";
        $criaOS = $crud->Sql($sql);

//        echo $sql;

        $sql = "SELECT * from relacaoitem ORDER BY doc_empresa";
        $arrayParam = '';
        $venda = $crud->getSQLGeneric($sql, $arrayParam, true);

        $sql = "SELECT * from relacaoitem_troca ORDER BY doc_empresa";
        $arrayParam = '';
        $troca = $crud->getSQLGeneric($sql, $arrayParam, true);

        $sql = "SELECT * from relacaoitem_devolucao ORDER BY doc_empresa";
        $arrayParam = '';
        $dev = $crud->getSQLGeneric($sql, $arrayParam, true);

        $sql = "SELECT * from relacaoitem_os ORDER BY doc_empresa";
        $arrayParam = '';
        $os = $crud->getSQLGeneric($sql, $arrayParam, true);
        ?>

        <table cellpadding="8" class="table table-striped table-bordered table-condensed full_table_list" style="font-size: 10px; padding: 10px">
            <thead>
                <tr> 
                    <th>Tipo</th>
                    <th>Operacao</th>
                    <th>Doc</th>
                    <th>Data</th>
                    <th>Vendedor</th>
                    <th>Grupo</th>
                    <th>Produto</th>
                    <th>Descricao</th>
                    <th>Quantidade</th>
                    <th>Custo</th>
                    <th>Custo Total</th>
                    <th>Desconto Item</th>
                    <th>Desconto Rateado</th>
                    <th>Credito</th>
                    <th>Venda</th>
                    <th>Venda Bruta</th>
                    <th>Venda Liq.</th>
                    <th>V. Pago Bruto</th>
                    <th>Troco</th>
                    <th>V. Pago Liq</th>
                    <th>Margem Bruta (R$)</th>
                    <th>Margem Bruta (%)</th>
                    <th>Para</th>
                    <th>Nome</th>
                    <th>Operacao</th>
                    <th>Empresa</th>
                </tr>
            </thead>


            <?php
            foreach ($venda as $venda) :
                $dataVenda = (empty($venda->datapagamento_formatada) || $venda->datapagamento_formatada == '0000-00-00') ? $venda->data_formatada : $venda->datapagamento_formatada;
                $credito = (empty($venda->credito_por_item)) ? 0 : $venda->credito_por_item;
                $totalqtd += $venda->qtd;
                $custototal += $venda->custo_total;
                $descitem += $venda->descitem;
                $descvenda += $venda->desconto_rateado - $venda->descitem;
                $creditovenda += $credito;
                $totalbruto += $venda->total + $venda->descitem - $credito;
                $totalliq += $venda->total + $venda->descitem - $venda->desconto_rateado - $credito;
                $valorpago += $venda->valor_pago_por_item * $venda->qtd;
                $troco += $venda->troco_por_item;
                $pagoliq += ($venda->valor_pago_por_item * $venda->qtd) - $venda->troco_por_item;
                ?>
                <tr>
                    <td>Venda <?= ($venda->tipo === 'C') ? 'Consignada' : '' ?></td>
                    <td>Saida</td>
                    <td><?= $venda->doc_empresa ?></td>
                    <td><?= parseDate($dataVenda, 'd/m/Y') ?></td>
                    <td><?= removerAcentos($venda->VendedorNome) ?></td>
                    <td><?= $venda->grupo . ' ' . removerAcentos($venda->grupo_descricao) ?></td>
                    <td><?= $venda->codproduto ?></td>
                    <td><?= removerAcentos($venda->produto_descricao) ?></td>
                    <td><?= (fmod($venda->qtd, 1) == 0) ? intval($venda->qtd) : number_format($venda->qtd, 2, ',', '.'); ?></td>
                    <td><?= FormataValor($venda->custo) ?></td>
                    <td><?= FormataValor($venda->custo_total) ?></td>
                    <td><?= FormataValor($venda->descitem) ?></td>
                    <td><?= FormataValor($venda->desconto_rateado) ?></td>
                    <td><?= number_format($credito, 2, ',', '') ?></td>
                    <td><?= FormataValor($venda->preco) ?></td>
                    <td><?= FormataValor($venda->total + $venda->descitem - $credito) ?></td>
                    <td><?= FormataValor($venda->total + $venda->descitem - $venda->desconto_rateado - $credito) ?></td>
                    <td><?= FormataValor4($venda->valor_pago_por_item * $venda->qtd) ?></td>
                    <td><?= FormataValor($venda->troco) ?></td>
                    <td><?= FormataValor4(($venda->valor_pago_por_item * $venda->qtd) - $venda->troco_por_item) ?></td>
                    <td><?= FormataValor($venda->lucro_reais) ?></td>
                    <td><?= FormataValor($venda->lucro_percentual) ?></td>
                    <td><?= $venda->para_completo ?></td>
                    <td><?= $venda->Nome_Completo_ID ?> - <?= removerAcentos($venda->Nome_Completo) ?></td>
                    <td><?= removerAcentos($venda->operacao_descricao) ?> </td>
                    <td><?= Empresa($venda->empresa) ?></td>
                </tr>

                <?php
            endforeach;
            ?>



            <?php
            foreach ($troca as $troca) :
                $dataVenda = (empty($troca->datapagamento_formatada) || $troca->datapagamento_formatada == '0000-00-00') ? $troca->data_formatada : $troca->datapagamento_formatada;
                $credito = (empty($troca->credito_por_item)) ? 0 : $troca->credito_por_item;
                $custototal += $troca->custo_total;
                $descitem += $troca->descitem;
                $descvenda += $troca->desconto_rateado - $troca->descitem;
                $creditovenda += $credito;

                if ($troca->operacao == 'E') :
                    $tipo = 'Devolucao';
                    $totalqtd -= $troca->qtd;
                    $totalbruto -= $troca->total + $troca->descitem - $credito;
                    $totalliq -= $troca->total + $troca->descitem - $troca->desconto_rateado - $credito;
                else :
                    $tipo = 'Saida';
                    $totalqtd += $troca->qtd;
                    $totalbruto += $troca->total + $troca->descitem - $credito;
                    $totalliq += $troca->total + $troca->descitem - $troca->desconto_rateado - $credito;
                endif;
                $valorpago += $troca->valor_pago_por_item * $troca->qtd;
                $troco += $troca->troco_por_item;
                $pagoliq += ($troca->valor_pago_por_item * $troca->qtd) - $troca->troco_por_item;
                ?>
                <tr>
                    <td>Troca</td>
                    <td><?= $tipo ?></td>
                    <td><?= $troca->doc_empresa ?></td>
                    <td><?= parseDate($dataVenda, 'd/m/Y') ?></td>
                    <td><?= removerAcentos($troca->VendedorNome) ?></td>
                    <td><?= $troca->grupo . ' ' . removerAcentos($troca->grupo_descricao) ?></td>
                    <td><?= $troca->codproduto ?></td>
                    <td><?= removerAcentos($troca->produto_descricao) ?></td>
                    <td><?= ($troca->operacao === 'E') ? '-' : ''; ?><?= (fmod($troca->qtd, 1) == 0) ? intval($troca->qtd) : number_format($troca->qtd, 2, ',', '.'); ?></td>
                    <td><?= FormataValor($troca->custo) ?></td>
                    <td><?= ($troca->operacao === 'E') ? '-' : ''; ?><?= FormataValor($troca->custo_total) ?></td>
                    <td><?= FormataValor($troca->descitem) ?></td>
                    <td><?= FormataValor($troca->desconto_rateado) ?></td>
                    <td><?= number_format($credito, 2, ',', '.') ?></td>
                    <td><?= FormataValor($troca->preco) ?></td>
                    <td><?= ($troca->operacao === 'E') ? '-' : ''; ?><?= FormataValor($troca->total + $troca->descitem - $credito) ?></td>
                    <td><?= ($troca->operacao === 'E') ? '-' : ''; ?><?= FormataValor($troca->total + $troca->descitem - $troca->desconto_rateado - $credito) ?></td>
                    <td><?= FormataValor4($troca->valor_pago_por_item * $troca->qtd) ?></td>
                    <td><?= FormataValor($troca->troco) ?></td>
                    <td><?= FormataValor4(($troca->valor_pago_por_item * $troca->qtd) - $troca->troco_por_item) ?></td>
                    <td><?= ($troca->operacao === 'E') ? '-' : ''; ?><?= FormataValor($troca->lucro_reais) ?></td>
                    <td><?= ($troca->operacao === 'E') ? '-' : ''; ?><?= FormataValor($troca->lucro_percentual) ?></td>
                    <td><?= $troca->para_completo ?></td>
                    <td><?= $troca->Nome_Completo_ID ?> - <?= removerAcentos($troca->Nome_Completo) ?></td>
                    <td>Presencial</td>
                    <td><?= Empresa($troca->empresa) ?></td>
                </tr>

                <?php
            endforeach;
            ?>

            <?php
            foreach ($dev as $dev) :
                $dataVenda = (empty($dev->datapagamento_formatada) || $dev->datapagamento_formatada == '0000-00-00') ? $dev->data_formatada : $dev->datapagamento_formatada;
                $credito = (empty($dev->credito_por_item)) ? 0 : $dev->credito_por_item;
                $custototal += $dev->custo_total;
                $descitem += $dev->descitem;
                $descvenda += $dev->desconto_rateado - $dev->descitem;
                $creditovenda += $credito;
                $tipo = 'Devolucao';
                $totalqtd -= $dev->qtd;
                $totalbruto -= $dev->total + $dev->descitem - $credito;
                $totalliq -= $dev->total + $dev->descitem - $dev->desconto_rateado - $credito;
                $valorpago -= $dev->valor_pago_por_item;
                $troco -= $dev->troco_por_item;
                $pagoliq -= $dev->valor_pago_por_item - $dev->troco_por_item;
                ?>
                <tr>
                    <td>Devolucao</td>
                    <td>Devolucao</td>
                    <td><?= $dev->doc_empresa ?></td>
                    <td><?= parseDate($dataVenda, 'd/m/Y') ?></td>
                    <td><?= removerAcentos($dev->VendedorNome) ?></td>
                    <td><?= $dev->grupo . ' ' . removerAcentos($dev->grupo_descricao) ?></td>
                    <td><?= $dev->codproduto ?></td>
                    <td><?= removerAcentos($dev->produto_descricao) ?></td>
                    <td>-<?= (fmod($dev->qtd, 1) == 0) ? intval($dev->qtd) : number_format($dev->qtd, 2, ',', '.'); ?></td>
                    <td><?= FormataValor($dev->custo) ?></td>
                    <td>-<?= FormataValor($dev->custo_total) ?></td>
                    <td><?= FormataValor($dev->descitem) ?></td>
                    <td><?= FormataValor($dev->desconto_rateado) ?></td>
                    <td><?= number_format($credito, 2, ',', '.') ?></td>
                    <td><?= FormataValor($dev->preco) ?></td>
                    <td>-<?= FormataValor($dev->total + $dev->descitem - $credito) ?></td>
                    <td>-<?= FormataValor($dev->total + $dev->descitem - $dev->desconto_rateado - $credito) ?></td>
                    <td>-<?= FormataValor4($dev->valor_pago_por_item) ?></td>
                    <td><?= FormataValor($dev->troco) ?></td>
                    <td>-<?= FormataValor4(($dev->valor_pago_por_item) - $dev->troco_por_item) ?></td>
                    <td>-<?= FormataValor($dev->lucro_reais) ?></td>
                    <td>-<?= FormataValor($dev->lucro_percentual) ?></td>
                    <td><?= $dev->para_completo ?></td>
                    <td><?= $dev->Nome_Completo_ID ?> - <?= removerAcentos($dev->Nome_Completo) ?></td>
                    <td>Presencial </td>
                    <td><?= Empresa($troca->empresa) ?></td>
                </tr>

                <?php
            endforeach;
            ?>




            <?php
            foreach ($os as $os) :
                $dataVenda = $os->data_formatada;
                $credito = 0;
                $totalqtd += $os->qtd;
                $custototal += $os->custo_total;
                $descitem += $os->descitem;
                $descvenda += $os->desconto_rateado;
                $creditovenda += $credito;
                $totalbruto += $os->totalprodser;
                $totalliq += $os->totalprodser - $os->desconto_rateado;
                $valorpago += $os->totalprodser - $os->desconto_rateado;
                $troco += 0;
                $pagoliq += $os->totalprodser - $os->desconto_rateado;
                if (empty($os->servicoid)) :
                    $tipo = 'Saida';
                else :
                    $tipo = 'Servico';
                endif;
                ?>
                <tr>
                    <td>O.S</td>
                    <td><?= $tipo ?></td>
                    <td><?= $os->doc_empresa ?></td>
                    <td><?= parseDate($dataVenda, 'd/m/Y') ?></td>
                    <td><?= removerAcentos($os->VendedorNome) ?></td>
                    <td><?= $os->grupo . ' ' . removerAcentos($os->grupo_descricao) ?></td>
                    <td><?= $os->codprodse ?></td>
                    <td><?= removerAcentos($os->descprodser) ?></td>
                    <td><?= (fmod($os->qtd, 1) == 0) ? intval($os->qtd) : number_format($os->qtd, 2, ',', '.'); ?></td>
                    <td><?= FormataValor($os->custo) ?></td>
                    <td><?= FormataValor($os->custo_total) ?></td>
                    <td>0,00</td>
                    <td><?= FormataValor($os->desconto_rateado) ?></td>
                    <td>0,00</td>
                    <td><?= FormataValorn($os->valorprodser) ?></td>
                    <td><?= FormataValor($os->totalprodser) ?></td>
                    <td><?= FormataValor($os->totalprodser - $os->desconto_rateado - $credito) ?></td>
                    <td><?= FormataValor4($os->totalprodser - $os->desconto_rateado - $credito) ?></td>
                    <td>0,00</td>
                    <td><?= FormataValor4($os->totalprodser - $os->desconto_rateado - $credito) ?></td>
                    <td><?= FormataValor($os->lucro_reais) ?></td>
                    <td><?= FormataValor($os->lucro_percentual) ?></td>
                    <td>Cliente</td>
                    <td><?= $os->clienteid ?> - <?= removerAcentos($os->xNome) ?></td>
                    <td>Presencial </td>
                    <td><?= Empresa($os->empresa) ?></td>
                </tr>

                <?php
            endforeach;
            ?>
            <tr>
                <th></th>
                <th></th>
                <th></th>
                <th></th>
                <th></th>
                <th></th>
                <th></th>
                <th></th>
                <th><?= (fmod($totalqtd, 1) == 0) ? intval($totalqtd) : number_format($totalqtd, 2, ',', '.'); ?></th>
                <th></th>
                <th><?= 'R$ ' . number_format($custototal, 2, ',', '.') ?></th>
                <th><?= 'R$ ' . number_format($descitem, 2, ',', '.') ?></th>
                <th><?= 'R$ ' . number_format($descvenda, 2, ',', '.') ?></th>
                <th><?= 'R$ ' . number_format($creditovenda, 2, ',', '.') ?></th>
                <th></th>
                <th><?= 'R$ ' . number_format($totalbruto, 2, ',', '.') ?></th>
                <th><?= 'R$ ' . number_format($totalliq, 2, ',', '.') ?></th>
                <th><?= 'R$ ' . number_format($valorpago, 2, ',', '.') ?></th>
                <th><?= 'R$ ' . number_format($troco, 2, ',', '.') ?></th>
                <th><?= 'R$ ' . number_format($pagoliq, 2, ',', '.') ?></th>
                <th></th>
                <th></th>
                <th></th>
                <th></th>
                <th></th>
                <th></th>
            </tr>
        </table>
    </body>
</html>



<?php
if ($_POST['arq'] == 'PDF') :
    require_once("../../_inc/mpdf/vendor/autoload.php");
    ini_set("pcre.backtrack_limit", "500000000000000");

    $mpdf = new \Mpdf\Mpdf([
        'margin_top' => 5,
        'margin_left' => 5,
        'margin_right' => 5,
        'mirrorMargins' => true,
        'default_font_size' => 12,
        'format' => 'A4-L'
    ]);
//$mpdf->SetWatermarkText('DRAFT');
    $mpdf->keep_table_proportions = true;
    $mpdf->allow_charset_conversion = true;
    $footer = "<table width = \"1000\">
                   <tr>
                     <td style='font-size: 10px; bottom:-15px;' align=\"right\">Pag: {PAGENO} de {nb} " . date('d/m/Y') . "</td>
                   </tr>
                 </table>";
    $mpdf->SetHTMLFooter($footer);
    $html = ob_get_clean();
    $mpdf->SetTitle('Movimentações');
    $mpdf->WriteHTML($html);
    $mpdf->Output();
// imprime

    exit();
elseif ($_POST['arq'] == 'EXCEL') :
    $nomeFile = Empresa($empresa) . '_' . parseDate($_POST['datai'], "dmY") . 'a' . parseDate($_POST['dataf'], "dmY");
    $file = $nomeFile . '.xls';
    header("Content-Type: application/vnd.ms-excel; charset=UTF-8");
    header("Content-Disposition: attachment; filename=\"{$file}\"");
    header("Content-Description: PHP Generated Data");
    echo "\xEF\xBB\xBF"; // Adiciona o BOM UTF-8
else :
    echo '';
endif;
?>