<?php
ob_start();
?>
<html>
    <head>
        <title> Relatório </title>
        <style>
            @import "../../../_frontend/_layout/assets/vendor/bootstrap/css/bootstrap.min.css";

            table {
                border-collapse: collapse;
            }
            thead {
                vertical-align: bottom;
                text-align: center;
                font-weight: bold;
            }
            tfoot {
                text-align: center;
                font-weight: bold;
            }
            th {
                text-align: left;
                padding-left: 0.35em;
                padding-right: 0.35em;
                padding-top: 0.35em;
                padding-bottom: 0.35em;
                vertical-align: top;
            }
            td {
                padding-left: 0.35em;
                padding-right: 0.35em;
                padding-top: 0.35em;
                padding-bottom: 0.35em;
                vertical-align: top;
            }

            table {
                width: 100%;
                border-collapse: collapse;
            }

            thead {
                position: sticky;
                top: 0;
                background-color: #fff; /* Cor de fundo para não ficar transparente */
                z-index: 1000; /* Garante que fique sobre outros elementos */
            }

            th {
                background-color: #f4f4f4; /* Estilização opcional */
            }


        </style>
    </head>

    <?php
    date_default_timezone_set("Brazil/East");
    require_once("../../../functions.php");
//
    require_once "../../../_backend/_class/Conexao_class.php";
    require_once "../../../_backend/_class/Crud_class.php";
    require_once "../../../_backend/_class/cobranca_class.php";
    require_once "../../../_backend/_class/parametros.php";

//error_reporting(E_ALL);
//ini_set('display_errors', 'On');


    function FormataValor($valor) {
        return number_format($valor, 2, ',', '');
    }

    function FormataValorn($valor) {
        if (empty($valor)) :
            return '';
        else :
            return number_format($valor, 2, ',', '');
        endif;
    }

    function FormataValor4($valor) {
        return number_format($valor, 4, ',', '');
    }

    function retornoCategoria($valor) {
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'usuario');
        $sql = "SELECT * from categorias where sigla = '$valor'";
        $arrayParam = '';
        $cat = $crud->getSQLGeneric($sql, $arrayParam, false);
        
        return $cat->descricao;
    }

    function removerAcentos($string) {
        $acentos = array(
            'Á' => 'A', 'À' => 'A', 'Â' => 'A', 'Ã' => 'A', 'Ä' => 'A', 'Å' => 'A',
            'É' => 'E', 'È' => 'E', 'Ê' => 'E', 'Ë' => 'E',
            'Í' => 'I', 'Ì' => 'I', 'Î' => 'I', 'Ï' => 'I',
            'Ó' => 'O', 'Ò' => 'O', 'Ô' => 'O', 'Õ' => 'O', 'Ö' => 'O',
            'Ú' => 'U', 'Ù' => 'U', 'Û' => 'U', 'Ü' => 'U',
            'Ç' => 'C',
            'á' => 'a', 'à' => 'a', 'â' => 'a', 'ã' => 'a', 'ä' => 'a', 'å' => 'a',
            'é' => 'e', 'è' => 'e', 'ê' => 'e', 'ë' => 'e',
            'í' => 'i', 'ì' => 'i', 'î' => 'i', 'ï' => 'i',
            'ó' => 'o', 'ò' => 'o', 'ô' => 'o', 'õ' => 'o', 'ö' => 'o',
            'ú' => 'u', 'ù' => 'u', 'û' => 'u', 'ü' => 'u',
            'ç' => 'c'
        );

        return strtr($string, $acentos);
    }

    $datai = $_POST['datai'];
    $dataf = $_POST['dataf'];
    $categoria = $_POST['categoria'] ?? 'IN';
    $produto = $_POST['produto'];
    $empresa = $_POST['empresa'];
    $codinterno = $_POST['codinterno'];
//    $empresa = Empresa($_POST['empresa']);
    ?>

    <body>

        <div align="center">
            DESEMPENHO DE PRODUTOS
            <br/> <small> <?= $datai ?> à <?= $dataf ?></small> <br/>
            <?php
            if (!empty($codinterno)) :
                echo '<small> Cód. Interno: '.$codinterno.'  </small>';
            endif;
            ?>
            
             <?php
            if (!empty($categoria)) :
                echo '<small> Categoria: '.$categoria.' - ' . retornoCategoria($categoria) . ' </small>';
            endif;
            ?>
        </div>

        <?php
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'usuario');
        $sql = "SELECT 
  cat.sigla AS categoria,
  p.codigo AS produto_codigo,
  p.descricao AS produto_descricao,
  e.codproduto AS codigo_produto,
  e.barras as CodInterno,
  e.produto AS estoque_produto,

  COALESCE(ent.qtd_entrada, 0) AS qtd_entrada,

  SUM(CASE WHEN mov.tipo = 'venda' THEN mov.quantidade ELSE 0 END) AS qtd_vendida,
  SUM(CASE WHEN mov.tipo = 'venda' THEN mov.valorliquido ELSE 0 END) AS valor_vendido,

  SUM(CASE WHEN mov.tipo = 'devolucao' THEN mov.quantidade ELSE 0 END) AS qtd_devolvida,
  SUM(CASE WHEN mov.tipo = 'devolucao' THEN mov.valorliquido ELSE 0 END) AS valor_devolvido,

  ROUND(p.custo * (
      SUM(CASE WHEN mov.tipo = 'venda' THEN mov.quantidade ELSE 0 END) -
      SUM(CASE WHEN mov.tipo = 'devolucao' THEN mov.quantidade ELSE 0 END)
  ), 2) AS custo_total,

  ROUND(( 
      SUM(CASE WHEN mov.tipo = 'venda' THEN mov.valorliquido ELSE 0 END) -
      SUM(CASE WHEN mov.tipo = 'devolucao' THEN mov.valorliquido ELSE 0 END) -
      (p.custo * (
          SUM(CASE WHEN mov.tipo = 'venda' THEN mov.quantidade ELSE 0 END) -
          SUM(CASE WHEN mov.tipo = 'devolucao' THEN mov.quantidade ELSE 0 END)
      ))
  ), 2) AS lucro

FROM (
  SELECT m.data, i.produto, i.quantidade, i.valorliquido, 'venda' AS tipo
  FROM movimentacao m
  JOIN itmovimentacao i ON i.documento = m.documento
  WHERE i.cancelado <> 'S' AND m.situacao = 'F' and m.empresa = '$empresa'

  UNION ALL

  SELECT t.data, it.produto, it.quantidade, it.valorliquido, 'venda' AS tipo
  FROM movimentacao_troca t
  JOIN itmovimentacao_troca it ON it.documento = t.documento
  WHERE it.cancelado <> 'S' AND it.operacao = 'S' AND t.situacao = 'F' and t.empresa = '$empresa'

  UNION ALL

  SELECT d.data, id.produto, id.quantidade, id.valorliquido, 'devolucao' AS tipo
  FROM movimentacao_dev d
  JOIN itmovimentacao_dev id ON id.documento = d.documento
  WHERE id.cancelado <> 'S' AND d.situacao = 'F' and d.empresa = '$empresa'

  UNION ALL

  SELECT t.data, it.produto, it.quantidade, it.valorliquido, 'devolucao' AS tipo
  FROM movimentacao_troca t
  JOIN itmovimentacao_troca it ON it.documento = t.documento
  WHERE it.cancelado <> 'S' AND it.operacao = 'E' AND t.situacao = 'F' and t.empresa = '$empresa'
) mov

JOIN estoqueprodutos e ON e.codproduto = mov.produto
JOIN produtos p ON p.codigo = e.produto
LEFT JOIN categorias cat ON cat.sigla = p.categoria

LEFT JOIN (
  SELECT 
    ie.produto,
    SUM(ie.quantidade) AS qtd_entrada
  FROM movimentacao_ent me
  JOIN itmovimentacao_ent ie ON ie.documento = me.documento
  WHERE ie.cancelado <> 'S' AND me.situacao = 'F'
    AND STR_TO_DATE(me.data, '%d/%m/%Y') BETWEEN STR_TO_DATE('$datai', '%d/%m/%Y') AND STR_TO_DATE('$dataf', '%d/%m/%Y')
        and me.empresa = '$empresa'
  GROUP BY ie.produto
) ent ON ent.produto = mov.produto

WHERE STR_TO_DATE(mov.data, '%d/%m/%Y') BETWEEN STR_TO_DATE('$datai', '%d/%m/%Y') AND STR_TO_DATE('$dataf', '%d/%m/%Y')
    ";

        if (!empty($categoria)) :
            $sql .= " and p.categoria = '$categoria'";
        endif;
        
        if (!empty($codinterno)) :
            $sql .= " and e.barras = '$codinterno'";
        endif;

        if (!empty($produto)) :
            $sql .= " AND e.produto = '$produto'";
        endif;

        $sql .= "
GROUP BY e.codproduto
ORDER BY p.codigo;";

//       echo $sql;
        $arrayParam = '';
        $venda = $crud->getSQLGeneric($sql, $arrayParam, true);
        ?>

        <table cellpadding="8" class="table table-striped table-bordered table-condensed full_table_list" style="font-size: 10px; padding: 10px">
            <thead>
                <tr> 
                    <th>Produto</th>
                    <th>Descricao</th>
                    <th>Qtd Entrada</th>
                    <th>Qtd Vendida</th>
                    <th>Total Vendido</th>
                    <th>Qtd Devolivdo</th>
                    <th>Total Devolivdo</th>
                    <th>Qtd Geral</th>
                    <th>Total Geral</th>                  
                    <th>Custo Total</th>
                    <th>Lucro (R$)</th>
                </tr>
            </thead>


            <?php
            $totalentrada = 0;
            $totalsaida = 0;
            $totaldev = 0;
            $valorvenda = 0;
            $valordev = 0;
            $custototal = 0;
            $lucrototal = 0;
            foreach ($venda as $venda) :
                $totalentrada += $venda->qtd_entrada;
                $totalsaida += $venda->qtd_vendida;
                $totaldev += $venda->qtd_devolvida;
                $valorvenda += $venda->valor_vendido;
                $valordev += $venda->valor_devolvido;
                $custototal += $venda->custo_total;
                $lucrototal += $venda->lucro;
                $qtdgeral = $venda->qtd_vendida - $venda->qtd_devolvida;
                ?>
                <tr>
                    <td><?= $venda->codigo_produto ?></td>
                    <td><?= removerAcentos($venda->produto_descricao) ?></td>
                    <td><?= (fmod($venda->qtd_entrada, 1) == 0) ? intval($venda->qtd_entrada) : number_format($venda->qtd_entrada, 2, ',', '.'); ?></td>
                    <td><?= (fmod($venda->qtd_vendida, 1) == 0) ? intval($venda->qtd_vendida) : number_format($venda->qtd_vendida, 2, ',', '.'); ?></td>
                    <td><?= FormataValor($venda->valor_vendido) ?></td>
                    <td><?= (fmod($venda->qtd_devolvida, 1) == 0) ? intval($venda->qtd_devolvida) : number_format($venda->qtd_devolvida, 2, ',', '.'); ?></td>
                    <td><?= FormataValor($venda->valor_devolvido) ?></td>
                    <td><?= (fmod($qtdgeral, 1) == 0) ? intval($qtdgeral) : number_format($qtdgeral, 2, ',', '.'); ?></td>
                    <td><?= FormataValor($venda->valor_vendido - $venda->valor_devolvido) ?></td>
                    <td><?= FormataValor($venda->custo_total) ?></td>
                    <td><?= FormataValor($venda->lucro) ?></td>
                </tr>

                <?php
            endforeach;

            $qtdtotalgeral = $totalsaida - $totaldev;
            $vlrtotalgeral = $valorvenda - $valordev;
            ?>


            <tr>

                <th></th>
                <th></th>
                <th><?= (fmod($totalentrada, 1) == 0) ? intval($totalentrada) : number_format($totalentrada, 2, ',', '.'); ?></th>
                <th><?= (fmod($totalsaida, 1) == 0) ? intval($totalsaida) : number_format($totalsaida, 2, ',', '.'); ?></th>
                <th><?= 'R$ ' . number_format($valorvenda, 2, ',', '.') ?></th>
                <th><?= (fmod($totaldev, 1) == 0) ? intval($totaldev) : number_format($totaldev, 2, ',', '.'); ?></th>
                <th><?= 'R$ ' . number_format($valordev, 2, ',', '.') ?></th>
                <th><?= (fmod($qtdtotalgeral, 1) == 0) ? intval($qtdtotalgeral) : number_format($qtdtotalgeral, 2, ',', '.'); ?></th>
                <th><?= 'R$ ' . number_format($vlrtotalgeral, 2, ',', '.') ?></th>
                <th><?= 'R$ ' . number_format($custototal, 2, ',', '.') ?></th>
                <th><?= 'R$ ' . number_format($lucrototal, 2, ',', '.') ?></th>

            </tr>
        </table>
    </body>
</html>



<?php
if ($_POST['arq'] == 'PDF') :
    require_once("../../_inc/mpdf/vendor/autoload.php");
    ini_set("pcre.backtrack_limit", "500000000000000");

    $mpdf = new \Mpdf\Mpdf([
        'margin_top' => 5,
        'margin_left' => 5,
        'margin_right' => 5,
        'mirrorMargins' => true,
        'default_font_size' => 12,
        'format' => 'A4-L'
    ]);
//$mpdf->SetWatermarkText('DRAFT');
    $mpdf->keep_table_proportions = true;
    $mpdf->allow_charset_conversion = true;
    $footer = "<table width = \"1000\">
                   <tr>
                     <td style='font-size: 10px; bottom:-15px;' align=\"right\">Pag: {PAGENO} de {nb} " . date('d/m/Y') . "</td>
                   </tr>
                 </table>";
    $mpdf->SetHTMLFooter($footer);
    $html = ob_get_clean();
    $mpdf->SetTitle('Movimentações');
    $mpdf->WriteHTML($html);
    $mpdf->Output();
// imprime

    exit();
elseif ($_POST['arq'] == 'EXCEL') :
    $nomeFile = Empresa($empresa) . '_' . parseDate($_POST['datai'], "dmY") . 'a' . parseDate($_POST['dataf'], "dmY");
    $file = $nomeFile . '.xls';
    header("Content-Type: application/vnd.ms-excel; charset=UTF-8");
    header("Content-Disposition: attachment; filename=\"{$file}\"");
    header("Content-Description: PHP Generated Data");
    echo "\xEF\xBB\xBF"; // Adiciona o BOM UTF-8
else :
    echo '';
endif;
?>