<?php
ob_start();
?>
<html>
    <head>
        <title> Registro Saídas </title>
        <style>
            @import "../../../_frontend/_layout/assets/vendor/bootstrap/css/bootstrap.min.css";

            table {
                /*border-collapse: collapse;*/
                border : 1px solid #000;
            }
            thead {
                vertical-align: bottom;
                text-align: center;
                font-weight: bold;
            }
            tfoot {
                text-align: center;
                font-weight: bold;
            }
            th {
                text-align: left;
                padding-left: 0.35em;
                padding-right: 0.35em;
                padding-top: 0.35em;
                padding-bottom: 0.35em;
                vertical-align: top;
            }
            td {
                padding-left: 0.50em;
                padding-right: 0.50em;
                padding-top: 0.50em;
                padding-bottom: 0.50em;
                line-height: 1.50em;
                vertical-align: top;
            }

        </style>
    </head>
    <body>
        <?php
        date_default_timezone_set("Brazil/East");
        require_once("../../../functions.php");
        require_once "../../../_backend/_class/Conexao_class.php";
        require_once "../../../_backend/_class/Crud_class.php";
        require_once "../../../_backend/_class/parametros.php";
        require_once "../../../_backend/_class/Emitente_class.php";

        function Especie($valor) {
            switch ($valor) :
                case '55' :
                    return 'NFe';
                    break;
                case '65' :
                    return 'NFCe';
                    break;
                case '57' :
                    return 'CTe';
                    break;
                case '06' :
                    return 'NF/CEE';
                    break;
                case '22' :
                    return 'NFST';
                    break;
                case '51' :
                    return 'NFS';
                    break;
                default :
                    return $valor;
                    break;
            endswitch;
        }

        function Aliq($icms, $total) {
            $aliq = ($icms * 100) / $total;
            if ($aliq > 0) :
                $aliq = intval($aliq);
            else :
                $aliq = 0;
            endif;
            return number_format($aliq, 2, ',', '.');
        }

        $datai = $_POST['datai'];
        $dataf = $_POST['dataf'];
        $_POST['datai'] = parseDate($_POST['datai'], 'Y-m-d');
        $_POST['dataf'] = parseDate($_POST['dataf'], 'Y-m-d');
        ?>

        <table class="table table-bordered" style="font-size: 10px; padding: 10px">
            <tr> 
                <th colspan="11">REGISTROS DE SAÍDAS </th>
                <th colspan="3" align="right">MODELO - P2A</th>
            </tr>
            <tr> 
                <td colspan="14">
                    FIRMA:  &nbsp;&nbsp;<?= $emitente->xNome ?>
                    <Br/>
                    INSC. EST.:  &nbsp;&nbsp;<?= $emitente->IE ?> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;  
                    CNPJ (MF):  &nbsp;&nbsp;<?= $emitente->CNPJ ?><br/>
                    LIVRO:  &nbsp;&nbsp; <?= $_POST['livro'] ?> 
                    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 
                    FOLHA:  &nbsp;&nbsp; <?= $_POST['folha'] ?>
                    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 
                    MÊS OU PERÍODO/ANO: &nbsp;&nbsp;
                    <?= $datai ?>&nbsp;&nbsp; à &nbsp;&nbsp; <?= $dataf ?>
                </td>

            </tr>
            <tr>
                <th colspan="5" class="text-center">DOCUMENTO FISCAIS</th>
                <th></th>
                <th colspan="2" class="text-center">CODIFICAÇÃO</th>
                <th colspan="5" class="text-center">VALORES FISCAIS </th>
                <th></th>
            </tr>
            <tr>
                <th></th>
                <th></th>
                <th></th>
                <th></th>
                <th>UF</th>
                <th></th>
                <th colspan="2"></th>
                <th colspan="3">OPERAÇÕES COM DÉBITO DO IMPOSTO</th>
                <th colspan="2">OPERAÇÕES S/DÉBITO DO IMPOSTO</th>
                <th></th>
            </tr>

            <tr>
                <th><br/>ESPÉCIE</th>
                <th><br/>SÉRIE</th>
                <th><br/>NÚMERO</th>
                <th><br/>DATA DO DOC.</th>
                <th><br/>DEST</th>
                <th><br/>VALOR CONTÁBIL</th>
                <th><br/>CONTÁBIL</th>
                <th><br/>FISCAL</th>
                <th>BASE DE CÁLCULO <br/>
                    VALOR DA OPERAÇÃO                        
                </th>
                <th><br/>ALÍQ.</th>
                <th><br/>IMPOSTO DEBITADO</th>
                <th><br/>ISENTAS OU NÃO TRIBUTADAS</th>
                <th><br/>OUTRAS</th>
                <th><br/>OBSERVAÇÕES</th>                
            </tr>

            <?php
            $pdo = Conexao::getInstance();
            $crud = Crud::getInstance($pdo, 'nfe');
            $sql = "SELECT * from nfe";
            if($_POST['datarel'] == 'E') :
              $sql .= ' WHERE str_to_date(dhEmi, "%d/%m/%Y") BETWEEN "' . $_POST['datai'] . '" AND "' . $_POST['dataf'] . '"  '; 
            else :
              $sql .= ' WHERE str_to_date(dhSaiEnt, "%d/%m/%Y") BETWEEN "' . $_POST['datai'] . '" AND "' . $_POST['dataf'] . '"  ';    
            endif;        
            
            $sql .= " AND tipo = 'saida' AND tpNF  = '1'";
            $sql .= " AND empresa = '" . $_SESSION['Empresa'] . "'";
            $sql .= " AND ((status = '100') or (status = '999'))";
            
            if ($_POST['modelo'] != 'T') :
                $sql .= ' AND modelo = "' . $_POST['modelo'] . '" ';
            endif;
            
               if (!empty($_POST['usuario'])) :
                $sql .= ' AND usuario = "' . $_POST['usuario'] . '" ';
            endif;

            $sql .= " order by STR_TO_DATE(dhEmi, '%d/%m/%Y'), nNF";
            $arrayParam = '';
            $dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);
            $total = 0;
            $totalBc = 0;
            $totalIcms = 0;
            $totalisentas = 0;

            $totalpis = 0;
            $totalcofins = 0;
//                    echo $sql;
            foreach ($dados as $dados) :
                $total = $total + $dados->vNF;
                ?>
                <tr>
                    <td><?= Especie($dados->modelo) ?></td>
                    <td><?= $dados->serie ?></td>
                    <td><?= $dados->nNF ?></td>
                    <td><?= $dados->dhEmi ?></td>
                    <td><?= $dados->destUF ?></td>
                    <td><?= number_format($dados->vNF, 2, ',', '.') ?></td>
                    <td></td>

                    <?php
                    $sql = "SELECT CSTPIS,CFOP, pICMS, pIPI, sum(valortotal) as valortotal,  sum(vDesc) as vDesc,
                        sum(vBC) as vBC, sum(vBCIPI) as vBCIPI, sum(vICMS) as vICMS, sum(vIPI) as vIPI 
                        from produtonfe where NFe = '$dados->id' ";
                    $sql .= " GROUP BY CFOP, pICMS, CSTPIS";
                    $arrayParam = '';
                    $prodnfe = $crud->getSQLGeneric($sql, $arrayParam, TRUE);
                    ?>

                    <td>   
                        <?php
                        foreach ($prodnfe as $prodnfe1) :
                            ?>
                            <?= $prodnfe1->CSTPIS ?>-
                            <?= $prodnfe1->CFOP ?> <br/>

                            <?php
                        endforeach;
                        ?>
                    </td>                       

                    <td>   
                        <?php
                        foreach ($prodnfe as $prodnfe1) :
                            $totalBc = $totalBc + $prodnfe1->vBC;
                            ?>
                            <?= number_format($prodnfe1->vBC, 2, ',', '.') ?> <br/>

                            <?php
                        endforeach;
                        ?>
                    </td>

                    <td>   
                        <?php
                        foreach ($prodnfe as $prodnfe1) :
                            ?>
                            <?= $prodnfe1->pICMS ?> <br/>

                            <?php
                        endforeach;
                        ?>
                    </td>

                    <td>   
                        <?php
                        foreach ($prodnfe as $prodnfe1) :
                            $totalIcms = $totalIcms + $prodnfe1->vICMS;
                            ?>
                            <?= number_format($prodnfe1->vICMS, 2, ',', '.') ?> <br/>

                            <?php
                        endforeach;
                        ?>
                    </td>

                    <td>   
                        <?php
                        foreach ($prodnfe as $prodnfe1) :
                            if ($prodnfe1->valortotal > 0) :
                                $totalisentas = $totalisentas + ($prodnfe1->valortotal - $prodnfe1->vBC);
//                                $totalisentas = $totalisentas + ($prodnfe1->valortotal - $prodnfe1->vDesc - $prodnfe1->vBC);
                                ?>
                                <?= number_format($prodnfe1->valortotal - $prodnfe1->vBC, 2, ',', '.') ?> <br/>
                                <?php
                            else :
                                echo '0,00';
                            endif;
                            ?>

                            <?php
                        endforeach;
                        ?>
                    </td>

                    <td>
                        0,00
                    </td>


                    <td>   
                        <?php
                        foreach ($prodnfe as $prodnfe1) :
                            if ($prodnfe1->vIPI > 0) :
                                echo 'IPI :' . number_format($prodnfe1->vIPI, 2, ',', '.');
                            else :
                                echo '<br/>';
                            endif;
                        endforeach;

                        if ($dados->vCOFINSnf > 0) :
                            $totalcofins = $totalcofins + $dados->vCOFINSnf;
                            echo 'COFINS :' . number_format($dados->vCOFINSnf, 2, ',', '.');
                            echo '<br/>';
                        endif;

                        if ($dados->vPISnf > 0) :
                            $totalpis = $totalpis + $dados->vPISnf;
                            echo 'PIS :' . number_format($dados->vPISnf, 2, ',', '.');
                        endif;
                        ?>
                    </td>

                </tr>

                <?php
            endforeach;
            ?>

            <tr>
                <th></th>
                <th></th>
                <th></th>
                <th></th>
                <th></th>
                <th><?= number_format($total, 2, ',', '.') ?></th>
                <th></th>
                <th></th>
                <th><?= number_format($totalBc, 2, ',', '.') ?></th>
                <th></th>
                <th><?= number_format($totalIcms, 2, ',', '.') ?></th>
                <th><?= number_format($totalisentas, 2, ',', '.') ?></th>                
                <th></th>                
                <th></th>                
            </tr>
        </table>
        

Total Cofins : <?= $totalcofins ?> | 
Total Pis : <?= $totalpis ?>

    </body>
    
</html>




<?php
$nomeArquivo = 'Saidas_' . $_POST['datai'] . '_' . $_POST['dataf'] . '.pdf';
if ($_POST['modelo'] !== 'T') {
    $nomeArquivo = 'Saidas_' . Especie($_POST['modelo']) . '_' . $_POST['datai'] . '_' . $_POST['dataf'] . '.pdf';
}

if ($_POST['arq'] == 'PDF') :
    require_once("../../_inc/mpdf/vendor/autoload.php");
    ini_set("pcre.backtrack_limit", "500000000000000");

    $mpdf = new \Mpdf\Mpdf([
        'margin_top' => 5,
        'margin_left' => 5,
        'margin_right' => 5,
        'mirrorMargins' => true,
        'default_font_size' => 10,
        'format' => 'A4-L',
        'default_font' => 'sans-serif',
    ]);
//$mpdf->SetWatermarkText('DRAFT');
    $mpdf->keep_table_proportions = true;
    $mpdf->allow_charset_conversion = true;
    $footer = "<table width = \"1000\">
                   <tr>
                     <td style='font-size: 10px; bottom:-15px;' align=\"right\">Pag: {PAGENO} de {nb} | <strong> Impresso: " . date('d/m/Y H:i') . " </strong></td>
                   </tr>
                 </table>";
    $mpdf->SetHTMLFooter($footer);
    $html = ob_get_clean();
    $mpdf->SetTitle('Movimentações');
    $mpdf->WriteHTML($html);
    $mpdf->Output($nomeArquivo, 'I');
// imprime
    exit();

elseif ($_POST['arq'] == 'EXCEL') :
    $file = 'registro-p1a.xls';
    header("Content-type: application/x-msexcel");
    header("Content-Disposition: attachment; filename=\"{$file}\"");
    header("Content-Description: PHP Generated Data");
endif;
?>
