<?php
ob_start();
?>
<html>
    <head>
        <title> Registro Inventário </title>
        <style>
            @import "../../../_frontend/_layout/assets/vendor/bootstrap/css/bootstrap.min.css";

            table {
                /*border-collapse: collapse;*/
                border : 1px solid #000;
            }
            thead {
                vertical-align: bottom;
                text-align: center;
                font-weight: bold;
            }
            tfoot {
                text-align: center;
                font-weight: bold;
            }
            th {
                text-align: left;
                padding-left: 0.35em;
                padding-right: 0.35em;
                padding-top: 0.35em;
                padding-bottom: 0.35em;
                vertical-align: top;
            }
            td {
                padding-left: 0.50em;
                padding-right: 0.50em;
                padding-top: 0.50em;
                padding-bottom: 0.50em;
                line-height: 1.50em;
                vertical-align: top;
            }

        </style>
    </head>
    <body>
        <?php
        date_default_timezone_set("Brazil/East");
        require_once("../../../functions.php");
        require_once "../../../_backend/_class/Conexao_class.php";
        require_once "../../../_backend/_class/Crud_class.php";
        require_once "../../../_backend/_class/parametros.php";
        require_once "../../../_backend/_class/Emitente_class.php";


function TribNCM($produto, $empresa) {
     $pdo = Conexao::getInstance();
            $crud = Crud::getInstance($pdo, 'nfe');
            $sql = "SELECT ncm from tributacaoprodutos where produto = '$produto'";
            $sql .= " AND empresa = '" . $empresa . "'";
            $arrayParam = '';

            $dados = $crud->getSQLGeneric($sql, $arrayParam, false);
            
            return $dados->ncm;
}

        function Especie($valor) {
            switch ($valor) :
                case '55' :
                    return 'NFe';
                    break;
                case '65' :
                    return 'NFCe';
                    break;
                case '57' :
                    return 'CTe';
                    break;
                case '06' :
                    return 'NF/CEE';
                    break;
                case '22' :
                    return 'NFST';
                    break;
                case '51' :
                    return 'NFS';
                    break;
                default :
                    return $valor;
                    break;
            endswitch;
        }

        function Aliq($icms, $total) {
            $aliq = ($icms * 100) / $total;
            if ($aliq > 0) :
                $aliq = intval($aliq);
            else :
                $aliq = 0;
            endif;
            return number_format($aliq, 2, ',', '.');
        }

//        $datai = $_POST['datai'];
//        $dataf = $_POST['dataf'];
//        $_POST['datai'] = parseDate($_POST['datai'], 'Y-m-d');
//        $_POST['dataf'] = parseDate($_POST['dataf'], 'Y-m-d');
        ?>

        <table class="table table-bordered" style="font-size: 10px; padding: 10px">
            <tr> 
                <th colspan="6">LIVRO REGISTRO DE INVENTÁRIO - RI - MODELO P7 </th>
            </tr>
            <tr> 
                <td colspan="6">
                    FIRMA:  &nbsp;&nbsp;<?= $emitente->xNome ?>
                    <Br/>
                    INSC. EST.:  &nbsp;&nbsp;<?= $emitente->IE ?> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;  
                    CNPJ (MF):  &nbsp;&nbsp;<?= $emitente->CNPJ ?><br/>
                    FOLHA:  &nbsp;&nbsp; 2
                    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 
                    ESTOQUES EXISTENTES EM: &nbsp;&nbsp; <?= $_GET['data'] ?>
                </td>

            </tr>

            <tr>
                <th align="center">CLASSIFICAÇÃO </th>
                <th align="center">CODIGO </th>
                <th align="center">DISCRIMINAÇÃO</th>
                <th align="center">UNIDADE</th>
                <th align="center">QUANTIADE</th>
                <th align="center" colspan="2">VALORES</th>
            </tr>
            <tr>
                <th align="center">FISCAL</th>
                <th></th>
                <th></th>
                <th></th>
                <th></th>
                <th align="center">UNITÁRIO</th>
                <th align="center">TOTAL</th>
            </tr>



            <?php
            $pdo = Conexao::getInstance();
            $crud = Crud::getInstance($pdo, 'nfe');
            $sql = "SELECT produto, descricao, unidade, ref, sum(qtdsaida) as qtdsaida, 
                sum(qtdentrada) as qtdentrada, data, ncm, sum(totalsaida) as totalsaida,
                sum(totalentrada) as totalentrada,
                empresa from temp_inventario";
            $sql .= " WHERE empresa = '" . $_SESSION['Empresa'] . "'";

            $sql .= " Group by produto order by descricao";
            $arrayParam = '';

            $dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);
            $i = 1;
            foreach ($dados as $dados) :
                $qtd = $dados->qtdentrada - $dados->qtdsaida;
                $qtd = number_format($qtd, 3, '.', '');
//                $precomediototal = $dados->totalentrada - $dados->totalsaida;
                $precomedio = $dados->totalentrada / $dados->qtdentrada;
                $total = $qtd * $precomedio;
                $precomediov = number_format($precomedio, 6, ',', '.');
                
                $precocorrigio = substr($precomediov, -4);
                
                // $qtd = number_format($qtd, 3, ',', '.');

                if ($precocorrigio == '0000') :
                    $precomedio = number_format($precomedio, 2, ',', '.');
                else :
                    $precomedio = number_format($precomedio, 6, ',', '.');
                endif;

                if ($qtd > 0) :
                    $qtdtotal = $qtdtotal + $qtd;
                    $totalinventaro = $totalinventaro + $total;
                    //TribNCM($dados->produto, $_SESSION['Empresa'])
                    ?>
                    <tr>
                        <th></th>
                        <th><?= $dados->produto ?></th>
                        <th><?= $dados->descricao ?></th>
                        <th><?= $dados->unidade ?></th>
                        <th><?= $qtd ?></th>
                        <th><?= $precomedio ?></th>
                        <th><?= number_format($total, 2, ',', '.') ?></th>
                    </tr>
                    <?php
                    $i += 1;
                endif;
            endforeach;
//            echo $sql;
//
            ?>

            <tr>
                <th colspan="5">TOTAIS</th>
                <th><?= number_format($qtdtotal, 2, ',', '.') ?></th>
                <th><?= number_format($totalinventaro, 2, ',', '.') ?></th>
            </tr>     
        </table>
    </body>
</html>



<?php
if ($_GET['arq'] == 'PDF') :
    require_once("../../_inc/mpdf/vendor/autoload.php");
    ini_set("pcre.backtrack_limit", "500000000000000");

    $mpdf = new \Mpdf\Mpdf([
        'margin_top' => 5,
        'margin_left' => 5,
        'margin_right' => 5,
        'mirrorMargins' => true,
        'default_font_size' => 10,
        'format' => 'A4-L',
        'default_font' => 'sans-serif',
    ]);
//$mpdf->SetWatermarkText('DRAFT');
    $mpdf->keep_table_proportions = true;
    $mpdf->allow_charset_conversion = true;
    $footer = "<table width = \"1000\">
                   <tr>
                     <td style='font-size: 10px; bottom:-15px;' align=\"right\">Pag: {PAGENO} de {nb} | <strong> Impresso: " . date('d/m/Y H:i') . " </strong></td>
                   </tr>
                 </table>";
    $mpdf->SetHTMLFooter($footer);
    $html = ob_get_clean();
    $mpdf->SetTitle('Movimentações');
    $mpdf->WriteHTML($html);
    //primeiro coloca o nome, depois como quer que o PDF seja exibido, I - no navegador | D - Download direto
    $mpdf->Output('inventarioP7.pdf', 'I');
// imprime
    exit();

elseif ($_GET['arq'] == 'Excel' || $_GET['arq'] == 'EXCEL') :
    $file = 'registro-p1a.xls';
    header("Content-type: application/x-msexcel");
    header("Content-Disposition: attachment; filename=\"{$file}\"");
    header("Content-Description: PHP Generated Data");
endif;
?>
