<?php
ob_start();
?>
<html>
    <head>
        <title> Registro Entradas </title>
        <style>
            @import "../../../_frontend/_layout/assets/vendor/bootstrap/css/bootstrap.min.css";

            table {
                /*border-collapse: collapse;*/
                border : 1px solid #000;
            }
            thead {
                vertical-align: bottom;
                text-align: center;
                font-weight: bold;
            }
            tfoot {
                text-align: center;
                font-weight: bold;
            }
            th {
                text-align: left;
                padding-left: 0.35em;
                padding-right: 0.35em;
                padding-top: 0.35em;
                padding-bottom: 0.35em;
                vertical-align: top;
            }
            td {
                padding-left: 0.50em;
                padding-right: 0.50em;
                padding-top: 0.50em;
                padding-bottom: 0.50em;
                line-height: 1.50em;
                vertical-align: top;
            }

        </style>
    </head>
    <body>
        <?php
        date_default_timezone_set("Brazil/East");
        require_once("../../../functions.php");
        require_once "../../../_backend/_class/Conexao_class.php";
        require_once "../../../_backend/_class/Crud_class.php";
        require_once "../../../_backend/_class/parametros.php";
        require_once "../../../_backend/_class/Emitente_class.php";

        function Especie($valor) {
            switch ($valor) :
                case '55' :
                    return 'NFe';
                    break;
                case '65' :
                    return 'NFCe';
                    break;
                case '57' :
                    return 'CTe';
                    break;
                case '06' :
                    return 'NF/CEE';
                    break;
                case '22' :
                    return 'NFST';
                    break;
                case '51' :
                    return 'NFS';
                    break;
                default :
                    return $valor;
                    break;
            endswitch;
        }

        function Aliq($icms, $total) {
            $aliq = ($icms * 100) / $total;
            if ($aliq > 0) :
                $aliq = intval($aliq);
            else :
                $aliq = 0;
            endif;
            return number_format($aliq, 2, ',', '.');
        }

        $datai = $_POST['datai'];
        $dataf = $_POST['dataf'];
        $_POST['datai'] = parseDate($_POST['datai'], 'Y-m-d');
        $_POST['dataf'] = parseDate($_POST['dataf'], 'Y-m-d');
        ?>

        <table class="table table-bordered" style="font-size: 10px; padding: 10px">
            <tr> 
                <th colspan="12">REGISTROS DE ENTRADAS </th>
                <th colspan="3">(a) CÓDIGO DE VALORES FISCAIS</th>
            </tr>
            <tr> 
                <td colspan="12">
                    FIRMA:  &nbsp;&nbsp;<?= $emitente->xNome ?>
                    <Br/>
                    INSC. EST.:  &nbsp;&nbsp;<?= $emitente->IE ?> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;  
                    CNPJ (MF):  &nbsp;&nbsp;<?= $emitente->CNPJ ?><br/>
                    LIVRO:  &nbsp;&nbsp; 0 
                    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 
                    FOLHA:  &nbsp;&nbsp; 1
                    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 
                    MÊS OU PERÍODO/ANO: &nbsp;&nbsp;
                    <?= $datai ?>&nbsp;&nbsp; à &nbsp;&nbsp; <?= $dataf ?>
                </td>
                <td colspan="3">
                    1 – OPERAÇÕES COM CRÉDITO DO IMPOSTO<br/>
                    2 – OPER. SEM CRÉDITO DO IMPOSTO – ISENTAS OU NÃOTRIBUTADAS<br/>
                    3 – OPER. SEM CRÉDITO DE IMPOSTO – OUTRAS

                </td>
            </tr>

            <tr>
                <th class="text-center">DATA DE </th>
                <th colspan="6" class="text-center">DOCUMENTO FISCAIS</th>
                <th></th>
                <th colspan="2" class="text-center">CODIFICAÇÃO</th>
                <th colspan="4" class="text-center">VALORES FISCAIS </th>
                <th></th>
            </tr>

            <tr>
                <th><br/>ENTRADA</th>
                <th><br/>ESPÉCIE</th>
                <th><br/>SÉRIE</th>
                <th><br/>NÚMERO</th>
                <th><br/>DATA DO DOC.</th>
                <th><br/>CÓDIGO EMITENTE</th>
                <th><br/>UF ORI</th>
                <th><br/>VALOR CONTÁBIL</th>
                <th><br/>CONTÁBIL</th>
                <th><br/>FISCAL</th>
                <th><br/>CÓD. (a)</th>
                <th>BASE DE CÁLCULO <br/>
                    VALOR DA OPERAÇÃO                        
                </th>
                <th><br/>ALÍQ.</th>
                <th><br/>IMPOSTO CREDITADO</th>
                <th><br/>OBSERVAÇÕES</th>                
            </tr>

            <?php
            $pdo = Conexao::getInstance();
            $crud = Crud::getInstance($pdo, 'nfe');
            $sql = "SELECT * from nfe";

            if ($_POST['tipodata'] == 'E') :
                $sql .= " WHERE STR_TO_DATE(dhEmi, '%d/%m/%Y') BETWEEN  '{$_POST['datai']}' AND '{$_POST['dataf']}' ";
            elseif ($_POST['tipodata'] == 'S') :
                $sql .= " WHERE STR_TO_DATE(dhSaiEnt, '%d/%m/%Y') BETWEEN  '{$_POST['datai']}' AND '{$_POST['dataf']}'";
            else :
                $sql .= " WHERE ((STR_TO_DATE(dhEmi, '%d/%m/%Y') BETWEEN  '{$_POST['datai']}' AND '{$_POST['dataf']}') OR (STR_TO_DATE(dhSaiEnt, '%d/%m/%Y') BETWEEN  
                '{$_POST['datai']}' AND '{$_POST['dataf']}')) ";
            endif;

            $sql .= " AND ((tipo = 'Entrada') or (tpNF = '0'))";
            $sql .= " AND empresa = '" . $_SESSION['Empresa'] . "'";
            
            $sql .= " AND (nfe.status != '')";

            if ($_POST['modelo'] != 'T') :
                $sql .= ' AND modelo = "' . $_POST['modelo'] . '" ';
            endif;

            $sql .= " order by STR_TO_DATE(dhEmi, '%d/%m/%Y')";
            $arrayParam = '';
            $dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);
            $total = 0;
            $totalBc = 0;
            $totalIcms = 0;
            $qtdNfe = 0;
            foreach ($dados as $dados) :
                $qtdNfe++;
                $total = $total + $dados->vNF;
                ?>
                <tr>
                    <td><?= $dados->dhEmi ?></td>
                    <td><?= Especie($dados->modelo) ?></td>
                    <td><?= $dados->serie ?></td>
                    <td><?= $dados->nNF ?></td>
                    <td><?= $dados->dhEmi ?></td>
                    <td><?= $dados->destCNPJ ?> - <?= $dados->destxNome ?></td>
                    <td><?= $dados->destUF ?></td>
                    <td><?= number_format($dados->vNF, 2, ',', '.') ?></td>
                    <td></td>

                    <?php
                    $sql = "SELECT CFOP, pICMS, pIPI, 
                        sum(vBC) as vBC, sum(vBCIPI) as vBCIPI, sum(vICMS) as vICMS, sum(vIPI) as vIPI ,  sum(vCOFINS) as vCOFINS 
                        from produtonfe where NFe = '$dados->id' ";
                    $sql .= " GROUP BY CFOP, pICMS";
                    $arrayParam = '';
                    $prodnfe = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

                    if (count($prodnfe) > 0) :
                        ?>

                        <td>   
                            <?php
                            foreach ($prodnfe as $prodnfe1) :
                                ?>
                                <?= $prodnfe1->CFOP ?> <br/>

                                <?php
                            endforeach;
                            ?>
                        </td>

                        <td>   
                            <?php
                            foreach ($prodnfe as $prodnfe1) :

                                if ($prodnfe1->vICMS > 0) :
                                    echo '1';
                                    echo '<br/>';
                                else :
                                    echo '2';
                                    echo '<br/>';

                                endif;
                                ?>                          
                                <?php
                            endforeach;
                            ?>
                        </td>

                        <td>   
                            <?php
                            foreach ($prodnfe as $prodnfe1) :
                                $totalBc = $totalBc + $prodnfe1->vBC;
                                ?>
                                <?= number_format($prodnfe1->vBC, 2, ',', '.') ?> <br/>

                                <?php
                            endforeach;
                            ?>
                        </td>

                        <td>   
                            <?php
                            foreach ($prodnfe as $prodnfe1) :
                                ?>
                                <?= $prodnfe1->pICMS ?> <br/>

                                <?php
                            endforeach;
                            ?>
                        </td>

                        <td>   
                            <?php
                            foreach ($prodnfe as $prodnfe1) :
                                $totalIcms = $totalIcms + $prodnfe1->vICMS;
                                ?>
                                <?= number_format($prodnfe1->vICMS, 2, ',', '.') ?> <br/>

                                <?php
                            endforeach;
                            ?>
                        </td>
                        <td>   
                            <?php
                            foreach ($prodnfe as $prodnfe1) :
                                if ($prodnfe1->vIPI > 0) :
                                    echo 'IPI :' . number_format($prodnfe1->vIPI, 2, ',', '.');
                                    echo '<br/>';
                                else :
                                    echo '<br/>';
                                endif;

                            endforeach;
                            ?>
                        </td>

                        <?php
                    else :
                        $totalBc = $totalBc + $dados->vBCnf;
                        $totalIcms = $totalIcms + $dados->vICMSnf;
                        ?>
                        <td><?= $dados->CFOP ?></td>
                        <td>
                            <?php
                            if ($dados->vICMSnf > 0) :
                                echo '1';
                            else :
                                echo '2';
                            endif;
                            ?>
                        </td>
                        <td><?= number_format($dados->vBCnf, 2, ',', '.') ?></td>
                        <td><?= Aliq($dados->vICMSnf, $dados->vBCnf) ?></td>
                        <td><?= number_format($dados->vICMSnf, 2, ',', '.') ?></td>
                        <td></td>
                    <?php
                    endif;
                    ?>
                </tr>

                <?php
            endforeach;
            ?>

            <tr>
                <th></th>
                <th></th>
                <th></th>
                <th></th>
                <th></th>
                <th></th>
                <th></th>
                <th><?= number_format($total, 2, ',', '.') ?></th>
                <th></th>
                <th></th>
                <th></th>
                <th><?= number_format($totalBc, 2, ',', '.') ?></th>
                <th></th>
                <th><?= number_format($totalIcms, 2, ',', '.') ?></th>
                <th>        Total de <?= $qtdNfe ?> Notas Fiscais.
                </th>                
            </tr>
        </table>

    </body>
</html>




<?php
$nomeArquivo = 'Entradas_' . $_POST['datai'] . '_' . $_POST['dataf'] . '.pdf';
if ($_POST['modelo'] !== 'T') {
    $nomeArquivo = 'Entradas_' . Especie($_POST['modelo']) . '_' . $_POST['datai'] . '_' . $_POST['dataf'] . '.pdf';
}

if ($_POST['arq'] == 'PDF') :
    require_once("../../_inc/mpdf/vendor/autoload.php");
    ini_set("pcre.backtrack_limit", "500000000000000");

    $mpdf = new \Mpdf\Mpdf([
        'margin_top' => 5,
        'margin_left' => 5,
        'margin_right' => 5,
        'mirrorMargins' => true,
        'default_font_size' => 10,
        'format' => 'A4-L',
        'default_font' => 'sans-serif',
    ]);
//$mpdf->SetWatermarkText('DRAFT');
    $mpdf->keep_table_proportions = true;
    $mpdf->allow_charset_conversion = true;
    $footer = "<table width = \"1000\">
                   <tr>
                     <td style='font-size: 10px; bottom:-15px;' align=\"right\">Pag: {PAGENO} de {nb} | <strong> Impresso: " . date('d/m/Y H:i') . " </strong></td>
                   </tr>
                 </table>";
    $mpdf->SetHTMLFooter($footer);
    $html = ob_get_clean();
    $mpdf->SetTitle('Movimentações');
    $mpdf->WriteHTML($html);
    $mpdf->Output($nomeArquivo, 'I');
// imprime
    exit();

elseif ($_POST['arq'] == 'EXCEL') :
    $file = 'registro-p1a.xls';
    header("Content-type: application/x-msexcel");
    header("Content-Disposition: attachment; filename=\"{$file}\"");
    header("Content-Description: PHP Generated Data");
endif;
?>
