<?php
ob_start();
date_default_timezone_set("Brazil/East");
require_once("../../../functions.php");
//
require_once "../../../_backend/_class/Conexao_class.php";
require_once "../../../_backend/_class/Crud_class.php";
require_once "../../../_backend/_class/parametros.php";
?>

<html>
    <head>
        <title> Rastreio de produtos  ( <?= $_POST['produto'] ?> )</title>
        <style>

            table {
                border-collapse: collapse;
            }
            thead {
                vertical-align: bottom;
                text-align: center;
                font-weight: bold;
            }
            tfoot {
                text-align: center;
                font-weight: bold;
            }
            th {
                text-align: left;
                padding-left: 0.35em;
                padding-right: 0.35em;
                padding-top: 0.35em;
                padding-bottom: 0.35em;
                vertical-align: top;
            }
            td {
                padding-left: 0.35em;
                padding-right: 0.35em;
                padding-top: 0.35em;
                padding-bottom: 0.35em;
                vertical-align: top;
            }

            .page {
                width: 21cm;
                min-height: 29.7cm;
                padding: 2cm;
                margin: 1cm auto;
                border: 1px #D3D3D3 solid;
                border-radius: 5px;
                background: white;
                box-shadow: 0 0 5px rgba(0, 0, 0, 0.1);
            }
        </style>
        <?php
        if ($_POST['gerar'] != 'PDF') :
            ?>
            <link href="../../../_frontend/_layout/assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet" type="text/css"/>
            <?php
        endif;
        ?>
    </head>
    <body>


        <div align="center">
            FLUXO DE PRODUTO DA NOTA FISCAL
            <Br/> 
            PERÍODO: <?= $_POST['datai'] ?> À <?= $_POST['dataf'] ?>
            <br/>
            <?= $_POST['produto'] ?>
        </div>

        <table class="table table-condensed text-center" style="font-size: 12px; width: 100%; text-align: left">

            <tr>
                <td><b>Operação</b></td>
                <td><b>Modelo</b></td>
                <td><b>Data</b></td>
                <td><b>Numero</b></td>
                <td><b>CFOP</b></td>
                <td style="width: 50%"><b>Destinatário</b></td>
                <td><b>Quantidade</b></td>
                <td><b>Valor </b></td>
                <td><b>Total</b></td>
            </tr>


            <?php
            $data1 = parseDate($_POST['datai'], "Y-m-d");
            $data2 = parseDate($_POST['dataf'], "Y-m-d");

            $pdo = Conexao::getInstance();
            $crud = Crud::getInstance($pdo, 'nfe');
            $sql = "SELECT
                nfe.tipo,
    nfe.natOp, 
    nfe.nNF, 
    nfe.dhEmi, 
    nfe.modelo, 
    nfe.destCNPJ, 
    nfe.destxNome, 
    produtonfe.cProd, 
    produtonfe.xProd, 
    produtonfe.CFOP, 
    sum(produtonfe.qtd) as qtd, 
    produtonfe.vProd, 
    sum(produtonfe.valortotal) as valortotal 
FROM nfe
INNER JOIN produtonfe ON produtonfe.NFe = nfe.id";
            $sql .= ' WHERE str_to_date(nfe.dhEmi, "%d/%m/%Y") BETWEEN "' . $data1 . '" AND "' . $data2 . '"  ';
            $sql .= " AND nfe.empresa = '" . $_SESSION['Empresa'] . "'";
            $sql .= " AND produtonfe.cProd = '" . $_POST['produto'] . "'";
            $sql .= ' GROUP BY nfe.nNF, produtonfe.cProd ORDER BY str_to_date(nfe.dhEmi, "%d/%m/%Y")';

            echo $sql;
            $arrayParam = '';
            $dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);
            foreach ($dados as $dados) :
                ?>
                <tr>
                    <td><?= $dados->tipo ?></td>
                    <td><?= $dados->modelo ?></td>
                    <td><?= $dados->dhEmi ?></td>
                    <td><?= $dados->nNF ?></td>
                    <td><?= $dados->CFOP ?></td>
                    <td><?= $dados->destxNome ?></td>
                    <td><?= $dados->qtd ?></td>
                    <td>R$ <?= number_format($dados->vProd, 2, ',', '.') ?></td>
                    <td>R$ <?= number_format($dados->valortotal, 2, ',', '.') ?></td>
                </tr>
                <?php
            endforeach;
            ?>
        </table>

    </body>
</html>

<?php
if ($_POST['gerar'] == 'PDF') :
    ini_set("pcre.backtrack_limit", "500000000000000");
    require_once("../../_inc/mpdf/vendor/autoload.php");
    $mpdf = new \Mpdf\Mpdf([
        'margin_top' => 5,
        'margin_left' => 5,
        'margin_right' => 5,
        'mirrorMargins' => true,
        'default_font_size' => 12,
        'format' => 'A4-L'
    ]);
    $mpdf->keep_table_proportions = true;
    $mpdf->allow_charset_conversion = true;
    $footer = "<table width = \"1000\">
                   <tr>
                     <td style='font-size: 10px; bottom:-15px;' align=\"right\">Pag: {PAGENO} de {nb} " . date('d/m/Y') . "</td>
                   </tr>
                 </table>";
    $mpdf->SetHTMLFooter($footer);
    $html = ob_get_clean();
    $mpdf->SetTitle('Estoque');
    $mpdf->WriteHTML($html);
    $mpdf->Output();
// imprime

    exit();
endif;
?>
