<?php
ob_start();

date_default_timezone_set("Brazil/East");
require_once("../../../functions.php");
//
require_once "../../../_backend/_class/Conexao_class.php";
require_once "../../../_backend/_class/Crud_class.php";
require_once "../../../_backend/_class/parametros.php";

// error_reporting(E_ALL);
// ini_set('display_errors', 'On');

function sortFunction($a, $b) {
    return strtotime($a["data"]) - strtotime($b["data"]);
}


$inicio = parseDate($_POST['datai'], "Y-m-d");
$fim = parseDate($_POST['dataf'], "Y-m-d");


//SAIDA

// <td><b>Documento</b></td>
// <td><b>Data</b></td>
// <td><b>Vendedor</b></td>
// <td><b>Quantidade</b></td>

$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'cliente');
$data = date("d/m");
$sql = 'SELECT 
    movimentacao.documento, 
    movimentacao.data, 
    movimentacao.doc_empresa,
    vendedor.xNome,
    vendedor.xFant,
    SUM(itmovimentacao.quantidade) AS quantidade_itens
FROM movimentacao 
LEFT JOIN itmovimentacao 
    ON itmovimentacao.documento = movimentacao.documento 
LEFT JOIN vendedor 
    ON movimentacao.vendedor = vendedor.vendedorid 
WHERE 
    STR_TO_DATE(movimentacao.data, "%d/%m/%Y") BETWEEN "' . $inicio . '" AND "' . $fim . '"
    AND movimentacao.empresa = "' . $_POST['empresa'] . '"
    AND movimentacao.situacao = "F"
    AND itmovimentacao.cancelado = "N"
GROUP BY 
    movimentacao.documento, 
    movimentacao.data, 
    movimentacao.doc_empresa,
    movimentacao.empresa
ORDER BY quantidade_itens desc';

$arrayParam = '';
$dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);
$totalsaida = count($dados);


$sql = 'SELECT emitente.xNome, emitente.xFant FROM emitente WHERE emitenteid = ' . $_POST['empresa'] . '';
$empresa = $crud->getSQLGeneric($sql, $arrayParam, false);

?>

<html>
    <head>
        <title> Quantidade Itens Vendas </title>
        <style>

            table {
                border-collapse: collapse;
            }
            thead {
                vertical-align: bottom;
                text-align: center;
                font-weight: bold;
            }
            tfoot {
                text-align: center;
                font-weight: bold;
            }
            th {
                text-align: left;
                padding-left: 0.35em;
                padding-right: 0.35em;
                padding-top: 0.35em;
                padding-bottom: 0.35em;
                vertical-align: top;
            }
            td {
                padding-left: 0.35em;
                padding-right: 0.35em;
                padding-top: 0.35em;
                padding-bottom: 0.35em;
                vertical-align: top;
            }

            .page {
                width: 21cm;
                min-height: 29.7cm;
                padding: 2cm;
                margin: 1cm auto;
                border: 1px #D3D3D3 solid;
                border-radius: 5px;
                background: white;
                box-shadow: 0 0 5px rgba(0, 0, 0, 0.1);
            }
        </style>
        <?php
        if ($_POST['gerar'] != 'PDF') :
            ?>
            <link href="../../../_frontend/_layout/assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet" type="text/css"/>
            <?php
        endif;
        ?>
    </head>
    <body>

        
        <div align="center">
                    QUANTIDADE DE ITENS POR VENDA
            <Br/> 
            PERÍODO: <?= $_POST['datai'] ?> À <?= $_POST['dataf'] ?>
            <br/>
            FILIAL:
            <?php if($empresa->xNome) :?>
                <td><?= $empresa->xNome ?></td>
            <?php else :?>
                <td><?= $empresa->xFant ?></td>
            <?php endif; ?>
            <br><br>
        </div>

        <table class="table table-condensed text-center" style="font-size: 12px; width: 100%; text-align: left">

            <tr>
                <td colspan="3"><b>Documento</b></td>
                <td colspan="3"><b>Data</b></td>
                <td colspan="3"><b>Vendedor</b></td>
                <td colspan="3"><b>Qtd. Itens</b></td>
            </tr>

            <?php 
            $itensTotais = 0;
            foreach ($dados as $venda) :
            ?>

            <tr>
                <td colspan="3"><?= $venda->doc_empresa ?></td>

                <td colspan="3"><?= $venda->data ?></td>

                <?php if($venda->xNome) :?>
                    <td colspan="3"><?= $venda->xNome ?></td>
                <?php else :?>
                    <td colspan="3"><?= $venda->xFant ?></td>
                <?php endif; ?>

                <td colspan="3"><?= intval($venda->quantidade_itens) ?></td>
            </tr>

            <?php 
            $itensTotais += $venda->quantidade_itens;
            endforeach;
            ?>

            <tr> 
                <td colspan="12"> <hr/> </td>
            </tr>
            <tr>
                <td colspan="10"> <b> TOTAL </b> </td>
                <td> <b> <?= $itensTotais ?> </b> </td>
            </tr>

        </table>


    </body>
</html>
<?php
if ($_POST['gerar'] == 'PDF') :
    ini_set("pcre.backtrack_limit", "500000000000000");
    require_once("../../_inc/mpdf/vendor/autoload.php");
    $mpdf = new \Mpdf\Mpdf([
        'margin_top' => 5,
        'margin_left' => 5,
        'margin_right' => 5,
        'mirrorMargins' => true,
        'default_font_size' => 12,
        'format' => 'A4'
    ]);
    $mpdf->keep_table_proportions = true;
    $mpdf->allow_charset_conversion = true;
    $footer = "<table width = \"1000\">
                   <tr>
                     <td style='font-size: 10px; bottom:-15px;' align=\"right\">Pag: {PAGENO} de {nb} " . date('d/m/Y') . "</td>
                   </tr>
                 </table>";
    $mpdf->SetHTMLFooter($footer);
    $html = ob_get_clean();
    $mpdf->SetTitle('Estoque');
    $mpdf->WriteHTML($html);
    $mpdf->Output();
// imprime

    exit();
endif;
?>