<?php
ob_start();
?>
<html>
    <head>
        <title> Relatório </title>
        <style>
            @import "../../../_frontend/_layout/assets/vendor/bootstrap/css/bootstrap.min.css";

            table {
                /*border-collapse: collapse;*/
                border : 1px solid #000;
            }
            thead {
                vertical-align: bottom;
                text-align: center;
                font-weight: bold;
            }
            tfoot {
                text-align: center;
                font-weight: bold;
            }
            th {
                text-align: left;
                padding-left: 0.35em;
                padding-right: 0.35em;
                padding-top: 0.35em;
                padding-bottom: 0.35em;
                vertical-align: top;
            }
            td {
                padding-left: 0.50em;
                padding-right: 0.50em;
                padding-top: 0.50em;
                padding-bottom: 0.50em;
                line-height: 1.50em;
                vertical-align: top;
            }

        </style>
    </head>
    <body>
        <?php
        date_default_timezone_set("Brazil/East");
        require_once("../../../functions.php");
        require_once "../../../_backend/_class/Conexao_class.php";
        require_once "../../../_backend/_class/Crud_class.php";
        require_once "../../../_backend/_class/parametros.php";
        require_once "../../../_backend/_class/Emitente_class.php";

//error_reporting(E_ALL);
//ini_set('display_errors', 'On');
        function Especie($valor) {
            switch ($valor) :
                case '55' :
                    return 'NFe';
                    break;
                case '65' :
                    return 'NFCe';
                    break;
                case '57' :
                    return 'CTe';
                    break;
                case '06' :
                    return 'NF/CEE';
                    break;
                case '22' :
                    return 'NFST';
                    break;
                case '51' :
                    return 'NFS';
                    break;
                default :
                    return $valor;
                    break;
            endswitch;
        }

        function Aliq($icms, $total) {
            $aliq = ($icms * 100) / $total;
            if ($aliq > 0) :
                $aliq = intval($aliq);
            else :
                $aliq = 0;
            endif;
            return number_format($aliq, 2, ',', '.');
        }

        $datai = $_POST['datai'];
        $dataf = $_POST['dataf'];
        $_POST['datai'] = parseDate($datai, 'Y-m-d');
        $_POST['dataf'] = parseDate($dataf, 'Y-m-d');
        ?>

        <table class="table table-bordered" style="font-size: 10px; padding: 10px">
            <tr> 
                <th colspan="8">PRODUTOS MONOFASICOS </th>
            </tr>
            <tr> 
                <td colspan="8">
                    FIRMA:  &nbsp;&nbsp;<?= $emitente->xNome ?>
                    <Br/>
                    INSC. EST.:  &nbsp;&nbsp;<?= $emitente->IE ?> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;  
                    CNPJ (MF):  &nbsp;&nbsp;<?= $emitente->CNPJ ?><br/>                 
                    MÊS OU PERÍODO/ANO: &nbsp;&nbsp;
                    <?= $datai ?>&nbsp;&nbsp; à &nbsp;&nbsp; <?= $dataf ?>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                    <?php
                    if ($_POST['modelo'] != 'T') :
                       echo ' Modelo: '.$_POST['modelo'].' - '.Especie($_POST['modelo']);
                    endif;
                    ?>
                </td>

            </tr>
            <tr>               
                <th class="text-center">PRODUTO</th>
                <th class="text-center">NCM</th>
                <th class="text-center">CST PIS</th>
                <th class="text-center">CST COFINS</th>
                <th class="text-center">CST/CSOSN</th>
                <th class="text-center">QUANTIDADE</th>
                <th class="text-center">VALOR MÉDIO</th>
                <th class="text-center">TOTAL</th>
            </tr>

            <?php
            $pdo = Conexao::getInstance();
            $crud = Crud::getInstance($pdo, 'nfe');
            $sql = "SELECT nfe.id, nfe.dhEmi, nfe.tipo, nfe.tpNF, nfe.empresa, nfe.status, nfe.modelo, 
                produtonfe.CFOP, produtonfe.xProd, produtonfe.cst, produtonfe.ncm, produtonfe.cProd, produtonfe.pICMS, produtonfe.pIPI, 
                sum(produtonfe.valortotal) as valortotal, sum(produtonfe.qtd) as qtd,
                tributacaoprodutos.cstpis, tributacaoprodutos.cstcofins, tributacaoprodutos.empresa
                from nfe
                INNER JOIN produtonfe ON produtonfe.NFe = nfe.id
                INNER JOIN tributacaoprodutos ON tributacaoprodutos.produto = produtonfe.cProd
                ";
            $sql .= ' WHERE str_to_date(dhEmi, "%d/%m/%Y") BETWEEN "' . $_POST['datai'] . '" AND "' . $_POST['dataf'] . '"  ';
            $sql .= " AND tipo = 'saida' AND tpNF  = '1'";
            $sql .= " AND nfe.empresa = '" . $_SESSION['Empresa'] . "'";
            $sql .= " AND tributacaoprodutos.empresa = '" . $_SESSION['Empresa'] . "'";
            $sql .= " AND ((status = '100') or (status = '999'))";
            $sql .= " AND tributacaoprodutos.cstpis = '04'";
            $sql .= " AND tributacaoprodutos.cstcofins = '04'";
            if ($_POST['modelo'] != 'T') :
                $sql .= ' AND modelo = "' . $_POST['modelo'] . '" ';
            endif;
            $sql .= " GROUP BY produtonfe.cProd";

//            echo $sql;
//            $sql .= " order by STR_TO_DATE(dhEmi, '%d/%m/%Y'), nNF";
            $arrayParam = '';
            $dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);
            $total = 0;
            $totalqtd = 0;
            $totalBc = 0;
            $totalIcms = 0;
            $totalisentas = 0;

//                    echo $sql;
            foreach ($dados as $dados) :
                $total = $total + $dados->valortotal;
                $totalqtd = $totalqtd + $dados->qtd;
                $medio = $dados->valortotal / $dados->qtd;
                ?>
                <tr>
                    <td> <?= $dados->cProd ?> - <?= $dados->xProd ?></td>          
                    <td> <?= $dados->ncm ?> </td>          
                    <td> <?= $dados->cstpis ?> </td>          
                    <td> <?= $dados->cstcofins ?> </td>          
                    <td> <?= $dados->cst ?> </td>          
                    <td><?= number_format($dados->qtd, 2, ',', '.') ?></td>
                    <td><?= number_format($medio, 4, ',', '.') ?></td>
                    <td><?= number_format($dados->valortotal, 2, ',', '.') ?></td>
                </tr>

                <?php
            endforeach;
            ?>
            <tr>
                <td colspan="4"><td>
                <td><?= number_format($totalqtd, 2, ',', '.') ?></td>
                <td></td>
                <td><?= number_format($total, 2, ',', '.') ?></td>
            </tr>

        </table>
    </body>
</html>



<?php
//$_POST['arq'] = 'PDF';
if ($_POST['arq'] == 'PDF') :
    require_once("../../_inc/mpdf/vendor/autoload.php");
    ini_set("pcre.backtrack_limit", "500000000000000");

    $mpdf = new \Mpdf\Mpdf([
        'margin_top' => 5,
        'margin_left' => 5,
        'margin_right' => 5,
        'mirrorMargins' => true,
        'default_font_size' => 10,
        'format' => 'A4-L',
        'default_font' => 'sans-serif',
    ]);
//$mpdf->SetWatermarkText('DRAFT');
    $mpdf->keep_table_proportions = true;
    $mpdf->allow_charset_conversion = true;
    $footer = "<table width = \"1000\">
                   <tr>
                     <td style='font-size: 10px; bottom:-15px;' align=\"right\">Pag: {PAGENO} de {nb} | <strong> Impresso: " . date('d/m/Y H:i') . " </strong></td>
                   </tr>
                 </table>";
    $mpdf->SetHTMLFooter($footer);
    $html = ob_get_clean();
    $mpdf->SetTitle('Movimentações');
    $mpdf->WriteHTML($html);
    $mpdf->Output();
//    imprime
    exit();

elseif ($_POST['arq'] == 'EXCEL') :
    $file = 'registro-p1a.xls';
    header("Content-type: application/x-msexcel");
    header("Content-Disposition: attachment; filename=\"{$file}\"");
    header("Content-Description: PHP Generated Data");
endif;
?>
