<?php
ob_start();
?>
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <title> Relatório </title>
        <style>

            table {
                border-collapse: collapse;
            }
            thead {
                vertical-align: bottom;
                text-align: center;
                font-weight: bold;
            }
            tfoot {
                text-align: center;
                font-weight: bold;
            }
            th {
                text-align: left;
                padding-left: 0.35em;
                padding-right: 0.35em;
                padding-top: 0.35em;
                padding-bottom: 0.35em;
                vertical-align: top;
            }
            td {
                padding-left: 0.35em;
                padding-right: 0.35em;
                padding-top: 0.35em;
                padding-bottom: 0.35em;
                vertical-align: top;
            }

            .page {
                width: 21cm;
                min-height: 29.7cm;
                padding: 2cm;
                margin: 1cm auto;
                border: 1px #D3D3D3 solid;
                border-radius: 5px;
                background: white;
                box-shadow: 0 0 5px rgba(0, 0, 0, 0.1);
            }

            @media print {
                .page {
                    border: none;
                    border-radius: 0px;
                    box-shadow: 0 0 0px rgba(0, 0, 0, 0.1);
                    margin: 0px;
                    padding: 0px;
                }
            }

        </style>

    </head>

    <?php
    date_default_timezone_set("Brazil/East");
    require_once("../../../functions.php");

    require_once "../../../_backend/_class/Conexao_class.php";
    require_once "../../../_backend/_class/Crud_class.php";
    require_once "../../../_backend/_class/parametros.php";

//        error_reporting(E_ALL);
//       ini_set('display_errors', 'On');




    function BuscaVariacaoDesc($prod, $variacao, $sigla, $nivel) {
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'estoqueprodutos');
        $sql = "SELECT produtos.variacao, produtos.codigo, 
                    variacao.variacaoid, variacao.var1, variacao.var2, 
                    variacao.var3 ,
                    itensvariacao.variacao, itensvariacao.sigla,
                    itensvariacao.descricao, itensvariacao.nivel
                    FROM produtos 
                    INNER JOIN variacao ON produtos.variacao = variacao.variacaoid 
                    INNER JOIN itensvariacao ON itensvariacao.variacao = variacao.variacaoid                   
                    WHERE codigo = '$prod' 
                    AND variacao.variacaoid = '$variacao'
                    AND itensvariacao.nivel = '$nivel'
                    AND itensvariacao.sigla = '$sigla'";
        $arrayParam = '';
        $dados = $crud->getSQLGeneric($sql, $arrayParam, false);

//                echo $sql;
        return $dados->descricao;
    }

    function BucaEmitente($fiscal) {
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'emitente');
        $sql = "SELECT emitenteid, xNome from emitente";
//        if ($fiscal == 'S') :
//            $sql .= " where emitenfe = 'S'";
//        else :
//            $sql .= " where emitenfe = 'N'";
//        endif;

        $sql .= " where emitenfe = 'N'";
        $arrayParam = '';
        $dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

        $emitente = '';
        foreach ($dados as $dados) :
            $emitente .= 'estoqueprodutos.qtd' . $dados->emitenteid . ',';
        endforeach;

        return substr($emitente, 0, -1);
    }

    function BucaEmitenteQtd($fiscal) {
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'emitente');
        $sql = "SELECT emitenteid, xNome, emitenfe from emitente";
//        if ($fiscal == 'S') :
//            $sql .= " where emitenfe = 'S'";
//        else :
//            $sql .= " where emitenfe = 'N'";
//        endif;
        $sql .= " where emitenfe = 'N'";

        $arrayParam = '';
        $dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

        $emitente = array();
        foreach ($dados as $dados) :
            $emitente[] = $dados->emitenteid;
        endforeach;

        return $emitente;
    }

    function BucaFilial($valor) {
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'estoqueprodutos');
        $sql = "SELECT emitenteid, xNome from emitente where emitenteid = '$valor'";
        $arrayParam = '';
        $dados = $crud->getSQLGeneric($sql, $arrayParam, false);

        return $dados->xNome;
    }

    function BuscaFornecedor($valor) {
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'estoqueprodutos');
        $sql = "SELECT fornecedorid, xNome from fornecedor where fornecedorid = '$valor'";
        $arrayParam = '';
        $dados = $crud->getSQLGeneric($sql, $arrayParam, false);

        return $dados;
    }

// a partir daqui

    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'temp_estoque');
    $sql = "DELETE FROM temp_estoque";
    $retornodelete = $crud->Sql($sql);
//echo $sql;
//echo '<br/>';
    $pdo = null;
    $crud = null;

//   print_r($dadosEmitente);

    $documento = '1';

    $dadosemit = BucaEmitenteQtd($parametros->fiscal);
//
//        print_r($dadosemit);

    if ($_GET['empresa'] == 'T') :
        $sql = 'SELECT estoqueprodutos.produto, estoqueprodutos.var1, estoqueprodutos.var2, estoqueprodutos.var3, 
        estoqueprodutos.codproduto, ' . BucaEmitente($parametros->fiscal) . ', 
produtos.codigo, produtos.descricao, produtos.categoria, produtos.unidade, produtos.custo, produtos.fornecedor,
produtos.variacao, categorias.sigla, categorias.descricao as catdesc,
estoqueprodutos.ordem1, estoqueprodutos.ordem2
FROM estoqueprodutos INNER JOIN produtos
ON estoqueprodutos.produto = produtos.codigo 
LEFT JOIN categorias ON produtos.categoria = categorias.sigla
WHERE 1=1';
    else :
        $sql = 'SELECT estoqueprodutos.produto, estoqueprodutos.var1, estoqueprodutos.var2, estoqueprodutos.var3, 
        estoqueprodutos.codproduto, estoqueprodutos.qtd' . $_GET['empresa'] . ' as estoque, 
produtos.codigo, produtos.descricao, produtos.categoria, produtos.unidade, produtos.custo, produtos.fornecedor,
produtos.variacao, categorias.sigla, categorias.descricao as catdesc,
estoqueprodutos.ordem1, estoqueprodutos.ordem2
FROM estoqueprodutos INNER JOIN produtos
ON estoqueprodutos.produto = produtos.codigo 
LEFT JOIN categorias ON produtos.categoria = categorias.sigla
WHERE 1=1';
    endif;

//        echo $sql;
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'estoqueprodutos');

    if (!empty($_GET['categoria'])) :
        $sql .= " AND categoria = '" . $_GET['categoria'] . "' ";
    endif;

    if (!empty($_GET['produto'])) :
        $sql .= " AND produto = '" . $_GET['produto'] . "' ";
    endif;

    if (!empty($_GET['fornecedor'])) :
        $sql .= " AND fornecedor = '" . $_GET['fornecedor'] . "' ";
    endif;

    $sql .= ' ORDER BY estoqueprodutos.produto, estoqueprodutos.ordem1, estoqueprodutos.ordem2, estoqueprodutos.var1, estoqueprodutos.var2  ASC';

//    echo $sql;
    $arrayParam = '';
    $dadosEstoque = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

    foreach ($dadosEstoque as $value) :

        $array = json_decode(json_encode($value), true);

        if ($_GET['empresa'] == 'T') :

            for ($i = 0; $i < count($dadosemit); $i++) :

                $empresa = $dadosemit[$i];
                $estoque = 'qtd' . $empresa;

                // echo $empresa;
                //  echo '<br/>';

                $pdo = Conexao::getInstance();
                $crud = Crud::getInstance($pdo, 'temp_estoque');
                if ($value->var2 == '') :
                    $sql = "SELECT * FROM temp_estoque WHERE produto = '$value->produto' and documento = '" . $empresa . "'";
                else :
                    $sql = "SELECT * FROM temp_estoque WHERE produto = '$value->produto' and var1 = '$value->var1' and documento = '" . $empresa . "'";
                endif;
                $arrayParam = '';
                $dadosit = $crud->getSQLGeneric($sql, $arrayParam, true);

                $totalregistro = count($dadosit);
                if ($totalregistro > 0) :
                    if ($value->var2 == '') :
                        $variacoes = $dadosit[0]->variacoes . '|' . $value->var1 . ':' . $array[$estoque];
                    else :
                        $variacoes = $dadosit[0]->variacoes . '|' . $value->var2 . ':' . $array[$estoque];
                    endif;
                    $sql = "UPDATE temp_estoque SET variacoes = '$variacoes' where id = '" . $dadosit[0]->id . "'";
                    $insert = $crud->Sql($sql);

                // echo $sql;
                else :
                    if ($value->var2 == '') :
                        $var = '';
                        $variacoes = $value->var1 . ':' . $array[$estoque];
                    else :
                        $var = $value->var1;
                        $variacoes = $value->var2 . ':' . $array[$estoque];
                    endif;

//                        echo $variacoes;
                    $sql = "INSERT INTO temp_estoque(produto, ref, descricao, var1, variacoes, vunit, total, documento,variacao)
                VALUES ('$value->produto', '$value->ref', '$value->descricao', '$var', '$variacoes',
                  '$value->custo', '',  '" . $empresa . "', '$value->variacao')
                ";
                    $insert = $crud->Sql($sql);

                // echo $sql;

                endif;
            endfor;

        else :

            //empresa unica
            $empresa = $_GET['empresa'];
            $estoque = 'qtd' . $empresa;

            // echo $empresa;
            //  echo '<br/>';

            $pdo = Conexao::getInstance();
            $crud = Crud::getInstance($pdo, 'temp_estoque');
            if ($value->var2 == '') :
                $sql = "SELECT * FROM temp_estoque WHERE produto = '$value->produto' and documento = '" . $empresa . "'";
            else :
                $sql = "SELECT * FROM temp_estoque WHERE produto = '$value->produto' and var1 = '$value->var1' and documento = '" . $empresa . "'";
            endif;
            $arrayParam = '';
            $dadosit = $crud->getSQLGeneric($sql, $arrayParam, true);

            $totalregistro = count($dadosit);
            if ($totalregistro > 0) :
                if ($value->var2 == '') :
                    $variacoes = $dadosit[0]->variacoes . '|' . $value->var1 . ':' . $value->estoque;
                else :
                    $variacoes = $dadosit[0]->variacoes . '|' . $value->var2 . ':' . $value->estoque;
                endif;
                $sql = "UPDATE temp_estoque SET variacoes = '$variacoes' where id = '" . $dadosit[0]->id . "'";
                $insert = $crud->Sql($sql);

            // echo $sql;
            else :
                if ($value->var2 == '') :
                    $var = '';
                    $variacoes = $value->var1 . ':' . $value->estoque;
                else :
                    $var = $value->var1;
                    $variacoes = $value->var2 . ':' . $value->estoque;
                endif;

//                        echo $variacoes;
                $sql = "INSERT INTO temp_estoque(produto, ref, descricao, var1, variacoes, vunit, total, documento, variacao)
                VALUES ('$value->produto', '$value->ref', '$value->descricao', '$var', '$variacoes',
                  '$value->custo', '',  '" . $empresa . "', '$value->variacao')
                ";
                $insert = $crud->Sql($sql);

            // echo $sql;

            endif;
        endif;

    endforeach;
    ?>


    <body>

        <div align="center" style="font-size: 12px;">
            <b>RELAÇÃO DE ESTOQUE DOS PRODUTOS POR GRADE</b> <br/>
            <?= date("d/m/Y H:i") ?>
            <br/>
            <b> Agrupamento por Variação 2 </b>


            <?php
            if (!empty($_GET['fornecedor'])) :
                $fornecedor = BuscaFornecedor($_GET['fornecedor']);
                ?>
                <br/>
                <?= $fornecedor->fornecedorid ?> - <?= $fornecedor->xNome ?>
                <?php
            endif;
            ?>
            <?php
            if ($_GET['empresa'] == 'T') :
                ?>
                <br/>
                FILIAL: TODAS
                <?php
            else :
                ?>
                <br/>
                FILIAL: <?= BucaFilial($_GET['empresa']) ?>
            <?php
            endif;
            ?>

        </div>


        <?php
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'temp_romaneio');
        $sql = "SELECT * FROM temp_estoque order by produto, ref, var1";
        $arrayParam = '';
        $dadositens = $crud->getSQLGeneric($sql, $arrayParam, true);

        $prodarray = array();
        foreach ($dadositens as $value) :

            if (!in_array($value->produto . $value->var1 . $value->documento, $prodarray)) :


                $separa = explode("|", $value->variacoes);
                $grade = '';
                $totalcor = 0;
                for ($index = 0; $index < count($separa); $index++) :
                    $grade = explode(":", $separa[$index]);

                    $totalcor = $totalcor + intval($grade[1]);
                endfor;

                $prodarray[$value->produto . $value->var1 . $value->documento] = array(
                    "var2" => $value->var1,
                    "produto" => $value->produto,
                    "descricao" => $value->descricao,
                    "vunit" => $value->vunit,
                    "empresa" => $value->documento,
                    "qtd" => $totalcor
                );
            endif;

        endforeach;

        $json = json_encode($prodarray);
        $data = json_decode($json, true);

// Função para agrupar dados por produto e empresa
        function groupData($data) {
            $groupedData = [];

            foreach ($data as $value) {
                $produto = $value['produto'];
                $empresa = $value['empresa'];
                $var2 = $value['var2'];
                $qtd = $value['qtd'];

                if (!isset($groupedData[$produto])) {
                    $groupedData[$produto] = [
                        'descricao' => $value['descricao'],
                        'vunit' => $value['vunit'],
                        'empresas' => [],
                        'var2_quantities' => [],
                        'var2_columns' => []
                    ];
                }

                if (!isset($groupedData[$produto]['empresas'][$empresa])) {
                    $groupedData[$produto]['empresas'][$empresa] = [];
                }

                if (!isset($groupedData[$produto]['empresas'][$empresa][$var2])) {
                    $groupedData[$produto]['empresas'][$empresa][$var2] = 0;
                }

                $groupedData[$produto]['empresas'][$empresa][$var2] += $qtd;

                if (!isset($groupedData[$produto]['var2_quantities'][$var2])) {
                    $groupedData[$produto]['var2_quantities'][$var2] = 0;
                }

                $groupedData[$produto]['var2_quantities'][$var2] += $qtd;

                if (!in_array($var2, $groupedData[$produto]['var2_columns'])) {
                    $groupedData[$produto]['var2_columns'][] = $var2;
                }
            }

            return $groupedData;
        }

// Agrupar dados
        $groupedData = groupData($data);

// Função para gerar a tabela HTML
        function generateTable($groupedData) {

            $pdo = Conexao::getInstance();
            $crud = Crud::getInstance($pdo, 'emitente');
            $sql = "SELECT emitenteid, xFant from emitente";
            $arrayParam = '';
            $dadosemite = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

            foreach ($dadosemite as $dadosemit) :
                $empresad[$dadosemit->emitenteid] = $dadosemit->xFant;
            endforeach;

            echo '<table  class="table table-striped table-bordered table-condensed full_table_list" style="font-size: 12px; width: 100%;">';

            // Ordenar dados agrupados por produto
            ksort($groupedData);

            foreach ($groupedData as $produto => $produtoData) {
                $descricao = $produtoData['descricao'];
                $vunit = $produtoData['vunit'];

                // Ordenar colunas var2
                sort($produtoData['var2_columns']);

                // Adicionar linha de descrição do produto
                echo '<tr style="background-color: #dee2e6;">';
                echo '<td colspan="3">' . htmlspecialchars($produto) . '-' . htmlspecialchars($descricao) . ' </td>';
                echo '<td style="border: #e6ede8 dashed 1px">R$ ' . htmlspecialchars(number_format($vunit, 2, ',', '.')) . '</td>';

                $totalcoluna = count($produtoData['var2_columns']);
                foreach ($produtoData['var2_columns'] as $var2) {
                    echo '<td style="border: #e6ede8 dashed 1px">' . htmlspecialchars($var2) . '</td>';
                }
                for ($iz = $totalcoluna; $iz < 20; $iz++) :
                    echo '<td>';
                    echo '</td>';
                endfor;
                echo '<td> Total </td>';
                echo '<td> V. Total </td>';

                echo '</tr>';

                // Ordenar empresas dentro de cada produto
                ksort($produtoData['empresas']);

                foreach ($produtoData['empresas'] as $empresa => $quantidades) {
                    $totalvar = 0;

                    echo '<tr>';

                    echo '<td colspan="4" style="border: #e6ede8 dashed 1px">' . $empresad[$empresa] . '</td>';
                    foreach ($produtoData['var2_columns'] as $var2) {
                        $totalvar = $totalvar + $quantidades[$var2];
                        echo '<td style="border: #e6ede8 dashed 1px">' . (isset($quantidades[$var2]) ? htmlspecialchars($quantidades[$var2]) : 0) . '</td>';
                    }
                    $totalcoluna = count($produtoData['var2_columns']);
                    for ($iz = $totalcoluna; $iz < 20; $iz++) :
                        echo '<td>';
                        echo '</td>';
                    endfor;
                    echo '<td> ' . $totalvar . ' </td>';
                    echo '<td> R$ ' . number_format($vunit * $totalvar, 2, ',', '.') . ' </td>';
                    echo '</tr>';
                }

                // Adicionar linha de soma das quantidades
                echo '<tr>';
                echo '<td colspan="4">Totais ' . htmlspecialchars($produto) . '</td>';
                $totalgeral = 0;
                foreach ($produtoData['var2_columns'] as $var2) {
                    $totalgeral = $totalgeral + $produtoData['var2_quantities'][$var2];
                    echo '<td>' . htmlspecialchars($produtoData['var2_quantities'][$var2]) . '</td>';
                }
                for ($iz = $totalcoluna; $iz < 20; $iz++) :
                    echo '<td>';
                    echo '</td>';
                endfor;
                echo '<td> ' . $totalgeral . ' </td>';
                echo '<td> R$ ' . number_format($vunit * $totalgeral, 2, ',', '.') . ' </td>';
                echo '</tr>';
            }

            echo '</table>';
        }

// Gerar a tabela HTML
        generateTable($groupedData);
        ?>
    </body>
</html>


<?php
if ($_GET['gerar'] == 'EXCEL') :
//    $data = parseDate($_POST['data'], "dmY");
    $file = 'estoquegrade.xls';
    header("Content-type: application/x-msexcel");
    header("Content-Disposition: attachment; filename=\"{$file}\"");
    header("Content-Description: PHP Generated Data");
elseif ($_GET['gerar'] == 'HTML') :
    echo '';
else :
    ini_set("pcre.backtrack_limit", "500000000000000");
    require_once("../../_inc/mpdf/vendor/autoload.php");
    $mpdf = new \Mpdf\Mpdf([
        'margin_top' => 5,
        'margin_left' => 5,
        'margin_right' => 5,
        'mirrorMargins' => true,
        'default_font_size' => 12,
        'format' => 'A4-L'
    ]);
    $mpdf->keep_table_proportions = true;
    $mpdf->allow_charset_conversion = true;
    $footer = "<table width = \"1000\">
                   <tr>
                     <td style='font-size: 10px; bottom:-15px;' align=\"right\">Pag: {PAGENO} de {nb} " . date('d/m/Y') . "</td>
                   </tr>
                 </table>";
    $mpdf->SetHTMLFooter($footer);
    $html = ob_get_clean();
    $mpdf->SetTitle('Estoque');
    $mpdf->WriteHTML($html);
    $mpdf->Output();
// imprime

    exit();
endif;
?>