<?php
ob_start();
?>
<html>
    <head>
        <title> Relatório </title>
        <style>

            table {
                border-collapse: collapse;
            }
            thead {
                vertical-align: bottom;
                text-align: center;
                font-weight: bold;
            }
            tfoot {
                text-align: center;
                font-weight: bold;
            }
            th {
                text-align: left;
                padding-left: 0.35em;
                padding-right: 0.35em;
                padding-top: 0.35em;
                padding-bottom: 0.35em;
                vertical-align: top;
            }
            td {
                padding-left: 0.35em;
                padding-right: 0.35em;
                padding-top: 0.35em;
                padding-bottom: 0.35em;
                vertical-align: top;
            }

            .page {
                width: 21cm;
                min-height: 29.7cm;
                padding: 2cm;
                margin: 1cm auto;
                border: 1px #D3D3D3 solid;
                border-radius: 5px;
                background: white;
                box-shadow: 0 0 5px rgba(0, 0, 0, 0.1);
            }

            @media print {
                .page {
                    border: none;
                    border-radius: 0px;
                    box-shadow: 0 0 0px rgba(0, 0, 0, 0.1);
                    margin: 0px;
                    padding: 0px;
                }
            }

        </style>

        <?php
        if ($_POST['gerar'] != 'PDF') :
            ?>
            <link href="../../../_frontend/_layout/assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet" type="text/css"/>
            <?php
        endif;
        ?>
    </head>
    <?php
    date_default_timezone_set("Brazil/East");
    require_once("../../../functions.php");
//
    require_once "../../../_backend/_class/Conexao_class.php";
    require_once "../../../_backend/_class/Crud_class.php";
    require_once "../../../_backend/_class/parametros.php";

    function TotalRegistro($sql, $sqlo, $produto, $var) {
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'estoqueprodutos');
        $sql1 = $sql;
        $sql1 .= " and estoqueprodutos.produto = '$produto' AND estoqueprodutos.var1 = '$var'";
        $sql1 .= $sqlo;
        $arrayParam = '';
        $dados = $crud->getSQLGeneric($sql1, $arrayParam, true);

//        echo $sql1;
        return count($dados);
    }

    function BucaEmitente() {
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'estoqueprodutos');
        $sql = "SELECT * from emitente";
        $arrayParam = '';
        $dados = $crud->getSQLGeneric($sql, $arrayParam, true);

        $emitente = '';
        foreach ($dados as $dados) :
            $emitente .= 'estoqueprodutos.qtd' . $dados->emitenteid . '+';
        endforeach;

        return substr($emitente, 0, -1);
    }

    function BucaEmitenteOp($operador) {
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'estoqueprodutos');
        $sql = "SELECT * from emitente";
        $arrayParam = '';
        $dados = $crud->getSQLGeneric($sql, $arrayParam, true);

        $emitente = '';
        foreach ($dados as $dados) :
            $emitente .= ' AND estoqueprodutos.qtd' . $dados->emitenteid . ' ' . $operador . ' ';
        endforeach;

        return $emitente;
    }

    function BuscaGrupo($grupo) {
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'estoqueprodutos');
        $sql = "SELECT * from grupos where sequencia = '$grupo'";
        $arrayParam = '';
        $dados = $crud->getSQLGeneric($sql, $arrayParam, false);

        return $dados->descricao;
    }

    function BuscaCategoria($grupo) {
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'estoqueprodutos');
        $sql = "SELECT * from categorias where sigla = '$grupo'";
        $arrayParam = '';
        $dados = $crud->getSQLGeneric($sql, $arrayParam, false);

        return $dados->descricao;
    }

    function BuscaVariacaoDesc($prod, $variacao, $sigla, $nivel) {
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'estoqueprodutos');
        $sql = "SELECT produtos.variacao, produtos.codigo, 
                    variacao.variacaoid, variacao.var1, variacao.var2, 
                    variacao.var3 ,
                    itensvariacao.variacao, itensvariacao.sigla,
                    itensvariacao.descricao, itensvariacao.nivel
                    FROM produtos 
                    INNER JOIN variacao ON produtos.variacao = variacao.variacaoid 
                    INNER JOIN itensvariacao ON itensvariacao.variacao = variacao.variacaoid                   
                    WHERE codigo = '$prod' 
                    AND itensvariacao.nivel = '$nivel'
                    AND itensvariacao.sigla = '$sigla'";
        $arrayParam = '';
        $dados = $crud->getSQLGeneric($sql, $arrayParam, false);

        return $dados->descricao;
    }

    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'usuario');


    if (!empty($_POST['grupos'])) :
        if ($_POST['empresa'] == 'T') :
            $sql = 'Select estoqueprodutos.produto, estoqueprodutos.var1, estoqueprodutos.var2, estoqueprodutos.var3, 
        estoqueprodutos.codproduto, Sum(' . BucaEmitente() . ') as estoque,
produtos.codigo, produtos.descricao, produtos.categoria, produtos.unidade, produtos.custo, produtos.fornecedor,
categorias.sigla, categorias.descricao as catdesc,
grupoprodutos.produto, grupoprodutos.grupo
FROM estoqueprodutos 
INNER JOIN produtos ON estoqueprodutos.produto = produtos.codigo 
LEFT JOIN categorias ON produtos.categoria = categorias.sigla
LEFT JOIN grupoprodutos ON produtos.codigo = grupoprodutos.produto
WHERE 1=1';
        else :
            $sql = 'Select estoqueprodutos.produto, estoqueprodutos.var1, estoqueprodutos.var2, estoqueprodutos.var3, 
        estoqueprodutos.codproduto, estoqueprodutos.qtd' . $_POST['empresa'] . ' as estoque, 
produtos.codigo, produtos.descricao, produtos.categoria, produtos.unidade, produtos.custo, produtos.fornecedor,
categorias.sigla, categorias.descricao as catdesc,
grupoprodutos.produto, grupoprodutos.grupo
FROM estoqueprodutos 
INNER JOIN produtos ON estoqueprodutos.produto = produtos.codigo 
LEFT JOIN categorias ON produtos.categoria = categorias.sigla
LEFT JOIN grupoprodutos ON produtos.codigo = grupoprodutos.produto
WHERE 1=1';
        endif;
    else :
        if ($_POST['empresa'] == 'T') :
            $sql = 'Select estoqueprodutos.produto, estoqueprodutos.var1, estoqueprodutos.var2, estoqueprodutos.var3, 
        estoqueprodutos.codproduto, Sum(' . BucaEmitente() . ') as estoque, 
produtos.codigo, produtos.descricao, produtos.categoria, produtos.unidade, produtos.custo, produtos.fornecedor,
categorias.sigla, categorias.descricao as catdesc
FROM estoqueprodutos INNER JOIN produtos
ON estoqueprodutos.produto = produtos.codigo 
LEFT JOIN categorias ON produtos.categoria = categorias.sigla
WHERE 1=1';
        else :
            $sql = 'Select estoqueprodutos.produto, estoqueprodutos.var1, estoqueprodutos.var2, estoqueprodutos.var3, 
        estoqueprodutos.codproduto, estoqueprodutos.qtd' . $_POST['empresa'] . ' as estoque, 
produtos.codigo, produtos.descricao, produtos.categoria, produtos.unidade, produtos.custo, produtos.fornecedor,
categorias.sigla, categorias.descricao as catdesc
FROM estoqueprodutos INNER JOIN produtos
ON estoqueprodutos.produto = produtos.codigo 
LEFT JOIN categorias ON produtos.categoria = categorias.sigla
WHERE 1=1';
        endif;
    endif;


    if ($_POST['empresa'] == 'T') :
        if ($_POST['estoque'] != 'Geral') :
            if ($_POST['estoque'] === 'Negativo') :
                $sql .= BucaEmitenteOp('< 0');
            elseif ($_POST['estoque'] === 'Zero') :
                $sql .= BucaEmitenteOp('= 0');
            else :
                $sql .= BucaEmitenteOp('> 0');
            endif;
        endif;
    else :
        if ($_POST['estoque'] != 'Geral') :
            if ($_POST['estoque'] === 'Negativo') :
                $sql .= ' AND estoqueprodutos.qtd' . $_POST['empresa'] . ' < 0';
            elseif ($_POST['estoque'] === 'Zero') :
                $sql .= ' AND estoqueprodutos.qtd' . $_POST['empresa'] . ' = 0';
            else :
                $sql .= ' AND estoqueprodutos.qtd' . $_POST['empresa'] . ' > 0';
            endif;
        endif;
    endif;


    if (!empty($_POST['categoria'])) :
        $sql .= " AND categoria = '" . $_POST['categoria'] . "' ";
    endif;

    if (!empty($_POST['produto'])) :
        $sql .= " AND produto = '" . $_POST['produto'] . "' ";
    endif;

    if (!empty($_POST['fornecedor'])) :
        $sql .= " AND fornecedor = '" . $_POST['fornecedor'] . "' ";
    endif;

    if (!empty($_POST['grupos'])) :
        $sql .= " AND grupoprodutos.grupo like '" . $_POST['grupos'] . "%' ";
    endif;

    $sql1 = $sql;

    if ($_POST['ordernar'] === 'descricao') :
        $sql .= ' GROUP by  estoqueprodutos.var1, estoqueprodutos.var2, estoqueprodutos.produto ORDER BY produtos.descricao, estoqueprodutos.var2 ASC';
        $sq2 = ' GROUP by estoqueprodutos.var1, estoqueprodutos.var2, estoqueprodutos.produtoORDER BY produtos.descricao, estoqueprodutos.var2 ASC';
    else :
        $sql .= ' GROUP by estoqueprodutos.var1, estoqueprodutos.var2, estoqueprodutos.produto ORDER BY produtos.codigo, estoqueprodutos.var2 ASC';
        $sql2 = ' GROUP by estoqueprodutos.var1, estoqueprodutos.var2, estoqueprodutos.produto ORDER BY produtos.codigo, estoqueprodutos.var2 ASC';
    endif;

    $arrayParam = '';
    $estoqueprodutos = $crud->getSQLGeneric($sql, $arrayParam, true);

//    echo $sql;
    $prod = array();
    ?>
    <body>
        <?php
        if ($_POST['gerar'] == 'PDF') :
            ?>
            <div class="container">
                <?php
            else :
                ?>
                <div class="container page">
                <?php
                endif;
                ?>

                <div align="center">
                    <h4 align="center"> ESTOQUE GRADE PRODUTOS
                        <?php
                        if (!empty($_POST['grupos'])) :
                            echo '<br/><span align="center" style="font-size: 12px;">GRUPO : ' . $_POST['grupos'] . ' - ' . BuscaGrupo($_POST['grupos']) . '</span>';
                        endif;

                        if (!empty($_POST['categoria'])) :
                            echo '<br/><span align="center" style="font-size: 12px;">CATEGORIA : ' . $_POST['categoria'] . ' - ' . BuscaCategoria($_POST['categoria']) . '</span>';
                        endif;
                        ?>
                    </h4>
                </div>

                <?php require_once './cabecalho.php'; ?>

                <table class="table table-condensed text-center" style="font-size: 12px; width: 100%; text-align: left">
                    <tr> 
                        <td colspan="2" style="width: 60%"><b>Codigo</b></td>
                        <td style="width: 15%"><b>COR</b></td>
                        <td style="width: 10%"><b>Categoria</b></td>
                        <td style="width: 10%"><b>Custo</b></td>
                        <td style="width: 10%"><b>Qtd total</b></td>
                        <td style="width: 10%"><b>Total (R$)</b></td>
                    </tr>

                    <?php
                    $qtd = 0;
                    $total = 0;
                    $valortotal = 0;
                    $qtdtotal = 0;

                    foreach ($estoqueprodutos as $dados) :
//                        echo '<pre>';
//                        print_r($dados);
//                        echo '</pre>';

                        $qtd = $qtd + $dados->estoque;
                        $total = $total + ($dados->estoque * $dados->custo);
                        if (!in_array($dados->produto . $dados->var1, $prod)) :
                            $prod[] = $dados->produto . $dados->var1;
                            $produto = $dados->produto . $dados->var1;
                            $totalprodudoi = TotalRegistro($sql1, $sql2, $dados->produto, $dados->var1);
                            $variaveli = 1;
                            echo 'entrou';
                            ?>
                            <?php
                            if ($_POST['gerar'] == 'PDF') :
                                echo '<tr> <td colspan="7"> <hr/> </td> </tr>';
                            endif;
                            ?>
                            <tr>
                                <td colspan="2"><?= $dados->produto ?> - <?= $dados->descricao ?></td>                                
                                <td><?= $dados->var1 ?> <?= BuscaVariacaoDesc($dados->produto, 1, $dados->var1, 1) ?></td>
                                <td><?= $dados->catdesc ?></td>
                                <td>R$ <?= number_format($dados->custo, $parametros->casadecimal, ',', '.') ?></td>
                                <td></td>
                                <td></td>
                            </tr>
                            <?php
//                  
                        endif;
                        ?>

                        <?php
                        if ($variaveli == '1') :
                            echo '<tr>';
                            echo '<td> ' . $dados->produto . $dados->var1 . '  &nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;  GRADE</td>';
                            echo '<td>';
                            echo '<table class="table text-center" style="font-size: 12px; width: 100%; text-align: left"> <tr> ';
                        endif;

                        $qtdtotal = $qtdtotal + $dados->estoque;
                        ?>
                        <td>
                            <?= BuscaVariacaoDesc($dados->produto, 2, $dados->var2, 2) ?>  <br/>
                            <?= intval($dados->estoque) ?>
                        </td>

                        <?php
                        echo $variaveli . ' e ' . $totalprodudoi;
                        if ($variaveli == $totalprodudoi) :
                            echo '</tr> </table>';
                            echo '</td>';
                            ?>
                            <td> </td>
                            <td></td>
                            <td></td>
                            <td> <br/><?= intval($qtdtotal) ?></td>       
                            <td><br/> <?= number_format($qtdtotal * $dados->custo, $parametros->casadecimalqtd, ',', '.') ?></td>
                            </tr>
                            <?php
                        endif;
                        $variaveli++;

                    endforeach;
                    ?>

                    <tr>
                        <td colspan="7"> <hr/></td>
                    </tr>
                    <tr> 
                        <td colspan="5">TOTAIS</td>
                        <td><?= intval($qtd) ?></td>
                        <td>R$ <?= number_format($total, '2', ',', '.') ?></td>
                    </tr>
                </table>
            </div>
    </body>
</html>

<?php
print_r($prod);
?>
<?php
if ($_POST['gerar'] == 'PDF') :
    ini_set("pcre.backtrack_limit", "500000000000000");
    require_once("../../_inc/mpdf/vendor/autoload.php");
    $mpdf = new \Mpdf\Mpdf([
        'margin_top' => 5,
        'margin_left' => 5,
        'margin_right' => 5,
        'mirrorMargins' => true,
        'default_font_size' => 12,
    ]);
    $mpdf->keep_table_proportions = true;
    $mpdf->allow_charset_conversion = true;
    $footer = "<table width = \"1000\">
                   <tr>
                     <td style='font-size: 10px; bottom:-15px;' align=\"right\">Pag: {PAGENO} de {nb} " . date('d/m/Y') . "</td>
                   </tr>
                 </table>";
    $mpdf->SetHTMLFooter($footer);
    $html = ob_get_clean();
    $mpdf->SetTitle('Estoque');
    $mpdf->WriteHTML($html);
    $mpdf->Output();
// imprime

    exit();
endif;
?>