<?php
ob_start();
?>
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <title> Relatório </title>
        <style>

            table {
                border-collapse: collapse;
            }
            thead {
                vertical-align: bottom;
                text-align: center;
                font-weight: bold;
            }
            tfoot {
                text-align: center;
                font-weight: bold;
            }
            th {
                text-align: left;
                padding-left: 0.35em;
                padding-right: 0.35em;
                padding-top: 0.35em;
                padding-bottom: 0.35em;
                vertical-align: top;
            }
            td {
                padding-left: 0.35em;
                padding-right: 0.35em;
                padding-top: 0.35em;
                padding-bottom: 0.35em;
                vertical-align: top;
            }

            .page {
                width: 21cm;
                min-height: 29.7cm;
                padding: 2cm;
                margin: 1cm auto;
                border: 1px #D3D3D3 solid;
                border-radius: 5px;
                background: white;
                box-shadow: 0 0 5px rgba(0, 0, 0, 0.1);
            }

            @media print {
                .page {
                    border: none;
                    border-radius: 0px;
                    box-shadow: 0 0 0px rgba(0, 0, 0, 0.1);
                    margin: 0px;
                    padding: 0px;
                }
            }

        </style>

    </head>

    <?php
    date_default_timezone_set("Brazil/East");
    require_once("../../../functions.php");

    require_once "../../../_backend/_class/Conexao_class.php";
    require_once "../../../_backend/_class/Crud_class.php";
    require_once "../../../_backend/_class/parametros.php";

//        error_reporting(E_ALL);
//       ini_set('display_errors', 'On');


    function BuscaVariacaoDesc($prod, $variacao, $sigla, $nivel) {
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'estoqueprodutos');
        $sql = "SELECT produtos.variacao, produtos.codigo, 
                    variacao.variacaoid, variacao.var1, variacao.var2, 
                    variacao.var3 ,
                    itensvariacao.variacao, itensvariacao.sigla,
                    itensvariacao.descricao, itensvariacao.nivel
                    FROM produtos 
                    INNER JOIN variacao ON produtos.variacao = variacao.variacaoid 
                    INNER JOIN itensvariacao ON itensvariacao.variacao = variacao.variacaoid                   
                    WHERE codigo = '$prod' 
                    AND variacao.variacaoid = '$variacao'
                    AND itensvariacao.nivel = '$nivel'
                    AND itensvariacao.sigla = '$sigla'";
        $arrayParam = '';
        $dados = $crud->getSQLGeneric($sql, $arrayParam, false);

//                echo $sql;
        return $dados->descricao;
    }

    function BucaEmitente($fiscal) {
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'emitente');
        $sql = "SELECT emitenteid, xNome from emitente";
//        if ($fiscal == 'S') :
//            $sql .= " where emitenfe = 'S'";
//        else :
//            $sql .= " where emitenfe = 'N'";
//        endif;

        $sql .= " where emitenfe = 'N'";
        $arrayParam = '';
        $dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

        $emitente = '';
        foreach ($dados as $dados) :
            $emitente .= 'estoqueprodutos.qtd' . $dados->emitenteid . ',';
        endforeach;

        return substr($emitente, 0, -1);
    }

    function BucaEmitenteQtd($fiscal) {
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'emitente');
        $sql = "SELECT emitenteid, xNome, emitenfe from emitente";
//        if ($fiscal == 'S') :
//            $sql .= " where emitenfe = 'S'";
//        else :
//            $sql .= " where emitenfe = 'N'";
//        endif;
        $sql .= " where emitenfe = 'N'";

        $arrayParam = '';
        $dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

        $emitente = array();
        foreach ($dados as $dados) :
            $emitente[] = $dados->emitenteid;
        endforeach;

        return $emitente;
    }

    function BucaFilial($valor) {
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'estoqueprodutos');
        $sql = "SELECT emitenteid, xNome from emitente where emitenteid = '$valor'";
        $arrayParam = '';
        $dados = $crud->getSQLGeneric($sql, $arrayParam, false);

        return $dados->xNome;
    }

    function BuscaFornecedor($valor) {
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'estoqueprodutos');
        $sql = "SELECT fornecedorid, xNome from fornecedor where fornecedorid = '$valor'";
        $arrayParam = '';
        $dados = $crud->getSQLGeneric($sql, $arrayParam, false);

        return $dados;
    }

// a partir daqui

    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'temp_estoque');
    $sql = "DELETE FROM temp_estoque";
    $retornodelete = $crud->Sql($sql);
//echo $sql;
//echo '<br/>';
    $pdo = null;
    $crud = null;

//   print_r($dadosEmitente);

    $documento = '1';

    $dadosemit = BucaEmitenteQtd($parametros->fiscal);
//
//        print_r($dadosemit);

    if ($_GET['empresa'] == 'T') :
        $sql = 'SELECT estoqueprodutos.produto, estoqueprodutos.var1, estoqueprodutos.var2, estoqueprodutos.var3, 
        estoqueprodutos.codproduto, ' . BucaEmitente($parametros->fiscal) . ', 
produtos.codigo, produtos.descricao, produtos.categoria, produtos.unidade, produtos.custo, produtos.fornecedor,
produtos.variacao, categorias.sigla, categorias.descricao as catdesc,
estoqueprodutos.ordem1, estoqueprodutos.ordem2
FROM estoqueprodutos INNER JOIN produtos
ON estoqueprodutos.produto = produtos.codigo 
LEFT JOIN categorias ON produtos.categoria = categorias.sigla
WHERE 1=1';
    else :
        $sql = 'SELECT estoqueprodutos.produto, estoqueprodutos.var1, estoqueprodutos.var2, estoqueprodutos.var3, 
        estoqueprodutos.codproduto, estoqueprodutos.qtd' . $_GET['empresa'] . ' as estoque, 
produtos.codigo, produtos.descricao, produtos.categoria, produtos.unidade, produtos.custo, produtos.fornecedor,
produtos.variacao, categorias.sigla, categorias.descricao as catdesc,
estoqueprodutos.ordem1, estoqueprodutos.ordem2
FROM estoqueprodutos INNER JOIN produtos
ON estoqueprodutos.produto = produtos.codigo 
LEFT JOIN categorias ON produtos.categoria = categorias.sigla
WHERE 1=1';
    endif;

//        echo $sql;
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'estoqueprodutos');

    if (!empty($_GET['categoria'])) :
        $sql .= " AND categoria = '" . $_GET['categoria'] . "' ";
    endif;

    if (!empty($_GET['produto'])) :
        $sql .= " AND produto = '" . $_GET['produto'] . "' ";
    endif;

    if (!empty($_GET['fornecedor'])) :
        $sql .= " AND fornecedor = '" . $_GET['fornecedor'] . "' ";
    endif;

    $sql .= ' ORDER BY estoqueprodutos.produto, estoqueprodutos.ordem1, estoqueprodutos.ordem2, estoqueprodutos.var1, estoqueprodutos.var2  ASC';

//    echo $sql;
    $arrayParam = '';
    $dadosEstoque = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

    foreach ($dadosEstoque as $value) :

        $array = json_decode(json_encode($value), true);

        if ($_GET['empresa'] == 'T') :

            for ($i = 0; $i < count($dadosemit); $i++) :

                $empresa = $dadosemit[$i];
                $estoque = 'qtd' . $empresa;

                // echo $empresa;
                //  echo '<br/>';

                $pdo = Conexao::getInstance();
                $crud = Crud::getInstance($pdo, 'temp_estoque');
                if ($value->var2 == '') :
                    $sql = "SELECT * FROM temp_estoque WHERE produto = '$value->produto' and documento = '" . $empresa . "'";
                else :
                    $sql = "SELECT * FROM temp_estoque WHERE produto = '$value->produto' and var1 = '$value->var1' and documento = '" . $empresa . "'";
                endif;
                $arrayParam = '';
                $dadosit = $crud->getSQLGeneric($sql, $arrayParam, true);

                $totalregistro = count($dadosit);
                if ($totalregistro > 0) :
                    if ($value->var2 == '') :
                        $variacoes = $dadosit[0]->variacoes . '|' . $value->var1 . ':' . $array[$estoque];
                    else :
                        $variacoes = $dadosit[0]->variacoes . '|' . $value->var2 . ':' . $array[$estoque];
                    endif;
                    $sql = "UPDATE temp_estoque SET variacoes = '$variacoes' where id = '" . $dadosit[0]->id . "'";
                    $insert = $crud->Sql($sql);

                // echo $sql;
                else :
                    if ($value->var2 == '') :
                        $var = '';
                        $variacoes = $value->var1 . ':' . $array[$estoque];
                    else :
                        $var = $value->var1;
                        $variacoes = $value->var2 . ':' . $array[$estoque];
                    endif;

//                        echo $variacoes;
                    $sql = "INSERT INTO temp_estoque(produto, ref, descricao, var1, variacoes, vunit, total, documento,variacao)
                VALUES ('$value->produto', '$value->ref', '$value->descricao', '$var', '$variacoes',
                  '$value->custo', '',  '" . $empresa . "', '$value->variacao')
                ";
                    $insert = $crud->Sql($sql);

                // echo $sql;

                endif;
            endfor;

        else :

            //empresa unica
            $empresa = $_GET['empresa'];
            $estoque = 'qtd' . $empresa;

            // echo $empresa;
            //  echo '<br/>';

            $pdo = Conexao::getInstance();
            $crud = Crud::getInstance($pdo, 'temp_estoque');
            if ($value->var2 == '') :
                $sql = "SELECT * FROM temp_estoque WHERE produto = '$value->produto' and documento = '" . $empresa . "'";
            else :
                $sql = "SELECT * FROM temp_estoque WHERE produto = '$value->produto' and var1 = '$value->var1' and documento = '" . $empresa . "'";
            endif;
            $arrayParam = '';
            $dadosit = $crud->getSQLGeneric($sql, $arrayParam, true);

            $totalregistro = count($dadosit);
            if ($totalregistro > 0) :
                if ($value->var2 == '') :
                    $variacoes = $dadosit[0]->variacoes . '|' . $value->var1 . ':' . $value->estoque;
                else :
                    $variacoes = $dadosit[0]->variacoes . '|' . $value->var2 . ':' . $value->estoque;
                endif;
                $sql = "UPDATE temp_estoque SET variacoes = '$variacoes' where id = '" . $dadosit[0]->id . "'";
                $insert = $crud->Sql($sql);

            // echo $sql;
            else :
                if ($value->var2 == '') :
                    $var = '';
                    $variacoes = $value->var1 . ':' . $value->estoque;
                else :
                    $var = $value->var1;
                    $variacoes = $value->var2 . ':' . $value->estoque;
                endif;

//                        echo $variacoes;
                $sql = "INSERT INTO temp_estoque(produto, ref, descricao, var1, variacoes, vunit, total, documento, variacao)
                VALUES ('$value->produto', '$value->ref', '$value->descricao', '$var', '$variacoes',
                  '$value->custo', '',  '" . $empresa . "', '$value->variacao')
                ";
                $insert = $crud->Sql($sql);

            // echo $sql;

            endif;
        endif;

    endforeach;
    ?>


    <body>

        <div align="center" style="font-size: 12px;">
            <b>RELAÇÃO DE ESTOQUE DOS PRODUTOS POR GRADE</b> <br/>
            <?= date("d/m/Y H:i") ?>


            <?php
            if (!empty($_GET['fornecedor'])) :
                $fornecedor = BuscaFornecedor($_GET['fornecedor']);
                ?>
                <br/>
                <?= $fornecedor->fornecedorid ?> - <?= $fornecedor->xNome ?>
                <?php
            endif;
            ?>
            <?php
            if ($_GET['empresa'] == 'T') :
                ?>
                <br/>
                FILIAL: TODAS
                <?php
            else :
                ?>
                <br/>
                FILIAL: <?= BucaFilial($_GET['empresa']) ?>
            <?php
            endif;
            ?>

        </div>


        <table class="table table-striped table-condensed full_table_list" style="font-size: 12px; width: 100%;">
            <tr style="background-color: #dee2e6;">
                <?php
                if ($_GET['ref'] == 'S') :
                    ?>
                    <td><b>Ref.</b></td>
                    <?php
                endif;
                ?>
                <td style="width: 30%;"><b>Produto</b></td>
                <td><b>Var. 1</b></td>
                <td colspan="12" style="width: 50%;"><b>Quantidade</b></td>
                <td><b>Qtd. Total</b></td>
                <td><b>Valor</b></td>
                <td><b>Total</b></td>
            </tr>
            <?php
            $pdo = Conexao::getInstance();
            $crud = Crud::getInstance($pdo, 'temp_romaneio');
            $sql = "SELECT * FROM temp_estoque order by produto, ref, var1";
            $arrayParam = '';
            $dadositens = $crud->getSQLGeneric($sql, $arrayParam, true);
            $totalpeca = 0;
            $custototal = 0;
            $prodarray = array();
            $totalemit = count($dadosemit);
            $contagem = 1;
            foreach ($dadositens as $value) :
//        $total = $total + $value->total;
//        $totalpeca = 0;
                $valorliq = $valorliq + $value->total;
                ?>
                <tr style="background-color: #EEEBEB; border:#e6ede8 dashed 1px; border-left: none; border-right: none;">


                    <!--print_r($-->
                    <?php
                    $exibe = 'N';
                    if (!in_array($value->produto . $value->var1, $prodarray)) :
                        $totalemp = 0;
                        $custoemp = 0;
                        $contagem = 1;
                        $exibe = 'S';
                        if ($_GET['ref'] == 'S') :
                            ?>
                            <td>
                                <?= $value->ref ?>
                            </td>
                            <?php
                        endif;
                        ?>
                        <td colspan="6">
                            <?= $value->produto . ' ' . $value->descricao ?>

                        </td>

                        <td colspan="10">
                            <?= $value->var1 ?>
                        </td>
                    <tr/>
                    <?php
                endif;
                ?>    
                <tr style="border:#e6ede8 dashed 1px; border-left: none; border-right: none;">

                    <td colspan="2">
                        <?= BucaFilial($value->documento) ?>
                    </td>
                    <?php
                    $prodarray[] = $value->produto . $value->var1;

                    $separa = explode("|", $value->variacoes);
                    $grade = '';
                    $i = 0;
                    $qtditem = 0;

                    for ($index = 0; $index < count($separa); $index++) :
                        $grade = explode(":", $separa[$index]);

                        $totalpeca = $totalpeca + $grade[1];
                        $totalemp = $totalemp + $grade[1];
                        $qtditem = $qtditem + $grade[1];
                        echo '<td style="border: #e6ede8 dashed 1px">';
                        if ($exibe == 'S') :
                            $gradeinfo = BuscaVariacaoDesc($value->produto, $value->variacao, $grade[0], 2);
                            echo '<b>' . $gradeinfo . '</b>';
                            echo '<br/>';
                        endif;

                        echo intval($grade[1]);
                        echo '</td>';
                        $i++;
                    endfor;
                    for ($iz = $i; $iz < 12; $iz++) :
                        echo '<td>';
                        echo '</td>';
                    endfor;
                    ?>

                    <td><?= $qtditem ?> </td>
                    <td>R$ <?= number_format($value->vunit, $parametros->casadecimal, ',', '.') ?></td>
                    <td>R$ <?= number_format($qtditem * $value->vunit, $parametros->casadecimal, ',', '.') ?></td>

                </tr>

                <?php
                if ($contagem == $totalemit) :
                    ?>
                    <tr style="border:#e6ede8 dashed 1px; border-left: none; border-right: none;">
                        <?php
                        if ($_GET['ref'] == 'S') :
                            ?>
                            <td></td>
                            <?php
                        endif;
                        ?>
                        <td colspan="14"><b>TOTAIS</b></td>
                        <td><b><?= intval($totalemp) ?></b></td>
                        <td><b></b></td>
                        <td></td>

                    </tr>
                    <?php
                endif;
                $contagem++;
                $custototal = $custototal + ($qtditem * $value->vunit);
            endforeach;
            ?>

            <tr style="background-color: #dee2e6;">
                <?php
                if ($_GET['ref'] == 'S') :
                    ?>
                    <td></td>
                    <?php
                endif;
                ?>
                <td colspan="14"><b>TOTAIS</b></td>
                <td><b><?= intval($totalpeca) ?></b></td>
                <td><b></b></td>
                <td><b>R$ <?= number_format($custototal, $parametros->casadecimal, ',', '.') ?></b></td>

            </tr>

        </table>


    </body>
</html>


<?php
if ($_GET['gerar'] == 'EXCEL') :
//    $data = parseDate($_POST['data'], "dmY");
    $file = 'estoquegrade.xls';
    header("Content-type: application/x-msexcel");
    header("Content-Disposition: attachment; filename=\"{$file}\"");
    header("Content-Description: PHP Generated Data");
elseif ($_GET['gerar'] == 'HTML') :
    echo '';
else :
    ini_set("pcre.backtrack_limit", "500000000000000");
    require_once("../../_inc/mpdf/vendor/autoload.php");
    $mpdf = new \Mpdf\Mpdf([
        'margin_top' => 5,
        'margin_left' => 5,
        'margin_right' => 5,
        'mirrorMargins' => true,
        'default_font_size' => 12,
    ]);
    $mpdf->keep_table_proportions = true;
    $mpdf->allow_charset_conversion = true;
    $footer = "<table width = \"1000\">
                   <tr>
                     <td style='font-size: 10px; bottom:-15px;' align=\"right\">Pag: {PAGENO} de {nb} " . date('d/m/Y') . "</td>
                   </tr>
                 </table>";
    $mpdf->SetHTMLFooter($footer);
    $html = ob_get_clean();
    $mpdf->SetTitle('Estoque');
    $mpdf->WriteHTML($html);
    $mpdf->Output();
// imprime

    exit();
endif;
?>