<?php
ob_start();
?>
<html>
    <head>
        <title> Relatório </title>
        <style>
            /*@import "../../../_frontend/_layout/assets/vendor/bootstrap/css/bootstrap.min.css";*/

            table {
                border-collapse: collapse;
            }
            thead {
                vertical-align: bottom;
                text-align: center;
                font-weight: bold;
            }
            tfoot {
                text-align: center;
                font-weight: bold;
            }
            th {
                text-align: left;
                padding-left: 0.35em;
                padding-right: 0.35em;
                padding-top: 0.35em;
                padding-bottom: 0.35em;
                vertical-align: top;
            }
            td {
                padding-left: 0.35em;
                padding-right: 0.35em;
                padding-top: 0.35em;
                padding-bottom: 0.35em;
                vertical-align: top;
            }

        </style>
    </head>
    <?php
    date_default_timezone_set("Brazil/East");
    require_once("../../../functions.php");
//
    require_once "../../../_backend/_class/Conexao_class.php";
    require_once "../../../_backend/_class/Crud_class.php";
    require_once "../../../_backend/_class/parametros.php";

    function BuscaProduto($codigo) {
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'usuario');
        $sql = "SELECT produtos.codigo, produtos.descricao, produtos.comissao,
estoqueprodutos.produto, estoqueprodutos.codproduto
FROM produtos 
INNER JOIN estoqueprodutos ON estoqueprodutos.produto = produtos.codigo
WHERE estoqueprodutos.codproduto = '$codigo'
";
        $arrayParam = '';
        $dadosproduto = $crud->getSQLGeneric($sql, $arrayParam, false);

        return $dadosproduto;
    }

    function BuscaVenda($valor) {
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'estoqueprodutos');
        $sql = "SELECT movimentacao.doc_empresa, movimentacao.data, movimentacao.documento, movimentacao.cliente,                
cliente.clienteid, cliente.xNome, cliente.whatsapp FROM movimentacao
left join cliente on clienteid = movimentacao.cliente
 WHERE documento = '$valor' ";
        $arrayParam = '';
        $dados = $crud->getSQLGeneric($sql, $arrayParam, false);

        return $dados;
    }

    function BuscaDev($valor) {
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'estoqueprodutos');
        $sql = "SELECT movimentacao_dev.doc_empresa, movimentacao_dev.data, movimentacao_dev.documento, movimentacao_dev.cliente,                
cliente.clienteid, cliente.xNome, cliente.whatsapp FROM movimentacao_dev
left join cliente on clienteid = movimentacao_dev.cliente 
WHERE documento = '$valor' ";

//        echo $sql;S
        $arrayParam = '';
        $dados = $crud->getSQLGeneric($sql, $arrayParam, false);

        return $dados;
    }

    function BuscaTroca($valor) {
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'estoqueprodutos');
        $sql = "SELECT movimentacao_troca.doc_empresa, movimentacao_troca.data, movimentacao_troca.documento, movimentacao_troca.cliente,                
cliente.clienteid, cliente.xNome, cliente.whatsapp FROM movimentacao_troca
left join cliente on clienteid = movimentacao_troca.cliente
 WHERE documento = '$valor' ";
        $arrayParam = '';
        $dados = $crud->getSQLGeneric($sql, $arrayParam, false);

        return $dados;
    }
    ?>

    <body>
        <div align="center">
            LISTAR PRODUTOS COM INFORMAÇÕES <BR/>

        </div>

        <table class="table table-condensed text-center" style="font-size: 12px; width: 100%; text-align: left">
            <tr>
                <td><b>Documento</b></td>
                <td><b>Data</b></td>
                <td><b>Cliente</b></td>
                <td><b>Whatsapp</b></td>
                <td><b>Produto</b></td>
                <td><b>Valor</b></td>
                <td><b>Imei</b></td>
                <td><b>Serie</b></td>
                <td><b>Bateria</b></td>
                <td><b>Obs</b></td>
            </tr>


            <tr> 
                <td colspan="10" style="background-color: #F5F5F5">VENDA</td>  
            </tr>
            <?php
            $pdo = Conexao::getInstance();
            $crud = Crud::getInstance($pdo, 'fornecedor');
            $sql = "SELECT * FROM itmovimentacao WHERE 1=1";

            if (!empty($_POST['serie'])) :
                $sql .= " AND serie = '" . $_POST['serie'] . "' ";
            endif;

            if (!empty($_POST['imei'])) :
                $sql .= " AND imei = '" . $_POST['imei'] . "' ";
            endif;

            if (!empty($_POST['bateria'])) :
                $sql .= " AND bateria = '" . $_POST['bateria'] . "' ";
            endif;

            $sql .= " order by documento ASC";
            $arrayParam = '';
            $dadosf = $crud->getSQLGeneric($sql, $arrayParam, true);

//            echo $sql;
            foreach ($dadosf as $dados) :
                $dadosvenda = BuscaVenda($dados->documento);
                $dadosprod = BuscaProduto($dados->produto);
                ?>
                <tr>
                    <td><?= $dadosvenda->doc_empresa ?></td>
                    <td><?= $dadosvenda->data ?></td>
                    <td><?= $dadosvenda->xNome ?></td>
                    <td><?= $dadosvenda->whatsapp ?></td>
                    <td><?= $dados->produto ?> <?= $dadosprod->descricao ?></td>
                    <td>R$ <?= number_format($dados->valorliquido, 2, ',', '') ?></td>
                    <td><?= $dados->imei ?> </td>
                    <td><?= $dados->serie ?> </td>
                    <td><?= $dados->bateria ?> </td>
                    <td><?= $dados->obs ?> </td>
                </tr>

                <?php
            endforeach;
            ?>


            <tr> 
                <td colspan="10" style="background-color: #F5F5F5">TROCA</td>  
            </tr>
            <?php
            $pdo = Conexao::getInstance();
            $crud = Crud::getInstance($pdo, 'fornecedor');
            $sql = "SELECT * FROM itmovimentacao_troca WHERE 1=1";

            if (!empty($_POST['serie'])) :
                $sql .= " AND serie = '" . $_POST['serie'] . "' ";
            endif;

            if (!empty($_POST['imei'])) :
                $sql .= " AND imei = '" . $_POST['imei'] . "' ";
            endif;

            if (!empty($_POST['bateria'])) :
                $sql .= " AND bateria = '" . $_POST['bateria'] . "' ";
            endif;

            $sql .= " order by documento ASC";
            $arrayParam = '';
            $dadosf = $crud->getSQLGeneric($sql, $arrayParam, true);

//            echo $sql;
            foreach ($dadosf as $dados) :
                $dadosvenda = BuscaTroca($dados->documento);
                $dadosprod = BuscaProduto($dados->produto);
                ?>
                <tr>
                    <td><?= $dadosvenda->doc_empresa ?></td>
                    <td><?= $dadosvenda->data ?></td>
                    <td><?= $dadosvenda->xNome ?></td>
                    <td><?= $dadosvenda->whatsapp ?></td>
                    <td><b> <?= $dados->operacao ?> </b> | <?= $dados->produto ?> <?= $dadosprod->descricao ?></td>
                    <td>R$ <?= number_format($dados->valorliquido, 2, ',', '') ?></td>
                    <td><?= $dados->imei ?> </td>
                    <td><?= $dados->serie ?> </td>
                    <td><?= $dados->bateria ?> </td>
                    <td><?= $dados->obs ?> </td>
                </tr>

                <?php
            endforeach;
            ?>

            <tr> 
                <td colspan="10" style="background-color: #F5F5F5">DEVOLUÇÃO</td>  
            </tr>
            <?php
            $pdo = Conexao::getInstance();
            $crud = Crud::getInstance($pdo, 'fornecedor');
            $sql = "SELECT * FROM itmovimentacao_dev WHERE 1=1";

            if (!empty($_POST['serie'])) :
                $sql .= " AND serie = '" . $_POST['serie'] . "' ";
            endif;

            if (!empty($_POST['imei'])) :
                $sql .= " AND imei = '" . $_POST['imei'] . "' ";
            endif;

            if (!empty($_POST['bateria'])) :
                $sql .= " AND bateria = '" . $_POST['bateria'] . "' ";
            endif;

            $sql .= " order by documento ASC";
            $arrayParam = '';
            $dadosf = $crud->getSQLGeneric($sql, $arrayParam, true);

//            echo $sql;
            foreach ($dadosf as $dados) :
                $dadosvenda = BuscaDev($dados->documento);
                $dadosprod = BuscaProduto($dados->produto);
                ?>
                <tr>
                    <td><?= $dadosvenda->doc_empresa ?></td>
                    <td><?= $dadosvenda->data ?></td>
                    <td><?= $dadosvenda->xNome ?></td>
                    <td><?= $dadosvenda->whatsapp ?></td>
                    <td><?= $dados->produto ?> <?= $dadosprod->descricao ?></td>
                    <td>R$ <?= number_format($dados->valorliquido, 2, ',', '') ?></td>
                    <td><?= $dados->imei ?> </td>
                    <td><?= $dados->serie ?> </td>
                    <td><?= $dados->bateria ?> </td>
                    <td><?= $dados->obs ?> </td>
                </tr>

                <?php
            endforeach;
            ?>


        </table>

    </body>
</html>
<?php
//print_r($_POST);
if ($_POST['gerar'] == 'PDF') :

    require_once("../../_inc/mpdf/vendor/autoload.php");
    ini_set("pcre.backtrack_limit", "500000000000000");

    $mpdf = new \Mpdf\Mpdf([
        'margin_top' => 5,
        'margin_left' => 5,
        'margin_right' => 5,
        'mirrorMargins' => true,
        'default_font_size' => 12,
        'format' => 'A4-L'
    ]);
    $mpdf->keep_table_proportions = true;
    $mpdf->allow_charset_conversion = true;
    $footer = "<table width = \"1000\">
                   <tr>
                     <td style='font-size: 10px; bottom:-15px;' align=\"right\">Pag: {PAGENO} de {nb} " . date('d/m/Y') . "</td>
                   </tr>
                 </table>";
    $mpdf->SetHTMLFooter($footer);
    $html = ob_get_clean();
    $mpdf->SetTitle('Informações de aparelhos');
    $mpdf->WriteHTML($html);
    $mpdf->Output();
// imprime

    exit();
elseif ($_POST['gerar'] == 'EXCEL') :
//    error_reporting(E_ALL);
//ini_set('display_errors', 'On');
    $file = 'estoque.xls';
    header("Content-type: application/x-msexcel");
    header("Content-Disposition: attachment; filename=\"{$file}\"");
    header("Content-Description: PHP Generated Data");

else :

endif;
?>