<?php
ob_start();
date_default_timezone_set("Brazil/East");
require_once("../../../functions.php");
require_once "../../../_backend/_class/Conexao_class.php";
require_once "../../../_backend/_class/Crud_class.php";
require_once "../../../_backend/_class/parametros.php";

function BuscaVariacaoDesc($produto) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'estoqueprodutos');
    $sql = "SELECT produtos.codigo, produtos.descricao, produtos.ref, estoqueprodutos.codproduto,estoqueprodutos.produto,
        estoqueprodutos.var1, estoqueprodutos.var2,estoqueprodutos.var3
        from produtos 
        INNER JOIN estoqueprodutos ON estoqueprodutos.produto = produtos.codigo
        where codproduto = '$produto'
        ";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, false);

    return $dados;
}

function VerificaGrupo($produto, $grupo) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'estoqueprodutos');
    $sql = "SELECT * from grupoprodutos where grupo like '" . $grupo . "%' AND produto = '$produto'";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, true);
    $total = count($dados);
//        echo $sql;
    return $total;
}

function BuscaEmpresa($empresa) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'estoqueprodutos');
    $sql = "SELECT * from emitente where emitenteid = '$empresa'
        ";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, false);

    return $dados->xFant;
}

$_POST['datai'] = parseDate($_POST['datai'], 'Y-m-d');
$_POST['dataf'] = parseDate($_POST['dataf'], 'Y-m-d');
?>
<html>
    <head>
        <title> Relatório </title>
        <style>
            /*@import "../../../_frontend/_layout/assets/vendor/bootstrap/css/bootstrap.min.css";*/

            table {
                border-collapse: collapse;
            }
            thead {
                vertical-align: bottom;
                text-align: center;
                font-weight: bold;
            }
            tfoot {
                text-align: center;
                font-weight: bold;
            }
            th {
                text-align: left;
                padding-left: 0.35em;
                padding-right: 0.35em;
                padding-top: 0.35em;
                padding-bottom: 0.35em;
                vertical-align: top;
            }
            td {
                padding-left: 0.35em;
                padding-right: 0.35em;
                padding-top: 0.35em;
                padding-bottom: 0.35em;
                vertical-align: top;
            }

        </style>
    </head>

    <body>

        <div align="center">
            PRODUTOS POR PERÍODO
            <br/> <small> <?= BuscaEmpresa($_POST['empresa']) ?> <br/><?= parseDate($_POST['datai'], "d/m/Y"); ?> à <?= parseDate($_POST['dataf'], "d/m/Y"); ?></small>
        </div>
        <table class="table table-bordered table-condesed" style="font-size: 10px; ">
            <tr> 
                <th style="width: 70%" class="text-left">Produto</th>
                <th style="width: 10%" class="text-left">Ref</th>
                <th style="width: 20%" class="text-left">Variação</th>
                <th style="width: 10%" class="text-left">Quantidade</th>
                <th style="width: 10%" class="text-left">Separado</th>
                <th style="width: 10%" class="text-left">Falta</th>
                <th style="width: 10%" class="text-left">Estoque Atual</th>
            </tr>

            <?php
            $empresaestoque = 'qtd' . $_POST['empresa'];

            $pdo = Conexao::getInstance();
            $crud = Crud::getInstance($pdo, 'usuario');
            $sql = 'Select pedidos.empresa, pedidos.documento , pedidos.data , pedidos.status,
            itpedido.documento, itpedido.produto, sum(itpedido.quantidade) as quantidade,  sum(itpedido.quantidadeprevia) as quantidadeprevia, 
            estoqueprodutos.produto as pd, estoqueprodutos.' . $empresaestoque . ' as estoque, estoqueprodutos.codproduto,estoqueprodutos.var1,estoqueprodutos.var2,
            produtos.codigo, produtos.prateleira, produtos.categoria, produtos.descricao, produtos.ref
            FROM pedidos           
            inner join itpedido ON itpedido.documento = pedidos.documento
            inner join estoqueprodutos ON estoqueprodutos.codproduto = itpedido.produto
            inner join produtos ON produtos.codigo = estoqueprodutos.produto
            where
            str_to_date(data, "%d/%m/%Y") BETWEEN "' . $_POST['datai'] . '" AND "' . $_POST['dataf'] . '" ';

            $sql .= " AND empresa = '" . $_POST['empresa'] . "'";

            if (!empty($_POST['produtos'])) :
                $sql .= " AND estoqueprodutos.produto = '" . $_POST['produtos'] . "' ";
            endif;

            if ($_POST['status'] != 'T') :
                $sql .= ' AND status = "' . $_POST['status'] . '" ';
            endif;

            $sql .= " GROUP BY itpedido.produto";
            $arrayParam = '';
            $movimentacao = $crud->getSQLGeneric($sql, $arrayParam, true);

//        echo $sql;
            $total = 0;
            $totalprevia = 0;
            $totalestoque = 0;
            $gera = 'S';
            foreach ($movimentacao as $movimentacao) :
                if (!empty($_POST['grupos'])) :
                    $tgrupo = 0;
                    $grupo = str_replace('.00', '', $_POST['grupos']);
                    $tgrupo = VerificaGrupo($movimentacao->codigo, $grupo);
                    if ($tgrupo > 0) :
                        $gera = 'S';
                    else :
                        $gera = 'N';
                    endif;
                endif;
                if ($gera == "S") :
//                    $dadosprod = BuscaVariacaoDesc($movimentacao->produto);
                    $total = $total + $movimentacao->quantidade;
                    $totalprevia = $totalprevia + $movimentacao->quantidadeprevia;
                    $totalestoque = $totalestoque + $movimentacao->estoque;
                    ?>
                    <tr>
                        <td style="border-bottom: 1px solid #6d6d6d"> <?= $movimentacao->codigo ?> <?= $movimentacao->descricao ?> </td>
                        <td style="border-bottom: 1px solid #6d6d6d"> <?= $movimentacao->ref ?> </td>
                        <td style="border-bottom: 1px solid #6d6d6d"><?= $movimentacao->codigo ?> &nbsp;&nbsp;&nbsp; <?= $movimentacao->var1 ?> &nbsp;&nbsp;&nbsp; <?= $movimentacao->var2 ?></td>
                        <td style="border-bottom: 1px solid #6d6d6d"> <?= intval($movimentacao->quantidade) ?> </td>
                        <td style="border-bottom: 1px solid #6d6d6d"> <?= intval($movimentacao->quantidadeprevia) ?> </td>
                        <td style="border-bottom: 1px solid #6d6d6d"> <?= intval($movimentacao->quantidade - $movimentacao->quantidadeprevia) ?> </td>
                        <td style="border-bottom: 1px solid #6d6d6d"> <?= intval($movimentacao->estoque) ?> </td>
                    </tr>
                    <?php
                endif;
            endforeach;
            ?>

            <tr>
                <th style="border-bottom: 1px solid #6d6d6d" colspan="3"> TOTAIS </th>
                <th style="border-bottom: 1px solid #6d6d6d"> <?= intval($total) ?> </th>
                <th style="border-bottom: 1px solid #6d6d6d"> <?= intval($totalprevia) ?> </th>
                <th style="border-bottom: 1px solid #6d6d6d"> <?= intval($total - $totalprevia) ?> </th>
                <th style="border-bottom: 1px solid #6d6d6d"> <?= intval($totalestoque) ?> </th>
            </tr>

        </table>
    </body>

</html>

<?php
if ($_POST['gerar'] == 'PDF') :
    ini_set("pcre.backtrack_limit", "500000000000000");
    require_once("../../_inc/mpdf/vendor/autoload.php");
    $mpdf = new \Mpdf\Mpdf([
        'margin_top' => 5,
        'margin_left' => 5,
        'margin_right' => 5,
        'mirrorMargins' => true,
        'default_font_size' => 12,
        'format' => 'A4'
    ]);
    $mpdf->keep_table_proportions = true;
    $mpdf->allow_charset_conversion = true;
    $footer = "<table width = \"1000\">
                   <tr>
                     <td style='font-size: 10px; bottom:-15px;' align=\"right\">Pag: {PAGENO} de {nb} " . date('d/m/Y') . "</td>
                   </tr>
                 </table>";
    $mpdf->SetHTMLFooter($footer);
    $html = ob_get_clean();
    $mpdf->SetTitle('Estoque');
    $mpdf->WriteHTML($html);
    $mpdf->Output();
// imprime

    exit();
elseif ($_POST['gerar'] == 'EXCEL') :
    $file = 'MaisVendidos.xls';
    header("Content-type: application/x-msexcel");
    header("Content-Disposition: attachment; filename=\"{$file}\"");
    header("Content-Description: PHP Generated Data");
else :
    echo '';
endif;
?>