<?php
ob_start();
?>
<html>
    <head>
        <title> Relatório </title>
    </head>
    <?php
    ob_start();

    date_default_timezone_set("Brazil/East");
    require_once("../../../functions.php");
//
    require_once "../../../_backend/_class/Conexao_class.php";
    require_once "../../../_backend/_class/Crud_class.php";
    require_once "../../../_backend/_class/cobranca_class.php";
    require_once "../../../_backend/_class/parametros.php";

    function Situacao($valor) {
        switch ($valor) {
            case 'PE':
                return "PENDENTE";
                break;
            case 'SE':
                return "SEPARAÇÃO";
                break;
            case 'EX':
                return "EXPEDIÇÃO";
                break;
            case 'ET':
                return "ENTREGUE";
                break;
            case 'EP':
                return "ENTREGUE PARCIALMENTE";
                break;
            case 'CO':
                return "CONCLUÍDO";
                break;
            case 'FA':
                return "FATURADO";
                break;
            case 'AF':
                return "AGURADANDO FATURAMENTO";
                break;
            case 'EN':
                return "ENVIADO";
                break;
            case 'BL':
                return "BLOQUEADO";
                break;
            case 'SU':
                return "SUSPENSO";
                break;
            case 'C':
                return "CANCELADO";
                break;
        }
    }

    function BuscaPara($valor, $id) {
        if ($valor == 'R') :
            $sql = "SELECT * from representante where representanteid = '$id' ";
        else :
            $sql = "SELECT * from cliente where clienteid = '$id' ";
        endif;

        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'tabela');
        $arrayParam = '';
        $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

        return $dados;
    }

    function BuscaPed($id) {
        $sql = "SELECT * from pedidos where documento = '$id' ";
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'tabela');
        $arrayParam = '';
        $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

        return $dados;
    }

    function BuscaCat($id) {
        $sql = "SELECT * from categorias where sigla = '$id' ";
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'tabela');
        $arrayParam = '';
        $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

        return $dados->descricao;
    }

    function TotalPecasSep($id) {
        $sql = "SELECT sum(quantidade) as total from itpedido_separacao where documento = '$id' and faturado = 'N'";
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'tabela');
        $arrayParam = '';
        $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

//        echo $sql;
        return $dados->total;
    }

    function TotalPecasFat($id) {
        $sql = "SELECT sum(quantidadeconferencia) as total from itpedido_separacao where documento = '$id' and faturado = 'S'";
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'tabela');
        $arrayParam = '';
        $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

//        echo $sql;
        return $dados->total;
    }

    function TotalPecasCanc($id) {
        $sql = "SELECT sum(quantidadecancelada) as total from itpedido where documento = '$id'";
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'tabela');
        $arrayParam = '';
        $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

//        echo $sql;
        return $dados->total;
    }

    function TotalPecas($id) {
        $sql = "SELECT sum(quantidade) as total from itpedido where documento = '$id'";
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'tabela');
        $arrayParam = '';
        $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

//        echo $sql;
        return $dados->total;
    }

    $_POST['datai'] = parseDate($_POST['datai'], 'Y-m-d');
    $_POST['dataf'] = parseDate($_POST['dataf'], 'Y-m-d');
    ?>
    <body>

        <?php require_once './cabecalho.php'; ?>

        <div align="center">
            RELAÇÃO DOS PEDIDOS
            <small><br/>
                <?php
                if (!empty($_POST['categoria'])) :
                    echo BuscaCat($_POST['categoria']);
                else :
                    echo parseDate($_POST['datai'], "d/m/Y");
                    ?> 
                    à
                    <?=
                    parseDate($_POST['dataf'], "d/m/Y");
                endif;
                ?>
            </small>
        </div>


        <table cellpadding="8" class="table table-striped table-bordered table-condensed full_table_list" style="font-size: 9px;">
            <tr>
                <th style="width: 4%">PED</th>
                <th style="width: 9%">SITUAÇÃO</th>
                <th style="width: 7%">DATA PEDIDO</th>
                <th style="width: 7%">DATA PREVISÃO</th>
                <th style="width: 15%">CLIENTE</th>
                <th style="width: 8%">TOTAL</th>
                <th style="width: 4%">QTD PED.</th>
                <th style="width: 4%">QTD SEP.</th>
                <th style="width: 4%">QTD FAT.</th>
                <th style="width: 4%">QTD CAN.</th>
                <th style="width: 4%">QTD DIF.</th>
                <th style="width: 15%">REPRESENTANTE</th>
                <th style="width: 8%">COLEÇÃO</th>
                <th style="width: 10%">ENDEREÇO</th>
                <th style="width: 10%">CIDADE</th>
                <th style="width: 4%">UF</th>
                <th style="width: 10%">OBS</th>
            </tr>


            <?php
            $pdo = Conexao::getInstance();
            $crud = Crud::getInstance($pdo, 'usuario');
            $sql = 'Select * from pedidos where pedidos.status <> "C"';

            if (!empty($_POST['empresa'])) :
                $sql .= " AND empresa = '" . $_POST['empresa'] . "'";
            endif;

            if (!empty($_POST['representante'])) :
                $sql .= " AND representante = '" . $_POST['representante'] . "'";
            endif;

            if (!empty($_POST['cliente'])) :
                $sql .= " AND cliente = '" . $_POST['cliente'] . "'";
            endif;

            if ($_POST['status'] <> 'T') :
                $sql .= " AND status = '" . $_POST['status'] . "'";
            endif;

            if (!empty($_POST['categoria'])) :
                $sql .= " AND categoria = '" . $_POST['categoria'] . "'";
            endif;

            $sql .= ' AND str_to_date(data, "%d/%m/%Y") 
                    BETWEEN "' . $_POST['datai'] . '" AND "' . $_POST['dataf'] . '"';

            $arrayParam = '';
            $movimentacao = $crud->getSQLGeneric($sql, $arrayParam, true);

//            echo $sql;
            $totalpeca = 0;
            $totalped = 0;
            $totalcomissaogeral = 0;
            foreach ($movimentacao as $ped) :

//                $pedidos = BuscaPed($ped->pedido);
                $cliente = BuscaPara('C', $ped->cliente);
                $representante = BuscaPara('R', $ped->representante);
                $qtdsep = TotalPecasSep($ped->documento);
                $qtdfat = TotalPecasFat($ped->documento);
                $qtd = TotalPecas($ped->documento);
                $qtdcan = TotalPecasCanc($ped->documento);
                $dif = $qtd - $qtdsep - $qtdfat - $qtdcan;

                $totalpeca = $totalpeca + $qtd;
                $totalsep = $totalsep + $qtdsep;
                $totalfat = $totalfat + $qtdfat;
                $totalcan = $totalcan + $qtdcan;
                $totalped = $totalped + $ped->valortotal;
//            print_r($pedidos);
                ?>
                <tr>
                    <td><?= $ped->doc_empresa ?></td>
                    <td><?= Situacao($ped->status) ?></td>
                    <td><?= $ped->data ?></td>
                    <td><?= $ped->previsao ?></td>
                    <td><?= $cliente->xNome ?></td>
                    <td>R$ <?= number_format($ped->valortotal, 2, ',', '.') ?></td>
                    <td><?= intval($qtd) ?></td>
                    <td><?= intval($qtdsep) ?></td>
                    <td><?= intval($qtdfat) ?></td>
                    <td><?= intval($qtdcan) ?></td>
                    <td><?= intval($dif) ?></td>
                    <td ><?= $representante->xNome ?></td>
                    <td ><?= BuscaCat($ped->categoria) ?></td>
                    <td ><?= $cliente->xLgr . ' nº' . $cliente->nro ?></td>
                    <td ><?= $cliente->xMun ?></td>
                    <td ><?= $cliente->UF ?></td>
                    <td ><?= $ped->obs ?></td>
                </tr>
                <?php
            endforeach;
            ?>


            <tr>
                <td colspan="5">TOTAIS</td>
                <td>R$ <?= number_format($totalped, 2, ',', '.') ?></td>
                <td><?= intval($totalpeca) ?></td>
                <td><?= intval($totalsep) ?></td>
                <td><?= intval($totalfat) ?></td>
                <td><?= intval($totalcan) ?></td>
                <td><?= intval($totalpeca - $totalsep - $totalfat - $totalcan) ?></td>
                <td colspan="3"></td>
            </tr>
        </table>
    </body>
</html>

<?php
if ($_POST['gerar'] == 'EXCEL') :
//    $data = parseDate($_POST['data'], "dmY");
    $file = 'faturamento_pedidos.xls';
    header("Content-type: application/x-msexcel");
    header("Content-Disposition: attachment; filename=\"{$file}\"");
    header("Content-Description: PHP Generated Data");
else :
    $stylesheet = " 
             .table-bordered th,
    .table-bordered td {
        border: 1px solid #ddd !important; } 

    .full_table_list_titulo{border-collapse: collapse;}
    .full_table_list_titulo tr{border:1px black solid;}

    .full_table_list{border-collapse: collapse;}
    .full_table_list tr{border:1px black solid;}
    .full_table_list tr:nth-child(even) {background: #eee}
    .full_table_list tr:nth-child(odd) {background: #fff}  

    .tablecor {border:1px black solid; background: #eee}
    .titulotr {border:1px black solid; background: #F5F5F5}
            table {width: 100%; padding: 10px;}
            tr {border:1px black solid}
            .titulotr {border:1px black solid; background: #F5F5F5}";

    require_once("../../_inc/mpdf/vendor/autoload.php");
    ini_set("pcre.backtrack_limit", "500000000000000");

    $mpdf = new \Mpdf\Mpdf([
        'margin_top' => 5,
        'margin_left' => 5,
        'margin_right' => 5,
        'mirrorMargins' => true,
        'default_font_size' => 12,
        'format' => 'A4-L'
    ]);
    $mpdf->keep_table_proportions = true;
    $mpdf->allow_charset_conversion = true;
    $footer = "<table width = \"1000\">
    <tr>
        <td style='font-size: 10px; bottom:-15px;' align=\"right\">Pag: {PAGENO} de {nb} " . date('d/m/Y') . "</td>
    </tr>
</table>";
    $mpdf->SetHTMLFooter($footer);
    $html = ob_get_clean();
    $mpdf->SetTitle('Lancamentos');
    $mpdf->WriteHTML($stylesheet, 1);
    $mpdf->WriteHTML($html, 2);
    $mpdf->Output();
// imprime

    exit();
endif;
?>