<?php
ob_start();
?>
<html>
    <head>
        <title> Relatório </title>
        <style>

            h1, h2, h3, h4, h5, h6,
            .h1, .h2, .h3, .h4, .h5, .h6 {
                font-family: inherit;
                font-weight: 500;
                line-height: 1.1;
                color: inherit;
            }
            h1 small,
            h1 .small, h2 small,
            h2 .small, h3 small,
            h3 .small, h4 small,
            h4 .small, h5 small,
            h5 .small, h6 small,
            h6 .small,
            .h1 small,
            .h1 .small, .h2 small,
            .h2 .small, .h3 small,
            .h3 .small, .h4 small,
            .h4 .small, .h5 small,
            .h5 .small, .h6 small,
            .h6 .small {
                font-weight: normal;
                line-height: 1;
                color: #777777;
            }

            h1, .h1,
            h2, .h2,
            h3, .h3 {
                margin-top: 20px;
                margin-bottom: 10px;
            }
            h1 small,
            h1 .small, .h1 small,
            .h1 .small,
            h2 small,
            h2 .small, .h2 small,
            .h2 .small,
            h3 small,
            h3 .small, .h3 small,
            .h3 .small {
                font-size: 65%;
            }

            h4, .h4,
            h5, .h5,
            h6, .h6 {
                margin-top: 10px;
                margin-bottom: 10px;
            }
            h4 small,
            h4 .small, .h4 small,
            .h4 .small,
            h5 small,
            h5 .small, .h5 small,
            .h5 .small,
            h6 small,
            h6 .small, .h6 small,
            .h6 .small {
                font-size: 75%;
            }

            h1, .h1 {
                font-size: 36px;
            }

            h2, .h2 {
                font-size: 30px;
            }

            h3, .h3 {
                font-size: 24px;
            }

            h4, .h4 {
                font-size: 18px;
            }

            h5, .h5 {
                font-size: 14px;
            }

            h6, .h6 {
                font-size: 12px;
            }
            .text-center {
                text-align: center;
            }

            table {
                width: 100%;
                padding: 3px;
            }

            td {
                padding: 0px;
            }
            th {
                text-align: left;
            }
            /*.titulotr { border:  none};*/
            /*.titulotr { background: #000; border:1px black solid;};*/
            .table-bordered th,
            .table-bordered td {
                border: 1px solid #ddd !important;
                border-bottom: 1px solid #ddd !important;
            }

            .full_table_list_titulo{
                border-collapse: collapse;
            }
            .full_table_list_titulo tr{
                border:1px black solid;
            }

            .full_table_list{
                border-collapse: collapse;
            }
            .full_table_list tr{
                border:1px black solid;
            }
            .full_table_list tr:nth-child(even) {
                background: #fff
            }
            .full_table_list tr:nth-child(odd) {
                background: #fff
            }

            .tablecor {
                border:1px black solid;
                background: #eee
            }
            .titulotr {
                border:1px black solid;
                background: #F5F5F5
            }
        </style>

    </head>
    <?php
    require_once "../../../_backend/_class/Conexao_class.php";
    require_once "../../../_backend/_class/Crud_class.php";
    require_once "../../../_backend/_class/parametros.php";

//error_reporting(E_ALL);
//ini_set('display_errors', 'On');
    function BuscaVariacaoDesc($prod, $variacao, $sigla, $nivel) {
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'estoqueprodutos');
        $sql = "SELECT produtos.variacao, produtos.codigo, 
                    variacao.variacaoid, variacao.var1, variacao.var2, 
                    variacao.var3 ,
                    itensvariacao.variacao, itensvariacao.sigla,
                    itensvariacao.descricao, itensvariacao.nivel
                    FROM produtos 
                    INNER JOIN variacao ON produtos.variacao = variacao.variacaoid 
                    INNER JOIN itensvariacao ON itensvariacao.variacao = variacao.variacaoid                   
                    WHERE codigo = '$prod' 
                    AND variacao.variacaoid = '$variacao'
                    AND itensvariacao.nivel = '$nivel'
                    AND itensvariacao.sigla = '$sigla'";
        $arrayParam = '';
        $dados = $crud->getSQLGeneric($sql, $arrayParam, false);

//                echo $sql;
        return $dados->descricao;
    }

    function BuscaDescProd($valor) {
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'vendedor');
        $sql = "SELECT * from produtos where codigo = '$valor'";
        $arrayParam = '';
        $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

        return $dados;
    }

    function BuscaCategoria($valor) {
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'vendedor');
        $sql = "SELECT * from categorias where sigla = '$valor'";
        $arrayParam = '';
        $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

        return $dados->descricao;
    }

    function BuscaProducao($produto) {
        //echo $produto;
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'vendedor');
        $sql = "SELECT pcp_ordemprod.produto, pcp_ordemprod.doc, pcp_ordemprod.situacao,
                pcp_itemprod.codproduto, sum(pcp_itemprod.qtd) AS qtd, sum(pcp_itemprod.qtdbaixa) AS qtdbaixa , 
                pcp_itemprod.doc FROM pcp_itemprod
                INNER JOIN pcp_ordemprod ON pcp_ordemprod.doc = pcp_itemprod.doc
                WHERE pcp_itemprod.codproduto = '$produto' 
                AND pcp_ordemprod.situacao <> 'C' AND pcp_ordemprod.situacao <> 'F' 
                GROUP BY pcp_itemprod.codproduto ";
        $arrayParam = '';
        $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

//        echo $sql;
        $qtd = $dados->qtd - $dados->qtdbaixa;
        if ($qtd > 0) :
            return $qtd;
        else :
            return 0;
        endif;
    }

//    error_reporting(E_ALL);
//    ini_set('display_errors', 'On');
//
    $_POST['datai'] = parseDate($_POST['datai'], 'Y-m-d');
    $_POST['dataf'] = parseDate($_POST['dataf'], 'Y-m-d');

    if (isset($_POST['categoria'])) :
        $categoria = $_POST['categoria'];
    else :
        $categoria = '';
    endif;

    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'temp_pedidos_producao');
    $sql = "DELETE FROM temp_pedidos_producao where empresa = '" . $_SESSION['Empresa'] . "'";
    $retornodel = $crud->Sql($sql);

    function BuscaSeparado($datai, $dataf, $produto, $categoria) {
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'itpedido');
        $sql = "SELECT sum(itpedido_separacao.quantidade) as qtd, itpedido_separacao.id,  itpedido_separacao.produto as prod, itpedido_separacao.item, itpedido_separacao.documento,
pedidos.data, pedidos.documento    
from itpedido_separacao 
INNER JOIN pedidos on pedidos.documento = itpedido_separacao.documento
WHERE itpedido_separacao.faturado = 'N'";

        if (!empty($categoria)) :
            $sql .= ' AND pedidos.categoria = "' . $categoria . '"';
        endif;

        $sql .= ' AND str_to_date(pedidos.data, "%d/%m/%Y") BETWEEN "' . $datai . '" AND "' . $dataf . '"';

//        $sql .= ' str_to_date(pedidos.data, "%d/%m/%Y") BETWEEN "' . $datai . '" AND "' . $dataf . '"';
        $sql .= " and produto = '$produto'";
        $sql .= "GROUP BY itpedido_separacao.produto";
        $arrayParam = '';
        $dadosit = $crud->getSQLGeneric($sql, $arrayParam, false);

//    echo $sql;
        if (empty($dadosit->qtd)) :
            return 0;
        else :
            return $dadosit->qtd;
        endif;
    }

    function BuscaFaturado($datai, $dataf, $produto, $categoria) {
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'itpedido');
        $sql = "SELECT sum(itpedido_separacao.quantidade) as qtd, itpedido_separacao.id,  itpedido_separacao.produto as prod, itpedido_separacao.item, itpedido_separacao.documento,
pedidos.data, pedidos.documento    
from itpedido_separacao 
INNER JOIN pedidos on pedidos.documento = itpedido_separacao.documento
WHERE itpedido_separacao.faturado = 'S'";

        if (!empty($categoria)) :
            $sql .= ' AND pedidos.categoria = "' . $categoria . '"';
        endif;

        $sql .= ' AND str_to_date(pedidos.data, "%d/%m/%Y") BETWEEN "' . $datai . '" AND "' . $dataf . '"';

//        $sql .= ' str_to_date(pedidos.data, "%d/%m/%Y") BETWEEN "' . $datai . '" AND "' . $dataf . '"';
        $sql .= " and produto = '$produto'";
        $sql .= "GROUP BY itpedido_separacao.produto";
        $arrayParam = '';
        $dadosit = $crud->getSQLGeneric($sql, $arrayParam, false);

//    echo $sql;
        if (empty($dadosit->qtd)) :
            return 0;
        else :
            return $dadosit->qtd;
        endif;
    }

    function BuscaQtdPedido($datai, $dataf, $produto, $categoria) {
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'itpedido');
        $sql = "SELECT sum(itpedido.quantidade) -  sum(itpedido.quantidadecancelada) as qtd, itpedido.id,  itpedido.produto as prod, itpedido.item, itpedido.documento,
pedidos.data, pedidos.documento    
from itpedido 
INNER JOIN pedidos on pedidos.documento = itpedido.documento
WHERE 1=1";

        if (!empty($categoria)) :
            $sql .= ' AND pedidos.categoria = "' . $categoria . '"';
        endif;

        $sql .= ' AND str_to_date(pedidos.data, "%d/%m/%Y") BETWEEN "' . $datai . '" AND "' . $dataf . '"';

//        $sql .= ' str_to_date(pedidos.data, "%d/%m/%Y") BETWEEN "' . $datai . '" AND "' . $dataf . '"';
        $sql .= " and produto = '$produto'";
        $sql .= "GROUP BY itpedido.produto";
        $arrayParam = '';
        $dadosit = $crud->getSQLGeneric($sql, $arrayParam, false);

//    echo $sql;
        if (empty($dadosit->qtd)) :
            return 0;
        else :
            return $dadosit->qtd;
        endif;
    }

    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'itpedido');
    $sql = "SELECT sum(itpedido.quantidade) -  sum(itpedido.quantidadecancelada) as qtd, itpedido.id,  itpedido.produto as prod, itpedido.item, itpedido.documento, itpedido.obs, itpedido.ordem,
itpedido.preco, estoqueprodutos.produto, estoqueprodutos.codproduto, estoqueprodutos.foto, estoqueprodutos.var1, estoqueprodutos.var2, estoqueprodutos.var3,
estoqueprodutos.acrescimo, estoqueprodutos.ordem1, estoqueprodutos.ordem2,
estoqueprodutos." . $_SESSION['Estoque'] . " as estoque, produtos.codigo, produtos.descricao, produtos.ref,
pedidos.data, pedidos.documento, pedidos.categoria    
from itpedido 
LEFT JOIN estoqueprodutos on itpedido.produto = estoqueprodutos.codproduto
LEFT JOIN produtos on produtos.codigo = estoqueprodutos.produto
INNER JOIN pedidos on pedidos.documento = itpedido.documento
WHERE 1=1";

    if (!empty($_POST['categoria'])) :
        $sql .= ' AND pedidos.categoria = "' . $_POST['categoria'] . '"';
    endif;

    $sql .= ' AND str_to_date(pedidos.data, "%d/%m/%Y") BETWEEN "' . $_POST['datai'] . '" AND "' . $_POST['dataf'] . '"';

    $sql .= "GROUP BY estoqueprodutos.produto
        ORDER BY produtos.codigo, produtos.ref, estoqueprodutos.ordem1, estoqueprodutos.ordem2, itpedido.item ASC";
    $arrayParam = '';
    $dadositp = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

//    echo $sql;

    foreach ($dadositp as $value) :
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'itpedido');
        $sql = "select estoqueprodutos.produto, estoqueprodutos.codproduto, estoqueprodutos.var1, estoqueprodutos.var2, estoqueprodutos.var3,
estoqueprodutos.acrescimo, estoqueprodutos.ordem1, estoqueprodutos.ordem2,
estoqueprodutos." . $_SESSION['Estoque'] . " as estoque from estoqueprodutos where produto = '$value->produto' order by ordem1, ordem2 ASC";
        $arrayParam = '';
        $dadosprod = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

        foreach ($dadosprod as $prod) :

            $pdo = Conexao::getInstance();
            $crud = Crud::getInstance($pdo, 'temp_pedidos_producao');
            if ($prod->var2 == '') :
                $sql = "SELECT * FROM temp_pedidos_producao WHERE produto = '$value->codigo' and empresa = '" . $_SESSION['Empresa'] . "'";
            else :
                $sql = "SELECT * FROM temp_pedidos_producao WHERE produto = '$value->codigo' and var1 = '$prod->var1' and empresa = '" . $_SESSION['Empresa'] . "'";
            endif;
            $arrayParam = '';
            $dadosit = $crud->getSQLGeneric($sql, $arrayParam, true);

            $totalregistro = count($dadosit);
            if ($totalregistro > 0) :

                if ($prod->var2 == '') :
                    $qtdpedido = BuscaQtdPedido($_POST['datai'], $_POST['dataf'], $prod->codproduto, $categoria);
                    $qtdseparacao = BuscaSeparado($_POST['datai'], $_POST['dataf'], $prod->codproduto, $categoria);
                    $qtd = abs($qtdpedido - $qtdseparacao) - BuscaFaturado($_POST['datai'], $_POST['dataf'], $prod->codproduto, $categoria);
                    $variacoes = $dadosit[0]->variacoes_pedido . '|' . $prod->var1 . ':' . $qtd;
                    $variacoessep = $dadosit[0]->variacoes_estoque . '|' . $prod->var1 . ':' . $prod->estoque;
                    $variacoes_sep = $dadosit[0]->variacoes_separacao . '|' . $prod->var1 . ':' . $qtdseparacao;
                else :
                    $qtdpedido = BuscaQtdPedido($_POST['datai'], $_POST['dataf'], $prod->codproduto, $categoria);
                    $qtdseparacao = BuscaSeparado($_POST['datai'], $_POST['dataf'], $prod->codproduto, $categoria);
                    $qtd = abs($qtdpedido - $qtdseparacao) - BuscaFaturado($_POST['datai'], $_POST['dataf'], $prod->codproduto, $categoria);
                    $variacoes = $dadosit[0]->variacoes_pedido . '|' . $prod->var2 . ':' . $qtd;
                    $variacoessep = $dadosit[0]->variacoes_estoque . '|' . $prod->var2 . ':' . $prod->estoque;
                    $variacoes_sep = $dadosit[0]->variacoes_separacao . '|' . $prod->var2 . ':' . $qtdseparacao;
                endif;

//        echo $variacoessep;
//        echo '<Br/>';
                $sql = "UPDATE temp_pedidos_producao SET "
                        . "variacoes_pedido = '$variacoes', variacoes_estoque = '$variacoessep', variacoes_separacao = '$variacoes_sep' where id = '" . $dadosit[0]->id . "'";
                $insert = $crud->Sql($sql);

            else :

                if ($prod->var2 == '') :
                    $qtdpedido = BuscaQtdPedido($_POST['datai'], $_POST['dataf'], $prod->codproduto, $categoria);
                    $qtdseparacao = BuscaSeparado($_POST['datai'], $_POST['dataf'], $prod->codproduto, $categoria);
                    $qtd = abs($qtdpedido - $qtdseparacao) - BuscaFaturado($_POST['datai'], $_POST['dataf'], $prod->codproduto, $categoria);
                    $var = '';
                    $variacoes = $prod->var1 . ':' . $qtd;
                    $variacoessep = $prod->var1 . ':' . $prod->estoque;
                    $variacoes_sep = $prod->var1 . ':' . $qtdseparacao;
                else :
                    $qtdpedido = BuscaQtdPedido($_POST['datai'], $_POST['dataf'], $prod->codproduto, $categoria);
                    $qtdseparacao = BuscaSeparado($_POST['datai'], $_POST['dataf'], $prod->codproduto, $categoria);
                    $qtd = abs($qtdpedido - $qtdseparacao) - BuscaFaturado($_POST['datai'], $_POST['dataf'], $prod->codproduto, $categoria);
                    $var = $prod->var1;
                    $variacoes = $prod->var2 . ':' . $qtd;
                    $variacoessep = $prod->var2 . ':' . $prod->estoque;
                    $variacoes_sep = $prod->var2 . ':' . $qtdseparacao;
                endif;

                $sql = "INSERT INTO temp_pedidos_producao(produto, ref, descricao, var1, variacoes_pedido, variacoes_estoque, variacoes_separacao, empresa)
                VALUES ('$value->codigo', '$value->ref', '$value->descricao', '$var', '$variacoes','$variacoessep', '$variacoes_sep', '" . $_SESSION['Empresa'] . "')";
                $insert = $crud->Sql($sql);
            endif;

        endforeach;

//        echo '<pre>';
//        print_r($dadosprod);
//        echo '<pre>';
    endforeach;
    ?>
    <html>

        <body>

            <div align="center">
                RELATORIO PEDIDOS PARA PRODUÇÃO
                <small>  
                    <br/>
                    <?= parseDate($_POST['datai'], "d/m/Y"); ?> à <?= parseDate($_POST['dataf'], "d/m/Y"); ?></small>
                <br/>
                <?php
                if (!empty($_POST['categoria'])) :
                    echo 'Categoria: ' . $_POST['categoria'] . ' - ' . BuscaCategoria($_POST['categoria']);

                endif;
                ?>
            </div>



            <table class="table" style="width: 100%; font-size: 10px;" >
                <tr >
                    <td>PRODUTO</td>
                    <td style="width: 80%">DESCRIÇÃO</td>
                </tr>


                <?php
                $pdo = Conexao::getInstance();
                $crud = Crud::getInstance($pdo, 'temp_romaneio');
                $sql = "SELECT * FROM temp_pedidos_producao WHERE empresa = '" . $_SESSION['Empresa'] . "' order by ref, var1";
                $arrayParam = '';
                $dadositens = $crud->getSQLGeneric($sql, $arrayParam, true);
                $totalpeca = 0;
                $prodtos = array();
                $sobra = array();
                $sobra1 = 0;
                $sobra2 = 0;
                $sobra3 = 0;
                $sobra4 = 0;
                $sobra5 = 0;
                $sobra6 = 0;
                $sobra7 = 0;
                $sobra8 = 0;
                $sobra9 = 0;
                $sobra10 = 0;
                $sobra11 = 0;
                $sobra12 = 0;
                $totalestoque = 0;
                $totalpedidos = 0;
                $prefaturamento = 0;
                $producao = 0;
                $sobratotal = 0;
                $produzirtotal = 0;
                foreach ($dadositens as $value) :
                    $soma1 = 0;
                    $soma2 = 0;
                    $soma3 = 0;
                    $soma4 = 0;
                    $soma5 = 0;
                    $soma6 = 0;
                    $soma7 = 0;
                    $soma8 = 0;
                    $soma9 = 0;
                    $soma10 = 0;
                    $soma11 = 0;
                    $soma12 = 0;

                    $prodinfo = BuscaDescProd($value->produto);
                    if (!in_array($value->produto, $prodtos)) :
                        $prodtos[] = $value->produto;
                        ?>
                        <tr style="border-bottom: 1px dashed #dee2e6; background-color: #c6c6c6; ">
                            <td style=" border-bottom: 1px solid #ddd; padding: 5px;">
                                <b> <?= $value->produto ?> </b>
                            </td>
                            <td style=" border-bottom: 1px solid #ddd; padding: 5px;">
                                <b>  <?= $value->ref . ' ' . $value->descricao ?></b>
                            </td>
                        </tr>
                    <?php else :
                        ?>
                        <tr>
                            <td colspan="2" style="border-bottom: 1px dashed #dee2e6;">

                            </td>
                        </tr>
                    <?php
                    endif;
                    ?>

                    <tr>
                        <td>
                            <?= $value->var1 ?> - <?= BuscaVariacaoDesc($value->produto, $prodinfo->variacao, $value->var1, 1) ?>
                        </td>

                        <td>
                            <table class="table table-bordered" style="width: 100%; font-size: 10px;" >
                                <tr>
                                    <?php
                                    $separa = explode("|", $value->variacoes_pedido);
                                    $grade = '';
                                    $i = 0;
                                    $qtditem = 0;
                                    ?>
                                    <td></td>
                                    <?php
                                    for ($index = 0;
                                            $index < count($separa);
                                            $index++) :
                                        $grade = explode(":", $separa[$index]);
                                        echo '<td style=" border-bottom: 1px solid #ddd;">';
                                        echo '<b>' . $grade[0] . '</b>';
                                        echo '</td>';
                                        $i++;
                                    endfor;
                                    for ($iz = $i;
                                            $iz < 12;
                                            $iz++) :
                                        echo '<td style=" border-bottom: 1px solid #ddd;">';
                                        echo '</td>';
                                    endfor;
                                    ?>
                                    <td></td>
                                </tr>

                                <tr>
                                    <td style="width: 20%">ESTOQUE</td>

                                    <?php
                                    $i = 0;
                                    $separa = explode("|", $value->variacoes_estoque);
                                    $qtditem = 0;
                                    $sb = 1;
                                    for ($index = 0;
                                            $index < count($separa);
                                            $index++) :
                                        $grade = explode(":", $separa[$index]);
                                        $totalpeca = $totalpeca + $grade[1];
                                        $qtditem = $qtditem + $grade[1];

                                        if ($sb == 1) :
                                            $soma1 = $soma1 + $grade[1];
                                        endif;

                                        if ($sb == 2) :
                                            $soma2 = $soma2 + $grade[1];
                                        endif;

                                        if ($sb == 3) :
                                            $soma3 = $soma3 + $grade[1];
                                        endif;

                                        if ($sb == 4) :
                                            $soma4 = $soma4 + $grade[1];
                                        endif;

                                        if ($sb == 5) :
                                            $soma5 = $soma5 + $grade[1];
                                        endif;

                                        if ($sb == 6) :
                                            $soma6 = $soma6 + $grade[1];
                                        endif;

                                        if ($sb == 7) :
                                            $soma7 = $soma7 + $grade[1];
                                        endif;

                                        if ($sb == 8) :
                                            $soma8 = $soma8 + $grade[1];
                                        endif;

                                        if ($sb == 9) :
                                            $soma9 = $soma9 + $grade[1];
                                        endif;

                                        if ($sb == 10) :
                                            $soma10 = $soma10 + $grade[1];
                                        endif;

                                        if ($sb == 11) :
                                            $soma11 = $soma11 + $grade[1];
                                        endif;

                                        if ($sb == 12) :
                                            $soma12 = $soma12 + $grade[1];
                                        endif;
                                        $totalestoque = $totalestoque + intval($grade[1]);

                                        echo '<td style=" border-bottom: 1px solid #ddd;">';
                                        echo intval($grade[1]);
                                        echo '</td>';
                                        $i++;
                                        $sb++;
                                    endfor;
                                    for ($iz = $i;
                                            $iz < 12;
                                            $iz++) :
                                        echo '<td style=" border-bottom: 1px solid #ddd;">';
                                        echo '</td>';
                                    endfor;
                                    ?>

                                    <td><?= $qtditem ?> </td>
                                </tr>


                                <tr>
                                    <td style="width: 20%">PEDIDOS</td>

                                    <?php
                                    $i = 0;
                                    $separa = explode("|", $value->variacoes_pedido);
                                    $qtditem = 0;
                                    $sb = 1;

                                    for ($index = 0;
                                            $index < count($separa);
                                            $index++) :
                                        $grade = explode(":", $separa[$index]);
                                        $totalpeca = $totalpeca + $grade[1];
                                        $qtditem = $qtditem + $grade[1];

                                        if ($sb == 1) :
                                            $soma1 = $soma1 - $grade[1];
                                        endif;

                                        if ($sb == 2) :
                                            $soma2 = $soma2 - $grade[1];
                                        endif;

                                        if ($sb == 3) :
                                            $soma3 = $soma3 - $grade[1];
                                        endif;

                                        if ($sb == 4) :
                                            $soma4 = $soma4 - $grade[1];
                                        endif;

                                        if ($sb == 5) :
                                            $soma5 = $soma5 - $grade[1];
                                        endif;

                                        if ($sb == 6) :
                                            $soma6 = $soma6 - $grade[1];
                                        endif;

                                        if ($sb == 7) :
                                            $soma7 = $soma7 - $grade[1];
                                        endif;

                                        if ($sb == 8) :
                                            $soma8 = $soma8 - $grade[1];
                                        endif;

                                        if ($sb == 9) :
                                            $soma9 = $soma9 - $grade[1];
                                        endif;

                                        if ($sb == 10) :
                                            $soma10 = $soma10 - $grade[1];
                                        endif;

                                        if ($sb == 11) :
                                            $soma11 = $soma11 - $grade[1];
                                        endif;

                                        if ($sb == 12) :
                                            $soma12 = $soma12 - $grade[1];
                                        endif;

                                        $totalpedidos = $totalpedidos + intval($grade[1]);
                                        echo '<td style=" border-bottom: 1px solid #ddd;">';
                                        echo intval($grade[1]);
                                        echo '</td>';
                                        $i++;
                                        $sb++;
                                    endfor;
                                    for ($iz = $i;
                                            $iz < 12;
                                            $iz++) :
                                        echo '<td style=" border-bottom: 1px solid #ddd;">';
                                        echo '</td>';
                                    endfor;
                                    ?>

                                    <td><?= $qtditem ?> </td>
                                </tr>


                                <tr>
                                    <td style="width: 20%">PRE-FATURAMENTO</td>

                                    <?php
                                    $i = 0;
                                    $separa = explode("|", $value->variacoes_separacao);
                                    $qtditem = 0;
                                    $sb = 1;
                                    for ($index = 0;
                                            $index < count($separa);
                                            $index++) :
                                        $grade = explode(":", $separa[$index]);
                                        $totalpeca = $totalpeca + $grade[1];
                                        $qtditem = $qtditem + $grade[1];

//                                        if ($sb == 1) :
//                                            $soma1 = $soma1 + $grade[1];
//                                        endif;
//
//                                        if ($sb == 2) :
//                                            $soma2 = $soma2 + $grade[1];
//                                        endif;
//
//                                        if ($sb == 3) :
//                                            $soma3 = $soma3 + $grade[1];
//                                        endif;
//
//                                        if ($sb == 4) :
//                                            $soma4 = $soma4 + $grade[1];
//                                        endif;
//
//                                        if ($sb == 5) :
//                                            $soma5 = $soma5 + $grade[1];
//                                        endif;
//
//                                        if ($sb == 6) :
//                                            $soma6 = $soma6 + $grade[1];
//                                        endif;
//
//                                        if ($sb == 7) :
//                                            $soma7 = $soma7 + $grade[1];
//                                        endif;
//
//                                        if ($sb == 8) :
//                                            $soma8 = $soma8 + $grade[1];
//                                        endif;
//
//                                        if ($sb == 9) :
//                                            $soma9 = $soma9 + $grade[1];
//                                        endif;
//
//                                        if ($sb == 10) :
//                                            $soma10 = $soma10 + $grade[1];
//                                        endif;
//
//                                        if ($sb == 11) :
//                                            $soma11 = $soma11 + $grade[1];
//                                        endif;
//
//                                        if ($sb == 12) :
//                                            $soma12 = $soma12 + $grade[1];
//                                        endif;

                                        $prefaturamento = $prefaturamento + intval($grade[1]);
                                        echo '<td style=" border-bottom: 1px solid #ddd;">';
                                        echo intval($grade[1]);
                                        echo '</td>';
                                        $i++;
                                        $sb++;
                                    endfor;
                                    for ($iz = $i;
                                            $iz < 12;
                                            $iz++) :
                                        echo '<td style=" border-bottom: 1px solid #ddd;">';
                                        echo '</td>';
                                    endfor;
                                    ?>

                                    <td><?= $qtditem ?> </td>
                                </tr>

                                <tr>
                                    <td style="width: 20%">PRODUÇÃO</td>

                                    <?php
                                    $i = 0;
                                    $separa = explode("|", $value->variacoes_pedido);
                                    $qtditem = 0;
                                    $sb = 1;
                                    for ($index = 0;
                                            $index < count($separa);
                                            $index++) :
                                        $grade = explode(":", $separa[$index]);
                                        $totalpeca = $totalpeca + $grade[1];
                                        $qtdpd = BuscaProducao($value->produto . $value->var1 . $grade[0]);
                                        $qtditem = $qtditem + BuscaProducao($value->produto . $value->var1 . $grade[0]);

                                        if ($sb == 1) :
                                            $soma1 = $soma1 + $qtdpd;
                                        endif;

                                        if ($sb == 2) :
                                            $soma2 = $soma2 + $qtdpd;
                                        endif;

                                        if ($sb == 3) :
                                            $soma3 = $soma3 + $qtdpd;
                                        endif;

                                        if ($sb == 4) :
                                            $soma4 = $soma4 + $qtdpd;
                                        endif;

                                        if ($sb == 5) :
                                            $soma5 = $soma5 + $qtdpd;
                                        endif;

                                        if ($sb == 6) :
                                            $soma6 = $soma6 + $qtdpd;
                                        endif;

                                        if ($sb == 7) :
                                            $soma7 = $soma7 + $qtdpd;
                                        endif;

                                        if ($sb == 8) :
                                            $soma8 = $soma8 + $qtdpd;
                                        endif;

                                        if ($sb == 9) :
                                            $soma9 = $soma9 + $qtdpd;
                                        endif;

                                        if ($sb == 10) :
                                            $soma10 = $soma10 + $qtdpd;
                                        endif;

                                        if ($sb == 11) :
                                            $soma11 = $soma11 + $qtdpd;
                                        endif;

                                        if ($sb == 12) :
                                            $soma12 = $soma12 + $qtdpd;
                                        endif;

                                        $producao = $producao + intval($qtdpd);

                                        echo '<td style=" border-bottom: 1px solid #ddd;">';
                                        echo intval($qtdpd);
                                        echo '</td>';
                                        $i++;
                                        $sb++;
                                    endfor;
                                    for ($iz = $i;
                                            $iz < 12;
                                            $iz++) :
                                        echo '<td style=" border-bottom: 1px solid #ddd;">';
                                        echo '</td>';
                                    endfor;
                                    ?>

                                    <td><?= $qtditem ?> </td>
                                </tr>
                                <tr >
                                    <td style="width: 20%; font-weight: bold;">SOBRA</td>

                                    <?php
                                    $i = 0;
                                    $sb = 1;
                                    $totalsobra = 0;
                                    for ($iz = $i;
                                            $iz < 12;
                                            $iz++) :
                                        echo '<td style=" border-bottom: 1px solid #ddd; font-weight: bold;">';

                                        if ($sb == 1) :
                                            if ($soma1 > 0) :
                                                $totalsobra = $totalsobra + $soma1;
                                                echo $soma1;
                                            else :
                                                echo '0';
                                            endif;
                                        endif;

                                        if ($sb == 2) :
                                            if ($soma2 > 0) :
                                                $totalsobra = $totalsobra + $soma2;
                                                echo $soma2;
                                            else :
                                                echo '0';
                                            endif;
                                        endif;

                                        if ($sb == 3) :
                                            if ($soma3 > 0) :
                                                $totalsobra = $totalsobra + $soma3;
                                                echo $soma3;
                                            else :
                                                echo '0';
                                            endif;
                                        endif;

                                        if ($sb == 4) :
                                            if ($soma4 > 0) :
                                                $totalsobra = $totalsobra + $soma4;
                                                echo $soma4;
                                            else :
                                                echo '0';
                                            endif;
                                        endif;

                                        if ($sb == 5) :
                                            if ($soma5 > 0) :
                                                $totalsobra = $totalsobra + $soma5;
                                                echo $soma5;
                                            else :
                                                echo '0';
                                            endif;
                                        endif;

                                        if ($sb == 6) :
                                            if ($soma6 > 0) :
                                                $totalsobra = $totalsobra + $soma6;
                                                echo $soma6;
                                            else :
                                                echo '0';
                                            endif;
                                        endif;

                                        if ($sb == 7) :
                                            if ($soma7 > 0) :
                                                $totalsobra = $totalsobra + $soma7;
                                                echo $soma7;
                                            else :
                                                echo '0';
                                            endif;
                                        endif;

                                        if ($sb == 8) :
                                            if ($soma8 > 0) :
                                                $totalsobra = $totalsobra + $soma8;
                                                echo $soma8;
                                            else :
                                                echo '0';
                                            endif;
                                        endif;

                                        if ($sb == 9) :
                                            if ($soma9 > 0) :
                                                $totalsobra = $totalsobra + $soma9;
                                                echo $soma9;
                                            else :
                                                echo '0';
                                            endif;
                                        endif;

                                        if ($sb == 10) :
                                            if ($soma10 > 0) :
                                                $totalsobra = $totalsobra + $soma10;
                                                echo $soma10;
                                            else :
                                                echo '0';
                                            endif;
                                        endif;

                                        if ($sb == 11) :
                                            if ($soma11 > 0) :
                                                $totalsobra = $totalsobra + $soma11;
                                                echo $soma11;
                                            else :
                                                echo '0';
                                            endif;
                                        endif;

                                        if ($sb == 12) :
                                            if ($soma12 > 0) :
                                                $totalsobra = $totalsobra + $soma12;
                                                echo $soma12;
                                            else :
                                                echo '0';
                                            endif;
                                        endif;

                                        echo '</td>';
                                        $sb++;

                                    endfor;

                                    $sobratotal = $sobratotal + $totalsobra;
                                    ?>
                                    <td><?= $totalsobra ?> </td>
                                </tr>


                                <tr>
                                    <td style="width: 20%; font-weight: bold;">PRODUZIR</td>

                                    <?php
                                    $i = 0;
                                    $sb = 1;
                                    $totalproduzir = 0;
                                    for ($iz = $i;
                                            $iz < 12;
                                            $iz++) :
                                        echo '<td style=" border-bottom: 1px solid #ddd; font-weight: bold;">';

                                        if ($sb == 1) :
                                            if ($soma1 < 0) :
                                                $totalproduzir = $totalproduzir + abs($soma1);
                                                echo abs($soma1);
                                            else :
                                                echo '0';
                                            endif;
                                        endif;

                                        if ($sb == 2) :
                                            if ($soma2 < 0) :
                                                $totalproduzir = $totalproduzir + abs($soma2);
                                                echo abs($soma2);
                                            else :
                                                echo '0';
                                            endif;
                                        endif;

                                        if ($sb == 3) :
                                            if ($soma3 < 0) :
                                                $totalproduzir = $totalproduzir + abs($soma3);
                                                echo abs($soma3);
                                            else :
                                                echo '0';
                                            endif;
                                        endif;

                                        if ($sb == 4) :
                                            if ($soma4 < 0) :
                                                $totalproduzir = $totalproduzir + abs($soma4);
                                                echo abs($soma4);
                                            else :
                                                echo '0';
                                            endif;
                                        endif;

                                        if ($sb == 5) :
                                            if ($soma5 < 0) :
                                                $totalproduzir = $totalproduzir + abs($soma5);
                                                echo abs($soma5);
                                            else :
                                                echo '0';
                                            endif;
                                        endif;

                                        if ($sb == 6) :
                                            if ($soma6 < 0) :
                                                $totalproduzir = $totalproduzir + abs($soma6);
                                                echo abs($soma6);
                                            else :
                                                echo '0';
                                            endif;
                                        endif;

                                        if ($sb == 7) :
                                            if ($soma7 < 0) :
                                                $totalproduzir = $totalproduzir + abs($soma7);
                                                echo abs($soma7);
                                            else :
                                                echo '0';
                                            endif;
                                        endif;

                                        if ($sb == 8) :
                                            if ($soma8 < 0) :
                                                $totalproduzir = $totalproduzir + abs($soma8);
                                                echo abs($soma8);
                                            else :
                                                echo '0';
                                            endif;
                                        endif;

                                        if ($sb == 9) :
                                            if ($soma9 < 0) :
                                                $totalproduzir = $totalproduzir + abs($soma9);
                                                echo abs($soma9);
                                            else :
                                                echo '0';
                                            endif;
                                        endif;

                                        if ($sb == 10) :
                                            if ($soma10 < 0) :
                                                $totalproduzir = $totalproduzir + abs($soma10);
                                                echo abs($soma1,);
                                            else :
                                                echo '0';
                                            endif;
                                        endif;

                                        if ($sb == 11) :
                                            if ($soma11 < 0) :
                                                $totalproduzir = $totalproduzir + abs($soma11);
                                                echo abs($soma11);
                                            else :
                                                echo '0';
                                            endif;
                                        endif;

                                        if ($sb == 12) :
                                            if ($soma12 < 0) :
                                                $totalproduzir = $totalproduzir + abs($soma12);
                                                echo abs($soma12);
                                            else :
                                                echo '0';
                                            endif;
                                        endif;

                                        echo '</td>';

                                        $sb++;
                                    endfor;
                                    ?>

                                    <td><?= $totalproduzir ?> </td>
                                </tr>



                            </table>
                        </td>

                    </tr>
                    <?php
                    $produzirtotal = $produzirtotal + $totalproduzir;

                endforeach;
                ?>


                <tr style="border-bottom: 1px dashed #dee2e6;">
                    <td style="border-top: 1px dashed #dee2e6;">
                        TOTAIS
                    </td>
                    <td style="border-top: 1px dashed #dee2e6;">
                        <table class="table table-bordered" style="width: 100%; font-size: 10px;" >
                            <tr>
                                <td style="width: 20%; font-weight: bold;">ESTOQUE</td>
                                <?php
                                for ($iz = $i;
                                        $iz < 12;
                                        $iz++) :
                                    echo '<td style=" border-bottom: 1px solid #ddd;">';
                                    echo '</td>';
                                endfor;
                                ?>
                                <td><?= $totalestoque ?></td>
                            </tr>
                            <tr>
                                <td style="width: 20%; font-weight: bold;">PEDIDOS</td>
                                <?php
                                for ($iz = $i;
                                        $iz < 12;
                                        $iz++) :
                                    echo '<td style=" border-bottom: 1px solid #ddd;">';
                                    echo '</td>';
                                endfor;
                                ?>
                                <td><?= $totalpedidos ?></td>
                            </tr>
                            <tr>
                                <td style="width: 20%; font-weight: bold;">PRE-FATURAMENTO</td>
                                <?php
                                for ($iz = $i;
                                        $iz < 12;
                                        $iz++) :
                                    echo '<td style=" border-bottom: 1px solid #ddd;">';
                                    echo '</td>';
                                endfor;
                                ?>
                                <td><?= $prefaturamento ?></td>
                            </tr>
                            <tr>
                                <td style="width: 20%; font-weight: bold;">PRODUÇÃO</td>
                                <?php
                                for ($iz = $i;
                                        $iz < 12;
                                        $iz++) :
                                    echo '<td style=" border-bottom: 1px solid #ddd;">';
                                    echo '</td>';
                                endfor;
                                ?>
                                <td><?= $producao ?></td>
                            </tr>
                            <tr>
                                <td style="width: 20%; font-weight: bold;">SOBRA</td>
                                <?php
                                for ($iz = $i;
                                        $iz < 12;
                                        $iz++) :
                                    echo '<td style=" border-bottom: 1px solid #ddd;">';
                                    echo '</td>';
                                endfor;
                                ?>
                                <td><?= $sobratotal ?></td>
                            </tr>
                            <tr>
                                <td style="width: 20%; font-weight: bold;">PRODUZIR</td>
                                <?php
                                for ($iz = $i;
                                        $iz < 12;
                                        $iz++) :
                                    echo '<td style=" border-bottom: 1px solid #ddd;">';
                                    echo '</td>';
                                endfor;
                                ?>
                                <td><?= $produzirtotal ?></td>
                            </tr>
                        </table>
                    </td>
                </tr>

            </table>

        </body>

    </html>


    <?php
if ($_POST['gerar'] == 'PDF') :
    require_once("../../_inc/mpdf/vendor/autoload.php");
    ini_set("pcre.backtrack_limit", "500000000000000");

    $mpdf = new \Mpdf\Mpdf([
        'margin_top' => 5,
        'margin_left' => 5,
        'margin_right' => 5,
        'mirrorMargins' => true,
        'default_font_size' => 12,
        'default_font' => 'sans-serif',
    ]);
//$mpdf->SetWatermarkText('DRAFT');
    $mpdf->keep_table_proportions = true;
    $mpdf->allow_charset_conversion = true;
    $footer = "<table width = \"1000\">
                   <tr>
                     <td style='font-size: 10px; bottom:-15px;' align=\"right\">Pag: {PAGENO} de {nb} " . date('d/m/Y') . "</td>
                   </tr>
                 </table>";
    $mpdf->SetHTMLFooter($footer);
    $html = ob_get_clean();
    $mpdf->SetTitle('Movimentações');
    $mpdf->WriteHTML($html);
    $mpdf->Output();
// imprime

    exit();
elseif ($_POST['gerar'] == 'EXCEL') :
    $file = 'pedidoproducao.xls';
    header("Content-type: application/x-msexcel");
    header("Content-Disposition: attachment; filename=\"{$file}\"");
    header("Content-Description: PHP Generated Data");
else :
    echo '';
endif;
    ?>