<?php
ob_start();
?>
<html>
    <head>
        <title> Relatório </title>
        <style>
            /*@import "../../../_frontend/_layout/assets/vendor/bootstrap/css/bootstrap.min.css";*/      

            table {
                border-collapse: collapse;
            }
            thead {
                vertical-align: bottom;
                text-align: center;
                font-weight: bold;
            }
            tfoot {
                text-align: center;
                font-weight: bold;
            }
            th {
                text-align: left;
                padding-left: 0.35em;
                padding-right: 0.35em;
                padding-top: 0.35em;
                padding-bottom: 0.35em;
                vertical-align: top;
            }
            td {
                padding-left: 0.35em;
                padding-right: 0.35em;
                padding-top: 0.35em;
                padding-bottom: 0.35em;
                vertical-align: top;
            }

        </style>
    </head>

    <?php
    date_default_timezone_set("Brazil/East");
    require_once("../../../functions.php");
//

    require_once "../../../_backend/_class/Conexao_class.php";
    require_once "../../../_backend/_class/Crud_class.php";
    require_once "../../../_backend/_class/cobranca_class.php";
    require_once "../../../_backend/_class/parametros.php";

    $_POST['datai'] = parseDate($_POST['datai'], 'Y-m-d');
    $_POST['dataf'] = parseDate($_POST['dataf'], 'Y-m-d');

    $dataitime = strtotime($_POST['datai']);
    $dataftime = strtotime($_POST['dataf']);

    $dataconsulta = date("Y-m-d");
    $data1 = parseDate($dataconsulta, 'd/m/Y');

    function RetornaGrade($documento, $ordem) {
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'itpedido');
        $sql = "SELECT itpedido.quantidade as qtd,  itpedido.quantidadeprevia as previa, itpedido.valorliquido as  valorliquido, itpedido.valorbruto as valorbruto ,
itpedido.id,  itpedido.produto as prod, itpedido.item, itpedido.documento, itpedido.obs, itpedido.ordem,
itpedido.preco, estoqueprodutos.produto, estoqueprodutos.codproduto, estoqueprodutos.foto, estoqueprodutos.var1, estoqueprodutos.var2, estoqueprodutos.var3,
estoqueprodutos.acrescimo, produtos.codigo, produtos.descricao, produtos.ref from itpedido 
LEFT JOIN estoqueprodutos on itpedido.produto = estoqueprodutos.codproduto
LEFT JOIN produtos on produtos.codigo = estoqueprodutos.produto
WHERE itpedido.documento = '$documento' and ordem = '$ordem'";
        $sql .= " ORDER BY itpedido.item ASC";
        $arrayParam = '';
        $dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

        return $dados;
    }

    function Situacao($valor) {
        switch ($valor) {
            case 'PE':
                return "PENDENTE";
                break;
            case 'SE':
                return "SEPARAÇÃO";
                break;
            case 'EX':
                return "EXPEDIÇÃO";
                break;
            case 'ET':
                return "ENTREGUE";
                break;
            case 'EP':
                return "ENTREGUE PARCIALMENTE";
                break;
            case 'CO':
                return "CONCLUÍDO";
                break;
            case 'FA':
                return "FATURADO";
                break;
            case 'EN':
                return "ENVIADO";
                break;
            case 'BL':
                return "BLOQUEADO";
                break;
            case 'SU':
                return "SUSPENSO";
                break;
            case 'C':
                return "CANCELADO";
                break;
        }
    }

    function Vendedor($valor) {
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'usuario');
        $sql = "SELECT * from vendedor where vendedorid = '" . $valor . "' ";
        $arrayParam = '';
        $vendedor = $crud->getSQLGeneric($sql, $arrayParam, false);
        return $vendedor->xNome;
    }

    function BuscaPara($valor, $id) {

        if ($valor == 'R') :
            $sql = "SELECT * from representante where representanteid = '$id' ";
        elseif ($valor == 'F') :
            $sql = "SELECT * from funcionario where funcionarioid = '$id' ";
        else :
            $sql = "SELECT * from cliente where clienteid = '$id' ";
        endif;

        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'tabela');
        $arrayParam = '';
        $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

        return $dados;
    }

    if ($_POST['databusca'] == 'E') :

        $titulo = 'EMISSÃO';
    else :
        $titulo = 'PREVISÃO';

    endif;
    ?>
    <body>

        <div align="center">
            RELATÓRIO DE MOVIMENTAÇÕES
            <br/> <small> GERAL POR DATA DE <?= $titulo ?><br/><?= parseDate($_POST['datai'], "d/m/Y"); ?> à <?= parseDate($_POST['dataf'], "d/m/Y"); ?></small>

        </div>


        <?php require_once './cabecalho.php'; ?>

        <table class="table table-bordered" style="font-size: 10px;">
            <tr> 
                <th style="width: 5%" class="text-left">Doc</th>
                <th style="width: 8%" class="text-left">Controle</th>
                <th style="width: 45%" class="text-left">Nome</th>
                <th style="width: 15%" class="text-left">Data</th>
                <th style="width: 15%" class="text-left">Previsão</th>
                <th style="width: 10%" class="text-left">Desc.</th>
                <th style="width: 10%" class="text-left">Frete</th>
                <th style="width: 10%" class="text-left">Total</th>
                <th style="width: 10%" class="text-left">Situação</th>
            </tr>
            <?php
            if ($_POST['tipor'] == 'C') :
                ?>
                <tr> 
                    <th></th>
                    <th colspan="4">Produto</th>
                    <th>Quantitade</th>
                    <th>Qtd. Total</th>
                    <th>Valor Unit.</th>
                    <th>Total</th>
                </tr>
                <?php
            endif;
            ?>
            <tr>
                <td colspan="9" align="center"><hr/> <h3>MOVIMENTAÇÕES DE PEDIDOS</h3><hr/></td>
            </tr>
            <?php
            $totalvenda = 0;
            $desciten = 0;
            $descdoc = 0;
            $totalbruto = 0;
            $totalliquido = 0;
            $totalprod = 0;
            $totalprevia = 0;

//            echo $tabelabd;
            $pdo = Conexao::getInstance();
            $crud = Crud::getInstance($pdo, 'usuario');
            $sql = 'Select * FROM pedidos';

            if ($_POST['databusca'] == 'E') :
                $sql .= ' where str_to_date(data, "%d/%m/%Y") BETWEEN "' . $_POST['datai'] . '" AND "' . $_POST['dataf'] . '"';
            else :
                $sql .= ' where str_to_date(previsao, "%d/%m/%Y") BETWEEN "' . $_POST['datai'] . '" AND "' . $_POST['dataf'] . '"';
            endif;

            if (!empty($_POST['cliente'])) :
                $sql .= ' AND cliente = "' . $_POST['cliente'] . '" ';
            endif;

            if (!empty($_POST['vendedor'])) :
                $sql .= ' AND vendedor = "' . $_POST['vendedor'] . '" ';
            endif;

            if (!empty($_POST['representante'])) :
                $sql .= ' AND representante = "' . $_POST['representante'] . '" ';
            endif;

            if ($_POST['status'] != 'T') :
                if ($_POST['doccanc'] == 'S') :
                    $sql .= ' AND ((status = "' . $_POST['status'] . '") OR (status = "C")) ';
                else :
                    $sql .= ' AND status = "' . $_POST['status'] . '" ';
                endif;
            endif;

            $sql .= ' AND empresa = "' . $_POST['empresa'] . '"';
            $sql .= '  ORDER BY  doc_empresa ASC';

//            echo $sql;
            $frete = 0;

            $arrayParam = '';
            $movimentacao = $crud->getSQLGeneric($sql, $arrayParam, true);
            $docinicialsaida = 0;
            $docfinalsaida = 0;
            foreach ($movimentacao as $movimentacao) :

                if ($docinicialsaida == '0') :
                    $docinicialsaida = $movimentacao->doc_empresa;
                endif;
                $docfinalsaida = $movimentacao->doc_empresa;

//soma
                if ($movimentacao->status != 'C') :
                    $frete = $frete + $movimentacao->frete;
                    $totalbruto = $totalbruto + $movimentacao->valortotal + $movimentacao->desconto;
                    $totalliquido = $totalliquido + $movimentacao->valortotal;
                    $descdoc = $descdoc + $movimentacao->desconto;
                endif;

                $totalvenda++;

                $id = $movimentacao->cliente;
                $dest = BuscaPara('C', $movimentacao->cliente);
                ?>
                <tr> 
                    <td><?= $movimentacao->doc_empresa ?></td>
                    <td><?= $movimentacao->controle ?></td>
                    <td><?= $id ?> - <?= $dest->xNome ?></td>
                    <td><?= $movimentacao->data ?></td>
                    <td><?= $movimentacao->previsao ?></td>
                    <td>R$ <?= number_format($movimentacao->desconto, $parametros->casadecimal, ',', '.') ?></td>
                    <td>R$ <?= number_format($movimentacao->frete, $parametros->casadecimal, ',', '.') ?></td>
                    <td>R$ <?= number_format($movimentacao->valortotal, $parametros->casadecimal, ',', '.') ?></td>
                    <td><?= Situacao($movimentacao->status) ?></td>
                </tr>
                <tr>
                    <td></td>
                    <td><b>Vendedor(a) :</b></td>
                    <td colspan="7"><?= $movimentacao->vendedor ?> - <?= Vendedor($movimentacao->vendedor) ?></td>
                </tr>
                <!--<tr>-->
                    <!--<td colspan="7">-->

                                                                                                                                                                                                                                                                                                                                                                                                                                                    <!--<table class="table" style="border: none;">-->


                <?php
                $pdo = Conexao::getInstance();
                $crud = Crud::getInstance($pdo, 'usuario');
                $sql = "SELECT sum(itpedido.quantidade) as qtd, sum(itpedido.quantidadeprevia) as previa, sum(itpedido.valorliquido) as valorliquido, itpedido.valorbruto as valorbruto ,
itpedido.id,  itpedido.produto as prod, itpedido.item, itpedido.documento, itpedido.obs, itpedido.ordem,
itpedido.preco,
estoqueprodutos.produto, estoqueprodutos.codproduto, estoqueprodutos.foto, estoqueprodutos.var1, estoqueprodutos.var2, estoqueprodutos.var3,
estoqueprodutos.acrescimo, produtos.codigo, produtos.descricao, produtos.ref from itpedido 
LEFT JOIN estoqueprodutos on itpedido.produto = estoqueprodutos.codproduto
LEFT JOIN produtos on produtos.codigo = estoqueprodutos.produto
WHERE itpedido.documento = '$movimentacao->documento'";
                $sql .= " Group by ordem";
                $sql .= " ORDER BY itpedido.item DESC";

//                echo $sql;
                $arrayParam = '';
                $itmovimentacao = $crud->getSQLGeneric($sql, $arrayParam, true);
                foreach ($itmovimentacao as $value1) :
                    $prodgrade = '';
                    $prodgrade = RetornaGrade($movimentacao->documento, $value1->ordem);

//    print_r($prodgrade);

                    $totalprod = $totalprod + $value1->qtd;
                    $totalprevia = $totalprevia + $value1->previa;
                    $total = $total + $value1->valorliquido;
                    if ($_POST['tipor'] == 'C') :


                        if ($value1->qtd <> $value1->previa) :
                            ?>
                            <tr>

                                <?php
                            else :
                                ?>
                            <tr>

                            <?php
                            endif;
                            ?>
                            <td><?= $value1->produto ?> </td>
                            <td><?= $value1->ref ?> </td>
                            <td><?= $value1->descricao ?>  <br/> <?= $value1->obs ?></td>
                            <td colspan="3"> 
                                <table class="" style="border: none; ">
                                    <tr>

                                        <?php
                                        $result = array();
                                        $resulta = json_decode(json_encode($prodgrade), true);
//                        print_r($resulta);
                                        foreach ($resulta as $key => $item) {
                                            $arr[$item['var1']][$key] = $item;
                                        }


//                        $array = (array) $prodgrade;
//                        echo '<pre>';
//                        print_r($arr);
//                        echo '</pre>';

                                        foreach ($prodgrade as $value) :
//                            print_r($value);
                                            ?>
                                            <td style="border: none; padding: 0px 15px 0px;">
                                                <b style="font-size: 8px;"> <?= $value->var1 ?> 
                                                    <?php
                                                    if ($value->var2 <> '') :
                                                        echo '<br/>';
                                                    endif;

                                                    echo $value->var2
                                                    ?> </b><br/>
                                                <?php
                                                if (floor($value->qtd) == $value->qtd) :
                                                    ?>
                                                    <?= intval($value->qtd) ?>
                                                    <?php
                                                else :
                                                    ?>
                                                    <?= number_format($value->qtd, $parametros->casadecimalqtd, ',', '.') ?>
                                                <?php
                                                endif;
                                                ?>
                                                <?php
                                            endforeach;
                                            ?>
                                        </td>
                                    </tr>

                                </table>
                            </td>
                            <td><?= intval($value1->qtd) ?> </td>
                            <td><?= number_format($value1->preco, '2', ',', '.') ?></td>
                            <td><?= number_format($value1->valorliquido, '2', ',', '.') ?></td>
                        </tr>       
                        <?php
                    endif;
                endforeach;
                ?>




                <?php
                if ($_POST['faturamento'] == 'S') :
                    ?>
                    <tr>
                        <td colspan = "9">

                            <?php
                            $pdo = Conexao::getInstance();
                            $crud = Crud::getInstance($pdo, 'itmovimentacao');
                            $sql = "SELECT * FROM recebimentoped where documento = '$movimentacao->documento'";
//    echo $sql;
                            $arrayParam = '';
                            $dadosrec = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

                            $totalf = count($dadosrec);
                            if ($totalf > 0) :
                                ?>
                                <table class="table table-striped table-bordered table-condensed full_table_list">

                                    <?php
                                    foreach ($dadosrec as $value) :
                                        ?>
                                        <tr>
                                            <td><?= $value->dataven ?></td>
                                            <td colspan="2"><?= $cobranca[$value->tiporeceb] ?></td>
                                            <td>R$ <?= number_format($value->valor, $parametros->casadecimal, ',', '.') ?></td>
                                        </tr>
                                        <?php
                                    endforeach;
                                    ?>
                                </table>
                                <?php
                            endif;
                            ?>
                        </td>
                    </tr>
                    <?php
                endif;
                ?>
                <tr>
                    <td colspan="9">  <hr/> </td>
                </tr>
                <?php
            endforeach;
            ?>  

        </table>



        <hr/>
        <div align="center"> RESUMO  MOVIMENTAÇÕES DE SAÍDA</div>
        <table class="table" style="width: 100%; font-size: 10px;">
            <tr>
                <td style="width: 16%"> DOC INICIAL </td>
                <td style="width: 16%"> DOC FINAL </td>
                <td style="width: 16%"> TOTAL PEDIDOS </td>
                <td style="width: 16%"> DESCONTO ITENS </td>
                <td style="width: 16%"> DESCONTO DOC. </td>
                <td style="width: 16%"> TOTAL BRUTO </td>
                <?php
                if ($_POST['frete'] == 'A') :
                    ?>
                    <td style="width: 16%"> TOTAL FRETE </td>

                    <?php
                endif;
                ?>

                <td style="width: 18%"> TOTAL LIQUIDO </td>
                <td style="width: 18%"> TOTAL ITENS </td>
            </tr>
            <tr>
                <td> <?= $docinicialsaida ?> </td>
                <td> <?= $docfinalsaida ?> </td>
                <td> <?= $totalbruto ?> </td>
                <td> R$ <?= number_format($desciten, $parametros->casadecimal, ',', '.') ?> </td>
                <td> R$ <?= number_format($descdoc, $parametros->casadecimal, ',', '.') ?> </td>
                <td> R$ <?= number_format($totalbruto - $descdoc , $parametros->casadecimal, ',', '.') ?> </td>
                <?php
                if ($_POST['frete'] == 'A') :
                    ?>
                    <td> R$ <?= number_format($frete, $parametros->casadecimal, ',', '.') ?> </td>
                    <td> R$ <?= number_format($totalliquido - $frete, $parametros->casadecimal, ',', '.') ?> </td>
                    <?php
                else :
                    ?>
                    <td> R$ <?= number_format($totalliquido - $descdoc - $desciten, $parametros->casadecimal, ',', '.') ?> </td>
                <?php
                endif;
                ?>

                <td> <?= number_format($totalprod, $parametros->casadecimal, ',', '.') ?> </td>

            </tr>

        </table>


    </body>
</html>

<?php
require_once("../../_inc/mpdf/vendor/autoload.php");
ini_set("pcre.backtrack_limit", "900000000000000");

$mpdf = new \Mpdf\Mpdf([
    'margin_top' => 5,
    'margin_left' => 5,
    'margin_right' => 5,
    'mirrorMargins' => true,
    'default_font_size' => 12,
    'default_font' => 'sans-serif',
        ]);
//$mpdf->SetWatermarkText('DRAFT');
$mpdf->keep_table_proportions = true;
$mpdf->allow_charset_conversion = true;
$footer = "<table width = \"1000\">
                   <tr>
                     <td style='font-size: 10px; bottom:-15px;' align=\"right\">Pag: {PAGENO} de {nb} " . date('d/m/Y') . "</td>
                   </tr>
                 </table>";
$mpdf->SetHTMLFooter($footer);
$html = ob_get_clean();
$mpdf->SetTitle('Movimentações');
$mpdf->WriteHTML($html);
$mpdf->Output();
// imprime

exit();
?>