<?php
ob_start();
?>
<html>
    <head>
        <title> Relatório </title>
        <style>
            @import "../../../_frontend/_layout/assets/vendor/bootstrap/css/bootstrap.min.css";


            table {
                border-collapse: collapse;
            }
            thead {
                vertical-align: bottom;
                text-align: center;
                font-weight: bold;
            }
            tfoot {
                text-align: center;
                font-weight: bold;
            }
            th {
                text-align: left;
                padding-left: 0.35em;
                padding-right: 0.35em;
                padding-top: 0.35em;
                padding-bottom: 0.35em;
                vertical-align: top;
            }
            td {
                padding-left: 0.35em;
                padding-right: 0.35em;
                padding-top: 0.35em;
                padding-bottom: 0.35em;
                vertical-align: top;
            }


        </style>
    </head>
    <?php
    date_default_timezone_set("Brazil/East");
    require_once("../../../functions.php");
//
    require_once "../../../_backend/_class/Conexao_class.php";
    require_once "../../../_backend/_class/Crud_class.php";
    require_once "../../../_backend/_class/cobranca_class.php";
    require_once "../../../_backend/_class/parametros.php";

    function BuscaEmpresa($valor) {
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'estoqueprodutos');
        $sql = "SELECT * from emitente where emitenteid = '$valor'";
        $arrayParam = '';
        $dados = $crud->getSQLGeneric($sql, $arrayParam, false);

        return $dados->xNome;
    }

    function Vendedor($valor) {
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'usuario');
        $sql = "SELECT * from vendedor where vendedorid = '" . $valor . "' ";
        $arrayParam = '';
        $vendedor = $crud->getSQLGeneric($sql, $arrayParam, false);
        return $vendedor->xNome;
    }

    function Usuario($valor) {
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'usuario');
        $sql = "SELECT * from usuario where usuarioid = '" . $valor . "' ";
        $arrayParam = '';
        $vendedor = $crud->getSQLGeneric($sql, $arrayParam, false);
        return $vendedor->usuarionome;
    }

    function Cliente($id) {

        $sql = "SELECT * from cliente where clienteid = '$id' ";
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'tabela');
        $arrayParam = '';
        $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

        return $dados->xNome;
    }

    function DocIF($mes, $ano, $cliente, $vendedor, $usuario) {
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'usuario');
        $sql = "SELECT movimentacao.documento FROM movimentacao where 
            situacao = 'F'
            ";

        if (!empty($cliente)) :
            $sql .= ' AND cliente = "' . $cliente . '" ';
        endif;

        if (!empty($vendedor)) :
            $sql .= ' AND vendedor = "' . $vendedor . '" ';
        endif;

        if (!empty($usuario)) :
            $sql .= ' AND usuario = "' . $usuario . '" ';
        endif;
        $arrayParam = '';
        $movimentacao = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

        $docinicialsaidat = 0;
        $docfinalsaidat = 0;

        foreach ($movimentacao as $movimentacao) :
            if ($docinicialsaidat == '0') :
                $docinicialsaidat = $movimentacao->doc_empresa;
            endif;
            $docfinalsaidat = $movimentacao->doc_empresa;
        endforeach;
        
        $retorno = array("inicial" => $docinicialsaidat, "final" =>$docfinalsaidat);
        return $retorno;
    }

    $ano = $_POST['ano'];

    $datai = "$ano-01-01";
    $dataf = "$ano-12-31";

//    MOVIMENTAÇÃO
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'usuario');
    $sql = 'SELECT movimentacao.`data`, MONTH(str_to_date(data, "%d/%m/%Y")) as mes, YEAR(str_to_date(data, "%d/%m/%Y")) as ano, 
            SUM(movimentacao.frete) AS frete, SUM(movimentacao.valortotal) AS valortotal, SUM(movimentacao.valorpago) AS valorpago, 
            SUM(movimentacao.troco) AS troco, SUM(movimentacao.desconto) AS desconto, 
            movimentacao.vendedor, movimentacao.usuario, movimentacao.cliente
            FROM movimentacao 
            WHERE situacao = "F" 
            AND ((str_to_date(data, "%d/%m/%Y") BETWEEN "' . $datai . '" AND "' . $dataf . '" ) 
            OR (str_to_date(datapagamento, "%d/%m/%Y") BETWEEN "' . $datai . '" AND "' . $dataf . '")) 
            AND empresa = "' . $_POST['empresa'] . '"';

    if (!empty($_POST['cliente'])) :
        $sql .= ' AND cliente = "' . $_POST['cliente'] . '" ';
    endif;

    if (!empty($_POST['vendedor'])) :
        $sql .= ' AND vendedor = "' . $_POST['vendedor'] . '" ';
    endif;

    if (!empty($_POST['usuario'])) :
        $sql .= ' AND usuario = "' . $_POST['usuario'] . '" ';
    endif;

    $sql .= ' GROUP BY YEAR(str_to_date(data, "%d/%m/%Y")), MONTH(str_to_date(data, "%d/%m/%Y"))';
    $arrayParam = '';
    $movimentacao = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

//    echo $sql;
    $movarray = array();
    foreach ($movimentacao as $mov) :
        $movarray[$mov->mes] = array(
            "frete" => $mov->frete,
            "vtotal" => $mov->valortotal,
            "pago" => $mov->valorpago,
            "troco" => $mov->troco,
            "desconto" => $mov->desconto,
            "liquido" => $mov->valorpago - $mov->troco
        );
    endforeach;

//    MOVIMENTAÇÃO TROCA
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'usuario');
    $sql = 'SELECT movimentacao_troca.`data`, MONTH(str_to_date(data, "%d/%m/%Y")) as mes, YEAR(str_to_date(data, "%d/%m/%Y")) as ano, 
            SUM(movimentacao_troca.valortotal) AS valortotal, SUM(movimentacao_troca.valorpago) AS valorpago, 
            SUM(movimentacao_troca.desconto) AS desconto,
            movimentacao_troca.vendedor, movimentacao_troca.usuario, movimentacao_troca.cliente
            FROM movimentacao_troca 
            WHERE situacao = "F" 
            AND str_to_date(data, "%d/%m/%Y") BETWEEN "' . $datai . '" AND "' . $dataf . '" 
            AND empresa = "' . $_POST['empresa'] . '"';

    if (!empty($_POST['cliente'])) :
        $sql .= ' AND cliente = "' . $_POST['cliente'] . '" ';
    endif;

    if (!empty($_POST['vendedor'])) :
        $sql .= ' AND vendedor = "' . $_POST['vendedor'] . '" ';
    endif;

    if (!empty($_POST['usuario'])) :
        $sql .= ' AND usuario = "' . $_POST['usuario'] . '" ';
    endif;

    $sql .= ' GROUP BY YEAR(str_to_date(data, "%d/%m/%Y")), MONTH(str_to_date(data, "%d/%m/%Y"))';
    $arrayParam = '';
    $movimentacaotroca = $crud->getSQLGeneric($sql, $arrayParam, TRUE);
    $movarraytroca = array();
    foreach ($movimentacaotroca as $movt) :
        $movarraytroca[$movt->mes] = array(
            "vtotal" => $movt->valortotal,
            "pago" => $movt->valorpago,
            "desconto" => $movt->desconto,
            "liquido" => $movt->valorpago
        );

    endforeach;

//    MOVIMENTAÇÃO DEVOLUÇÃO
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'usuario');
    $sql = 'SELECT movimentacao_dev.`data`, MONTH(str_to_date(data, "%d/%m/%Y")) as mes, YEAR(str_to_date(data, "%d/%m/%Y")) as ano, 
            SUM(movimentacao_dev.valortotal) AS valortotal, SUM(movimentacao_dev.valorpago) AS valorpago, 
            SUM(movimentacao_dev.desconto) AS desconto ,
            movimentacao_dev.vendedor, movimentacao_dev.usuario, movimentacao_dev.cliente
            FROM movimentacao_dev 
            WHERE situacao = "F" 
            AND str_to_date(data, "%d/%m/%Y") BETWEEN "' . $datai . '" AND "' . $dataf . '" 
            AND empresa = "' . $_POST['empresa'] . '"';

    if (!empty($_POST['cliente'])) :
        $sql .= ' AND cliente = "' . $_POST['cliente'] . '" ';
    endif;

    if (!empty($_POST['vendedor'])) :
        $sql .= ' AND vendedor = "' . $_POST['vendedor'] . '" ';
    endif;

    if (!empty($_POST['usuario'])) :
        $sql .= ' AND usuario = "' . $_POST['usuario'] . '" ';
    endif;
    $sql .= ' GROUP BY YEAR(str_to_date(data, "%d/%m/%Y")), MONTH(str_to_date(data, "%d/%m/%Y"))';
    $arrayParam = '';
    $movimentacao_dev = $crud->getSQLGeneric($sql, $arrayParam, TRUE);
    $movarraydev = array();
    foreach ($movimentacao_dev as $movd) :
        $movarraydev[$movd->mes] = array(
            "vtotal" => $movd->valortotal,
            "pago" => $movd->valorpago,
            "desconto" => $movd->desconto,
            "liquido" => $movd->valorpago
        );

    endforeach;
//echo $sql;
//    echo '<pre>';
//    print_r($movarray);
//    echo '</pre>';
    ?>
    <body>
        <div align="center">
            CONSOLIDAÇÃO DE VENDAS ANUAL
            <Br/> 
            ANO: <?= $ano ?> 

            <?php
            if ($_POST['empresa'] !== 'T') :
                ?>
                <br/>
                FILIAL : <?= BuscaEmpresa($_POST['empresa']) ?>
                <?php
            else :
                ?>
                <br/>
                FILIAL : TODAS
            <?php
            endif;
            ?>


            <?php
            if (!empty($_POST['vendedor'])) :
                ?>
                <br/>
                Vendedor : <?= $_POST['empresa'] ?>  - <?= Vendedor($_POST['empresa']) ?>  
                <?php
            endif;
            ?>

            <?php
            if (!empty($_POST['usuario'])) :
                ?>
                <br/>
                Usuário : <?= $_POST['usuario'] ?>  - <?= Usuario($_POST['usuario']) ?>  
                <?php
            endif;
            ?>

            <?php
            if (!empty($_POST['cliente'])) :
                ?>
                <br/>
                Cliente : <?= $_POST['cliente'] ?>  - <?= Cliente($_POST['cliente']) ?>  
                <?php
            endif;
            ?>


        </div>

        <?php require_once './cabecalho.php'; ?>
        <table cellpadding="8" class="table table-striped table-bordered" style="font-size: 12px">
            <tr style="text-align: left; background-color: #e8e8e8;" >
                <th style="text-align: left; background-color: #e8e8e8;">MÊS</th>
                <th style="text-align: left; background-color: #e8e8e8;">VENDA R$</th>
                <th style="text-align: left; background-color: #e8e8e8;">TROCA R$</th>
                <th style="text-align: left; background-color: #e8e8e8;">DEVOLUÇÃO R$</th>
                <th style="text-align: left; background-color: #e8e8e8;">DESCONTO R$</th>
                <th style="text-align: left; background-color: #e8e8e8;">TOTAL R$</th>
            </tr>

            <?php
            $janeiro = 0;
            $janeirodesc = 0;
            $janeirotroca = 0;
            $janeirotrocadesc = 0;
            $janeirodev = 0;
            $janeirodevdesc = 0;
            $totaldesc = 0;
            $totalgeral = 0;

            $janeiro = $janeiro + $movarray['1']['vtotal'];
            $janeirodesc = $janeirodesc + $movarray['1']['desconto'];

            $janeirotroca = $janeirotroca + $movarraytroca['1']['vtotal'];
            $janeirotrocadesc = $janeirotrocadesc + $movarraytroca['1']['desconto'];

            $janeirodev = $janeirodev + $movarraydev['1']['vtotal'];
            $janeirodevdesc = $janeirodevdesc + $movarraydev['1']['desconto'];

            $totaldesc = $janeirodesc + $janeirotrocadesc + $janeirodevdesc;
            $totalgeral = (($janeiro + $janeirotroca) - $janeirodev) - $janeirodesc - $janeirodevdesc - $janeirotrocadesc;
            ?>

            <tr>
                <td>JANEIRO</td>
                <td><?= number_format($movarray['1']['vtotal'], 2, ',', '.') ?></td>       
                <td><?= number_format($movarraytroca['1']['vtotal'], 2, ',', '.') ?></td>       
                <td><?= number_format($movarraydev['1']['vtotal'], 2, ',', '.') ?></td>       
                <td><?= number_format($totaldesc, 2, ',', '.') ?></td>       
                <td><?= number_format($totalgeral, 2, ',', '.') ?></td>       
            </tr>



            <!--FEVEREIRO-->
            <?php
            $fevereiro = 0;
            $fevereirodesc = 0;
            $fevereirotroca = 0;
            $fevereirotrocadesc = 0;
            $fevereirodev = 0;
            $fevereirodevdesc = 0;
            $fevereirototaldesc = 0;
            $fevereirototalgeral = 0;

            $fevereiro = $fevereiro + $movarray['2']['vtotal'];
            $fevereirodesc = $fevereirodesc + $movarray['2']['desconto'];

            $fevereirotroca = $fevereirotroca + $movarraytroca['2']['vtotal'];
            $fevereirotrocadesc = $fevereirotrocadesc + $movarraytroca['2']['desconto'];

            $fevereirodev = $fevereirodev + $movarraydev['2']['vtotal'];
            $fevereirodevdesc = $fevereirodevdesc + $movarraydev['2']['desconto'];

            $fevereirototaldesc = $fevereirodesc + $fevereirotrocadesc + $fevereirodevdesc;
            $fevereirototalgeral = (($fevereiro + $fevereirotroca) - $fevereirodev) - $fevereirodesc - $fevereirodevdesc - $fevereirotrocadesc;
            ?>

            <tr>
                <td>FEVEREIRO</td>
                <td><?= number_format($movarray['2']['vtotal'], 2, ',', '.') ?></td>       
                <td><?= number_format($movarraytroca['2']['vtotal'], 2, ',', '.') ?></td>       
                <td><?= number_format($movarraydev['2']['vtotal'], 2, ',', '.') ?></td>       
                <td><?= number_format($fevereirototaldesc, 2, ',', '.') ?></td>       
                <td><?= number_format($fevereirototalgeral, 2, ',', '.') ?></td>       
            </tr>


            <!--MARÇO-->
            <?php
            $marco = 0;
            $marcodesc = 0;
            $marcotroca = 0;
            $marcotrocadesc = 0;
            $marcodev = 0;
            $marcodevdesc = 0;
            $marcototaldesc = 0;
            $marcototalgeral = 0;

            $marco = $marco + $movarray['3']['vtotal'];
            $marcodesc = $marcodesc + $movarray['3']['desconto'];

            $marcotroca = $marcotroca + $movarraytroca['3']['vtotal'];
            $marcotrocadesc = $marcotrocadesc + $movarraytroca['3']['desconto'];

            $marcodev = $marcodev + $movarraydev['3']['vtotal'];
            $marcodevdesc = $marcodevdesc + $movarraydev['3']['desconto'];

            $marcototaldesc = $marcodesc + $marcotrocadesc + $marcodevdesc;
            $marcototalgeral = (($marco + $marcotroca) - $marcodev) - $marcodesc - $marcodevdesc - $marcotrocadesc;
            ?>

            <tr>
                <td>MARÇO</td>
                <td><?= number_format($movarray['3']['vtotal'], 2, ',', '.') ?></td>       
                <td><?= number_format($movarraytroca['3']['vtotal'], 2, ',', '.') ?></td>       
                <td><?= number_format($movarraydev['3']['vtotal'], 2, ',', '.') ?></td>       
                <td><?= number_format($marcototaldesc, 2, ',', '.') ?></td>       
                <td><?= number_format($marcototalgeral, 2, ',', '.') ?></td>       
            </tr>

            <!--ABRIL-->
            <?php
            $abril = 0;
            $abrildesc = 0;
            $abriltroca = 0;
            $abriltrocadesc = 0;
            $abrildev = 0;
            $abrildevdesc = 0;
            $abriltotaldesc = 0;
            $abriltotalgeral = 0;

            $abril = $abril + $movarray['4']['vtotal'];
            $abrildesc = $abrildesc + $movarray['4']['desconto'];

            $abriltroca = $abriltroca + $movarraytroca['4']['vtotal'];
            $abriltrocadesc = $abriltrocadesc + $movarraytroca['4']['desconto'];

            $abrildev = $abrildev + $movarraydev['4']['vtotal'];
            $abrildevdesc = $abrildevdesc + $movarraydev['4']['desconto'];

            $abriltotaldesc = $abrildesc + $abriltrocadesc + $abrildevdesc;
            $abriltotalgeral = (($abril + $abriltroca) - $abrildev) - $abrildesc - $abrildevdesc - $abriltrocadesc;
            ?>

            <tr>
                <td>ABRIL</td>
                <td><?= number_format($movarray['4']['vtotal'], 2, ',', '.') ?></td>       
                <td><?= number_format($movarraytroca['4']['vtotal'], 2, ',', '.') ?></td>       
                <td><?= number_format($movarraydev['4']['vtotal'], 2, ',', '.') ?></td>       
                <td><?= number_format($abriltotaldesc, 2, ',', '.') ?></td>       
                <td><?= number_format($abriltotalgeral, 2, ',', '.') ?></td>       
            </tr>

            <!--MAIO-->
            <?php
            $maio = 0;
            $maiodesc = 0;
            $maiotroca = 0;
            $maiotrocadesc = 0;
            $maiodev = 0;
            $maiodevdesc = 0;
            $maiototaldesc = 0;
            $maiototalgeral = 0;

            $maio = $maio + $movarray['5']['vtotal'];
            $maiodesc = $maiodesc + $movarray['5']['desconto'];

            $maiotroca = $maiotroca + $movarraytroca['5']['vtotal'];
            $maiotrocadesc = $maiotrocadesc + $movarraytroca['5']['desconto'];

            $maiodev = $maiodev + $movarraydev['5']['vtotal'];
            $maiodevdesc = $maiodevdesc + $movarraydev['5']['desconto'];

            $maiototaldesc = $maiodesc + $maiotrocadesc + $maiodevdesc;
            $maiototalgeral = (($maio + $maiotroca) - $maiodev) - $maiodesc - $maiodevdesc - $maiotrocadesc;
            ?>

            <tr>
                <td>MAIO</td>
                <td><?= number_format($movarray['5']['vtotal'], 2, ',', '.') ?></td>       
                <td><?= number_format($movarraytroca['5']['vtotal'], 2, ',', '.') ?></td>       
                <td><?= number_format($movarraydev['5']['vtotal'], 2, ',', '.') ?></td>       
                <td><?= number_format($maiototaldesc, 2, ',', '.') ?></td>       
                <td><?= number_format($maiototalgeral, 2, ',', '.') ?></td>       
            </tr>

            <!--JUNHO-->
            <?php
            $junho = 0;
            $junhodesc = 0;
            $junhotroca = 0;
            $junhotrocadesc = 0;
            $junhodev = 0;
            $junhodevdesc = 0;
            $junhototaldesc = 0;
            $junhototalgeral = 0;

            $junho = $junho + $movarray['6']['vtotal'];
            $junhodesc = $junhodesc + $movarray['6']['desconto'];

            $junhotroca = $junhotroca + $movarraytroca['6']['vtotal'];
            $junhotrocadesc = $junhotrocadesc + $movarraytroca['6']['desconto'];

            $junhodev = $junhodev + $movarraydev['6']['vtotal'];
            $junhodevdesc = $junhodevdesc + $movarraydev['6']['desconto'];

            $junhototaldesc = $junhodesc + $junhotrocadesc + $junhodevdesc;
            $junhototalgeral = (($junho + $junhotroca) - $junhodev) - $junhodesc - $junhodevdesc - $junhotrocadesc;
            ?>

            <tr>
                <td>JUNHO</td>
                <td><?= number_format($movarray['6']['vtotal'], 2, ',', '.') ?></td>       
                <td><?= number_format($movarraytroca['6']['vtotal'], 2, ',', '.') ?></td>       
                <td><?= number_format($movarraydev['6']['vtotal'], 2, ',', '.') ?></td>       
                <td><?= number_format($junhototaldesc, 2, ',', '.') ?></td>       
                <td><?= number_format($junhototalgeral, 2, ',', '.') ?></td>       
            </tr>

            <!--JULHO-->
            <?php
            $julho = 0;
            $julhodesc = 0;
            $julhotroca = 0;
            $julhotrocadesc = 0;
            $julhodev = 0;
            $julhodevdesc = 0;
            $julhototaldesc = 0;
            $julhototalgeral = 0;

            $julho = $julho + $movarray['7']['vtotal'];
            $julhodesc = $julhodesc + $movarray['7']['desconto'];

            $julhotroca = $julhotroca + $movarraytroca['7']['vtotal'];
            $julhotrocadesc = $julhotrocadesc + $movarraytroca['7']['desconto'];

            $julhodev = $julhodev + $movarraydev['7']['vtotal'];
            $julhodevdesc = $julhodevdesc + $movarraydev['7']['desconto'];

            $julhototaldesc = $julhodesc + $julhotrocadesc + $julhodevdesc;
            $julhototalgeral = (($julho + $julhotroca) - $julhodev) - $julhodesc - $julhodevdesc - $julhotrocadesc;
            ?>

            <tr>
                <td>JULHO</td>
                <td><?= number_format($movarray['7']['vtotal'], 2, ',', '.') ?></td>       
                <td><?= number_format($movarraytroca['7']['vtotal'], 2, ',', '.') ?></td>       
                <td><?= number_format($movarraydev['7']['vtotal'], 2, ',', '.') ?></td>       
                <td><?= number_format($julhototaldesc, 2, ',', '.') ?></td>       
                <td><?= number_format($julhototalgeral, 2, ',', '.') ?></td>       
            </tr>

            <!--AGOSTO-->
            <?php
            $agosto = 0;
            $agostodesc = 0;
            $agostotroca = 0;
            $agostotrocadesc = 0;
            $agostodev = 0;
            $agostodevdesc = 0;
            $agostototaldesc = 0;
            $agostototalgeral = 0;

            $agosto = $agosto + $movarray['8']['vtotal'];
            $agostodesc = $agostodesc + $movarray['8']['desconto'];

            $agostotroca = $agostotroca + $movarraytroca['8']['vtotal'];
            $agostotrocadesc = $agostotrocadesc + $movarraytroca['8']['desconto'];

            $agostodev = $agostodev + $movarraydev['8']['vtotal'];
            $agostodevdesc = $agostodevdesc + $movarraydev['8']['desconto'];

            $agostototaldesc = $agostodesc + $agostotrocadesc + $agostodevdesc;
            $agostototalgeral = (($agosto + $agostotroca) - $agostodev) - $agostodesc - $agostodevdesc - $agostotrocadesc;
            ?>

            <tr>
                <td>AGOSTO</td>
                <td><?= number_format($movarray['8']['vtotal'], 2, ',', '.') ?></td>       
                <td><?= number_format($movarraytroca['8']['vtotal'], 2, ',', '.') ?></td>       
                <td><?= number_format($movarraydev['8']['vtotal'], 2, ',', '.') ?></td>       
                <td><?= number_format($agostototaldesc, 2, ',', '.') ?></td>       
                <td><?= number_format($agostototalgeral, 2, ',', '.') ?></td>       
            </tr>

            <!--SETEMBRO-->
            <?php
            $setembro = 0;
            $setembrodesc = 0;
            $setembrotroca = 0;
            $setembrotrocadesc = 0;
            $setembrodev = 0;
            $setembrodevdesc = 0;
            $setembrototaldesc = 0;
            $setembrototalgeral = 0;

            $setembro = $setembro + $movarray['9']['vtotal'];
            $setembrodesc = $setembrodesc + $movarray['9']['desconto'];

            $setembrotroca = $setembrotroca + $movarraytroca['9']['vtotal'];
            $setembrotrocadesc = $setembrotrocadesc + $movarraytroca['9']['desconto'];

            $setembrodev = $setembrodev + $movarraydev['9']['vtotal'];
            $setembrodevdesc = $setembrodevdesc + $movarraydev['9']['desconto'];

            $setembrototaldesc = $setembrodesc + $setembrotrocadesc + $setembrodevdesc;
            $setembrototalgeral = (($setembro + $setembrotroca) - $setembrodev) - $setembrodesc - $setembrodevdesc - $setembrotrocadesc;
            ?>

            <tr>
                <td>SETEMBRO</td>
                <td><?= number_format($movarray['9']['vtotal'], 2, ',', '.') ?></td>       
                <td><?= number_format($movarraytroca['9']['vtotal'], 2, ',', '.') ?></td>       
                <td><?= number_format($movarraydev['9']['vtotal'], 2, ',', '.') ?></td>       
                <td><?= number_format($setembrototaldesc, 2, ',', '.') ?></td>       
                <td><?= number_format($setembrototalgeral, 2, ',', '.') ?></td>       
            </tr>

            <!--OUTUBRO-->
            <?php
            $outubro = 0;
            $outubrodesc = 0;
            $outubrotroca = 0;
            $outubrotrocadesc = 0;
            $outubrodev = 0;
            $outubrodevdesc = 0;
            $outubrototaldesc = 0;
            $outubrototalgeral = 0;

            $outubro = $outubro + $movarray['10']['vtotal'];
            $outubrodesc = $outubrodesc + $movarray['10']['desconto'];

            $outubrotroca = $outubrotroca + $movarraytroca['10']['vtotal'];
            $outubrotrocadesc = $outubrotrocadesc + $movarraytroca['10']['desconto'];

            $outubrodev = $outubrodev + $movarraydev['10']['vtotal'];
            $outubrodevdesc = $outubrodevdesc + $movarraydev['10']['desconto'];

            $outubrototaldesc = $outubrodesc + $outubrotrocadesc + $outubrodevdesc;
            $outubrototalgeral = (($outubro + $outubrotroca) - $outubrodev) - $outubrodesc - $outubrodevdesc - $outubrotrocadesc;
            ?>

            <tr>
                <td>OUTUBRO</td>
                <td><?= number_format($movarray['10']['vtotal'], 2, ',', '.') ?></td>       
                <td><?= number_format($movarraytroca['10']['vtotal'], 2, ',', '.') ?></td>       
                <td><?= number_format($movarraydev['10']['vtotal'], 2, ',', '.') ?></td>       
                <td><?= number_format($outubrototaldesc, 2, ',', '.') ?></td>       
                <td><?= number_format($outubrototalgeral, 2, ',', '.') ?></td>       
            </tr>

            <!--NOVEMBRO-->
            <?php
            $novembro = 0;
            $novembrodesc = 0;
            $novembrotroca = 0;
            $novembrotrocadesc = 0;
            $novembrodev = 0;
            $novembrodevdesc = 0;
            $novembrototaldesc = 0;
            $novembrototalgeral = 0;

            $novembro = $novembro + $movarray['11']['vtotal'];
            $novembrodesc = $novembrodesc + $movarray['11']['desconto'];

            $novembrotroca = $novembrotroca + $movarraytroca['11']['vtotal'];
            $novembrotrocadesc = $novembrotrocadesc + $movarraytroca['11']['desconto'];

            $novembrodev = $novembrodev + $movarraydev['11']['vtotal'];
            $novembrodevdesc = $novembrodevdesc + $movarraydev['11']['desconto'];

            $novembrototaldesc = $novembrodesc + $novembrotrocadesc + $novembrodevdesc;
            $novembrototalgeral = (($novembro + $novembrotroca) - $novembrodev) - $novembrodesc - $novembrodevdesc - $novembrotrocadesc;
            ?>

            <tr>
                <td>NOVEMBRO</td>
                <td><?= number_format($movarray['11']['vtotal'], 2, ',', '.') ?></td>       
                <td><?= number_format($movarraytroca['11']['vtotal'], 2, ',', '.') ?></td>       
                <td><?= number_format($movarraydev['11']['vtotal'], 2, ',', '.') ?></td>       
                <td><?= number_format($novembrototaldesc, 2, ',', '.') ?></td>       
                <td><?= number_format($novembrototalgeral, 2, ',', '.') ?></td>       
            </tr>
            <!--DEZEMBRO-->
            <?php
            $dezembro = 0;
            $dezembrodesc = 0;
            $dezembrotroca = 0;
            $dezembrotrocadesc = 0;
            $dezembrodev = 0;
            $dezembrodevdesc = 0;
            $dezembrototaldesc = 0;
            $dezembrototalgeral = 0;

            $dezembro = $dezembro + $movarray['12']['vtotal'];
            $dezembrodesc = $dezembrodesc + $movarray['12']['desconto'];

            $dezembrotroca = $dezembrotroca + $movarraytroca['12']['vtotal'];
            $dezembrotrocadesc = $dezembrotrocadesc + $movarraytroca['12']['desconto'];

            $dezembrodev = $dezembrodev + $movarraydev['12']['vtotal'];
            $dezembrodevdesc = $dezembrodevdesc + $movarraydev['12']['desconto'];

            $dezembrototaldesc = $dezembrodesc + $dezembrotrocadesc + $dezembrodevdesc;
            $dezembrototalgeral = (($dezembro + $dezembrotroca) - $dezembrodev) - $dezembrodesc - $dezembrodevdesc - $dezembrotrocadesc;
            ?>

            <tr>
                <td>DEZEMBRO</td>
                <td><?= number_format($movarray['12']['vtotal'], 2, ',', '.') ?></td>       
                <td><?= number_format($movarraytroca['12']['vtotal'], 2, ',', '.') ?></td>       
                <td><?= number_format($movarraydev['12']['vtotal'], 2, ',', '.') ?></td>       
                <td><?= number_format($dezembrototaldesc, 2, ',', '.') ?></td>       
                <td><?= number_format($dezembrototalgeral, 2, ',', '.') ?></td>       
            </tr>


            <?php
            $totalvenda = $janeiro + $fevereiro + $marco + $abril + $maio + $junho + $julho + $agosto + $setembro + $outubro + $novembro + $dezembro;
            $totaltroca = $janeirotroca + $fevereirotroca + $marcotroca + $abriltroca + $maiotroca + $junhotroca + $julhotroca + $agostotroca + $setembrotroca + $outubrotroca + $novembrotroca + $dezembrotroca;
            $totaldev = $janeirodev + $fevereirodev + $marcodev + $abrildev + $maiodev + $junhodev + $julhodev + $agostodev + $setembrodev + $outubrodev + $novembrodev + $dezembrodev;
            $totaldesct = $totaldesc + $fevereirototaldesc + $marcototaldesc + $abriltotaldesc + $maiototaldesc + $junhototaldesc + $julhototaldesc + $agostototaldesc + $setembrototaldesc + $outubrototaldesc + $novembrototaldesc + $dezembrototaldesc;

            $totalgeralt = (($totalvenda + $totaltroca) - $totaldev) - $totaldesct;
            ?>
            <tr>
                <th style="text-align: left; background-color: #e8e8e8;">TOTAIS</th>
                <th style="text-align: left; background-color: #e8e8e8;"><?= number_format($totalvenda, 2, ',', '.') ?></th>       
                <th style="text-align: left; background-color: #e8e8e8;"><?= number_format($totaltroca, 2, ',', '.') ?></th>       
                <th style="text-align: left; background-color: #e8e8e8;"><?= number_format($totaldev, 2, ',', '.') ?></th>       
                <th style="text-align: left; background-color: #e8e8e8;"><?= number_format($totaldesct, 2, ',', '.') ?></th>       
                <th style="text-align: left; background-color: #e8e8e8;"><?= number_format($totalgeralt, 2, ',', '.') ?></th>       
            </tr>

        </table>


    </body>
</html>
<?php
if ($_POST['arq'] == 'PDF') :
    ini_set("pcre.backtrack_limit", "500000000000000");
    require_once("../../_inc/mpdf/vendor/autoload.php");
    $mpdf = new \Mpdf\Mpdf([
        'margin_top' => 5,
        'margin_left' => 5,
        'margin_right' => 5,
        'mirrorMargins' => true,
        'default_font_size' => 12,
        'format' => 'A4-L'
    ]);
    $mpdf->keep_table_proportions = true;
    $mpdf->allow_charset_conversion = true;
    $footer = "<table width = \"1000\">
                   <tr>
                     <td style='font-size: 10px; bottom:-15px;' align=\"right\">Pag: {PAGENO} de {nb} " . date('d/m/Y') . "</td>
                   </tr>
                 </table>";
    $mpdf->SetHTMLFooter($footer);
    $html = ob_get_clean();
    $mpdf->SetTitle('Estoque');
    $mpdf->WriteHTML($html);
    $mpdf->Output();
// imprime

    exit();
elseif ($_POST['arq'] == 'EXCEL') :
    $file = 'Consolidado.xls';
    header("Content-type: application/x-msexcel");
    header("Content-Disposition: attachment; filename=\"{$file}\"");
    header("Content-Description: PHP Generated Data");
else :
    echo '';
endif;
?>