<?php
ob_start();
?>
<html>
    <head>
        <title> Relatório </title>
        <style>
            @import "../../../_frontend/_layout/assets/vendor/bootstrap/css/bootstrap.min.css";


            table {
                border-collapse: collapse;
            }
            thead {
                vertical-align: bottom;
                text-align: center;
                font-weight: bold;
            }
            tfoot {
                text-align: center;
                font-weight: bold;
            }
            th {
                text-align: left;
                padding-left: 0.35em;
                padding-right: 0.35em;
                padding-top: 0.35em;
                padding-bottom: 0.35em;
                vertical-align: top;
            }
            td {
                padding-left: 0.35em;
                padding-right: 0.35em;
                padding-top: 0.35em;
                padding-bottom: 0.35em;
                vertical-align: top;
            }


        </style>
    </head>
    <?php
    date_default_timezone_set("Brazil/East");
    require_once("../../../functions.php");
//
    require_once "../../../_backend/_class/Conexao_class.php";
    require_once "../../../_backend/_class/Crud_class.php";
    require_once "../../../_backend/_class/cobranca_class.php";
    require_once "../../../_backend/_class/parametros.php";

    function BuscaEmpresa($valor) {
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'estoqueprodutos');
        $sql = "SELECT * from emitente where emitenteid = '$valor'";
        $arrayParam = '';
        $dados = $crud->getSQLGeneric($sql, $arrayParam, false);

        return $dados->xNome;
    }

    function Vendedor($valor) {
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'usuario');
        $sql = "SELECT * from vendedor where vendedorid = '" . $valor . "' ";
        $arrayParam = '';
        $vendedor = $crud->getSQLGeneric($sql, $arrayParam, false);
        return $vendedor->xNome;
    }

    function Usuario($valor) {
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'usuario');
        $sql = "SELECT * from usuario where usuarioid = '" . $valor . "' ";
        $arrayParam = '';
        $vendedor = $crud->getSQLGeneric($sql, $arrayParam, false);
        return $vendedor->usuarionome;
    }

    function Cliente($id) {

        $sql = "SELECT * from cliente where clienteid = '$id' ";
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'tabela');
        $arrayParam = '';
        $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

        return $dados->xNome;
    }

    function DocIF($dia, $cliente, $vendedor, $usuario) {
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'usuario');
        $sql = "SELECT movimentacao.documento FROM movimentacao where 
            situacao = 'F' and data = '$dia'";

        if (!empty($cliente)) :
            $sql .= ' AND cliente = "' . $cliente . '" ';
        endif;

        if (!empty($vendedor)) :
            $sql .= ' AND vendedor = "' . $vendedor . '" ';
        endif;

        if (!empty($usuario)) :
            $sql .= ' AND usuario = "' . $usuario . '" ';
        endif;
        $arrayParam = '';
        $movimentacao = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

        $docinicialsaidat = 0;
        $docfinalsaidat = 0;

        foreach ($movimentacao as $movimentacao) :
            if ($docinicialsaidat == '0') :
                $docinicialsaidat = $movimentacao->doc_empresa;
            endif;
            $docfinalsaidat = $movimentacao->doc_empresa;
        endforeach;

        $retorno = array("inicial" => $docinicialsaidat, "final" => $docfinalsaidat);
        return $retorno;
    }

    function TotalVendaDia($dia, $cliente, $vendedor, $usuario, $empresa) {
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'usuario');
        $sql = "SELECT movimentacao.documento FROM movimentacao where 
            situacao = 'F' and data = '$dia'";

        if (!empty($cliente)) :
            $sql .= ' AND cliente = "' . $cliente . '" ';
        endif;

        if (!empty($vendedor)) :
            $sql .= ' AND vendedor = "' . $vendedor . '" ';
        endif;

        if (!empty($usuario)) :
            $sql .= ' AND usuario = "' . $usuario . '" ';
        endif;

        if (!empty($empresa)) :
            $sql .= ' AND empresa = "' . $empresa . '" ';
        endif;
        $arrayParam = '';
        $movimentacao = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

        $total = count($movimentacao);
        
        return $total;
    }

    function TotalTrocaDia($dia, $cliente, $vendedor, $usuario, $empresa) {
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'usuario');
        $sql = "SELECT movimentacao_troca.documento FROM movimentacao_troca where 
            situacao = 'F' and data = '$dia'";

        if (!empty($cliente)) :
            $sql .= ' AND cliente = "' . $cliente . '" ';
        endif;

        if (!empty($vendedor)) :
            $sql .= ' AND vendedor = "' . $vendedor . '" ';
        endif;

        if (!empty($usuario)) :
            $sql .= ' AND usuario = "' . $usuario . '" ';
        endif;
        
         if (!empty($empresa)) :
            $sql .= ' AND empresa = "' . $empresa . '" ';
        endif;
        $arrayParam = '';
        $movimentacao = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

        $total = count($movimentacao);
        
        return $total;
    }

    function TotalDevDia($dia, $cliente, $vendedor, $usuario, $empresa) {
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'usuario');
        $sql = "SELECT movimentacao_dev.documento FROM movimentacao_dev where 
            situacao = 'F' and data = '$dia'";

        if (!empty($cliente)) :
            $sql .= ' AND cliente = "' . $cliente . '" ';
        endif;

        if (!empty($vendedor)) :
            $sql .= ' AND vendedor = "' . $vendedor . '" ';
        endif;

        if (!empty($usuario)) :
            $sql .= ' AND usuario = "' . $usuario . '" ';
        endif;
        
         if (!empty($empresa)) :
            $sql .= ' AND empresa = "' . $empresa . '" ';
        endif;
        $arrayParam = '';
        $movimentacao = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

        $total = count($movimentacao);
        
        return $total;
    }

    $mes = $_POST['mes'];
    $ano = $_POST['ano'];

    $empresa = $_POST['empresa'];
    
    $datai = "$ano-$mes-01";

    $ultimo_dia = date("t", mktime(0, 0, 0, $mes, '01', $ano));

    $dataf = "$ano-$mes-$ultimo_dia";

//    MOVIMENTAÇÃO
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'usuario');
    $sql = 'SELECT movimentacao.`data`, SUM(movimentacao.frete) AS frete, SUM(movimentacao.valortotal) AS valortotal, SUM(movimentacao.valorpago) AS valorpago, 
            SUM(movimentacao.troco) AS troco, SUM(movimentacao.desconto) AS desconto, DAY(str_to_date(data, "%d/%m/%Y")) as dia,  
            movimentacao.vendedor, movimentacao.usuario, movimentacao.cliente
            FROM movimentacao 
            WHERE situacao = "F" 
            AND ((str_to_date(data, "%d/%m/%Y") BETWEEN "' . $datai . '" AND "' . $dataf . '" ) 
            OR (str_to_date(datapagamento, "%d/%m/%Y") BETWEEN "' . $datai . '" AND "' . $dataf . '")) 
            AND empresa = "' . $_POST['empresa'] . '"';

    if (!empty($_POST['cliente'])) :
        $sql .= ' AND cliente = "' . $_POST['cliente'] . '" ';
    endif;

    if (!empty($_POST['vendedor'])) :
        $sql .= ' AND vendedor = "' . $_POST['vendedor'] . '" ';
    endif;

    if (!empty($_POST['usuario'])) :
        $sql .= ' AND usuario = "' . $_POST['usuario'] . '" ';
    endif;

    $sql .= ' GROUP BY data';
    $arrayParam = '';
    $movimentacao = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

//    $totalvg = count($movimentacao);
    echo $sql;
    $movarray = array();
    foreach ($movimentacao as $mov) :
        $movarray[$mov->dia] = array(
            "frete" => $mov->frete,
            "vtotal" => $mov->valortotal,
            "pago" => $mov->valorpago,
            "troco" => $mov->troco,
            "desconto" => $mov->desconto,
            "liquido" => $mov->valorpago - $mov->troco
        );
    endforeach;

//    MOVIMENTAÇÃO ITEM
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'usuario');
    $sql = 'SELECT movimentacao.`data`, movimentacao.vendedor, movimentacao.usuario, movimentacao.cliente,
            sum(itmovimentacao.quantidade) AS qtd, itmovimentacao.documento, itmovimentacao.cancelado, 
            DAY(str_to_date(data, "%d/%m/%Y")) as dia, SUM(itmovimentacao.desc_rateio) AS descrateio, 
            SUM(itmovimentacao.desconto) AS desconto
            FROM movimentacao 
            INNER JOIN itmovimentacao ON itmovimentacao.documento = movimentacao.documento
            WHERE situacao = "F" 
            AND ((str_to_date(data, "%d/%m/%Y") BETWEEN "' . $datai . '" AND "' . $dataf . '" ) 
            OR (str_to_date(datapagamento, "%d/%m/%Y") BETWEEN "' . $datai . '" AND "' . $dataf . '")) 
            AND cancelado = "N"    
            AND empresa = "' . $_POST['empresa'] . '"';

    if (!empty($_POST['cliente'])) :
        $sql .= ' AND cliente = "' . $_POST['cliente'] . '" ';
    endif;

    if (!empty($_POST['vendedor'])) :
        $sql .= ' AND vendedor = "' . $_POST['vendedor'] . '" ';
    endif;

    if (!empty($_POST['usuario'])) :
        $sql .= ' AND usuario = "' . $_POST['usuario'] . '" ';
    endif;

    $sql .= ' GROUP BY data, datapagamento';
    $arrayParam = '';
    $movimentacaoit = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

//    echo $sql;
    $movarrayit = array();
    foreach ($movimentacaoit as $movit) :
        $movarrayit[$movit->dia] = array(
            "item" => $movit->qtd,
            "descrateio" => $movit->descrateio + $movit->desconto
        );
    endforeach;

//    MOVIMENTAÇÃO TROCA
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'usuario');
    $sql = 'SELECT movimentacao_troca.`data`, DAY(str_to_date(data, "%d/%m/%Y")) as dia, 
            SUM(movimentacao_troca.valortotal) AS valortotal, SUM(movimentacao_troca.valorpago) AS valorpago, 
            SUM(movimentacao_troca.desconto) AS desconto,DAY(str_to_date(data, "%d/%m/%Y")) as dia, 
            movimentacao_troca.vendedor, movimentacao_troca.usuario, movimentacao_troca.cliente
            FROM movimentacao_troca 
            WHERE situacao = "F" 
            AND str_to_date(data, "%d/%m/%Y") BETWEEN "' . $datai . '" AND "' . $dataf . '" 
            AND empresa = "' . $_POST['empresa'] . '"';

    if (!empty($_POST['cliente'])) :
        $sql .= ' AND cliente = "' . $_POST['cliente'] . '" ';
    endif;

    if (!empty($_POST['vendedor'])) :
        $sql .= ' AND vendedor = "' . $_POST['vendedor'] . '" ';
    endif;

    if (!empty($_POST['usuario'])) :
        $sql .= ' AND usuario = "' . $_POST['usuario'] . '" ';
    endif;

    $sql .= ' GROUP BY data';
    $arrayParam = '';
    $movimentacaotroca = $crud->getSQLGeneric($sql, $arrayParam, TRUE);
    $movarraytroca = array();
    foreach ($movimentacaotroca as $movt) :
        $movarraytroca[$movt->dia] = array(
            "vtotal" => $movt->valortotal,
            "pago" => $movt->valorpago,
            "desconto" => $movt->desconto,
            "liquido" => $movt->valorpago
        );

    endforeach;

//    echo $sql
//    MOVIMENTAÇÃO ITEM TROCA
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'usuario');
    $sql = 'SELECT movimentacao_troca.`data`, 
            sum(itmovimentacao_troca.quantidade) AS qtd, itmovimentacao_troca.documento, itmovimentacao_troca.cancelado, itmovimentacao_troca.desconto,
            movimentacao_troca.vendedor, itmovimentacao_troca.operacao, movimentacao_troca.usuario, DAY(str_to_date(data, "%d/%m/%Y")) as dia, 
            movimentacao_troca.cliente
            FROM movimentacao_troca 
            INNER JOIN itmovimentacao_troca on itmovimentacao_troca.documento = movimentacao_troca.documento 
            WHERE situacao = "F" 
            AND str_to_date(data, "%d/%m/%Y") BETWEEN "' . $datai . '" AND "' . $dataf . '" 
            AND cancelado = "N"
            AND empresa = "' . $_POST['empresa'] . '"';

    if (!empty($_POST['cliente'])) :
        $sql .= ' AND cliente = "' . $_POST['cliente'] . '" ';
    endif;

    if (!empty($_POST['vendedor'])) :
        $sql .= ' AND vendedor = "' . $_POST['vendedor'] . '" ';
    endif;

    if (!empty($_POST['usuario'])) :
        $sql .= ' AND usuario = "' . $_POST['usuario'] . '" ';
    endif;

    $sql .= ' GROUP BY data, operacao';
    $arrayParam = '';
    $movimentacaotrocait = $crud->getSQLGeneric($sql, $arrayParam, TRUE);
    $movarraytrocait = array();
    foreach ($movimentacaotrocait as $movtir) :
        $movarraytrocait[$movtir->dia][$movtir->operacao] = array(
            "item" => $movtir->qtd,
            "desconto" => $movtir->desconto
        );

    endforeach;

//   echo '<pre>';
//   print_r($movarraytrocait);
//   echo '<pre>';
//    MOVIMENTAÇÃO DEVOLUÇÃO
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'usuario');
    $sql = 'SELECT movimentacao_dev.`data`, SUM(movimentacao_dev.valortotal) AS valortotal, SUM(movimentacao_dev.valorpago) AS valorpago, 
            SUM(movimentacao_dev.desconto) AS desconto ,DAY(str_to_date(data, "%d/%m/%Y")) as dia, 
            movimentacao_dev.vendedor, movimentacao_dev.usuario, movimentacao_dev.cliente
            FROM movimentacao_dev 
            WHERE situacao = "F" 
            AND str_to_date(data, "%d/%m/%Y") BETWEEN "' . $datai . '" AND "' . $dataf . '" 
            AND empresa = "' . $_POST['empresa'] . '"';

    if (!empty($_POST['cliente'])) :
        $sql .= ' AND cliente = "' . $_POST['cliente'] . '" ';
    endif;

    if (!empty($_POST['vendedor'])) :
        $sql .= ' AND vendedor = "' . $_POST['vendedor'] . '" ';
    endif;

    if (!empty($_POST['usuario'])) :
        $sql .= ' AND usuario = "' . $_POST['usuario'] . '" ';
    endif;
    $sql .= ' GROUP BY data';
    $arrayParam = '';
    $movimentacao_dev = $crud->getSQLGeneric($sql, $arrayParam, TRUE);
    $movarraydev = array();
    foreach ($movimentacao_dev as $movd) :
        $movarraydev[$movd->dia] = array(
            "vtotal" => $movd->valortotal,
            "pago" => $movd->valorpago,
            "desconto" => $movd->desconto,
            "liquido" => $movd->valorpago
        );

    endforeach;

//    MOVIMENTAÇÃO ITEM DEVOLUÇÃO
//    
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'usuario');
    $sql = 'SELECT movimentacao_dev.`data`,
            sum(itmovimentacao_dev.quantidade) AS qtd, itmovimentacao_dev.documento, itmovimentacao_dev.cancelado,
            movimentacao_dev.vendedor, movimentacao_dev.usuario, movimentacao_dev.cliente, DAY(str_to_date(data, "%d/%m/%Y")) as dia
            FROM movimentacao_dev
            NNER JOIN itmovimentacao_dev on itmovimentacao_dev.documento = itmovimentacao_dev.documento 
            WHERE situacao = "F" 
            AND str_to_date(data, "%d/%m/%Y") BETWEEN "' . $datai . '" AND "' . $dataf . '"
            AND cancelado = "N"
            AND empresa = "' . $_POST['empresa'] . '"';

    if (!empty($_POST['cliente'])) :
        $sql .= ' AND cliente = "' . $_POST['cliente'] . '" ';
    endif;

    if (!empty($_POST['vendedor'])) :
        $sql .= ' AND vendedor = "' . $_POST['vendedor'] . '" ';
    endif;

    if (!empty($_POST['usuario'])) :
        $sql .= ' AND usuario = "' . $_POST['usuario'] . '" ';
    endif;
    $sql .= ' GROUP BY data';
    $arrayParam = '';
    $movimentacao_devit = $crud->getSQLGeneric($sql, $arrayParam, TRUE);
    $movarraydevit = array();
    foreach ($movarraydevit as $movdit) :
        $movarraydevit[$movdit->dia] = array(
            "item" => $movdit->quantidade
        );

    endforeach;
//echo $sql;
//    echo '<pre>';
//    print_r($movarray);
//    echo '</pre>';
    ?>
    <body>
        <div align="center">
            CONSOLIDAÇÃO DE VENDAS MENSAL
            <Br/> 
            Periodo: <?= parseDate($datai, 'd/m/Y') ?> a <?= parseDate($dataf, 'd/m/Y') ?> 

<?php
if ($_POST['empresa'] !== 'T') :
    ?>
                <br/>
                FILIAL : <?= BuscaEmpresa($_POST['empresa']) ?>
                <?php
            else :
                ?>
                <br/>
                FILIAL : TODAS
            <?php
            endif;
            ?>


            <?php
            if (!empty($_POST['vendedor'])) :
                ?>
                <br/>
                Vendedor : <?= $_POST['empresa'] ?>  - <?= Vendedor($_POST['empresa']) ?>  
                <?php
            endif;
            ?>

<?php
if (!empty($_POST['usuario'])) :
    ?>
                <br/>
                Usuário : <?= $_POST['usuario'] ?>  - <?= Usuario($_POST['usuario']) ?>  
                <?php
            endif;
            ?>

<?php
if (!empty($_POST['cliente'])) :
    ?>
                <br/>
                Cliente : <?= $_POST['cliente'] ?>  - <?= Cliente($_POST['cliente']) ?>  
                <?php
            endif;
            ?>


        </div>

        <table cellpadding="8" class="table table-striped table-bordered" style="font-size: 12px">
            <tr style="text-align: left; background-color: #e8e8e8;" >
                <th style="text-align: left; background-color: #e8e8e8;" style="width: 14%">DIA</th>
                <th style="text-align: left; background-color: #e8e8e8;" style="width: 14%">VENDA R$</th>
                <th style="text-align: left; background-color: #e8e8e8;" style="width: 14%">TROCA R$</th>
                <th style="text-align: left; background-color: #e8e8e8;" style="width: 14%">DEVOLUÇÃO R$</th>
                <th style="text-align: left; background-color: #e8e8e8;" style="width: 14%">DESCONTO R$</th>
                <th style="text-align: left; background-color: #e8e8e8;" style="width: 14%">TOTAL ITENS</th>
                <th style="text-align: left; background-color: #e8e8e8;" style="width: 14%">TOTAL R$</th>
            </tr>


<?php
$totaldescmes = 0;
$totalmes = 0;
$totalvenda = 0;
$totaltroca = 0;
$totaldev = 0;
$itemtotal = 0;
$ultimo_dia++;
for ($index = 1;
        $index < $ultimo_dia;
        $index++) :

    $totaldia = 0;
    $totaldescdia = 0;

    $dia = $index; //str_pad($index, 2, '0', STR_PAD_LEFT);
    $diaf = str_pad($index, 2, '0', STR_PAD_LEFT);
    $datadia = $diaf . '/' . $mes . '/' . $ano;

    $totaldescdia = $movarray[$dia]['desconto'] + $movarraytroca[$dia]['desconto'] + $movarraydev[$dia]['desconto'] + $movarraytrocait[$dia]['S']['desconto'] + $movarrayit[$dia]['descrateio'];
    $totaldia = $movarray[$dia]['vtotal'] + $movarrayit[$dia]['descrateio'] + $movarraytrocait[$dia]['S']['desconto'] + $movarraytroca[$dia]['vtotal'] - $movarraydev[$dia]['vtotal'] - $totaldescdia;

    $totalvenda = $totalvenda + $movarray[$dia]['vtotal'] + $movarrayit[$dia]['descrateio'];
    $totaltroca = $totaltroca + $movarraytroca[$dia]['vtotal'] + $movarraytrocait[$dia]['S']['desconto'];
    $totaldev = $totaldev + $movarraydev[$dia]['vtotal'];

    $totalmes = $totalmes + $totaldia;
    $totaldescmes = $totaldescmes + $totaldescdia;

    $itemdia = $movarrayit[$dia]['item'] + $movarraytrocait[$dia]['S']['item'] - $movarraytrocait[$dia]['E']['item'] - $movarraydevit[$dia]['item'];
    $itemtotal = $itemtotal + $itemdia;
    
    $totalvendageral = TotalVendaDia($datadia, $_POST['cliente'], $_POST['vendedor'], $_POST['usuario'], $empresa);
    $totaltrocageral = TotalTrocaDia($datadia, $_POST['cliente'], $_POST['vendedor'], $_POST['usuario'], $empresa);
    $totaldevgeral = TotalDevDia($datadia, $_POST['cliente'], $_POST['vendedor'], $_POST['usuario'], $empresa);
    ?>
                <tr>
                    <td><?= $datadia ?></td>
                    <td><?= number_format($movarray[$dia]['vtotal'] + $movarrayit[$dia]['descrateio'], 2, ',', '.') ?> (<?= $totalvendageral ?>)</td>       
                    <td><?= number_format($movarraytroca[$dia]['vtotal'] + $movarraytrocait[$dia]['S']['desconto'], 2, ',', '.') ?> (<?= $totaltrocageral ?>)</td>       
                    <td><?= number_format($movarraydev[$dia]['vtotal'], 2, ',', '.') ?> (<?= $totaldevgeral ?>)</td>       
                    <td><?= number_format($totaldescdia, 2, ',', '.') ?></td>       
                    <td><?= $itemdia ?></td>       
                    <td><?= number_format($totaldia, 2, ',', '.') ?></td>       
                </tr>
    <?php
endfor;
?>

            <tr>
                <th style="text-align: left; background-color: #e8e8e8;">TOTAIS</th>
                <th style="text-align: left; background-color: #e8e8e8;"><?= number_format($totalvenda, 2, ',', '.') ?></th>       
                <th style="text-align: left; background-color: #e8e8e8;"><?= number_format($totaltroca, 2, ',', '.') ?></th>       
                <th style="text-align: left; background-color: #e8e8e8;"><?= number_format($totaldev, 2, ',', '.') ?></th>       
                <th style="text-align: left; background-color: #e8e8e8;"><?= number_format($totaldescmes, 2, ',', '.') ?></th>       
                <th style="text-align: left; background-color: #e8e8e8;"><?= $itemtotal ?></th>       
                <th style="text-align: left; background-color: #e8e8e8;"><?= number_format($totalvenda + $totaltroca - $totaldev - $totaldescmes, 2, ',', '.') ?></th>       
            </tr>

        </table>


    </body>
</html>
<?php
if ($_POST['arq'] == 'PDF') :
    ini_set("pcre.backtrack_limit", "500000000000000");
    require_once("../../_inc/mpdf/vendor/autoload.php");
    $mpdf = new \Mpdf\Mpdf([
        'margin_top' => 5,
        'margin_left' => 5,
        'margin_right' => 5,
        'mirrorMargins' => true,
        'default_font_size' => 12,
        'format' => 'A4'
    ]);
    $mpdf->keep_table_proportions = true;
    $mpdf->allow_charset_conversion = true;
    $footer = "<table width = \"1000\">
                   <tr>
                     <td style='font-size: 10px; bottom:-15px;' align=\"right\">Pag: {PAGENO} de {nb} " . date('d/m/Y') . "</td>
                   </tr>
                 </table>";
    $mpdf->SetHTMLFooter($footer);
    $html = ob_get_clean();
    $mpdf->SetTitle('ConsolidadoMensal');
    $mpdf->WriteHTML($html);
    $mpdf->Output();
// imprime

    exit();
elseif ($_POST['arq'] == 'EXCEL') :
    $file = 'ConsolidadoMensal.xls';
    header("Content-type: application/x-msexcel");
    header("Content-Disposition: attachment; filename=\"{$file}\"");
    header("Content-Description: PHP Generated Data");
else :
    echo '';
endif;
?>