<?php
ob_start();
?>
<html>
    <head>
        <title> Relatório </title>
        <style>
            /*@import "../../../_frontend/_layout/assets/vendor/bootstrap/css/bootstrap.min.css";*/

            table {
                border-collapse: collapse;
            }
            thead {
                vertical-align: bottom;
                text-align: center;
                font-weight: bold;
            }
            tfoot {
                text-align: center;
                font-weight: bold;
            }
            th {
                text-align: left;
                padding-left: 0.35em;
                padding-right: 0.35em;
                padding-top: 0.35em;
                padding-bottom: 0.35em;
                vertical-align: top;
            }
            td {
                padding-left: 0.35em;
                padding-right: 0.35em;
                padding-top: 0.35em;
                padding-bottom: 0.35em;
                vertical-align: top;
            }

        </style>
    </head>
    <?php

    function Vendedor($valor) {
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'usuario');
        $sql = "SELECT * from vendedor where vendedorid = '" . $valor . "' ";
        $arrayParam = '';
        $vendedor = $crud->getSQLGeneric($sql, $arrayParam, false);
        return $vendedor->xNome;
    }

    function BuscaNNF($valor) {
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'usuario');
        $sql = "SELECT * from nfe where id = '" . $valor . "' ";
        $arrayParam = '';
        $vendedor = $crud->getSQLGeneric($sql, $arrayParam, false);
        return $vendedor->nNF;
    }

    function Para($valor) {
        switch ($valor) :
            case 'C' :
                return 'Cliente';
                break;
            case 'F' :
                return 'Funcionário';
                break;
            case 'R' :
                return 'Representante';
        endswitch;
    }

    function BuscaPara($valor, $id) {

        if ($valor == 'R') :
            $sql = "SELECT * from representante where representanteid = '$id' ";
        elseif ($valor == 'F') :
            $sql = "SELECT * from funcionario where funcionarioid = '$id' ";
        else :
            $sql = "SELECT * from cliente where clienteid = '$id' ";
        endif;

        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'tabela');
        $arrayParam = '';
        $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

        return $dados;
    }

    date_default_timezone_set("Brazil/East");
    require_once("../../../functions.php");
//
    require_once "../../../_backend/_class/Conexao_class.php";
    require_once "../../../_backend/_class/Crud_class.php";
    require_once "../../../_backend/_class/cobranca_class.php";
    require_once "../../../_backend/_class/parametros.php";

    $_POST['datai'] = parseDate($_POST['datai'], 'Y-m-d');
    $_POST['dataf'] = parseDate($_POST['dataf'], 'Y-m-d');

    $dataitime = strtotime($_POST['datai']);
    $dataftime = strtotime($_POST['dataf']);

    $dataconsulta = date("Y-m-d");
    $data1 = parseDate($dataconsulta, 'd/m/Y');

    function Situacao($valor) {
        switch ($valor) :
            case 'A' :
                return 'Aberta';
                break;
            case 'F' :
                return 'Fechada';
                break;
            case 'C' :
                return 'Cancelado';
                break;
        endswitch;
    }
    ?>
    <body>

        <div align="center">
            RELATÓRIO DE MOVIMENTAÇÕES
            <br/> <small> GERAL <br/><?= parseDate($_POST['datai'], "d/m/Y"); ?> à <?= parseDate($_POST['dataf'], "d/m/Y"); ?></small>
        </div>


        <?php require_once './cabecalho.php'; ?>
        <?php
        if ($_POST['tipor'] === 'R'):
            echo '<div style="display: none;">';
        else :
            ?>
            <div>
            <?php
            endif;
            ?>
            <table class="table table-bordered" style="font-size: 10px;">
                <tr> 
                    <th style="width: 5%" class="text-left">Doc</th>
                    <th style="width: 8%" class="text-left">Entidade</th>
                    <th style="width: 45%" class="text-left">Nome</th>
                    <th style="width: 15%" class="text-left">Data | Data Pag</th>
                    <th style="width: 10%" class="text-left">Desc.</th>
                    <th style="width: 10%" class="text-left">Frete</th>
                    <th style="width: 10%" class="text-left">Vlr. Liq</th>
                    <th style="width: 10%" class="text-left">Vlr. Total</th>
                    <th style="width: 10%" class="text-left">Situação</th>
                    <th style="width: 5%" class="text-left">NF</th>
                </tr>
                <?php
                if ($_POST['tipor'] == 'C') :
                    ?>
                    <tr> 
                        <th></th>
                        <th colspan="4">Produto</th>
                        <th>Quantitade</th>
                        <th>Vlr. Unit.</th>
                        <th>Desconto</th>
                        <th>Total</th>
                        <th></th>
                    </tr>
                    <?php
                endif;
                ?>
                <tr>
                    <td colspan="10" align="center"><hr/> <h3>MOVIMENTAÇÕES DE SAÍDAS</h3><hr/></td>
                </tr>
                <?php
                $totalvenda = 0;
                $desciten = 0;
                $descdoc = 0;
                $totalbruto = 0;
                $totalliquido = 0;
                $totalprod = 0;

//            echo $tabelabd;
                $pdo = Conexao::getInstance();
                $crud = Crud::getInstance($pdo, 'usuario');
                $sql = 'Select * FROM movimentacao where 
                    ((str_to_date(data, "%d/%m/%Y") BETWEEN "' . $_POST['datai'] . '" AND "' . $_POST['dataf'] . '" ) 
                        OR                        
                       (str_to_date(datapagamento, "%d/%m/%Y") BETWEEN "' . $_POST['datai'] . '" AND "' . $_POST['dataf'] . '") )';

                if ($_POST['consig'] == 'N') :
                    $sql .= ' AND tipo != "C" ';
                endif;

                if ($_POST['simplesremessa'] == 'N') :
                    $sql .= ' AND tipo != "R" ';
                endif;

                if (!empty($_POST['cliente'])) :
                    $sql .= ' AND cliente = "' . $_POST['cliente'] . '" ';
                endif;

                if (!empty($_POST['fornecedor'])) :
                    $sql .= ' AND fornecedor = "' . $_POST['fornecedor'] . '" ';
                endif;

                if (!empty($_POST['vendedor'])) :
                    $sql .= ' AND vendedor = "' . $_POST['vendedor'] . '" ';
                endif;

                if (!empty($_POST['corretor'])) :
                    $sql .= ' AND corretor = "' . $_POST['corretor'] . '" ';
                endif;

                if (!empty($_POST['representante'])) :
                    $sql .= ' AND representante = "' . $_POST['representante'] . '" ';
                endif;

                if (!empty($_POST['funcionario'])) :
                    $sql .= ' AND funcionario = "' . $_POST['funcionario'] . '" ';
                endif;

                if (!empty($_POST['operacao'])) :
                    if ($_POST['operacao'] != 'T') :
                        $sql .= ' AND operacao = "' . $_POST['operacao'] . '" ';
                    endif;
                endif;

                if (!empty($_POST['usuario'])) :
                    $sql .= ' AND usuario = "' . $_POST['usuario'] . '" ';
                endif;

                if ($_POST['status'] != 'T') :
                    if ($_POST['doccanc'] == 'S') :
                        $sql .= ' AND ((situacao = "' . $_POST['status'] . '") OR (situacao = "C")) ';
                    else :
                        $sql .= ' AND situacao = "' . $_POST['status'] . '" ';

                    endif;
                endif;

                $sql .= ' AND empresa = "' . $_POST['empresa'] . '"';
                $sql .= '  ORDER BY  doc_empresa ASC';

//                echo $sql;
                $frete = 0;

                $arrayParam = '';
                $movimentacao = $crud->getSQLGeneric($sql, $arrayParam, true);
                $docinicialsaida = 0;
                $docfinalsaida = 0;
                foreach ($movimentacao as $movimentacao) :

                    if ($docinicialsaida == '0') :
                        $docinicialsaida = $movimentacao->doc_empresa;
                    endif;
                    $docfinalsaida = $movimentacao->doc_empresa;

//soma
                    if ($movimentacao->situacao != 'C') :
                        if ($movimentacao->tipo == 'C') :
                            if ($movimentacao->datapagamento != '') :
                                $datapag = parseDate($movimentacao->datapagamento, 'Y-m-d');
                                $datapag = strtotime($datapag);
                                if (($datapag >= $dataitime) && ($datapag <= $dataftime)) :
                                    $frete = $frete + $movimentacao->frete;
                                    $totalbruto = $totalbruto + $movimentacao->valortotal + $movimentacao->desconto;
                                    $totalliquido = $totalliquido + $movimentacao->valorpago - $movimentacao->troco;
                                    $descdoc = $descdoc + $movimentacao->desconto;
                                endif;
                            endif;
                        else :
                            $frete = $frete + $movimentacao->frete;
                            $totalbruto = $totalbruto + $movimentacao->valortotal + $movimentacao->desconto;
                            $totalliquido = $totalliquido + $movimentacao->valorpago - $movimentacao->troco;
                            $descdoc = $descdoc + $movimentacao->desconto;
                        endif;
                    endif;

                    $totalvenda++;

                    if ($movimentacao->para == 'R') :
                        $id = $movimentacao->representante;
                        $dest = BuscaPara('R', $movimentacao->representante);
                    elseif ($movimentacao->para == 'F') :
                        $id = $movimentacao->funcionario;
                        $dest = BuscaPara('F', $movimentacao->funcionario);
                    else :
                        $id = $movimentacao->cliente;
                        $dest = BuscaPara('C', $movimentacao->cliente);
                    endif;
                    ?>
                    <tr> 
                        <td><?= $movimentacao->doc_empresa ?></td>
                        <td><?= Para($movimentacao->para) ?></td>
                        <td><?= $id ?> - <?= $dest->xNome ?></td>
                        <td><?= $movimentacao->data ?> | <?= $movimentacao->datapagamento ?></td>
                        <td>R$ <?= number_format($movimentacao->desconto, $parametros->casadecimal, ',', '.') ?></td>
                        <td>R$ <?= number_format($movimentacao->frete, $parametros->casadecimal, ',', '.') ?></td>
                        <td>R$ <?= number_format($movimentacao->valortotal, $parametros->casadecimal, ',', '.') ?></td>
                        <td>R$ <?= number_format($movimentacao->valorpago - $movimentacao->troco, $parametros->casadecimal, ',', '.') ?></td>
                        <td><?= Situacao($movimentacao->situacao) ?></td>
                        <td><?= BuscaNNF($movimentacao->DocFiscal) ?></td>
                    </tr>
                    <tr>
                        <td></td>
                        <td><b>Vendedor(a) :</b></td>
                        <td colspan="8"><?= $movimentacao->vendedor ?> - <?= Vendedor($movimentacao->vendedor) ?></td>
                    </tr>
                    <!--<tr>-->
                        <!--<td colspan="7">-->

                                                                                                                                                                                                                                                                                                                                                                        <!--<table class="table" style="border: none;">-->


                    <?php
                    $pdo = Conexao::getInstance();
                    $crud = Crud::getInstance($pdo, 'usuario');
                    $sql = "SELECT itmovimentacao.quantidade as qtd, itmovimentacao.valorliquido as total, itmovimentacao.desconto as tdesconto, itmovimentacao.id, itmovimentacao.preco,
        itmovimentacao.documento, itmovimentacao.produto, itmovimentacao.cancelado, estoqueprodutos.produto, estoqueprodutos.codproduto, 
produtos.codigo, produtos.descricao from itmovimentacao
LEFT JOIN estoqueprodutos on itmovimentacao.produto = estoqueprodutos.codproduto
LEFT JOIN produtos on produtos.codigo = estoqueprodutos.produto
WHERE itmovimentacao.documento = '$movimentacao->documento' ";

//                echo $sql;
                    $arrayParam = '';
                    $itmovimentacao = $crud->getSQLGeneric($sql, $arrayParam, true);
                    foreach ($itmovimentacao as $itmovimentacao) :




//                    echo $itmovimentacao->cancelado;
                        if ($itmovimentacao->cancelado != 'S') :
                            if ($movimentacao->situacao != 'C') :
                                $desciten = $desciten + $itmovimentacao->tdesconto;
                                $totalprod = $totalprod + $itmovimentacao->qtd;
                            endif;
                        endif;
                        if ($_POST['tipor'] == 'C') :
                            if ($itmovimentacao->cancelado == 'S' || $movimentacao->situacao == 'C') :
                                if ($parametros->exibeitemcanc == 'S') :
                                    ?>
                                    <tr style="text-decoration: line-through;">
                                        <td></td>
                                        <td colspan="4"><s><?= $itmovimentacao->codproduto ?> - <?= $itmovimentacao->descricao ?></s></td>
                                        <td><s><?= $itmovimentacao->qtd ?></s></td>
                                        <td><s>R$ <?= number_format($itmovimentacao->preco, $parametros->casadecimal, ',', '.') ?></s></td>
                                        <td><s>R$ <?= number_format($itmovimentacao->tdesconto, $parametros->casadecimal, ',', '.') ?></s></td>
                                        <td><s>R$ <?= number_format($itmovimentacao->total, $parametros->casadecimal, ',', '.') ?></s> - CANC</td>
                                        <td></td>
                                    </tr>
                                    <?php
                                endif;
                            else :
                                ?>
                                <tr>
                                    <td></td>
                                    <td colspan="4"><?= $itmovimentacao->codproduto ?> - <?= $itmovimentacao->descricao ?></td>
                                    <td><?= $itmovimentacao->qtd ?></td>
                                    <td>R$ <?= number_format($itmovimentacao->preco, $parametros->casadecimal, ',', '.') ?></td>
                                    <td>R$ <?= number_format($itmovimentacao->tdesconto, $parametros->casadecimal, ',', '.') ?></td>
                                    <td>R$ <?= number_format($itmovimentacao->total, $parametros->casadecimal, ',', '.') ?></td>
                                    <td></td>
                                </tr>
                            <?php
                            endif;
                            ?>

                            <?php
                        endif;
                    endforeach;
                    ?>
                    <!--                    </table>-->

                    <!--</td>-->
                    <!--</tr>-->


                    <?php
                    if ($_POST['faturamento'] == 'S') :
                        if ($movimentacao->situacao != 'C') :
                            if ($movimentacao->tipo == 'C') :
                                if ($_POST['fatconsig'] == 'S') :
                                    ?>
                                    <tr>
                                        <td colspan="10">            
                                            <?php
                                            $pdo = Conexao::getInstance();
                                            $crud = Crud::getInstance($pdo, 'itmovimentacao');
                                            $sql = "SELECT * FROM recebimentoconsig where acerto = '$movimentacao->acerto'";
//                                        echo $sql;
                                            $arrayParam = '';
                                            $dadosrec = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

                                            $totalf = count($dadosrec);
                                            if ($totalf > 0) :
                                                ?>
                                                <table class="table table-striped table-bordered table-condensed full_table_list">

                                                    <?php
                                                    foreach ($dadosrec as $value) :
                                                        ?>
                                                        <tr>
                                                            <td> Acerto consignado Nº <?= $movimentacao->acerto ?> </td>
                                                            <td><?= $value->dataven ?></td>
                                                            <td colspan="2"><?= $cobranca[$value->tiporeceb] ?></td>
                                                            <td>R$ <?= number_format($value->valor, $parametros->casadecimal, ',', '.') ?></td>
                                                        </tr>
                                                        <?php
                                                    endforeach;
                                                    ?>
                                                </table>
                                                <?php
                                            endif;
                                            ?>
                                        </td>
                                    </tr>
                                    <?php
                                endif;
                            else :
                                ?>

                                <tr>
                                    <td colspan="10">

                                        <?php
                                        if ($movimentacao->utilizadocredito == 'S') :
                                            ?>
                                            <h5> UTILIZADO O CRÉDITO DE R$ <?= number_format($movimentacao->credito, $parametros->casadecimal, ',', '.') ?> COMO PARTE DO PAGAMENTO.</h5>
                                            <?php
                                        endif;
                                        ?>
                                        <?php
                                        $pdo = Conexao::getInstance();
                                        $crud = Crud::getInstance($pdo, 'itmovimentacao');
                                        $sql = "SELECT * FROM recebimentomov where documento = '$movimentacao->documento'";
//    echo $sql;
                                        $arrayParam = '';
                                        $dadosrec = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

                                        $totalf = count($dadosrec);
                                        if ($totalf > 0) :
                                            ?>
                                            <table class="table table-striped table-bordered table-condensed full_table_list">

                                                <?php
                                                foreach ($dadosrec as $value) :
                                                    ?>
                                                    <tr>
                                                        <td><?= $value->dataven ?></td>
                                                        <td colspan="2"><?= $cobranca[$value->tiporeceb] ?></td>
                                                        <td>R$ <?= number_format($value->valor, $parametros->casadecimal, ',', '.') ?></td>
                                                    </tr>
                                                    <?php
                                                endforeach;
                                                ?>
                                            </table>
                                            <?php
                                        endif;
                                        ?>
                                    </td>
                                </tr>
                            <?php
                            endif;
                        endif;
                    endif;
                    ?>
                    <tr>
                        <td colspan="10">  <hr/> </td>
                    </tr>
                    <?php
                endforeach;
                ?>  


                <tr>
                    <td colspan="10" align="center"><hr/> <h3>MOVIMENTAÇÕES DE TROCAS</h3> <hr/></td>
                </tr>
                <?php
                $totalvendatroca = 0;
                $descitentroca = 0;
                $descdoctroca = 0;
                $totalbrutotroca = 0;
                $totalliquidotroca = 0;
                $totalprodtroca = 0;

//            echo $tabelabd;
                $pdo = Conexao::getInstance();
                $crud = Crud::getInstance($pdo, 'usuario');
                $sql = 'Select * FROM movimentacao_troca where str_to_date(data, "%d/%m/%Y") BETWEEN "' . $_POST['datai'] . '" AND "' . $_POST['dataf'] . '" ';

                if (!empty($_POST['cliente'])) :
                    $sql .= ' AND cliente = "' . $_POST['cliente'] . '" ';
                endif;

                if (!empty($_POST['fornecedor'])) :
                    $sql .= ' AND fornecedor = "' . $_POST['fornecedor'] . '" ';
                endif;

                if (!empty($_POST['vendedor'])) :
                    $sql .= ' AND vendedor = "' . $_POST['vendedor'] . '" ';
                endif;

                if (!empty($_POST['corretor'])) :
                    $sql .= ' AND corretor = "' . $_POST['corretor'] . '" ';
                endif;

                if (!empty($_POST['representante'])) :
                    $sql .= ' AND representante = "' . $_POST['representante'] . '" ';
                endif;

                if (!empty($_POST['funcionario'])) :
                    $sql .= ' AND funcionario = "' . $_POST['funcionario'] . '" ';
                endif;

                if (!empty($_POST['operacao'])) :
                    if ($_POST['operacao'] != 'T') :
                        $sql .= ' AND operacao = "' . $_POST['operacao'] . '" ';
                    endif;
                endif;

                if (!empty($_POST['usuario'])) :
                    $sql .= ' AND usuario = "' . $_POST['usuario'] . '" ';
                endif;

                if ($_POST['status'] != 'T') :
                    if ($_POST['doccanc'] == 'S') :
                        $sql .= ' AND ((situacao = "' . $_POST['status'] . '") OR (situacao = "C")) ';
                    else :
                        $sql .= ' AND situacao = "' . $_POST['status'] . '" ';

                    endif;
                endif;

                $sql .= ' AND empresa = "' . $_POST['empresa'] . '"';
                $sql .= '  ORDER BY doc_empresa ASC';

//            echo $sql;
                $fretetroca = 0;
                $docinicialtroca = 0;
                $docfinaltroca = 0;
                $arrayParam = '';
                $movimentacao = $crud->getSQLGeneric($sql, $arrayParam, true);
                foreach ($movimentacao as $movimentacao) :

                    if ($docinicialtroca == '0') :
                        $docinicialtroca = $movimentacao->doc_empresa;
                    endif;
                    $docfinaltroca = $movimentacao->doc_empresa;

                    if ($movimentacao->situacao != 'C') :
                        $fretetroca = $fretetroca + $movimentacao->frete;
                        $totalbrutotroca = $totalbrutotroca + $movimentacao->valortotal + $movimentacao->desconto;
                        $totalliquidotroca = $totalliquidotroca + $movimentacao->valorpago - $movimentacao->troco;
                        $descdoc = $descdoc + $movimentacao->desconto;
                    endif;
                    $totalvendatroca++;

                    if ($movimentacao->para == 'R') :
                        $id = $movimentacao->representante;
                        $dest = BuscaPara('R', $movimentacao->representante);
                    elseif ($movimentacao->para == 'F') :
                        $id = $movimentacao->funcionario;
                        $dest = BuscaPara('F', $movimentacao->funcionario);
                    else :
                        $id = $movimentacao->cliente;
                        $dest = BuscaPara('C', $movimentacao->cliente);
                    endif;
                    ?>
                    <tr> 
                        <td><?= $movimentacao->doc_empresa ?></td>
                        <td><?= Para($movimentacao->para) ?></td>
                        <td><?= $id ?> - <?= $dest->xNome ?></td>
                        <td><?= $movimentacao->data ?></td>
                        <td>R$ <?= number_format($movimentacao->desconto, $parametros->casadecimal, ',', '.') ?></td>
                        <td>R$ <?= number_format($movimentacao->frete, $parametros->casadecimal, ',', '.') ?></td>
                        <td>R$ <?= number_format($movimentacao->valortotal, $parametros->casadecimal, ',', '.') ?></td>
                        <td>R$ <?= number_format($movimentacao->valorpago - $movimentacao->troco, $parametros->casadecimal, ',', '.') ?></td>
                        <td><?= Situacao($movimentacao->situacao) ?></td>
                        <td></td>

                    </tr>
                    <tr>
                        <td></td>
                        <td><b>Vendedor(a) :</b></td>
                        <td colspan="8"><?= $movimentacao->vendedor ?> - <?= Vendedor($movimentacao->vendedor) ?></td>
                    </tr>
                    <!--<tr>-->
                        <!--<td colspan="7">-->

                    <?php
                    $pdo = Conexao::getInstance();
                    $crud = Crud::getInstance($pdo, 'usuario');
                    $sql = "SELECT itmovimentacao_troca.quantidade as qtd, itmovimentacao_troca.valorliquido as total, itmovimentacao_troca.desconto as tdesconto, itmovimentacao_troca.id, itmovimentacao_troca.preco,
        itmovimentacao_troca.documento, itmovimentacao_troca.produto, itmovimentacao_troca.cancelado,  itmovimentacao_troca.operacao, estoqueprodutos.produto, estoqueprodutos.codproduto, 
produtos.codigo, produtos.descricao from itmovimentacao_troca
LEFT JOIN estoqueprodutos on itmovimentacao_troca.produto = estoqueprodutos.codproduto
LEFT JOIN produtos on produtos.codigo = estoqueprodutos.produto
WHERE itmovimentacao_troca.documento = '$movimentacao->documento' ";

//                echo $sql;
                    $arrayParam = '';
                    $itmovimentacao = $crud->getSQLGeneric($sql, $arrayParam, true);
                    foreach ($itmovimentacao as $itmovimentacao) :
//                    echo $itmovimentacao->cancelado;
                        if ($itmovimentacao->cancelado != 'S' || $movimentacao->situacao == 'C') :
                            $descitentroca = $descitentroca + $itmovimentacao->tdesconto;
                            if ($itmovimentacao->operacao == 'E') :
                                $totalprodtroca = $totalprodtroca - $itmovimentacao->qtd;
                            else :
                                $totalprodtroca = $totalprodtroca + $itmovimentacao->qtd;
                            endif;
                        endif;
                        if ($_POST['tipor'] == 'C') :
                            if ($itmovimentacao->cancelado == 'S' || $movimentacao->situacao == 'C') :
                                ?>
                                <tr style="text-decoration: line-through;">
                                    <td></td>
                                    <td colspan="4"><s><?= $itmovimentacao->operacao ?> | <?= $itmovimentacao->codproduto ?> - <?= $itmovimentacao->descricao ?></s></td>
                                    <td><s><?= $itmovimentacao->qtd ?></s></td>
                                    <td><s>R$ <?= number_format($itmovimentacao->preco, $parametros->casadecimal, ',', '.') ?></s></td>
                                    <td><s>R$ <?= number_format($itmovimentacao->tdesconto, $parametros->casadecimal, ',', '.') ?></s></td>
                                    <td><s>R$ <?= number_format($itmovimentacao->total, $parametros->casadecimal, ',', '.') ?></s> - CANC</td>
                                    <td></td>
                                </tr>
                                <?php
                            else :
                                ?>
                                <tr>
                                    <td></td>
                                    <td colspan="4"><?= $itmovimentacao->operacao ?> |  <?= $itmovimentacao->codproduto ?> - <?= $itmovimentacao->descricao ?></td>
                                    <td><?= $itmovimentacao->qtd ?></td>
                                    <td>R$ <?= number_format($itmovimentacao->preco, $parametros->casadecimal, ',', '.') ?></td>
                                    <td>R$ <?= number_format($itmovimentacao->tdesconto, $parametros->casadecimal, ',', '.') ?></td>
                                    <td>R$ <?= number_format($itmovimentacao->total, $parametros->casadecimal, ',', '.') ?></td>
                                    <td></td>
                                </tr>
                            <?php
                            endif;
                            ?>

                            <?php
                        endif;
                    endforeach;
                    ?>
                    <!--                    </table>-->

                    <!--</td>-->
                    <!--</tr>-->


                    <?php
                    if ($_POST['faturamento'] == 'S') :
                        ?>

                        <tr>
                            <td colspan="10">

                                <?php
                                if ($movimentacao->utilizadocredito == 'S') :
                                    ?>
                                    <h5> UTILIZADO O CRÉDITO DE R$ <?= number_format($movimentacao->credito, $parametros->casadecimal, ',', '.') ?> COMO PARTE DO PAGAMENTO.</h5>
                                    <?php
                                endif;
                                ?>
                                <?php
                                $pdo = Conexao::getInstance();
                                $crud = Crud::getInstance($pdo, 'itmovimentacao');
                                $sql = "SELECT * FROM recebimentomov_troca where documento = '$movimentacao->documento'";
//    echo $sql;
                                $arrayParam = '';
                                $dadosrec = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

                                $totalf = count($dadosrec);
                                if ($totalf > 0) :
                                    ?>
                                    <table class="table table-striped table-bordered table-condensed full_table_list">

                                        <?php
                                        foreach ($dadosrec as $value) :
                                            ?>
                                            <tr>
                                                <td><?= $value->dataven ?></td>
                                                <td colspan="2"><?= $cobranca[$value->tiporeceb] ?></td>
                                                <td>R$ <?= number_format($value->valor, $parametros->casadecimal, ',', '.') ?></td>
                                            </tr>
                                            <?php
                                        endforeach;
                                        ?>
                                    </table>
                                    <?php
                                endif;
                                ?>
                            </td>
                        </tr>
                        <?php
                    endif;
                    ?>
                    <tr>
                        <td colspan="10">  <hr/> </td>
                    </tr>
                    <?php
                endforeach;
                ?>  



                <?php
                if ($_POST['deddev'] == 'S') :
                    ?>
                    <tr>
                        <td colspan="10" align="center"><hr/> <h3>MOVIMENTAÇÕES DE DEVOLUÇÕES</h3> <hr/></td>
                    </tr>
                    <?php
                    $totaldevolucoes = 0;
                    $descidevolucoes = 0;
                    $descdocdevolucoes = 0;
                    $totalbrutodevolucoes = 0;
                    $totalliquidodevolucoes = 0;
                    $totalprodevolucao = 0;

//            echo $tabelabd;
                    $pdo = Conexao::getInstance();
                    $crud = Crud::getInstance($pdo, 'usuario');
                    $sql = 'Select * FROM movimentacao_dev where 
                        ((str_to_date(data, "%d/%m/%Y") BETWEEN "' . $_POST['datai'] . '" AND "' . $_POST['dataf'] . '" ) 
                        OR                        
                       (str_to_date(datapagamento, "%d/%m/%Y") BETWEEN "' . $_POST['datai'] . '" AND "' . $_POST['dataf'] . '") )';

                    if ($_POST['consig'] == 'N') :
                        $sql .= ' AND tipo != "C" ';
                    endif;

                    if (!empty($_POST['cliente'])) :
                        $sql .= ' AND cliente = "' . $_POST['cliente'] . '" ';
                    endif;

                    if (!empty($_POST['fornecedor'])) :
                        $sql .= ' AND fornecedor = "' . $_POST['fornecedor'] . '" ';
                    endif;

                    if (!empty($_POST['vendedor'])) :
                        $sql .= ' AND vendedor = "' . $_POST['vendedor'] . '" ';
                    endif;

                    if (!empty($_POST['corretor'])) :
                        $sql .= ' AND corretor = "' . $_POST['corretor'] . '" ';
                    endif;

                    if (!empty($_POST['representante'])) :
                        $sql .= ' AND representante = "' . $_POST['representante'] . '" ';
                    endif;

                    if (!empty($_POST['funcionario'])) :
                        $sql .= ' AND funcionario = "' . $_POST['funcionario'] . '" ';
                    endif;

                    if (!empty($_POST['usuario'])) :
                        $sql .= ' AND usuario = "' . $_POST['usuario'] . '" ';
                    endif;

                    if ($_POST['status'] != 'T') :
                        if ($_POST['doccanc'] == 'S') :
                            $sql .= ' AND ((situacao = "' . $_POST['status'] . '") OR (situacao = "C")) ';
                        else :
                            $sql .= ' AND situacao = "' . $_POST['status'] . '" ';

                        endif;
                    endif;

                    $sql .= ' AND empresa = "' . $_POST['empresa'] . '"';
                    $sql .= '  ORDER BY  str_to_date(data, "%d/%m/%Y")';

//            echo $sql;
                    $fretetroca = 0;

                    $arrayParam = '';
                    $docinicialdev = 0;
                    $docfinaldev = 0;
                    $movimentacao = $crud->getSQLGeneric($sql, $arrayParam, true);
                    foreach ($movimentacao as $movimentacao) :


                        if ($docinicialdev == '0') :
                            $docinicialdev = $movimentacao->doc_empresa;
                        endif;
                        $docfinaldev = $movimentacao->doc_empresa;

                        if ($movimentacao->situacao != 'C') :
                            if ($movimentacao->tipo == 'C') :
                                if ($movimentacao->datapagamento != '') :
                                    $datapag = parseDate($movimentacao->datapagamento, 'Y-m-d');
                                    $datapag = strtotime($datapag);
                                    if (($datapag >= $dataitime) && ($datapag <= $dataftime)) :
                                        $totalbrutodevolucao = $totalbrutodevolucao + $movimentacao->valortotal + $movimentacao->desconto;
                                        $totalliquidodevolucao = $totalliquidodevolucao + $movimentacao->valortotal - $movimentacao->troco;
                                        $descdoc = $descdoc + $movimentacao->desconto;
                                    endif;
                                endif;
                            else :
                                $totalbrutodevolucao = $totalbrutodevolucao + $movimentacao->valortotal + $movimentacao->desconto;
                                $totalliquidodevolucao = $totalliquidodevolucao + $movimentacao->valortotal - $movimentacao->troco;
                                $descdoc = $descdoc + $movimentacao->desconto;
                            endif;
                        endif;

//
//                        if ($movimentacao->situacao != 'C') :
//                            $totalbrutodevolucao = $totalbrutodevolucao + $movimentacao->valortotal + $movimentacao->desconto;
//                            $totalliquidodevolucao = $totalliquidodevolucao + $movimentacao->valortotal - $movimentacao->troco;
//                            $descdoc = $descdoc + $movimentacao->desconto;
//                        endif;
                        $totaldevolucoes++;

                        if ($movimentacao->para == 'R') :
                            $id = $movimentacao->representante;
                            $dest = BuscaPara('R', $movimentacao->representante);
                        elseif ($movimentacao->para == 'F') :
                            $id = $movimentacao->funcionario;
                            $dest = BuscaPara('F', $movimentacao->funcionario);
                        else :
                            $id = $movimentacao->cliente;
                            $dest = BuscaPara('C', $movimentacao->cliente);
                        endif;
                        ?>
                        <tr> 
                            <td><?= $movimentacao->doc_empresa ?></td>
                            <td><?= Para($movimentacao->para) ?></td>
                            <td><?= $id ?> - <?= $dest->xNome ?></td>
                            <td><?= $movimentacao->data ?> | <?= $movimentacao->datapagamento ?></td>
                            <td>R$ <?= number_format($movimentacao->desconto, $parametros->casadecimal, ',', '.') ?></td>
                            <td>R$ 0,00</td>
                            <td>R$ <?= number_format($movimentacao->valortotal, $parametros->casadecimal, ',', '.') ?></td>
                            <td>R$ <?= number_format($movimentacao->valorpago - $movimentacao->troco, $parametros->casadecimal, ',', '.') ?></td>
                            <td><?= Situacao($movimentacao->situacao) ?></td>
                            <td></td>

                        </tr>
                        <tr>
                            <td></td>
                            <td><b>Vendedor(a) :</b></td>
                            <td colspan="8"><?= $movimentacao->vendedor ?> - <?= Vendedor($movimentacao->vendedor) ?></td>
                        </tr>
                        <!--<tr>-->
                            <!--<td colspan="7">-->

                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        <!--<table class="table" style="border: none;">-->


                        <?php
                        $pdo = Conexao::getInstance();
                        $crud = Crud::getInstance($pdo, 'usuario');
                        $sql = "SELECT itmovimentacao_dev.quantidade as qtd, itmovimentacao_dev.valorliquido as total, itmovimentacao_dev.desconto as tdesconto, itmovimentacao_dev.id, itmovimentacao_dev.preco,
        itmovimentacao_dev.documento, itmovimentacao_dev.produto, itmovimentacao_dev.cancelado,  estoqueprodutos.produto, estoqueprodutos.codproduto, 
produtos.codigo, produtos.descricao from itmovimentacao_dev
LEFT JOIN estoqueprodutos on itmovimentacao_dev.produto = estoqueprodutos.codproduto
LEFT JOIN produtos on produtos.codigo = estoqueprodutos.produto
WHERE itmovimentacao_dev.documento = '$movimentacao->documento' ";

//                echo $sql;


                        $arrayParam = '';
                        $itmovimentacao = $crud->getSQLGeneric($sql, $arrayParam, true);
                        foreach ($itmovimentacao as $itmovimentacao) :



//                    echo $itmovimentacao->cancelado;
                            if ($itmovimentacao->cancelado != 'S' || $movimentacao->situacao == 'C') :
                                $descitenevolucao = $descitenevolucao + $itmovimentacao->tdesconto;
                                $totalprodevolucao = $totalprodevolucao + $itmovimentacao->qtd;
                            endif;
                            if ($_POST['tipor'] == 'C') :
                                if ($itmovimentacao->cancelado == 'S' || $movimentacao->situacao == 'C') :
                                    ?>
                                    <tr style="text-decoration: line-through;">
                                        <td></td>
                                        <td colspan="4"><s><?= $itmovimentacao->codproduto ?> - <?= $itmovimentacao->descricao ?></s></td>
                                        <td><s><?= $itmovimentacao->qtd ?></s></td>
                                        <td><s>R$ <?= number_format($itmovimentacao->preco, $parametros->casadecimal, ',', '.') ?></s></td>
                                        <td><s>R$ <?= number_format($itmovimentacao->tdesconto, $parametros->casadecimal, ',', '.') ?></s></td>
                                        <td><s>R$ <?= number_format($itmovimentacao->total, $parametros->casadecimal, ',', '.') ?></s> - CANC</td>
                                        <td></td>
                                    </tr>
                                    <?php
                                else :
                                    ?>
                                    <tr>
                                        <td></td>
                                        <td colspan="4"><?= $itmovimentacao->codproduto ?> - <?= $itmovimentacao->descricao ?></td>
                                        <td><?= $itmovimentacao->qtd ?></td>
                                        <td>R$ <?= number_format($itmovimentacao->preco, $parametros->casadecimal, ',', '.') ?></td>
                                        <td>R$ <?= number_format($itmovimentacao->tdesconto, $parametros->casadecimal, ',', '.') ?></td>
                                        <td>R$ <?= number_format($itmovimentacao->total, $parametros->casadecimal, ',', '.') ?></td>
                                        <td></td>

                                    </tr>
                                <?php
                                endif;
                                ?>

                                <?php
                            endif;
                        endforeach;
                        ?>

                        <tr>
                            <td colspan="10">  <hr/> </td>
                        </tr>
                        <?php
                    endforeach;
                else :
                    $totaldevolucoes = 0;
                    $descidevolucoes = 0;
                    $descdocdevolucoes = 0;
                    $totalbrutodevolucoes = 0;
                    $totalliquidodevolucoes = 0;
                    $totalprodevolucao = 0;
                endif;
                ?>  

            </table>
        </div>

        <hr/>
        <div align="center"> RESUMO  MOVIMENTAÇÕES DE SAÍDA</div>
        <table class="table" style="width: 100%; font-size: 10px;">
            <tr>
                <td style="width: 16%"> DOC INICIAL </td>
                <td style="width: 16%"> DOC FINAL </td>
                <td style="width: 16%"> TOTAL VENDAS </td>
                <td style="width: 16%"> DESCONTO ITENS </td>
                <td style="width: 16%"> DESCONTO DOC. </td>
                <td style="width: 16%"> TOTAL BRUTO </td>
                <?php
                if ($_POST['frete'] == 'A') :
                    ?>
                    <td style="width: 16%"> TOTAL FRETE </td>

                    <?php
                endif;
                ?>

                <td style="width: 18%"> TOTAL LIQUIDO </td>
                <td style="width: 18%"> TOTAL ITENS </td>
            </tr>
            <tr>
                <td> <?= $docinicialsaida ?> </td>
                <td> <?= $docfinalsaida ?> </td>
                <td> <?= $totalvenda ?> </td>
                <td> R$ <?= number_format($desciten, $parametros->casadecimal, ',', '.') ?> </td>
                <td> R$ <?= number_format($descdoc, $parametros->casadecimal, ',', '.') ?> </td>
                <td> R$ <?= number_format($totalliquido + $descdoc + $desciten, $parametros->casadecimal, ',', '.') ?> </td>
                <?php
                if ($_POST['frete'] == 'A') :
                    ?>
                    <td> R$ <?= number_format($frete, $parametros->casadecimal, ',', '.') ?> </td>
                    <td> R$ <?= number_format($totalliquido - $frete, $parametros->casadecimal, ',', '.') ?> </td>
                    <?php
                else :
                    ?>
                    <td> R$ <?= number_format($totalliquido, $parametros->casadecimal, ',', '.') ?> </td>
                <?php
                endif;
                ?>

                <td> <?= number_format($totalprod, $parametros->casadecimal, ',', '.') ?> </td>

            </tr>

        </table>

        <hr/>
        <div align="center"> RESUMO  MOVIMENTAÇÕES DE TROCA</div>
        <table class="table" style="width: 100%; font-size: 10px;">
            <tr>
                <td style="width: 16%"> DOC INICIAL </td>
                <td style="width: 16%"> DOC FINAL </td>
                <td style="width: 16%"> TOTAL VENDAS </td>
                <td style="width: 16%"> DESCONTO ITENS </td>
                <td style="width: 16%"> DESCONTO DOC. </td>
                <td style="width: 16%"> TOTAL BRUTO </td>
                <?php
                if ($_POST['frete'] == 'A') :
                    ?>
                    <td style="width: 16%"> TOTAL FRETE </td>

                    <?php
                endif;
                ?>

                <td style="width: 18%"> TOTAL LIQUIDO </td>
                <td style="width: 18%"> TOTAL ITENS </td>
            </tr>
            <tr>
                <td> <?= $docinicialtroca ?> </td>
                <td> <?= $docfinaltroca ?> </td>
                <td> <?= $totalvendatroca ?> </td>
                <td> R$ <?= number_format($descitentroca, $parametros->casadecimal, ',', '.') ?> </td>
                <td> R$ <?= number_format($descdoctroca, $parametros->casadecimal, ',', '.') ?> </td>
                <td> R$ <?= number_format($totalliquidotroca + $descdoctroca + $descitentroca, $parametros->casadecimal, ',', '.') ?> </td>
                <?php
                if ($_POST['frete'] == 'A') :
                    ?>
                    <td> R$ <?= number_format($fretetroca, $parametros->casadecimal, ',', '.') ?> </td>
                    <td> R$ <?= number_format($totalliquidotroca - $fretetroca, $parametros->casadecimal, ',', '.') ?> </td>
                    <?php
                else :
                    ?>
                    <td> R$ <?= number_format($totalliquidotroca, $parametros->casadecimal, ',', '.') ?> </td>
                <?php
                endif;
                ?>

                <td> <?= number_format($totalprodtroca, $parametros->casadecimal, ',', '.') ?> </td>

            </tr>
        </table>

        <hr/>
        <div align="center"> RESUMO  MOVIMENTAÇÕES DE DEVOLUÇÕES</div>
        <table class="table" style="width: 100%; font-size: 10px;">
            <tr>
                <td style="width: 16%"> DOC INICIAL </td>
                <td style="width: 16%"> DOC FINAL </td>
                <td style="width: 16%"> TOTAL DEVOLUÇÕES </td>
                <td style="width: 16%"> DESCONTO ITENS </td>
                <td style="width: 16%"> DESCONTO DOC. </td>
                <td style="width: 16%"> TOTAL BRUTO </td>
                <td style="width: 18%"> TOTAL LIQUIDO </td>
                <td style="width: 18%"> TOTAL ITENS </td>
            </tr>
            <tr>
                <td> <?= $docinicialdev ?> </td>
                <td> <?= $docfinaldev ?> </td>
                <td> <?= $totaldevolucoes ?> </td>
                <td> R$ <?= number_format($descitendevolucao, $parametros->casadecimal, ',', '.') ?> </td>
                <td> R$ <?= number_format($descdocdevolucao, $parametros->casadecimal, ',', '.') ?> </td>
                <td> R$ <?= number_format($totalliquidodevolucao + $descdocdevolucao + $descitendevolucao, $parametros->casadecimal, ',', '.') ?> </td>
                <td> R$ <?= number_format($totalliquidodevolucao, $parametros->casadecimal, ',', '.') ?> </td>
                <td> <?= number_format($totalprodevolucao, $parametros->casadecimal, ',', '.') ?> </td>

            </tr>
        </table>

        <hr/>
        <div align="center"> RESUMO  GERAL</div>
        <table class="table" style="width: 100%; font-size: 10px;">
            <tr>
                <td style="width: 16%"> TOTAL VENDAS </td>
                <td style="width: 16%"> DESCONTO ITENS </td>
                <td style="width: 16%"> DESCONTO DOC. </td>
                <td style="width: 16%"> TOTAL BRUTO </td>
                <?php
                if ($_POST['frete'] == 'A') :
                    ?>
                    <td style="width: 16%"> TOTAL FRETE </td>

                    <?php
                endif;
                ?>

                <td style="width: 18%"> TOTAL LIQUIDO </td>
                <td style="width: 18%"> TOTAL ITENS </td>
            </tr>
            <tr>
                <td> <?= $totalvendatroca + $totalvenda ?> </td>
                <td> R$ <?= number_format($descitentroca + $desciten, $parametros->casadecimal, ',', '.') ?> </td>
                <td> R$ <?= number_format($descdoctroca + $descdoc, $parametros->casadecimal, ',', '.') ?> </td>
                <td> R$ <?= number_format($totalliquidotroca + $descdoctroca + $descitentroca + $totalliquido + $descdoc + $desciten - $totalliquidodevolucao, $parametros->casadecimal, ',', '.') ?> </td>
                <?php
                if ($_POST['frete'] == 'A') :
                    ?>
                    <td> R$ <?= number_format($fretetroca + $frete, $parametros->casadecimal, ',', '.') ?> </td>
                    <td> R$ <?= number_format($totalliquidotroca + $totalliquido - $frete - $fretetroca, $parametros->casadecimal, ',', '.') ?> </td>
                    <?php
                else :
                    ?>
                    <td> R$ <?= number_format($totalliquidotroca + $totalliquido - $totalliquidodevolucao, $parametros->casadecimal, ',', '.') ?> </td>
                    <?php
                    $totalpcomissao = $totalliquidotroca + $totalliquido - $totalliquidodevolucao;
                endif;
                ?>

                <td> <?= number_format($totalprodtroca + $totalprod - $totalprodevolucao, $parametros->casadecimal, ',', '.') ?> </td>

            </tr>
        </table>

        <?php
        if ($_POST['comissao'] == 'S') :

            $pdo = Conexao::getInstance();
            $crud = Crud::getInstance($pdo, 'usuario');
            $sql = "SELECT * from vendedor where vendedorid = '" . $_POST['vendedor'] . "' ";
            $arrayParam = '';
            $vendedor = $crud->getSQLGeneric($sql, $arrayParam, false);

            $totalg = $totalpcomissao; //$totalliquidotroca + $descdoctroca + $descitentroca + $totalliquido + $descdoc + $desciten;
            ?>
            <HR/>
            <div align="center"> COMISSÃO</div>
            <table class="table" style="width: 100%; font-size: 10px;">
                <tr>
                    <td style="width: 16%"> VENDEDOR </td>
                    <td style="width: 16%"> COMISSÃO </td>
                    <td style="width: 16%"> VENDA GERAL DO MÊS </td>
                    <td style="width: 16%"> VALOR DA COMISSÃO </td>

                </tr>
                <tr>
                    <td> <?= $vendedor->xNome ?> </td>
                    <td>  <?= $vendedor->comissaoav ?> </td>
                    <td> R$ <?= number_format($totalg, $parametros->casadecimal, ',', '.') ?> </td>
                    <td> R$  <?= number_format($totalg * $vendedor->comissaoav / 100, $parametros->casadecimal, ',', '.') ?> </td>

                </tr>
            </table>

            <?php
        endif;
        ?>

    </body>
</html>



<?php
if ($_POST['arq'] == 'PDF') :
    require_once("../../_inc/mpdf/vendor/autoload.php");
    ini_set("pcre.backtrack_limit", "500000000000000");

    $mpdf = new \Mpdf\Mpdf([
        'margin_top' => 5,
        'margin_left' => 5,
        'margin_right' => 5,
        'mirrorMargins' => true,
        'default_font_size' => 12,
        'default_font' => 'sans-serif',
    ]);
//$mpdf->SetWatermarkText('DRAFT');
    $mpdf->keep_table_proportions = true;
    $mpdf->allow_charset_conversion = true;
    $footer = "<table width = \"1000\">
                   <tr>
                     <td style='font-size: 10px; bottom:-15px;' align=\"right\">Pag: {PAGENO} de {nb} " . date('d/m/Y') . "</td>
                   </tr>
                 </table>";
    $mpdf->SetHTMLFooter($footer);
    $html = ob_get_clean();
    $mpdf->SetTitle('Movimentações');
    $mpdf->WriteHTML($html);
    $mpdf->Output();
// imprime

    exit();
elseif ($_POST['arq'] == 'EXCEL') :
    $file = 'Movimentacoes.xls';
    header("Content-type: application/x-msexcel");
    header("Content-Disposition: attachment; filename=\"{$file}\"");
    header("Content-Description: PHP Generated Data");
else :
    echo '';
endif;
?>