<?php
ob_start();
?>
<html>

<head>
    <title> Relatório </title>

</head>
<?php
ob_start();

date_default_timezone_set("Brazil/East");
require_once("../../../functions.php");
//
require_once "../../../_backend/_class/Conexao_class.php";
require_once "../../../_backend/_class/Crud_class.php";
require_once "../../../_backend/_class/cobranca_class.php";
require_once "../../../_backend/_class/parametros.php";

//error_reporting(E_ALL);
//ini_set('display_errors', 'On');

// function RetornaVenda($doc)
// {
//     $pdo = Conexao::getInstance();
//     $crud = Crud::getInstance($pdo, 'usuario');
//     $sql = "SELECT * FROM movimentacao where documento = '$doc'";
//     $arrayParam = '';
//     $movimentacao = $crud->getSQLGeneric($sql, $arrayParam, false);
//     return $movimentacao;
// }

// function RetornaTroca($doc)
// {
//     $pdo = Conexao::getInstance();
//     $crud = Crud::getInstance($pdo, 'usuario');
//     $sql = "SELECT * FROM movimentacao_troca where documento = '$doc'";
//     $arrayParam = '';
//     $movimentacao = $crud->getSQLGeneric($sql, $arrayParam, false);
//     return $movimentacao;
// }

// function RetornanNF($vendedor)
// {
//     $pdo = Conexao::getInstance();
//     $crud = Crud::getInstance($pdo, 'usuario');
//     $sql = "SELECT * FROM nfe where documento = '$vendedor'";
//     $arrayParam = '';
//     $movimentacao = $crud->getSQLGeneric($sql, $arrayParam, false);
//     return $movimentacao->nNF;
// }

// function RetornaVendedor($vendedor)
// {
//     $pdo = Conexao::getInstance();
//     $crud = Crud::getInstance($pdo, 'usuario');
//     $sql = "SELECT * FROM vendedor where vendedorid = '$vendedor'";
//     $arrayParam = '';
//     $movimentacao = $crud->getSQLGeneric($sql, $arrayParam, false);
//     return $movimentacao->xNome;
// }

// function RetornaConta($conta)
// {
//     $pdo = Conexao::getInstance();
//     $crud = Crud::getInstance($pdo, 'usuario');
//     $sql = "SELECT * FROM contas where contasid = '$conta'";
//     $arrayParam = '';
//     $movimentacao = $crud->getSQLGeneric($sql, $arrayParam, false);
//     return $movimentacao->contasdescricao;
// }

$_POST['datai'] = parseDate($_POST['datai'], 'Y-m-d');
$_POST['dataf'] = parseDate($_POST['dataf'], 'Y-m-d');

$dataconsulta = date("Y-m-d");
$data1 = parseDate($dataconsulta, 'd/m/Y');

$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'usuario');

// COALESCE retorna o que existir entre dois valores, não precisando das funcões para buscar informações agregadas
$sql = 'SELECT 
    caixa.*,
    usuario.usuarionome,
    COALESCE(v.documento, t.documento) as doc_ref,
    nfe.nNF,
    vend.xNome as vendedor_nome,
    c.contasdescricao
FROM caixa 
LEFT JOIN usuario ON caixa.usuario = usuario.usuarioid
LEFT JOIN movimentacao v ON caixa.documento = v.documento AND caixa.doc_tipo != "T"
LEFT JOIN movimentacao_troca t ON caixa.documento = t.documento AND caixa.doc_tipo = "T"
LEFT JOIN nfe ON caixa.documento = nfe.documento
LEFT JOIN vendedor vend ON COALESCE(v.vendedor, t.vendedor) = vend.vendedorid
LEFT JOIN contas c ON caixa.conta = c.contasid
WHERE str_to_date(caixa.data, "%d/%m/%Y") BETWEEN "'. $_POST['datai'] . '" AND "' . $_POST['dataf'] . '"';


if (!empty($_POST['tipo'])) :
    $sql .= ' AND caixa.tipo = "' . $_POST['tipo'] . '" ';
endif;

if (!empty($_POST['tipocobranca'])) :
    $sql .= ' AND caixa.tipocobranca = "' . $_POST['tipocobranca'] . '" ';
endif;

if (!empty($_POST['conta'])) :
    $sql .= ' AND caixa.conta = "' . $_POST['conta'] . '" ';
endif;

if (!empty($_POST['sangria'])) :
    $sql .= ' AND caixa.sangria = "' . $_POST['sangria'] . '" ';
endif;

if (!empty($_POST['empresa'])) :
    $sql .= ' AND caixa.empresa = "' . $_POST['empresa'] . '" ';
endif;

if (!empty($_POST['usuario'])) :
    $sql .= ' AND caixa.usuario = "' . $_POST['usuario'] . '" ';
endif;

$sql .= 'ORDER BY documento ASC';

// echo $sql;
$arrayParam = '';
$movimentacao = $crud->getSQLGeneric($sql, $arrayParam, true);

?>

<body>

    <div align="center">
        RELATORIO DE LANÇAMENTO DO CAIXA
        <br /> <small><?= parseDate($_POST['datai'], "d/m/Y"); ?> à <?= parseDate($_POST['dataf'], "d/m/Y"); ?> <?= empty($_POST['usuario']) ? '' : ' | Caixa: ' . $movimentacao['0']->usuarionome ?></small>
    </div>


    <?php require_once './cabecalho.php'; ?>

    <table cellpadding="8" class="table table-striped table-bordered table-condensed full_table_list" style="font-size: 10px; padding: 10px">
        <tr>
            <th style="width: 8%">Forma</th>
            <th style="width: 10%">Data</th>
            <th style="width: 12%">historico</th>
            <th style="width: 12%">Nº Doc fiscal</th>
            <th style="width: 12%">Vendedor</th>
            <th style="width: 10%">Crédito</th>
            <th style="width: 10%">Débito</th>
            <th style="width: 10%">Sangria</th>
            <th style="width: 18%">Conta</th>
        </tr>


        <?php
        $totalvenda = 0;
        $desciten = 0;
        $descdoc = 0;
        $totalbruto = 0;
        $totalliquido = 0;
        $totalprod = 0;
        $totaldespesa = 0;
        $totalreceita = 0;
        $lancamentosa = array();

        foreach ($movimentacao as $movimentacao) :
            $id = '';

            if ($movimentacao->tipo == 'D') :
                $totaldespesa = $totaldespesa + $movimentacao->valor;
            else :
                $totalreceita = $totalreceita + $movimentacao->valor;
            endif;
        ?>
            <tr>
                <td><?= $cobranca[$movimentacao->tipocobranca] ?></td>
                <td><?= $movimentacao->data ?></td>
                <td><?= $movimentacao->historico ?></td>
                <td><?= $movimentacao->nNF ?? '' ?></td>
                <td><?= $movimentacao->vendedor_nome ?? '' ?></td>

                <?php
                if ($movimentacao->tipo == 'D') :
                ?>
                    <td></td>
                    <td>R$ <?= number_format($movimentacao->valor, $parametros->casadecimal, ',', '.') ?></td>
                <?php
                else :
                ?>
                    <td>R$ <?= number_format($movimentacao->valor, $parametros->casadecimal, ',', '.') ?></td>
                    <td></td>
                <?php
                endif;
                ?>

                <td><?= $movimentacao->sangria ?></td>
                <td><?= $movimentacao->contasdescricao ? $movimentacao->conta . ' - ' . $movimentacao->contasdescricao : '' ?></td>
            </tr>
        <?php
        endforeach;
        ?>
    </table>


    <hr />
    <br />
    <br />
    <br />
    <div align="center"> RESUMO </div>
    <table cellpadding="8" class="table table-striped table-bordered table-condensed full_table_list" style="font-size: 10px; padding: 10px">
        <tr>
            <td style="width: 16%"> TOTAL CRÉDITO </td>
            <td style="width: 16%"> TOTAL DÉBITO</td>
            <td style="width: 16%"> TOTAL GERAL </td>

        </tr>
        <tr>
            <td> R$ <?= number_format($totalreceita, $parametros->casadecimal, ',', '.') ?> </td>
            <td> R$ <?= number_format($totaldespesa, $parametros->casadecimal, ',', '.') ?> </td>
            <td> R$ <?= number_format($totalreceita - abs($totaldespesa), $parametros->casadecimal, ',', '.') ?> </td>
        </tr>
    </table>
</body>

</html>

<?php
if ($_POST['tipoarquivo'] == 'Excell') :
    //    $data = parseDate($_GET['data'], "dmY");
    $file = 'caixa.xls';
    header("Content-type: application/x-msexcel");
    header("Content-Disposition: attachment; filename=\"{$file}\"");
    header("Content-Description: PHP Generated Data");
else :

    $stylesheet = " 
             .table-bordered th,
    .table-bordered td {
        border: 1px solid #ddd !important; } 

    .full_table_list_titulo{border-collapse: collapse;}
    .full_table_list_titulo tr{border:1px black solid;}

    .full_table_list{border-collapse: collapse;}
    .full_table_list tr{border:1px black solid;}
    .full_table_list tr:nth-child(even) {background: #eee}
    .full_table_list tr:nth-child(odd) {background: #fff}  

    .tablecor {border:1px black solid; background: #eee}
    .titulotr {border:1px black solid; background: #F5F5F5}
            table {width: 100%; padding: 10px;}
            tr {border:1px black solid}
            .titulotr {border:1px black solid; background: #F5F5F5}";

    require_once("../../_inc/mpdf/vendor/autoload.php");
    ini_set("pcre.backtrack_limit", "500000000000000");

    if ($_POST['exibeqtd'] == 'S') :
        $mpdf = new \Mpdf\Mpdf([
            'margin_top' => 5,
            'margin_left' => 5,
            'margin_right' => 5,
            'mirrorMargins' => true,
            'default_font_size' => 10,
            'format' => 'A4-L'
        ]);
    else :
        $mpdf = new \Mpdf\Mpdf([
            'margin_top' => 5,
            'margin_left' => 5,
            'margin_right' => 5,
            'mirrorMargins' => true,
            'default_font_size' => 10
        ]);
    endif;

    $mpdf->keep_table_proportions = true;
    $mpdf->allow_charset_conversion = true;
    $footer = "<table width = \"1000\">
    <tr>
        <td style='font-size: 10px; bottom:-15px;' align=\"right\">Pag: {PAGENO} de {nb} " . date('d/m/Y') . "</td>
    </tr>
</table>";
    $mpdf->SetHTMLFooter($footer);
    $html = ob_get_clean();
    $mpdf->SetTitle('Lancamentos');
    $mpdf->WriteHTML($stylesheet, 1);
    $mpdf->WriteHTML($html, 2);
    $mpdf->Output();
    // imprime

    exit();
endif;
?>