<?php
ob_start();
date_default_timezone_set("Brazil/East");
require_once("../../../functions.php");
//
require_once "../../../_backend/_class/Conexao_class.php";
require_once "../../../_backend/_class/Crud_class.php";
require_once "../../../_backend/_class/parametros.php";

//error_reporting(E_ALL);
//ini_set('display_errors', 'On');

function BuscaFornecedor($valor) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'estoqueprodutos');
    $sql = "SELECT fornecedorid, xNome from fornecedor where fornecedorid = '$valor'";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, false);

    return $dados;
}

   function BuscaVariacaoDesc($prod, $variacao, $sigla, $nivel) {
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'estoqueprodutos');
        $sql = "SELECT produtos.variacao, produtos.codigo, 
                    variacao.variacaoid, variacao.var1, variacao.var2, 
                    variacao.var3 ,
                    itensvariacao.variacao, itensvariacao.sigla,
                    itensvariacao.descricao, itensvariacao.nivel
                    FROM produtos 
                    INNER JOIN variacao ON produtos.variacao = variacao.variacaoid 
                    INNER JOIN itensvariacao ON itensvariacao.variacao = variacao.variacaoid                   
                    WHERE codigo = '$prod' 
                    AND variacao.variacaoid = '$variacao'
                    AND itensvariacao.nivel = '$nivel'
                    AND itensvariacao.sigla = '$sigla'";
        $arrayParam = '';
        $dados = $crud->getSQLGeneric($sql, $arrayParam, false);

//                echo $sql;
        return $dados->descricao;
    }

    
function BuscaCategoria($valor) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'estoqueprodutos');
    $sql = "SELECT categoriasid, descricao from categorias where sigla = '$valor'";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, false);
    return $dados;
}

function Produto($produto) {
    static $cache = [];
    if (!isset($cache[$produto])) {
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'usuario');
        $sql = "SELECT codigo, descricao from produtos where codigo = '" . $produto . "' ";
        $arrayParam = '';
        $vendedor = $crud->getSQLGeneric($sql, $arrayParam, false);

        $cache[$produto] = $vendedor->descricao;
    }
    return $cache[$produto];
}

//print_r($_POST);

$inicio1 = parseDate($_POST['datai'], "Y-m-d");
$fim1 = parseDate($_POST['dataf'], "Y-m-d");

//echo 'dif:'. $diferenca->days;

$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'itmovimentacao');
$sql = "DROP VIEW produtos_sem_vendas";
$retorno = $crud->Sql($sql);

$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'itmovimentacao');
$sql = "TRUNCATE temp_produtos_sem_vendas";
$retorno = $crud->Sql($sql);

$sql = "CREATE VIEW produtos_sem_vendas AS 
SELECT 
    e.produto, 
    e.codproduto, 
    e.var1, 
    e.var2, 
    e.qtd" . $_POST['empresa'] . " AS estoque, 
    e.ordem1, 
    e.ordem2, 
    p.codigo, 
    p.custo, 
    p.descricao, 
    p.categoria, 
    p.fornecedor, 
    p.variacao, 
    p.ref 
FROM estoqueprodutos e 
JOIN produtos p ON e.produto = p.codigo 

-- Garante que o produto teve uma compra antes de 01/03/2025
JOIN (
    SELECT ime.produto
    FROM movimentacao_ent me
    JOIN itmovimentacao_ent ime ON me.documento = ime.documento
    WHERE STR_TO_DATE(me.data, '%d/%m/%Y') < '" . $inicio1 . "'
    GROUP BY ime.produto
) primeiro_compra ON primeiro_compra.produto = e.codproduto

-- Verifica se o produto NÃO foi vendido no período
LEFT JOIN (
    SELECT DISTINCT i.produto
    FROM movimentacao m
    JOIN itmovimentacao i ON m.documento = i.documento
    WHERE m.situacao = 'F'
    AND m.empresa = '" . $_POST['empresa'] . "'
    AND STR_TO_DATE(m.data, '%d/%m/%Y') BETWEEN '" . $inicio1 . "' AND '" . $fim1 . "'
) vendas ON vendas.produto = e.codproduto

WHERE e.qtd" . $_POST['empresa'] . " > 0 
AND vendas.produto IS NULL -- Produtos que NÃO foram vendidos no período
";
        
if (!empty($_POST['categoria'])) :
    $sql .= " AND p.categoria = '" . $_POST['categoria'] . "' ";
endif;

if (!empty($_POST['fornecedor'])) :
    $sql .= " AND p.fornecedor = '" . $_POST['fornecedor'] . "' ";
endif;

$sql .= ' ORDER BY e.produto, e.ordem1, e.ordem2, e.var1, e.var2  ASC';

//echo $sql;
$arrayParam = '';
$retorno1 = $crud->Sql($sql);

$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'produtos_sem_vendas');
$sql = "SELECT * FROM produtos_sem_vendas";
$arrayParam = '';
$dadosit = $crud->getSQLGeneric($sql, $arrayParam, true);

foreach ($dadosit as $value) :

    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'temp_produtos_sem_vendas');
    if ($value->var2 == '') :
        $sql = "SELECT * FROM temp_produtos_sem_vendas WHERE codigo = '$value->produto' ";
    else :
        $sql = "SELECT * FROM temp_produtos_sem_vendas WHERE codigo = '$value->produto' and var1 = '$value->var1'";
    endif;
    $arrayParam = '';
    $dadosit = $crud->getSQLGeneric($sql, $arrayParam, true);

//    echo $sql;
    $totalregistro = count($dadosit);
    if ($totalregistro > 0) :
        if ($value->var2 == '') :
            $variacoes = $dadosit[0]->variacao . '|' . $value->var1 . ':' . $value->estoque;
        else :
            $variacoes = $dadosit[0]->variacao . '|' . $value->var2 . ':' . $value->estoque;
        endif;
        $sql = "UPDATE temp_produtos_sem_vendas SET variacao = '$variacoes' where id = '" . $dadosit[0]->id . "'";
        $insert = $crud->Sql($sql);
    else :
        if ($value->var2 == '') :
            $var = '';
            $variacoes = $value->var1 . ':' . $value->estoque;
        else :
            $var = $value->var1;
            $variacoes = $value->var2 . ':' . $value->estoque;
        endif;

        $sql = "INSERT INTO temp_produtos_sem_vendas(grade, empresa, codproduto, codigo, ref, descricao, var1, variacao, custo)
                VALUES ('$value->variacao', '" . $_POST['empresa'] . "', '$value->codproduto', '$value->codigo', '$value->ref', '$value->descricao', '$var', '$variacoes', '$value->custo')
                ";
        $insert = $crud->Sql($sql);

//        echo $sql;
    endif;

endforeach;
?>
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <title> Relatório </title>
        <style>
            body {
                font-size: 10px;
            }
            .spacer {
                border-bottom: 1px dashed #dee2e6;
            }


            h1, h2, h3, h4, h5, h6,
            .h1, .h2, .h3, .h4, .h5, .h6 {
                font-family: inherit;
                font-weight: 500;
                line-height: 1.1;
                color: inherit;
            }
            h1 small,
            h1 .small, h2 small,
            h2 .small, h3 small,
            h3 .small, h4 small,
            h4 .small, h5 small,
            h5 .small, h6 small,
            h6 .small,
            .h1 small,
            .h1 .small, .h2 small,
            .h2 .small, .h3 small,
            .h3 .small, .h4 small,
            .h4 .small, .h5 small,
            .h5 .small, .h6 small,
            .h6 .small {
                font-weight: normal;
                line-height: 1;
                color: #777777;
            }

            h1, .h1,
            h2, .h2,
            h3, .h3 {
                margin-top: 20px;
                margin-bottom: 10px;
            }
            h1 small,
            h1 .small, .h1 small,
            .h1 .small,
            h2 small,
            h2 .small, .h2 small,
            .h2 .small,
            h3 small,
            h3 .small, .h3 small,
            .h3 .small {
                font-size: 65%;
            }

            h4, .h4,
            h5, .h5,
            h6, .h6 {
                margin-top: 10px;
                margin-bottom: 10px;
            }
            h4 small,
            h4 .small, .h4 small,
            .h4 .small,
            h5 small,
            h5 .small, .h5 small,
            .h5 .small,
            h6 small,
            h6 .small, .h6 small,
            .h6 .small {
                font-size: 75%;
            }

            h1, .h1 {
                font-size: 36px;
            }

            h2, .h2 {
                font-size: 30px;
            }

            h3, .h3 {
                font-size: 24px;
            }

            h4, .h4 {
                font-size: 18px;
            }

            h5, .h5 {
                font-size: 14px;
            }

            h6, .h6 {
                font-size: 12px;
            }
            .text-center {
                text-align: center;
            }

            table {
                width: 100%;
                padding: 10px;
            }

            td {
                padding: 3px;
            }
            th {
                text-align: left;
            }
            /*.titulotr { border:  none};*/
            /*.titulotr { background: #000; border:1px black solid;};*/
            .table-bordered th,
            .table-bordered td {
                border: 1px solid #000 !important;
            }

            .full_table_list_titulo{
                border-collapse: collapse;
            }
            .full_table_list_titulo tr{
                border:1px black solid;
            }

            .full_table_list{
                border-collapse: collapse;
            }
            .full_table_list tr{
                border:1px black solid;
            }
            .full_table_list tr:nth-child(even) {
                background: #fff
            }
            .full_table_list tr:nth-child(odd) {
                background: #fff
            }

            .tablecor {
                border:1px black solid;
                background: #eee
            }
            .titulotr {
                border:1px black solid;
                background: #F5F5F5
            }

        </style>

    </head>
    <body>

        <div align="center" style="font-size: 12px;">
            <b>Mercadorias paradas no estoque</b> <br/>
            <?= $_POST['datai'] ?> a <?= $_POST['dataf'] ?>

            <?php
            if (!empty($_POST['fornecedor'])) :
                $fornecedor = BuscaFornecedor($_POST['fornecedor']);
                ?>
                <br/>
                <?= $fornecedor->fornecedorid ?> - <?= $fornecedor->xNome ?>
                <?php
            endif;
            ?>
            <?php
            if (!empty($_POST['categoria'])) :
                $categoria = BuscaCategoria($_POST['categoria']);
                ?>
                <br/>
                <?= $categoria->categoriasid ?> - <?= $categoria->descricao ?>
                <?php
            endif;
            ?>

        </div>


        <table class="table table-striped table-condensed full_table_list" style='font-size: 10px; '>
            <tr style="background-color: #dee2e6;">
                <td><b>Ref.</b></td>
                <td><b>Produto</b></td>
                <td><b>Var. 1</b></td>
                <td colspan="12"><b>Quantidade</b></td>
                <td><b>Qtd. Total</b></td>
                <td><b>Custo Total</b></td>
            </tr>
            <?php
            $pdo = Conexao::getInstance();
            $crud = Crud::getInstance($pdo, 'temp_romaneio');
            $sql = "SELECT * FROM temp_produtos_sem_vendas order by codigo, ref, var1";
            $arrayParam = '';
            $dadositens = $crud->getSQLGeneric($sql, $arrayParam, true);
            $totalpeca = 0;
            foreach ($dadositens as $value) :
//        $total = $total + $value->total;
//        $totalpeca = 0;
                // $valorliq = $valorliq + $value->total;
                //$dadosprod = Produto($value->produto);
                ?>
                <tr style="border-bottom: 1px dashed #dee2e6;">
                    <td>
                        <?= $value->ref ?>
                    </td>
                    <td>
                        <?= $value->codigo . ' ' . $value->descricao ?>
                    </td>

                    <td>
                        <?= $value->var1 ?>
                    </td>
                    
                    <?php
                    $separa = explode("|", $value->variacao);
                    $grade = '';
                    $i = 0;
                    $qtditem = 0;
                    $custopeca = 0;
                    for ($index = 0; $index < count($separa); $index++) :
                        $grade = explode(":", $separa[$index]);
                        $totalpeca = $totalpeca + $grade[1];
                        $qtditem = $qtditem + $grade[1];
                        $custopeca = $custopeca + (intval($grade[1]) * $value->custo);
                        $cstototal = $cstototal + (intval($grade[1]) * $value->custo);
                        echo '<td style="border: 1px solid #DCDCDC">';
                        echo '<b>' . BuscaVariacaoDesc($value->codigo, $value->grade, trim($grade[0]), 2) . '</b>';
                        echo '<br/>';
                        echo intval($grade[1]);
                        echo '</td>';
                        $i++;
                    endfor;
                    for ($iz = $i; $iz < 12; $iz++) :
                        echo '<td>';
                        echo '</td>';
                    endfor;
                    ?>

                    <td>
                        <?= $qtditem ?> 
                    </td>

                    <td>
                        R$ <?= number_format($custopeca, 2, ',', '.') ?>
                    </td>

                </tr>
                <?php
            endforeach;
            ?>

            <tr style="background-color: #dee2e6;">
                <td colspan="15"><b>Totais</b></td>
                <td><b> <?= $totalpeca ?> </b></td>
                <td><b>R$ <?= number_format($cstototal, 2, ',', '.') ?></b></td>
            </tr>
        </table>
    </body>
</html>



<?php
if ($_POST['gerar'] == 'EXCEL') :
//    $data = parseDate($_POST['data'], "dmY");
    $file = 'estoquegrade.xls';
    header("Content-type: application/x-msexcel");
    header("Content-Disposition: attachment; filename=\"{$file}\"");
    header("Content-Description: PHP Generated Data");
elseif ($_POST['gerar'] == 'HTML') :
    echo '';
else :
    ini_set("pcre.backtrack_limit", "500000000000000");
    require_once("../../_inc/mpdf/vendor/autoload.php");
    $mpdf = new \Mpdf\Mpdf([
        'margin_top' => 5,
        'margin_left' => 5,
        'margin_right' => 5,
        'mirrorMargins' => true,
        'default_font_size' => 12
    ]);
    $mpdf->keep_table_proportions = true;
    $mpdf->allow_charset_conversion = true;
    $footer = "<table width = \"1000\">
                   <tr>
                     <td style='font-size: 10px; bottom:-15px;' align=\"right\">Pag: {PAGENO} de {nb} " . date('d/m/Y') . "</td>
                   </tr>
                 </table>";
    $mpdf->SetHTMLFooter($footer);
    $html = ob_get_clean();
    $mpdf->SetTitle('Estoque');
    $mpdf->WriteHTML($html);
    $mpdf->Output();
// imprime

    exit();
endif;
?>