<?php
ob_start();

date_default_timezone_set("Brazil/East");
require_once("../../../functions.php");
//
require_once "../../../_backend/_class/Conexao_class.php";
require_once "../../../_backend/_class/Crud_class.php";
require_once "../../../_backend/_class/cobranca_class.php";
require_once "../../../_backend/_class/parametros.php";

//$_POST['datai'] = '01/05/2021';
//$_POST['dataf'] = '31/05/2021';
//$_POST['cliente'] = '2';
$_POST['datai'] = parseDate($_POST['datai'], 'Y-m-d');
$_POST['dataf'] = parseDate($_POST['dataf'], 'Y-m-d');

//error_reporting(E_ALL);
//ini_set('display_errors', 'On');

function FloorQtd($valor) {
    if (floor($valor) != $valor) :
        return $valor;
    else :
        return intval($valor);
    endif;
}

function Para($valor) {
    switch ($valor) :
        case 'C' :
            return 'Cliente';
            break;
        case 'F' :
            return 'Funcionário';
            break;
        case 'R' :
            return 'Representante';
    endswitch;
}

function BuscaPara($valor, $id) {

    if ($valor == 'R') :
        $sql = "SELECT * from representante where representanteid = '$id' ";
    elseif ($valor == 'F') :
        $sql = "SELECT * from funcionario where funcionarioid = '$id' ";
    else :
        $sql = "SELECT * from cliente where clienteid = '$id' ";
    endif;

    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'tabela');
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

    return $dados;
}

function BuscaProduto($codigo) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'tabela');
    $sql = "select estoqueprodutos.produto as prod, estoqueprodutos.codproduto, 
    estoqueprodutos.var1, estoqueprodutos.var2, estoqueprodutos.var3,
    produtos.codigo,  produtos.descricao, produtos.ref from estoqueprodutos 
    INNER JOIN produtos ON produtos.codigo = estoqueprodutos.produto 
    where codproduto = '$codigo'";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

    return $dados;
}
?>
<html>
    <head>
        <title> Relatório </title>

        <style>
            /*@import "../../../_frontend/_layout/assets/vendor/bootstrap/css/bootstrap.min.css";*/      


            table {
                border-collapse: collapse;
            }
            thead {
                vertical-align: bottom;
                text-align: center;
                font-weight: bold;
            }
            tfoot {
                text-align: center;
                font-weight: bold;
            }
            th {
                text-align: left;
                padding-left: 0.35em;
                padding-right: 0.35em;
                padding-top: 0.35em;
                padding-bottom: 0.35em;
                vertical-align: top;
            }
            td {
                padding-left: 0.35em;
                padding-right: 0.35em;
                padding-top: 0.35em;
                padding-bottom: 0.35em;
                vertical-align: top;
            }


        </style>
    </head>
    <body>

        <div align="center">
            RELATÓRIO DE MERCADORIAS CONSIGNADA
            <br/> <small> <?= parseDate($_POST['datai'], "d/m/Y"); ?> à <?= parseDate($_POST['dataf'], "d/m/Y"); ?></small>

        </div>


        <?php require_once './cabecalho.php'; ?>


        <table class="table table-bordered" style="font-size: 10px; width: 100%">

            <tr>
                <td>Código</td>
                <td>Ref</td>
                <td>Descrição</td>
                <td>Valor</td>
                <td>Quantidade</td>
                <td>Total</td>
            </tr>

            <?php
            $pdo = Conexao::getInstance();
            $crud = Crud::getInstance($pdo, 'usuario');
            $sql = 'SELECT movimentacao.documento, movimentacao.empresa, movimentacao.`data`, movimentacao.para, movimentacao.representante, movimentacao.vendedor, movimentacao.corretor, movimentacao.cliente, 
movimentacao.funcionario, movimentacao.situacao, movimentacao.tipo, movimentacao.doc_empresa,
itmovimentacao.documento, itmovimentacao.produto, itmovimentacao.preco, itmovimentacao.desconto, itmovimentacao.acrescimo, itmovimentacao.valorbruto, sum(itmovimentacao.valorliquido) as valorliquido,
itmovimentacao.acertado, sum(itmovimentacao.quantidade) as quantidade, itmovimentacao.cancelado
FROM movimentacao
INNER JOIN itmovimentacao ON movimentacao.documento = itmovimentacao.documento
WHERE str_to_date(data, "%d/%m/%Y") BETWEEN "' . $_POST['datai'] . '" AND "' . $_POST['dataf'] . '"';

            $sql .= ' AND tipo = "C" ';
            $sql .= ' AND situacao = "A" ';
            $sql .= ' AND cancelado = "N" ';

            if (!empty($_POST['produto'])) :
                $sql .= ' AND produto = "' . $_POST['produto'] . '" ';
            endif;

            if (!empty($_POST['vendedor'])) :
                $sql .= ' AND vendedor = "' . $_POST['vendedor'] . '" ';
            endif;

            if (!empty($_POST['corretor'])) :
                $sql .= ' AND corretor = "' . $_POST['corretor'] . '" ';
            endif;

            if (!empty($_POST['representante'])) :
                $sql .= ' AND representante = "' . $_POST['representante'] . '" ';
            endif;

            if (!empty($_POST['funcionario'])) :
                $sql .= ' AND funcionario = "' . $_POST['funcionario'] . '" ';

            endif;

            $sql .= ' AND empresa = "' . $_POST['empresa'] . '"';
//            $sql .= ' AND empresa = "1"';
            $sql .= ' GROUP BY itmovimentacao.produto';

//            echo $sql;
            $frete = 0;

            $arrayParam = '';
            $movimentacao = $crud->getSQLGeneric($sql, $arrayParam, true);
            $docinicialsaida = 0;
            $docfinalsaida = 0;
            $entidade = array();
            $totalcliente = 0;
//            print_R($movimentacao);

            $totalregistro = count($movimentacao);
            $totalregistro1 = 0;
            foreach ($movimentacao as $movimentacao) :

                $produto = BuscaProduto($movimentacao->produto);
                $totalcliente = $totalcliente + $movimentacao->quantidade;
                $totalliq = $totalliq + $movimentacao->valorliquido;
                ?>
                <tr>

                    <td><?= $movimentacao->produto ?></td>
                    <td><?= $produto->ref ?></td>
                    <td><?= $produto->descricao ?></td>
                    <td>R$ <?= number_format($movimentacao->preco, '2', ',', '.') ?></td>
                    <td><?= FloorQtd($movimentacao->quantidade) ?></td>
                    <td>R$ <?= number_format($movimentacao->valorliquido, '2', ',', '.') ?></td>
                </tr>

                <?php
                $totalregistro1++;
            endforeach;
            ?>

            <tr>
                <td colspan="4">TOTAL</td>
                <td><?= FloorQtd($totalcliente) ?></td>
                <td>R$ <?= number_format($totalliq, '2', ',', '.') ?></td>

            </tr>
        </table>

    </body>

</html>
<?php
require_once("../../_inc/mpdf/vendor/autoload.php");
ini_set("pcre.backtrack_limit", "500000000000000");

$mpdf = new \Mpdf\Mpdf([
    'margin_top' => 5,
    'margin_left' => 5,
    'margin_right' => 5,
    'mirrorMargins' => true,
    'default_font_size' => 12,
    'default_font' => 'sans-serif',
        ]);
//$mpdf->SetWatermarkText('DRAFT');
$mpdf->keep_table_proportions = true;
$mpdf->allow_charset_conversion = true;
$footer = "<table width = \"1000\">
                   <tr>
                     <td style='font-size: 10px; bottom:-15px;' align=\"right\">Pag: {PAGENO} de {nb} " . date('d/m/Y') . "</td>
                   </tr>
                 </table>";
$mpdf->SetHTMLFooter($footer);
$html = ob_get_clean();
$mpdf->SetTitle('Movimentações');
$mpdf->WriteHTML($html);
$mpdf->Output();
// imprime

exit();
?>